/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.sql.rowset.JdbcRowSet;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.JdbcPropertyPublisher;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.RowSetFactory;

public class MraldConnection {
    private Connection moConnection;
    private Statement moStatement;
    private Properties props;

    public MraldConnection(String sURL, String sDriver, String sUsername, String sPassword) throws SQLException {
        MraldConnection dammit = new MraldConnection(sURL, sDriver, sUsername, sPassword, new Properties(), null);
        this.moConnection = dammit.getConnection();
        this.moStatement = dammit.getStatement();
    }

    public MraldConnection(String sURL, String sDriver, String sUsername, String sPassword, Properties info, HttpServletRequest request) throws SQLException {
        info.put("user", sUsername);
        info.put("password", sPassword);
        this.props = info;
        JdbcPropertyPublisher.populateProperties(request, info);
        this.moConnection = DriverManager.getConnection(sURL, info);
        this.moConnection.setAutoCommit(true);
        this.moStatement = this.moConnection.createStatement();
    }

    public MraldConnection() throws SQLException {
        MraldConnection dammit = new MraldConnection(Config.getProperty("DBSERVER"), Config.getProperty("DBDRIVER"), Config.getProperty("DBLOGIN"), Config.getProperty("DBPASSWORD"), new Properties(), null);
        this.moConnection = dammit.getConnection();
        this.moStatement = dammit.getStatement();
    }

    public MraldConnection(String propsKey) {
        this.props = MetaData.getDbProperties(propsKey);
        if (this.props == null) {
            throw new RuntimeException("There is no data base connection configuration with the name " + propsKey);
        }
        try {
            MraldConnection dammit = new MraldConnection(Config.replacements(this.props.getProperty("DBSERVER")), this.props.getProperty("DBDRIVER"), this.props.getProperty("DBLOGIN"), this.props.getProperty("DBPASSWORD"), this.props, null);
            this.moConnection = dammit.getConnection();
            this.moStatement = dammit.createStatement();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error setting the connection to the database.", e);
        }
    }

    public MraldConnection(String propsKey, MsgObject msg) {
        this.props = MetaData.getDbProperties(propsKey);
        if (this.props == null) {
            throw new RuntimeException("There is no data base connection configuration with the name " + propsKey);
        }
        try {
            MraldConnection dammit = new MraldConnection(Config.replacements(this.props.getProperty("DBSERVER")), this.props.getProperty("DBDRIVER"), this.props.getProperty("DBLOGIN"), this.props.getProperty("DBPASSWORD"), this.props, msg.getReq());
            this.moConnection = dammit.getConnection();
            this.moStatement = dammit.createStatement();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error setting the connection to the database.", e);
        }
    }

    public MraldConnection(String propsKey, HttpServletRequest request) {
        this.props = MetaData.getDbProperties(propsKey);
        if (this.props == null) {
            throw new RuntimeException("There is no data base connection configuration with the name " + propsKey);
        }
        try {
            MraldConnection dammit = new MraldConnection(Config.replacements(this.props.getProperty("DBSERVER")), this.props.getProperty("DBDRIVER"), this.props.getProperty("DBLOGIN"), this.props.getProperty("DBPASSWORD"), this.props, request);
            this.moConnection = dammit.getConnection();
            this.moStatement = dammit.createStatement();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error setting the connection to the database.", e);
        }
    }

    public void setAutoCommit(boolean bAutoCommit) throws SQLException {
        this.moConnection.setAutoCommit(bAutoCommit);
    }

    public void setStatement(Statement oStatement) {
        this.moStatement = oStatement;
    }

    public Connection getConnection() {
        return this.moConnection;
    }

    public Statement getStatement() {
        return this.createStatement();
    }

    public Statement createStatement() {
        try {
            return this.moConnection.createStatement();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Statement resetStatement() {
        try {
            this.moStatement.close();
            this.moStatement = this.moConnection.createStatement();
            return this.moStatement;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws SQLException {
        if (this.moStatement != null) {
            this.moStatement.close();
            this.moStatement = null;
        }
        if (this.moConnection != null) {
            this.moConnection.close();
            this.moConnection = null;
        }
    }

    public void commit() throws SQLException {
        this.moConnection.commit();
    }

    public ResultSet executeQuery(String sSQL) throws SQLException {
        sSQL = MiscUtils.clearSemiColon(sSQL);
        return this.moStatement.executeQuery(sSQL);
    }

    public JdbcRowSet getRowSet(String query) throws SQLException {
        JdbcRowSet jrs;
        String clearedQuery = MiscUtils.clearSemiColon(query);
        try {
            jrs = RowSetFactory.createJdbcRowSet();
        }
        catch (MraldException e) {
            throw new RuntimeException("Sorry, the facilities for joining across databases are not configured correctly.  Please ask your administrator to correct the configuration", e);
        }
        jrs.setCommand(clearedQuery);
        jrs.setUrl(this.props.getProperty("DBSERVER"));
        jrs.setUsername(this.props.getProperty("DBLOGIN"));
        jrs.setPassword(this.props.getProperty("DBPASSWORD"));
        jrs.execute();
        return jrs;
    }

    public int executeUpdate(String sSQL) throws SQLException {
        sSQL = MiscUtils.clearSemiColon(sSQL);
        int iRowCount = this.moStatement.executeUpdate(sSQL);
        return iRowCount;
    }

    public ResultSet executeUpdate(String sSQL, int returnGenerated) throws SQLException {
        sSQL = MiscUtils.clearSemiColon(sSQL);
        this.moStatement.executeUpdate(sSQL, returnGenerated);
        return this.moStatement.getGeneratedKeys();
    }

    public void rollback() throws SQLException {
        this.moConnection.rollback();
    }

    public static boolean createPeopleTable() throws SQLException {
        try {
            int qNum = 0;
            MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
            String query = "create table latticegroup ( latticegroupid   varchar(50) not null, latticegroupname varchar(50) null, latticegroupdesc varchar(200) null, primary key (latticegroupid), check ((latticegroupid is not null)) )";
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "MraldConnection: createPeopleTable() - Query " + qNum++ + ":" + query);
            conn.executeUpdate(query);
            query = "insert into latticegroup values('Public', 'Public', 'All users can see the data in this COI - it is the most open, and also the most risky')";
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "MraldConnection: createPeopleTable() - Query " + qNum++ + ":" + query);
            conn.executeUpdate(query);
            query = "create table label_sql ( table_name varchar(200) not null, sql_clause varchar(2000) null, primary key (table_name) )";
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "MraldConnection: createPeopleTable() - Query " + qNum++ + ":" + query);
            conn.executeUpdate(query);
            query = "create table graphs ( graphid integer not null, userid varchar(100) not null, primary key (graphid, userid) )";
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "MraldConnection: createPeopleTable() - Query " + qNum++ + ":" + query);
            conn.executeUpdate(query);
            query = "CREATE TABLE people ( ";
            query = query + " email          varchar(100) not null,";
            query = query + " peopletypeid   integer null,";
            query = query + " password       varchar(100) null,";
            query = query + " latticegroupid varchar(50) null,";
            query = query + " firstname      varchar(50) null,";
            query = query + " lastname       varchar(75) null,";
            query = query + " company        varchar(100) null,";
            query = query + " department     varchar(50) null,";
            query = query + " address\t\t  varchar(300) null,";
            query = query + " city           varchar(50) null,";
            query = query + " state          varchar(50) null,";
            query = query + " zip            varchar(10) null,";
            query = query + " country        varchar(50) null,";
            query = query + " validationcode varchar(12) null,";
            query = query + " validated\t  varchar(1) null,";
            query = query + " primary key (email),";
            query = query + " foreign key (latticegroupid)";
            query = query + " references latticegroup (latticegroupid),";
            query = query + " check ((email is not null))";
            query = query + " )";
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "MraldConnection: createPeopleTable() - Query " + qNum++ + ":" + query);
            conn.executeUpdate(query);
            query = "insert into people (email, peopletypeid, latticegroupid, password, validationcode, validated) values ('admin@mitre.org', 3, 'Public', 'XPERsFUdQRgrVI/si2Fv1ROAJ3X4BnOredragQ==', 'still fake', 'Y')";
            MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "MraldConnection: createPeopleTable() - Query " + qNum++ + ":" + query);
            conn.executeUpdate(query);
            return true;
        }
        catch (SQLException sqe) {
            MraldOutFile.logToFile(sqe);
            return false;
        }
    }

    public static boolean createMessageTable() throws SQLException {
        MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
        String query = "CREATE TABLE message (id\t\t    identity,time_sent  timestamp, title      VARCHAR(100) NULL,body       VARCHAR(1024) NULL,status\t    VARCHAR(15) NOT NULL default 'NEW',PRIMARY KEY (id) )";
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "Creating message table in admin db: " + query);
        conn.executeUpdate(query);
        return true;
    }
}

