/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.WebUtils;

public class User {
    protected String email = "";
    protected String group = "";
    protected String password = "";
    protected String[] formIds;
    protected Object sharedUsers;
    protected int typeId;
    protected int userId;
    public static final int COMMON_USER = 1;
    public static final int ADMIN_USER = 3;

    public User() {
        this.userId = 0;
    }

    public User(String userName) {
        if (!WebUtils.isValidEmailAddress(userName)) {
            throw new RuntimeException(userName + " is not a valid email address");
        }
        this.email = userName;
    }

    public void setEmail(String email) throws RuntimeException {
        if (!WebUtils.isValidEmailAddress(email)) {
            throw new RuntimeException(email + " is not a valid email address");
        }
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFormIds(String[] formIds) {
        this.formIds = formIds;
    }

    public String[] getFormIds() {
        return this.formIds;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() throws NullPointerException {
        return this.group;
    }

    public void logUserAccess(String userName) {
        MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "System accessed by " + userName);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Email: ");
        ret.append(this.getEmail());
        ret.append("\nPeopleType: ");
        ret.append(this.getTypeId());
        ret.append("\nCOI: ");
        ret.append(this.getGroup());
        return ret.toString();
    }
}

