/*
 * Decompiled with CFR 0.152.
 */
package com.objectfab.tools.junitdoclet;

import com.objectfab.tools.junitdoclet.DefaultConfigurableStrategy;
import com.objectfab.tools.junitdoclet.JUnitDocletProperties;
import com.objectfab.tools.junitdoclet.NamingStrategy;
import com.objectfab.tools.junitdoclet.StringHelper;
import com.objectfab.tools.junitdoclet.TestingStrategy;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import java.util.LinkedList;
import java.util.Properties;

public class DefaultTestingStrategy
extends DefaultConfigurableStrategy
implements TestingStrategy,
JUnitDocletProperties {
    protected static final String TESTSUITE_SUITE_METHOD_NAME = "suite";
    protected static final String JUNIT_TEST_CLASS_NAME = "junit.framework.Test";
    protected static final String[][] ACCESSOR_STARTS_WITH;
    protected static int INDEX_SET;
    protected static int INDEX_GET;
    private static String[] requiredStrings;
    public static final String[] MINIMUM_MARKER_SET;

    public void init() {
        super.init();
        this.setProperties(null);
    }

    public boolean isTestablePackage(PackageDoc doc, NamingStrategy naming) {
        boolean returnValue = doc != null;
        returnValue = returnValue && naming != null && !naming.isTestPackageName(doc.name());
        return returnValue;
    }

    public boolean isTestableClass(ClassDoc doc, NamingStrategy naming) {
        boolean returnValue = doc != null;
        returnValue = returnValue && !doc.isAbstract();
        returnValue = returnValue && !doc.isInterface();
        returnValue = returnValue && !doc.isProtected();
        returnValue = returnValue && !doc.isPrivate();
        returnValue = returnValue && !this.isInnerClass(doc);
        returnValue = returnValue && doc.isPublic();
        returnValue = returnValue && !this.isATest(doc);
        returnValue = returnValue && naming != null && !naming.isTestClassName(doc.qualifiedName());
        returnValue = returnValue && !this.hasSuiteMethod(doc);
        return returnValue;
    }

    public boolean isTestableMethod(MethodDoc doc) {
        boolean returnValue = doc != null;
        returnValue = returnValue && !doc.isAbstract();
        returnValue = returnValue && !doc.isProtected();
        returnValue = returnValue && !doc.isPrivate();
        returnValue = returnValue && doc.isPublic();
        return returnValue;
    }

    public boolean codeTestSuite(PackageDoc[] packageDocs, int indexPackage, NamingStrategy naming, StringBuffer newCode, Properties properties) {
        boolean returnValue = packageDocs != null;
        returnValue = returnValue && indexPackage >= 0;
        returnValue = returnValue && indexPackage < packageDocs.length;
        returnValue = returnValue && naming != null;
        returnValue = returnValue && newCode != null;
        boolean bl = returnValue = returnValue && properties != null;
        if (returnValue) {
            returnValue = this.isTestablePackage(packageDocs[indexPackage], naming);
            if (returnValue) {
                Properties addProps = this.getTestSuiteProperties(packageDocs, indexPackage, naming, properties);
                String template = this.getTemplate(addProps, "testsuite", addProps.getProperty("template.name"));
                newCode.append(StringHelper.replaceVariables(template, addProps));
            }
        } else {
            this.printError("DefaultTestingStrategy.codeTestSuite() parameter error");
        }
        return returnValue;
    }

    public boolean codeTestCase(ClassDoc classDoc, PackageDoc packageDoc, NamingStrategy naming, StringBuffer newCode, Properties properties) {
        boolean returnValue = classDoc != null;
        returnValue = returnValue && packageDoc != null;
        returnValue = returnValue && naming != null;
        returnValue = returnValue && newCode != null;
        boolean bl = returnValue = returnValue && properties != null;
        if (returnValue) {
            returnValue = this.isTestableClass(classDoc, naming);
            if (returnValue) {
                Properties addProps = this.getTestCaseProperties(classDoc, packageDoc, naming, properties);
                String template = this.getTemplate(addProps, "testcase", addProps.getProperty("template.name"));
                newCode.append(StringHelper.replaceVariables(template, addProps));
            }
        } else {
            this.printError("DefaultTestingStrategy.codeTestCase() parameter error");
        }
        return returnValue;
    }

    public boolean codeTest(MethodDoc[] methodDocs, int index, ClassDoc classDoc, PackageDoc packageDoc, NamingStrategy naming, StringBuffer newCode, Properties properties) {
        boolean returnValue = methodDocs != null;
        returnValue = returnValue && index >= 0;
        returnValue = returnValue && index < methodDocs.length;
        returnValue = returnValue && classDoc != null;
        returnValue = returnValue && packageDoc != null;
        returnValue = returnValue && naming != null;
        returnValue = returnValue && newCode != null;
        boolean bl = returnValue = returnValue && properties != null;
        if (returnValue) {
            Properties addProps;
            returnValue = this.isTestableMethod(methodDocs[index]);
            if (returnValue && (addProps = this.getTestProperties(methodDocs, index, classDoc, packageDoc, naming, properties)) != null) {
                String template = this.getTemplate(addProps, "testmethod", addProps.getProperty("template.name"));
                newCode.append(StringHelper.replaceVariables(template, addProps));
            }
        } else {
            this.printError("DefaultTestingStrategy.codeTestCase() parameter error");
        }
        return returnValue;
    }

    public Properties getTestSuiteProperties(PackageDoc[] packageDocs, int indexPackage, NamingStrategy naming, Properties properties) {
        Properties returnValue = new Properties(properties);
        returnValue.setProperty("testsuite.package.name", naming.getTestPackageName(packageDocs[indexPackage].name()));
        returnValue.setProperty("testsuite.class.name", naming.getTestSuiteName(packageDocs[indexPackage].name()));
        returnValue.setProperty("template.name", "default");
        returnValue.setProperty("testsuite.add.testsuites", this.getTestSuiteAddTestSuites(packageDocs, indexPackage, naming, properties));
        returnValue.setProperty("testsuite.add.testcases", this.getTestSuiteAddTestCases(packageDocs, indexPackage, naming, properties));
        returnValue.setProperty("testsuite.imports", this.getTestSuiteImports(packageDocs, indexPackage, naming, properties));
        returnValue.setProperty("package.name", packageDocs[indexPackage].name());
        return returnValue;
    }

    public Properties getTestCaseProperties(ClassDoc classDoc, PackageDoc packageDoc, NamingStrategy naming, Properties properties) {
        Properties returnValue = new Properties(properties);
        returnValue.setProperty("testcase.package.name", naming.getTestPackageName(packageDoc.name()));
        returnValue.setProperty("testcase.class.name", naming.getTestCaseName(classDoc.name()));
        returnValue.setProperty("testcase.instance.name", classDoc.name().toLowerCase());
        returnValue.setProperty("testcase.instance.type", classDoc.qualifiedName());
        returnValue.setProperty("testcase.testmethods", this.getTestMethods(classDoc, packageDoc, naming, returnValue));
        returnValue.setProperty("testcase.method.unmatched", "testVault");
        returnValue.setProperty("template.name", "default");
        returnValue.setProperty("package.name", packageDoc.name());
        returnValue.setProperty("class.name", classDoc.name());
        return returnValue;
    }

    private String getTestMethods(ClassDoc classDoc, PackageDoc packageDoc, NamingStrategy naming, Properties properties) {
        MethodDoc[] methodDocs = classDoc.methods();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < methodDocs.length) {
            if (this.isTestableMethod(methodDocs[i])) {
                this.codeTest(methodDocs, i, classDoc, packageDoc, naming, sb, properties);
            }
            ++i;
        }
        return sb.toString();
    }

    public Properties getTestProperties(MethodDoc[] methodDocs, int index, ClassDoc classDoc, PackageDoc packageDoc, NamingStrategy naming, Properties properties) {
        Properties returnValue = null;
        StringBuffer signature = null;
        Parameter[] parameters = null;
        returnValue = this.getTestAccessorProperties(methodDocs, index, classDoc, packageDoc, naming, properties);
        if (returnValue == properties && returnValue != null) {
            if (this.isFirstTestableMethodWithName(methodDocs, index)) {
                returnValue = new Properties(properties);
                returnValue.setProperty("testmethod.name", naming.getTestMethodName(methodDocs[index].name()));
                returnValue.setProperty("template.name", "default");
                returnValue.setProperty("method.name", methodDocs[index].name());
                signature = new StringBuffer("");
                int i = 0;
                while (i < DefaultTestingStrategy.getNumberOfParameters(methodDocs[index])) {
                    parameters = methodDocs[index].parameters();
                    if (i > 0) {
                        signature.append(", ");
                    }
                    signature.append(parameters[i].typeName());
                    ++i;
                }
                returnValue.setProperty("method.signature", signature.toString());
            } else {
                returnValue = null;
            }
        }
        return returnValue;
    }

    public String getTestSuiteAddTestSuites(PackageDoc[] packageDocs, int indexPackage, NamingStrategy naming, Properties properties) {
        StringBuffer sb = new StringBuffer();
        Properties addProps = new Properties(properties);
        String template = this.getTemplate(properties, "add.testsuite.to.testsuite", "default");
        PackageDoc[] subPackages = this.getDirectSubPackages(packageDocs, indexPackage);
        int i = 0;
        while (i < subPackages.length) {
            if (this.isTestablePackage(subPackages[i], naming)) {
                addProps.setProperty("add.testsuite.name", naming.getTestSuiteName(subPackages[i].name()));
                addProps.setProperty("testsuite.package.name", naming.getTestPackageName(subPackages[i].name()));
                sb.append(StringHelper.replaceVariables(template, addProps));
            }
            ++i;
        }
        return sb.toString();
    }

    public String getTestSuiteAddTestCases(PackageDoc[] packageDocs, int indexPackage, NamingStrategy naming, Properties properties) {
        StringBuffer sb = new StringBuffer();
        Properties addProps = new Properties(properties);
        String template = this.getTemplate(properties, "add.testcase.to.testsuite", "default");
        ClassDoc[] classes = packageDocs[indexPackage].ordinaryClasses();
        int i = 0;
        while (i < classes.length) {
            if (this.isTestableClass(classes[i], naming)) {
                addProps.setProperty("add.testcase.name", naming.getTestCaseName(classes[i].name()));
                addProps.setProperty("testsuite.package.name", naming.getTestPackageName(packageDocs[indexPackage].name()));
                sb.append(StringHelper.replaceVariables(template, addProps));
            }
            ++i;
        }
        return sb.toString();
    }

    public String getTestSuiteImports(PackageDoc[] packageDocs, int indexPackage, NamingStrategy naming, Properties properties) {
        StringBuffer sb = new StringBuffer();
        Properties addProps = new Properties(properties);
        String template = this.getTemplate(properties, "add.import.testsuite", "default");
        PackageDoc[] subPackages = this.getDirectSubPackages(packageDocs, indexPackage);
        int i = 0;
        while (i < subPackages.length) {
            if (this.isTestablePackage(subPackages[i], naming)) {
                addProps.setProperty("add.testsuite.name", naming.getTestSuiteName(subPackages[i].name()));
                addProps.setProperty("testsuite.package.name", naming.getTestPackageName(subPackages[i].name()));
                sb.append(StringHelper.replaceVariables(template, addProps));
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean isFirstTestableMethodWithName(MethodDoc[] methodDocs, int index) {
        boolean returnValue = true;
        String reference = methodDocs[index].name();
        int i = 0;
        while (i < index && returnValue) {
            if (reference.equals(methodDocs[i].name()) && this.isTestableMethod(methodDocs[i])) {
                returnValue = false;
            }
            ++i;
        }
        return returnValue;
    }

    public int countTestableMethodsWithName(MethodDoc[] methodDocs, String methodName) {
        int returnValue = 0;
        int i = 0;
        while (i < methodDocs.length) {
            if (methodName.equals(methodDocs[i].name()) && this.isTestableMethod(methodDocs[i])) {
                ++returnValue;
            }
            ++i;
        }
        return returnValue;
    }

    public Properties getTestAccessorProperties(MethodDoc[] methodDocs, int index, ClassDoc classDoc, PackageDoc packageDoc, NamingStrategy naming, Properties properties) {
        Properties returnValue = null;
        String methodName = methodDocs[index].name();
        int indexAccessorPair = this.getAccessorPairIndex(methodDocs, index);
        if (indexAccessorPair >= 0) {
            if (methodName.startsWith(ACCESSOR_STARTS_WITH[indexAccessorPair][INDEX_SET]) && this.isFirstTestableMethodWithName(methodDocs, index)) {
                String accessedPropertyName = this.getAccessedPropertyName(methodName, indexAccessorPair);
                if (accessedPropertyName != null && accessedPropertyName.length() > 0) {
                    String testMethodName = naming.getTestAccessorName(ACCESSOR_STARTS_WITH[indexAccessorPair][INDEX_SET], ACCESSOR_STARTS_WITH[indexAccessorPair][INDEX_GET], accessedPropertyName);
                    String setAccessorName = ACCESSOR_STARTS_WITH[indexAccessorPair][INDEX_SET] + accessedPropertyName;
                    String getAccessorName = ACCESSOR_STARTS_WITH[indexAccessorPair][INDEX_GET] + accessedPropertyName;
                    Parameter[] parameters = methodDocs[index].parameters();
                    if (parameters != null && parameters.length == 1) {
                        String accessorTypeName = parameters[0].typeName();
                        int indexArray = accessorTypeName.indexOf("[]");
                        String testsByType = indexArray == -1 ? this.getAccessorTestsByType(properties, "default", accessorTypeName) : this.getAccessorTestsByType(properties, "array", accessorTypeName.substring(0, indexArray));
                        returnValue = new Properties(properties);
                        returnValue.setProperty("accessor.tests", testsByType);
                        returnValue.setProperty("accessor.name", testMethodName);
                        returnValue.setProperty("accessor.set.name", setAccessorName);
                        returnValue.setProperty("accessor.get.name", getAccessorName);
                        returnValue.setProperty("accessor.type.name", accessorTypeName);
                        returnValue.setProperty("testmethod.name", testMethodName);
                        returnValue.setProperty("template.name", "accessor");
                        returnValue.setProperty("method.name", methodDocs[index].name());
                    }
                } else {
                    returnValue = properties;
                }
            }
            if (methodName.startsWith(ACCESSOR_STARTS_WITH[indexAccessorPair][INDEX_GET])) {
                returnValue = null;
            }
        } else {
            returnValue = properties;
        }
        return returnValue;
    }

    public int getAccessorPairIndex(MethodDoc[] methodDocs, int index) {
        int returnValue = -1;
        boolean foundSet = false;
        boolean foundGet = false;
        boolean exactlyOneParamSet = true;
        boolean exactlyZeroParamGet = true;
        if (this.isTestableMethod(methodDocs[index])) {
            int i = 0;
            while (returnValue == -1 && i < ACCESSOR_STARTS_WITH.length) {
                String accessedPropertyName = this.getAccessedPropertyName(methodDocs[index].name(), i);
                if (accessedPropertyName != null && accessedPropertyName.length() > 0) {
                    String setAccessorName = ACCESSOR_STARTS_WITH[i][INDEX_SET] + accessedPropertyName;
                    String getAccessorName = ACCESSOR_STARTS_WITH[i][INDEX_GET] + accessedPropertyName;
                    int j = 0;
                    while (returnValue == -1 && j < methodDocs.length) {
                        if (this.isTestableMethod(methodDocs[j])) {
                            if (getAccessorName.equals(methodDocs[j].name())) {
                                foundGet |= true;
                                exactlyZeroParamGet &= DefaultTestingStrategy.getNumberOfParameters(methodDocs[j]) == 0;
                            } else if (setAccessorName.equals(methodDocs[j].name())) {
                                foundSet |= true;
                                exactlyOneParamSet &= DefaultTestingStrategy.getNumberOfParameters(methodDocs[j]) == 1;
                            }
                        }
                        ++j;
                    }
                    if (foundGet && foundSet && exactlyOneParamSet && exactlyZeroParamGet) {
                        returnValue = i;
                    }
                }
                ++i;
            }
        }
        return returnValue;
    }

    private static int getNumberOfParameters(MethodDoc methodDoc) {
        if (methodDoc.parameters() != null) {
            return methodDoc.parameters().length;
        }
        return 0;
    }

    public String getAccessedPropertyName(String accessorMethodName, int indexAccessorPair) {
        String returnValue = null;
        if (accessorMethodName != null && accessorMethodName.length() > 0) {
            int setOrGet = 0;
            while (returnValue == null && setOrGet < ACCESSOR_STARTS_WITH[indexAccessorPair].length) {
                String prefix = ACCESSOR_STARTS_WITH[indexAccessorPair][setOrGet];
                if (accessorMethodName.startsWith(prefix)) {
                    returnValue = accessorMethodName.substring(prefix.length());
                }
                ++setOrGet;
            }
        }
        return returnValue;
    }

    public String getAccessorTestsByType(Properties properties, String templateAttribute, String type) {
        String returnValue = null;
        if ("default".equals(templateAttribute)) {
            returnValue = properties.getProperty("accessor.tests." + type);
        }
        if (returnValue == null) {
            String template = this.getTemplate(properties, "accessor.tests", templateAttribute);
            Properties addProps = new Properties(properties);
            addProps.put("accessor.type.name", type);
            returnValue = StringHelper.replaceVariables(template, addProps);
        }
        if (returnValue != null) {
            returnValue = returnValue.trim();
        }
        return returnValue;
    }

    public boolean isInnerClass(ClassDoc doc) {
        boolean returnValue = false;
        if (doc != null) {
            returnValue = -1 < doc.name().indexOf(".");
        }
        return returnValue;
    }

    public boolean isATest(ClassDoc doc) {
        boolean returnValue = false;
        ClassDoc temp = doc;
        while (!returnValue && temp != null) {
            String tempName = temp.qualifiedName();
            if (tempName.equals(JUNIT_TEST_CLASS_NAME)) {
                returnValue = true;
            } else {
                ClassDoc[] interfaces = temp.interfaces();
                int i = 0;
                while (interfaces != null && i < interfaces.length) {
                    tempName = interfaces[i].qualifiedName();
                    if (tempName.equals(JUNIT_TEST_CLASS_NAME)) {
                        returnValue = true;
                    }
                    ++i;
                }
            }
            temp = temp.superclass();
        }
        return returnValue;
    }

    public boolean hasSuiteMethod(ClassDoc doc) {
        boolean returnValue = false;
        MethodDoc[] methods = doc.methods();
        int i = 0;
        while (!returnValue && i < methods.length) {
            MethodDoc method = methods[i];
            returnValue |= TESTSUITE_SUITE_METHOD_NAME.equals(method.name()) && method.isStatic();
            ++i;
        }
        return returnValue;
    }

    public PackageDoc[] getDirectSubPackages(PackageDoc[] packageDocs, int indexCurrentPackage) {
        LinkedList<PackageDoc> list = new LinkedList<PackageDoc>();
        String subStart = packageDocs[indexCurrentPackage].name() + ".";
        int i = 0;
        while (i < packageDocs.length) {
            String tempPackageName = packageDocs[i].name();
            if (i != indexCurrentPackage && tempPackageName.startsWith(subStart) && -1 == tempPackageName.indexOf(".", subStart.length())) {
                list.add(packageDocs[i]);
            }
            ++i;
        }
        return list.toArray(new PackageDoc[0]);
    }

    public boolean isValid(String code) {
        return this.hasAllRequiredStrings(code) && this.isValidStructure(code);
    }

    public boolean hasAllRequiredStrings(String code) {
        int i;
        boolean returnValue = true;
        if (requiredStrings == null) {
            requiredStrings = new String[MINIMUM_MARKER_SET.length];
            i = 0;
            while (i < MINIMUM_MARKER_SET.length) {
                DefaultTestingStrategy.requiredStrings[i] = MINIMUM_MARKER_SET[i].trim();
                ++i;
            }
        }
        i = 0;
        while (i < requiredStrings.length) {
            if (code.indexOf(requiredStrings[i]) == -1) {
                returnValue = false;
            }
            ++i;
        }
        return returnValue;
    }

    public boolean isValidStructure(String code) {
        boolean returnValue = true;
        if (code != null) {
            int indexBegin = code.indexOf("// JUnitDoclet begin ");
            int indexEnd = code.indexOf("// JUnitDoclet end ");
            while (returnValue && indexBegin < indexEnd && indexBegin > -1) {
                String markDescription = code.substring(indexBegin + "// JUnitDoclet begin ".length(), code.indexOf("\n", indexBegin));
                indexEnd = indexBegin + "// JUnitDoclet begin ".length();
                while ((indexEnd = code.indexOf("// JUnitDoclet end " + markDescription, indexEnd)) > 0 && Character.isWhitespace(code.charAt(indexEnd))) {
                }
                if (indexEnd > -1) {
                    int indexContentEnd;
                    int indexContentBegin = code.indexOf("\n", indexBegin + "// JUnitDoclet begin ".length());
                    if (indexContentBegin < (indexContentEnd = code.lastIndexOf("\n", indexEnd))) {
                        returnValue = this.isValidStructure(code.substring(indexContentBegin, indexContentEnd));
                    }
                } else {
                    returnValue = false;
                }
                indexBegin = code.indexOf("// JUnitDoclet begin ", indexEnd + 1);
                indexEnd = code.indexOf("// JUnitDoclet end ", indexEnd + 1);
            }
            returnValue = returnValue && indexBegin * indexEnd > 0;
            returnValue = returnValue && (indexBegin < 0 || indexBegin < indexEnd);
        } else {
            this.printError("DefaultTestingStrategy.isValidStructure() code == null");
            returnValue = false;
        }
        return returnValue;
    }

    public boolean merge(StringBuffer inOutCode, StringBuffer inCode, String fullClassName) {
        boolean returnValue = true;
        if (inOutCode != null) {
            if (inCode != null) {
                String oldContent = inCode.toString();
                StringBuffer unmatched = new StringBuffer();
                int oldIndexLeft = oldContent.indexOf("// JUnitDoclet begin ", 0);
                int oldIndexRight = oldContent.indexOf("\n", oldIndexLeft) + "\n".length();
                if (this.isValid(oldContent)) {
                    int insertToIndex;
                    String newContent;
                    while (oldIndexRight > -1 && oldIndexLeft > -1) {
                        String markDescription = oldContent.substring(oldIndexLeft + "// JUnitDoclet begin ".length(), oldIndexRight).trim();
                        oldIndexLeft = oldIndexRight;
                        oldIndexRight = oldContent.indexOf("// JUnitDoclet end " + markDescription, oldIndexLeft);
                        oldIndexRight = oldContent.lastIndexOf("\n", oldIndexRight) + "\n".length();
                        String markContent = oldContent.substring(oldIndexLeft, oldIndexRight);
                        newContent = inOutCode.toString();
                        int insertFromIndex = 0;
                        do {
                            if ((insertFromIndex = newContent.indexOf("// JUnitDoclet begin " + markDescription, insertFromIndex)) <= -1) continue;
                            insertFromIndex = insertFromIndex + "// JUnitDoclet begin ".length() + markDescription.length();
                        } while (insertFromIndex > -1 && !Character.isWhitespace(newContent.charAt(insertFromIndex)));
                        if (insertFromIndex > -1) {
                            while (insertFromIndex - 1 < newContent.length() && newContent.charAt(insertFromIndex - 1) != '\n') {
                                ++insertFromIndex;
                            }
                            insertToIndex = newContent.indexOf("// JUnitDoclet end " + markDescription, insertFromIndex);
                        } else {
                            insertToIndex = -1;
                        }
                        while (insertToIndex > 0 && newContent.charAt(insertToIndex - 1) == ' ') {
                            --insertToIndex;
                        }
                        if (insertFromIndex != -1 && insertToIndex != -1) {
                            if (this.containsCodeOrComment(markContent)) {
                                inOutCode.replace(insertFromIndex, insertToIndex, markContent);
                            }
                        } else if (this.containsCodeOrComment(markContent)) {
                            unmatched.append("// JUnitDoclet begin " + markDescription);
                            unmatched.append("\n");
                            unmatched.append(markContent);
                            unmatched.append("// JUnitDoclet end " + markDescription);
                            unmatched.append("\n");
                        }
                        oldIndexLeft = oldContent.indexOf("// JUnitDoclet begin ", oldIndexRight);
                        oldIndexRight = oldContent.indexOf("\n", oldIndexLeft) + "\n".length();
                    }
                    if (unmatched.length() > 0) {
                        newContent = inOutCode.toString();
                        insertToIndex = newContent.lastIndexOf("testVault");
                        while (insertToIndex > 0 && newContent.charAt(insertToIndex - 1) != '\n') {
                            --insertToIndex;
                        }
                        if (insertToIndex != -1) {
                            inOutCode.insert(insertToIndex, unmatched.toString());
                        }
                    }
                    if (this.hasUnmatchedMarkers(inOutCode.toString())) {
                        this.printWarning("Class " + fullClassName + " contains unmatched tests.");
                    }
                } else {
                    this.printWarning("Class " + fullClassName + " was not generated by JUnitDoclet. It's not overwritten.\n" + "Please rename and start JUnitDoclet again.");
                    returnValue = false;
                }
            }
        } else {
            this.printError("DefaultTestingStrategy.merge() inOutCode == null");
        }
        return returnValue;
    }

    public boolean containsCodeOrComment(String markContent) {
        boolean returnValue = false;
        if (markContent != null && markContent.length() > 0) {
            int i = 0;
            while (!returnValue && i < markContent.length()) {
                char ch = markContent.charAt(i);
                returnValue = !Character.isWhitespace(ch);
                ++i;
            }
        }
        return returnValue;
    }

    public boolean hasUnmatchedMarkers(String code) {
        boolean returnValue = false;
        int beginUnmatched = StringHelper.indexOfTwoPartString(code, "// JUnitDoclet begin method", "testcase.testVault", 0);
        int endUnmatched = StringHelper.indexOfTwoPartString(code, "// JUnitDoclet end method", "testcase.testVault", beginUnmatched);
        if (beginUnmatched != -1 && endUnmatched != -1 && endUnmatched > beginUnmatched) {
            int tempUnmatched = beginUnmatched + "// JUnitDoclet begin method".length() + "testVault".length();
            while ('\n' != code.charAt(tempUnmatched)) {
                ++tempUnmatched;
            }
            while (tempUnmatched < endUnmatched && Character.isWhitespace(code.charAt(tempUnmatched))) {
                ++tempUnmatched;
            }
            if (tempUnmatched < endUnmatched) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    static {
        TESTSUITE_SUITE_METHOD_NAME = TESTSUITE_SUITE_METHOD_NAME;
        JUNIT_TEST_CLASS_NAME = JUNIT_TEST_CLASS_NAME;
        ACCESSOR_STARTS_WITH = new String[][]{{"set", "get"}, {"set", "is"}};
        INDEX_SET = 0;
        INDEX_GET = 1;
        requiredStrings = null;
        MINIMUM_MARKER_SET = new String[]{"// JUnitDoclet begin import", "// JUnitDoclet end import", "// JUnitDoclet begin extends_implements", "// JUnitDoclet end extends_implements", "// JUnitDoclet begin class", "// JUnitDoclet end class"};
    }
}

