/*
 * Decompiled with CFR 0.152.
 */
package com.objectfab.tools.junitdoclet;

import com.objectfab.tools.junitdoclet.DefaultConfigurableStrategy;
import com.objectfab.tools.junitdoclet.JUnitDocletProperties;
import com.objectfab.tools.junitdoclet.WritingStrategy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class DefaultWritingStrategy
extends DefaultConfigurableStrategy
implements WritingStrategy,
JUnitDocletProperties {
    private static int INDENT_WIDTH = 2;

    public void indent(StringBuffer sourceCode) {
        int indentLevel = 0;
        int beginIndex = 0;
        int endIndex = 0;
        int opening = 0;
        int closing = 0;
        int inserted = 0;
        boolean openingFirst = false;
        boolean closingFirst = false;
        if (sourceCode != null) {
            while (endIndex < sourceCode.length()) {
                switch (sourceCode.charAt(endIndex)) {
                    case '{': {
                        ++opening;
                        if (closingFirst) break;
                        openingFirst = true;
                        break;
                    }
                    case '}': {
                        ++closing;
                        if (openingFirst) break;
                        closingFirst = true;
                        break;
                    }
                    case '\n': {
                        if (closing > opening) {
                            indentLevel -= closing - opening;
                        }
                        if (closing == opening && closingFirst) {
                            --indentLevel;
                        }
                        inserted = 0;
                        int i = 0;
                        while (i < indentLevel * INDENT_WIDTH) {
                            if (sourceCode.charAt(beginIndex + i) != ' ') {
                                sourceCode.insert(beginIndex + i, " ");
                                ++inserted;
                            }
                            ++i;
                        }
                        endIndex += inserted;
                        if (closing == opening && closingFirst) {
                            ++indentLevel;
                        }
                        if (opening > closing) {
                            indentLevel += opening - closing;
                        }
                        beginIndex = endIndex + 1;
                        opening = 0;
                        closing = 0;
                        openingFirst = false;
                        closingFirst = false;
                    }
                }
                ++endIndex;
            }
        }
    }

    public StringBuffer loadClassSource(String root, String fullClassName) {
        StringBuffer returnValue = null;
        File file = null;
        BufferedReader bufferedReader = null;
        String name = this.translateClassNameToFileName(fullClassName);
        try {
            file = new File(root, name);
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
                returnValue = new StringBuffer();
                while (bufferedReader.ready()) {
                    String line = bufferedReader.readLine();
                    returnValue.append(line);
                    returnValue.append("\n");
                }
                bufferedReader.close();
                bufferedReader = null;
            }
            file = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe.toString());
        }
        return returnValue;
    }

    public void writeClassSource(String root, String fullClassName, StringBuffer sourceCode) {
        File file = null;
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        String name = this.translateClassNameToFileName(fullClassName);
        try {
            file = new File(root, name);
            file.getParentFile().mkdirs();
            fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(sourceCode.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedWriter = null;
            fileWriter = null;
            file = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe.toString());
        }
        if (fileWriter != null) {
            try {
                fileWriter.close();
                fileWriter = null;
                file = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new RuntimeException(ioe.toString());
            }
        }
    }

    public String translateClassNameToFileName(String className) {
        String returnValue = className.replace('.', File.separatorChar) + ".java";
        return returnValue;
    }

    public boolean isExistingAndNewer(String dirInQuestion, String fullClassNameInQuestion, String dirReference, String fullClassNameReference) {
        boolean returnValue = false;
        if (dirInQuestion != null && fullClassNameInQuestion != null && dirReference != null && fullClassNameReference != null) {
            File inQuestion = new File(dirInQuestion, this.translateClassNameToFileName(fullClassNameInQuestion));
            File reference = new File(dirReference, this.translateClassNameToFileName(fullClassNameReference));
            returnValue = inQuestion.exists() && inQuestion.lastModified() > reference.lastModified();
        }
        return returnValue;
    }
}

