/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.TargetResolver;
import org.apache.axis2.util.UUIDGenerator;

public abstract class OperationClient {
    protected AxisOperation axisOp;
    protected ServiceContext sc;
    protected Options options;
    protected OperationContext oc;
    protected Callback callback;
    protected boolean completed;

    protected OperationClient(AxisOperation axisOp, ServiceContext sc, Options options) {
        this.axisOp = axisOp;
        this.sc = sc;
        this.options = options;
        this.completed = false;
        this.oc = new OperationContext(axisOp);
        this.oc.setParent(this.sc);
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public abstract void addMessageContext(MessageContext var1) throws AxisFault;

    public abstract MessageContext getMessageContext(String var1) throws AxisFault;

    public abstract void setCallback(Callback var1);

    public abstract void execute(boolean var1) throws AxisFault;

    public void reset() throws AxisFault {
        if (!this.completed) {
            throw new AxisFault(Messages.getMessage("cannotreset"));
        }
        this.oc = null;
        this.completed = false;
    }

    public void complete(MessageContext msgCtxt) throws AxisFault {
        TransportOutDescription trsout = msgCtxt.getTransportOut();
        if (trsout != null) {
            trsout.getSender().cleanup(msgCtxt);
        }
    }

    public OperationContext getOperationContext() {
        return this.oc;
    }

    protected void setMessageID(MessageContext mc) {
        String messageId = this.options.getMessageId();
        if (messageId == null || "".equals(messageId)) {
            messageId = UUIDGenerator.getUUID();
        }
        mc.setMessageID(messageId);
    }

    protected void addReferenceParameters(MessageContext msgctx) {
        Map map;
        EndpointReference tepr;
        EndpointReference to = msgctx.getTo();
        if (this.options.isManageSession() && (tepr = this.sc.getTargetEPR()) != null && (map = tepr.getAllReferenceParameters()) != null) {
            Iterator valuse = map.values().iterator();
            while (valuse.hasNext()) {
                Object refparaelement = valuse.next();
                if (!(refparaelement instanceof OMElement)) continue;
                to.addReferenceParameter((OMElement)refparaelement);
            }
        }
    }

    protected void prepareMessageContext(ConfigurationContext cc, MessageContext mc) throws AxisFault {
        TransportOutDescription senderTransport;
        if (mc.getSoapAction() == null || "".equals(mc.getSoapAction())) {
            mc.setSoapAction(this.options.getAction());
        }
        mc.setOptions(this.options);
        mc.setAxisMessage(this.axisOp.getMessage("Out"));
        TargetResolver targetResolver = cc.getAxisConfiguration().getTargetResolverChain();
        if (targetResolver != null) {
            targetResolver.resolveTarget(mc);
        }
        if ((senderTransport = this.options.getTransportOut()) == null) {
            EndpointReference toEPR = this.options.getTo() != null ? this.options.getTo() : mc.getTo();
            senderTransport = ClientUtils.inferOutTransport(cc.getAxisConfiguration(), toEPR, mc);
        }
        mc.setTransportOut(senderTransport);
        this.addReferenceParameters(mc);
    }
}

