/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemConfigurator
extends DeploymentEngine
implements AxisConfigurator {
    private static final Log log = LogFactory.getLog((Class)FileSystemConfigurator.class);
    private String axis2xml = null;
    private String repoLocation = null;

    public FileSystemConfigurator(String repoLocation, String axis2xml) {
        if (repoLocation == null) {
            repoLocation = System.getProperty("axis2.repo");
        }
        try {
            File repo;
            if (repoLocation != null && (repo = new File(repoLocation)).exists()) {
                this.repoLocation = repo.getAbsolutePath();
            }
        }
        catch (Exception e) {
            log.info((Object)("Couldn't find repository location '" + repoLocation + "'"));
            this.repoLocation = null;
        }
        if (axis2xml == null && (axis2xml = System.getProperty("axis2.xml")) != null) {
            try {
                File configFile = new File(axis2xml);
                if (!configFile.exists()) {
                    axis2xml = null;
                }
            }
            catch (Exception e) {
                axis2xml = null;
                log.info((Object)"Error in file (axis2.xml) creation inside FileSystemConfigurator");
            }
        }
        this.axis2xml = axis2xml;
    }

    public synchronized AxisConfiguration getAxisConfiguration() throws AxisFault {
        try {
            InputStream axis2xmlSream;
            if (this.axis2xml != null && !"".equals(this.axis2xml)) {
                axis2xmlSream = new FileInputStream(this.axis2xml);
            } else {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                axis2xmlSream = cl.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml");
            }
            this.axisConfig = this.populateAxisConfiguration(axis2xmlSream);
        }
        catch (FileNotFoundException e) {
            throw new AxisFault("System can not find the given axis2.xml " + this.axis2xml);
        }
        Parameter axis2repoPara = this.axisConfig.getParameter("repository");
        if (axis2repoPara != null) {
            this.repoLocation = (String)axis2repoPara.getValue();
        }
        if (this.repoLocation != null && !"".equals(this.repoLocation)) {
            this.loadRepository(this.repoLocation);
        } else {
            this.loadFromClassPath();
        }
        return this.axisConfig;
    }

    public void engageGlobalModules() throws AxisFault {
        this.engageModules();
    }

    public void loadServices() {
        if (this.repoLocation != null && !"".equals(this.repoLocation)) {
            super.loadServices();
        }
    }
}

