/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.i18n.Messages;

public class ServiceGroupBuilder
extends DescriptionBuilder {
    private OMElement serviceElement;
    private HashMap wsdlServices;

    public ServiceGroupBuilder(OMElement service, HashMap wsdlServices, ConfigurationContext configCtx) {
        this.serviceElement = service;
        this.wsdlServices = wsdlServices;
        this.configCtx = configCtx;
        this.axisConfig = this.configCtx.getAxisConfiguration();
    }

    public ArrayList populateServiceGroup(AxisServiceGroup axisServiceGroup) throws DeploymentException {
        ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
        try {
            Iterator itr = this.serviceElement.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, axisServiceGroup, axisServiceGroup.getParent());
            Iterator moduleConfigs = this.serviceElement.getChildrenWithName(new QName("moduleConfig"));
            this.processServiceModuleConfig(moduleConfigs, axisServiceGroup.getParent(), axisServiceGroup);
            Iterator moduleRefs = this.serviceElement.getChildrenWithName(new QName("module"));
            this.processModuleRefs(moduleRefs, axisServiceGroup);
            Iterator serviceitr = this.serviceElement.getChildrenWithName(new QName("service"));
            while (serviceitr.hasNext()) {
                OMElement service = (OMElement)serviceitr.next();
                OMAttribute serviceNameatt = service.getAttribute(new QName("name"));
                if (serviceNameatt == null) {
                    throw new DeploymentException(Messages.getMessage("servicenameeror"));
                }
                String serviceName = serviceNameatt.getAttributeValue();
                if (serviceName == null || "".equals(serviceName)) {
                    throw new DeploymentException(Messages.getMessage("servicenameeror"));
                }
                AxisService axisService = (AxisService)this.wsdlServices.get(serviceName);
                if (axisService == null) {
                    axisService = new AxisService(serviceName);
                } else {
                    axisService.setWsdlFound(true);
                }
                axisService.setParent(axisServiceGroup);
                axisService.setClassLoader(axisServiceGroup.getServiceGroupClassLoader());
                ServiceBuilder serviceBuilder = new ServiceBuilder(this.configCtx, axisService);
                AxisService as = serviceBuilder.populateService(service);
                serviceList.add(as);
            }
        }
        catch (AxisFault e) {
            throw new DeploymentException(e);
        }
        return serviceList;
    }

    protected void processModuleRefs(Iterator moduleRefs, AxisServiceGroup axisServiceGroup) throws DeploymentException {
        try {
            while (moduleRefs.hasNext()) {
                OMElement moduleref = (OMElement)moduleRefs.next();
                OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
                if (moduleRefAttribute == null) continue;
                String refName = moduleRefAttribute.getAttributeValue();
                if (this.axisConfig.getModule(new QName(refName)) == null) {
                    throw new DeploymentException(Messages.getMessage("modulenotfound", refName));
                }
                axisServiceGroup.addModuleref(new QName(refName));
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
    }

    protected void processServiceModuleConfig(Iterator moduleConfigs, ParameterInclude parent, AxisServiceGroup axisService) throws DeploymentException {
        while (moduleConfigs.hasNext()) {
            OMElement moduleConfig = (OMElement)moduleConfigs.next();
            OMAttribute moduleName_att = moduleConfig.getAttribute(new QName("name"));
            if (moduleName_att == null) {
                throw new DeploymentException(Messages.getMessage("invalidmoduleconfig"));
            }
            String module = moduleName_att.getAttributeValue();
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration(new QName(module), parent);
            Iterator parameters = moduleConfig.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, moduleConfiguration, parent);
            axisService.addModuleConfig(moduleConfiguration);
        }
    }
}

