/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.wsdl.WSDLConstants;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.WSDLSource;
import org.apache.woden.internal.DOMWSDLFactory;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFaultReference;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.enumeration.Direction;
import org.apache.woden.wsdl20.enumeration.MessageLabel;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.UnknownExtensionElement;
import org.apache.woden.wsdl20.xml.BindingElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDL20ToAxisServiceBuilder
extends WSDLToAxisServiceBuilder {
    protected Description description;
    private String wsdlURI;
    private static String RPC = "rpc";
    protected String interfaceName;
    private String savedTargetNamespace;
    private Map namespacemap;
    private NamespaceMap stringBasedNamespaceMap;
    private boolean setupComplete = false;

    public WSDL20ToAxisServiceBuilder(InputStream in, QName serviceName, String interfaceName) {
        this.in = in;
        this.serviceName = serviceName;
        this.interfaceName = interfaceName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, String name, String interfaceName) throws Exception {
        WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        DescriptionElement descriptionElement = wsdlReader.readWSDL(wsdlUri);
        this.savedTargetNamespace = descriptionElement.getTargetNamespace().toString();
        this.namespacemap = descriptionElement.getNamespaces();
        this.description = descriptionElement.toComponent();
        this.serviceName = null;
        if (name != null) {
            this.serviceName = new QName(descriptionElement.getTargetNamespace().toString(), name);
        }
        this.interfaceName = interfaceName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, QName serviceName) {
        super(null, serviceName);
        this.wsdlURI = wsdlUri;
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, AxisService service) {
        super(null, service);
        this.wsdlURI = wsdlUri;
    }

    public AxisService populateService() throws AxisFault {
        try {
            this.setup();
            Parameter wsdlDescriptionParamter = new Parameter();
            wsdlDescriptionParamter.setName("WSDL20Description");
            wsdlDescriptionParamter.setValue(this.description);
            this.axisService.addParameter(wsdlDescriptionParamter);
            if (this.description == null) {
                return null;
            }
            this.axisService.setTargetNamespace(this.savedTargetNamespace);
            this.axisService.setNameSpacesMap(this.stringBasedNamespaceMap);
            TypesElement typesElement = this.description.toElement().getTypesElement();
            if (typesElement != null) {
                Schema[] schemas = typesElement.getSchemas();
                for (int i = 0; i < schemas.length; ++i) {
                    XmlSchema schemaDefinition = schemas[i].getSchemaDefinition();
                    if (schemaDefinition == null || "http://www.w3.org/2001/XMLSchema".equals(schemaDefinition.getTargetNamespace())) continue;
                    this.axisService.addSchema(schemaDefinition);
                }
            }
            Binding binding = this.findBinding(this.description);
            this.processBinding(binding, this.description);
            return this.axisService;
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    protected void setup() throws AxisFault {
        if (this.setupComplete) {
            return;
        }
        try {
            if (this.description == null) {
                DescriptionElement descriptionElement = null;
                if (this.wsdlURI != null && !"".equals(this.wsdlURI)) {
                    descriptionElement = this.readInTheWSDLFile(this.wsdlURI);
                } else if (this.in != null) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(this.in);
                    WSDLReader reader = DOMWSDLFactory.newInstance().newWSDLReader();
                    WSDLSource wsdlSource = reader.createWSDLSource();
                    wsdlSource.setSource((Object)document.getDocumentElement());
                    descriptionElement = reader.readWSDL(wsdlSource);
                } else {
                    throw new AxisFault("No resources found to read the wsdl");
                }
                this.savedTargetNamespace = descriptionElement.getTargetNamespace().toString();
                this.namespacemap = descriptionElement.getNamespaces();
                this.description = descriptionElement.toComponent();
            }
            this.stringBasedNamespaceMap = new NamespaceMap();
            Iterator iterator = this.namespacemap.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                this.stringBasedNamespaceMap.put((Object)key, (Object)this.namespacemap.get(key).toString());
            }
            this.setupComplete = true;
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    private void processBinding(Binding binding, Description description) throws Exception {
        if (binding != null) {
            Interface serviceInterface = binding.getInterface();
            this.processInterface(serviceInterface, description);
        }
    }

    private void processInterface(Interface serviceInterface, Description dif) throws Exception {
        InterfaceOperation[] interfaceOperations = serviceInterface.getInterfaceOperations();
        for (int i = 0; i < interfaceOperations.length; ++i) {
            this.axisService.addOperation(this.populateOperations(interfaceOperations[i], this.description));
        }
    }

    private AxisOperation populateOperations(InterfaceOperation operation, Description description) throws Exception {
        QName opName = operation.getName();
        AxisOperation axisOperation = this.axisService.getOperation(opName);
        if (axisOperation == null) {
            String MEP = operation.getMessageExchangePattern().toString();
            axisOperation = AxisOperationFactory.getOperationDescription(MEP);
            axisOperation.setName(opName);
            PolicyInclude pi = axisOperation.getPolicyInclude();
            if (pi == null) {
                pi = new PolicyInclude();
                axisOperation.setPolicyInclude(pi);
            }
            pi.setPolicyRegistry(this.registry);
        }
        axisOperation.setStyle("document");
        InterfaceMessageReference[] interfaceMessageReferences = operation.getInterfaceMessageReferences();
        for (int i = 0; i < interfaceMessageReferences.length; ++i) {
            AxisMessage outMessage;
            InterfaceMessageReferenceElement messageReference = interfaceMessageReferences[i].toElement();
            MessageLabel messageLabel = messageReference.getMessageLabel();
            messageReference.getMessageLabel();
            if (messageLabel.equals(MessageLabel.IN)) {
                AxisMessage inMessage;
                if (this.isServerSide) {
                    inMessage = axisOperation.getMessage("In");
                    inMessage.setElementQName(messageReference.getElementName());
                    inMessage.setName(messageReference.getElementName().getLocalPart());
                    continue;
                }
                inMessage = axisOperation.getMessage("Out");
                inMessage.setElementQName(messageReference.getElementName());
                inMessage.setName(messageReference.getElementName().getLocalPart());
                continue;
            }
            MessageLabel messageLabel2 = messageReference.getMessageLabel();
            messageReference.getMessageLabel();
            if (!messageLabel2.equals(MessageLabel.OUT)) continue;
            if (this.isServerSide) {
                outMessage = axisOperation.getMessage("Out");
                outMessage.setElementQName(messageReference.getElementName());
                outMessage.setName(messageReference.getElementName().getLocalPart());
                continue;
            }
            outMessage = axisOperation.getMessage("In");
            outMessage.setElementQName(messageReference.getElementName());
            outMessage.setName(messageReference.getElementName().getLocalPart());
        }
        InterfaceFaultReference[] faults = operation.getInterfaceFaultReferences();
        for (int i = 0; i < faults.length; ++i) {
            AxisMessage faultMessage = new AxisMessage();
            InterfaceFaultReferenceElement interfaceFaultReferenceElement = faults[i].toElement();
            faultMessage.setDirection(interfaceFaultReferenceElement.getDirection().toString());
            faultMessage.setElementQName(interfaceFaultReferenceElement.getInterfaceFaultElement().getElementName());
            faultMessage.setName(interfaceFaultReferenceElement.getRef().getLocalPart());
            axisOperation.setFaultMessages(faultMessage);
        }
        return axisOperation;
    }

    private void copyExtensibleElements(ExtensionElement[] extensionElement, DescriptionElement descriptionElement, AxisDescription description, String originOfExtensibilityElements) {
        for (int i = 0; i < extensionElement.length; ++i) {
            ExtensionElement element = extensionElement[i];
            if (!(element instanceof UnknownExtensionElement)) continue;
            UnknownExtensionElement unknown = (UnknownExtensionElement)element;
            if (WSDLConstants.WSDL11Constants.SOAP_12_OPERATION.equals(unknown.getExtensionType())) {
                Element unknownElement = unknown.getElement();
                if (!(description instanceof AxisOperation)) continue;
                AxisOperation axisOperation = (AxisOperation)description;
                String style = unknownElement.getAttribute("style");
                if (style != null) {
                    axisOperation.setStyle(style);
                }
                axisOperation.setSoapAction(unknownElement.getAttribute("soapAction"));
                continue;
            }
            if (WSDLConstants.WSDL11Constants.SOAP_12_HEADER.equals(unknown.getExtensionType())) continue;
            if (WSDLConstants.WSDL11Constants.SOAP_12_BINDING.equals(unknown.getExtensionType())) {
                this.style = unknown.getElement().getAttribute("style");
                this.axisService.setSoapNsUri(element.getExtensionType().getNamespaceURI());
                continue;
            }
            if (WSDLConstants.WSDL11Constants.SOAP_12_ADDRESS.equals(unknown.getExtensionType())) {
                this.axisService.setEndpoint(unknown.getElement().getAttribute("location"));
                continue;
            }
            if (!WSDLConstants.WSDL11Constants.POLICY.equals(unknown.getExtensionType()) && !WSDLConstants.WSDL11Constants.POLICY_REFERENCE.equals(unknown.getExtensionType())) continue;
        }
    }

    private Binding findBinding(Description discription) throws AxisFault {
        Service[] services = discription.getServices();
        Service service = null;
        Endpoint endpoint = null;
        Binding binding = null;
        if (services.length == 0) {
            throw new AxisFault("No service found in the WSDL");
        }
        if (this.serviceName != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!this.serviceName.equals(services[i].getName())) continue;
                service = services[i];
                break;
            }
            if (service == null) {
                throw new AxisFault("Service not found the WSDL " + this.serviceName.getLocalPart());
            }
        } else {
            service = services[0];
        }
        Endpoint[] endpoints = service.getEndpoints();
        if (this.interfaceName != null) {
            if (endpoints.length == 0) {
                throw new AxisFault("No Endpoints/Ports found in the service:" + service.getName().getLocalPart());
            }
            for (int i = 0; i < endpoints.length; ++i) {
                if (!this.interfaceName.equals(endpoints[i].getName().toString())) continue;
                endpoint = endpoints[i];
                break;
            }
            if (endpoint == null) {
                throw new AxisFault("No port found for the given name :" + this.interfaceName);
            }
        } else {
            endpoint = endpoints[0];
        }
        this.axisService.setName(service.getName().getLocalPart());
        if (endpoint != null) {
            this.axisService.setEndpoint(endpoint.getAddress().toString());
            binding = endpoint.getBinding();
        }
        return binding;
    }

    private Element[] generateWrapperSchema(DescriptionElement wodenDescription, BindingElement binding) {
        ArrayList<Element> schemaElementList = new ArrayList<Element>();
        String targetNamespaceUri = wodenDescription.getTargetNamespace().toString();
        schemaElementList.add(this.createSchemaForInterface(binding.getInterfaceElement(), targetNamespaceUri, this.findWrapForceable(binding)));
        return schemaElementList.toArray(new Element[schemaElementList.size()]);
    }

    private Element createSchemaForInterface(InterfaceElement interfaceElement, String targetNamespaceUri, boolean forceWrapping) {
        HashMap<QName, Object> messagesMap = new HashMap<QName, Object>();
        HashMap<QName, InterfaceMessageReferenceElement> inputOperationsMap = new HashMap<QName, InterfaceMessageReferenceElement>();
        HashMap<QName, InterfaceMessageReferenceElement> outputOperationsMap = new HashMap<QName, InterfaceMessageReferenceElement>();
        HashMap<InterfaceFaultElement, InterfaceFaultReferenceElement> faultyOperationsMap = new HashMap<InterfaceFaultElement, InterfaceFaultReferenceElement>();
        HashMap namespaceImportsMap = new HashMap();
        HashMap complexTypeElementsMap = new HashMap();
        ArrayList elementElementsList = new ArrayList();
        HashMap namespacePrefixMap = new HashMap();
        InterfaceOperationElement[] operationElements = interfaceElement.getInterfaceOperationElements();
        for (int k = 0; k < operationElements.length; ++k) {
            InterfaceOperationElement opElement = operationElements[k];
            InterfaceMessageReferenceElement[] interfaceMessageReferenceElements = opElement.getInterfaceMessageReferenceElements();
            for (int i = 0; i < interfaceMessageReferenceElements.length; ++i) {
                InterfaceMessageReferenceElement interfaceMessageReferenceElement = interfaceMessageReferenceElements[i];
                String direction = interfaceMessageReferenceElement.getDirection().toString();
                messagesMap.put(interfaceMessageReferenceElement.getElementName(), interfaceMessageReferenceElement);
                if (Direction.IN.toString().equalsIgnoreCase(direction)) {
                    inputOperationsMap.put(opElement.getName(), interfaceMessageReferenceElement);
                    continue;
                }
                if (!Direction.OUT.toString().equalsIgnoreCase(direction)) continue;
                outputOperationsMap.put(opElement.getName(), interfaceMessageReferenceElement);
            }
            InterfaceFaultReferenceElement[] interfaceFaultReferenceElements = opElement.getInterfaceFaultReferenceElements();
            for (int i = 0; i < interfaceFaultReferenceElements.length; ++i) {
                InterfaceFaultReferenceElement interfaceFaultReferenceElement = interfaceFaultReferenceElements[i];
                String direction = interfaceFaultReferenceElement.getDirection().toString();
                messagesMap.put(interfaceFaultReferenceElement.getRef(), interfaceFaultReferenceElement);
                faultyOperationsMap.put(interfaceFaultReferenceElement.getInterfaceFaultElement(), interfaceFaultReferenceElement);
            }
        }
        if (forceWrapping) {
            QName[] keys = messagesMap.keySet().toArray(new QName[messagesMap.size()]);
        } else {
            QName[] allKeys = messagesMap.keySet().toArray(new QName[messagesMap.size()]);
            ArrayList wrappableMessageNames = new ArrayList();
            boolean noMessagesTobeProcessed = true;
            if (noMessagesTobeProcessed) {
                return null;
            }
            QName[] keys = wrappableMessageNames.toArray(new QName[wrappableMessageNames.size()]);
        }
        return null;
    }

    private boolean findWrapForceable(BindingElement binding) {
        boolean retVal = false;
        if (RPC.equalsIgnoreCase(binding.getInterfaceElement().getStyleDefault().toString())) {
            return true;
        }
        if (!retVal) {
            InterfaceOperationElement[] operations = binding.getInterfaceElement().getInterfaceOperationElements();
            for (int i = 0; i < operations.length; ++i) {
                URI[] styles = operations[i].getStyle();
                for (int j = 0; j < styles.length; ++j) {
                    if (!RPC.equalsIgnoreCase(styles[j].toString())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private DescriptionElement readInTheWSDLFile(String wsdlURI) throws WSDLException {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        return reader.readWSDL(wsdlURI);
    }
}

