/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.RESTSender;
import org.apache.axis2.transport.http.SOAPOverHTTPSender;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsHTTPTransportSender
extends AbstractHandler
implements TransportSender {
    protected static final String PROXY_HOST_NAME = "proxy_host";
    protected static final String PROXY_PORT = "proxy_port";
    int soTimeout = 60000;
    protected TransportOutDescription proxyOutSetting = null;
    private static final Log log = LogFactory.getLog((Class)CommonsHTTPTransportSender.class);
    protected String httpVersion = "HTTP/1.1";
    private boolean chunked = false;
    int connectionTimeout = 60000;

    public void cleanup(MessageContext msgContext) throws AxisFault {
        HttpMethod httpMethod = (HttpMethod)msgContext.getProperty("HTTP_METHOD");
        if (httpMethod != null) {
            httpMethod.releaseConnection();
        }
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
        Parameter version = transportOut.getParameter("PROTOCOL");
        if (version != null) {
            if ("HTTP/1.1".equals(version.getValue())) {
                this.httpVersion = "HTTP/1.1";
                Parameter transferEncoding = transportOut.getParameter(HTTPConstants.HEADER_TRANSFER_ENCODING);
                if (transferEncoding != null && HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equals(transferEncoding.getValue())) {
                    this.chunked = true;
                }
            } else if ("HTTP/1.0".equals(version.getValue())) {
                this.httpVersion = "HTTP/1.0";
            } else {
                throw new AxisFault("Parameter PROTOCOL Can have values only HTTP/1.0 or HTTP/1.1");
            }
        }
        try {
            Parameter tempSoTimeoutParam = transportOut.getParameter("SO_TIMEOUT");
            Parameter tempConnTimeoutParam = transportOut.getParameter("CONNECTION_TIMEOUT");
            if (tempSoTimeoutParam != null) {
                this.soTimeout = Integer.parseInt((String)tempSoTimeoutParam.getValue());
            }
            if (tempConnTimeoutParam != null) {
                this.connectionTimeout = Integer.parseInt((String)tempConnTimeoutParam.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"Invalid timeout value format: not a number", (Throwable)nfe);
        }
    }

    public void stop() {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            OMOutputFormat format = new OMOutputFormat();
            String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEnc != null) {
                format.setCharSetEncoding(charSetEnc);
            } else {
                OperationContext opctx = msgContext.getOperationContext();
                if (opctx != null) {
                    charSetEnc = (String)opctx.getProperty("CHARACTER_SET_ENCODING");
                }
            }
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
            msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
            msgContext.setDoingREST(HTTPTransportUtils.isDoingREST(msgContext));
            format.setSOAP11(msgContext.isSOAP11());
            format.setDoOptimize(msgContext.isDoingMTOM());
            format.setDoingSWA(msgContext.isDoingSwA());
            format.setCharSetEncoding(charSetEnc);
            EndpointReference epr = null;
            String transportURL = (String)msgContext.getProperty("TransportURL");
            if (transportURL != null) {
                epr = new EndpointReference(transportURL);
            } else if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
                epr = msgContext.getTo();
            }
            Object dataOut = msgContext.isDoingREST() ? msgContext.getEnvelope().getBody().getFirstElement() : msgContext.getEnvelope();
            if (epr != null) {
                if (!epr.hasNoneAddress()) {
                    this.writeMessageWithCommons(msgContext, epr, (OMElement)dataOut, format);
                }
            } else if (msgContext.getProperty("TRANSPORT_OUT") != null) {
                this.sendUsingOutputStream(msgContext, format, (OMElement)dataOut);
            } else {
                throw new AxisFault("Both the TO and Property MessageContext.TRANSPORT_OUT is Null, No where to send");
            }
            if (msgContext.getOperationContext() != null) {
                msgContext.getOperationContext().setProperty("CONTENT_WRITTEN", "true");
            }
        }
        catch (XMLStreamException e) {
            log.debug((Object)e);
            throw new AxisFault(e);
        }
        catch (FactoryConfigurationError e) {
            log.debug((Object)e);
            throw new AxisFault(e);
        }
        catch (IOException e) {
            log.debug((Object)e);
            throw new AxisFault(e);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void sendUsingOutputStream(MessageContext msgContext, OMOutputFormat format, OMElement dataOut) throws AxisFault, XMLStreamException {
        OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
        if (msgContext.isServerSide()) {
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            if (transportInfo != null) {
                String contentType;
                Object contentTypeObject = msgContext.getProperty("ContentType");
                if (contentTypeObject != null) {
                    contentType = (String)contentTypeObject;
                } else if (msgContext.isDoingREST() && !format.isOptimized()) {
                    contentType = "application/xml";
                } else {
                    contentType = format.getContentType();
                    format.setSOAP11(msgContext.isSOAP11());
                }
                String encoding = contentType + "; charset=" + format.getCharSetEncoding();
                transportInfo.setContentType(encoding);
            } else {
                throw new AxisFault("OutTransportInfo has not been set");
            }
        }
        format.setAutoCloseWriter(true);
        if (!msgContext.isDoingMTOM() & msgContext.isDoingSwA() & !msgContext.isDoingREST()) {
            StringWriter bufferedSOAPBody = new StringWriter();
            dataOut.serializeAndConsume((Writer)bufferedSOAPBody, format);
            MIMEOutputUtils.writeSOAPWithAttachmentsMessage((StringWriter)bufferedSOAPBody, (OutputStream)out, (Attachments)msgContext.getAttachmentMap(), (OMOutputFormat)format);
        } else {
            dataOut.serializeAndConsume(out, format);
        }
    }

    public void writeMessageWithCommons(MessageContext messageContext, EndpointReference toEPR, OMElement dataout, OMOutputFormat format) throws AxisFault {
        try {
            URL url = new URL(toEPR.getAddress());
            String soapActionString = "\"\"";
            Object disableSoapAction = messageContext.getOptions().getProperty("disableSoapAction");
            if (!(JavaUtils.isTrueExplicitly(disableSoapAction) || (soapActionString = messageContext.getSoapAction()) != null && soapActionString.length() != 0)) {
                soapActionString = messageContext.getWSAAction();
                if (messageContext.getAxisOperation() != null && (soapActionString == null || soapActionString.length() == 0)) {
                    soapActionString = messageContext.getAxisOperation().getInputAction();
                }
            }
            if (soapActionString == null) {
                soapActionString = "\"\"";
            }
            AbstractHTTPSender sender = !messageContext.isDoingREST() ? new SOAPOverHTTPSender() : new RESTSender();
            if (messageContext.getProperty("__CHUNKED__") != null) {
                this.chunked = JavaUtils.isTrueExplicitly(messageContext.getProperty("__CHUNKED__"));
            }
            if (messageContext.getProperty("__HTTP_PROTOCOL_VERSION__") != null) {
                this.httpVersion = (String)messageContext.getProperty("__HTTP_PROTOCOL_VERSION__");
            }
            sender.setChunked(this.chunked);
            sender.setHttpVersion(this.httpVersion);
            sender.setFormat(format);
            sender.send(messageContext, dataout, url, soapActionString);
        }
        catch (MalformedURLException e) {
            log.debug((Object)e);
            throw new AxisFault(e);
        }
        catch (HttpException e) {
            log.debug((Object)e);
            throw new AxisFault(e);
        }
        catch (IOException e) {
            log.debug((Object)e);
            throw new AxisFault(e);
        }
    }

    public void writeMessageWithToOutPutStream(MessageContext msgContext, OutputStream out) {
    }
}

