/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.transport.http.server.OutputBuffer;
import org.apache.axis2.transport.http.server.Worker;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.StringEntity;
import org.apache.ws.commons.schema.XmlSchema;

public class HTTPWorker
implements Worker {
    public void service(HttpRequest request, HttpResponse response, MessageContext msgContext) throws HttpException, IOException {
        OutputBuffer outbuffer;
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        final String servicePath = configurationContext.getServiceContextPath();
        String contextPath = (servicePath.startsWith("/") ? servicePath : "/" + servicePath) + "/";
        HttpVersion ver = request.getRequestLine().getHttpVersion();
        String uri = request.getRequestLine().getUri();
        String method = request.getRequestLine().getMethod();
        String soapAction = HttpUtils.getSoapAction(request);
        boolean chunked = false;
        TransportOutDescription transportOut = msgContext.getTransportOut();
        if (transportOut != null) {
            Parameter p = transportOut.getParameter("PROTOCOL");
            if (p != null && "HTTP/1.0".equals(p.getValue())) {
                ver = HttpVersion.HTTP_1_0;
            }
            if (ver.greaterEquals(HttpVersion.HTTP_1_1) && (p = transportOut.getParameter(HTTPConstants.HEADER_TRANSFER_ENCODING)) != null && HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equals(p.getValue())) {
                chunked = true;
            }
        }
        if (method.equals("GET")) {
            AxisService service;
            HashMap services;
            String serviceName;
            if (uri.equals("/favicon.ico")) {
                response.setStatusLine(new StatusLine(ver, 301, "Redirect"));
                response.addHeader(new Header("Location", "http://ws.apache.org/favicon.ico"));
                return;
            }
            if (!uri.startsWith(contextPath)) {
                response.setStatusLine(new StatusLine(ver, 301, "Redirect"));
                response.addHeader(new Header("Location", contextPath));
                return;
            }
            if (uri.indexOf("?") < 0 && !uri.endsWith(contextPath) && (serviceName = uri.replaceAll(contextPath, "")).indexOf("/") < 0) {
                String res = HTTPTransportReceiver.printServiceHTML(serviceName, configurationContext);
                StringEntity entity = new StringEntity(res);
                entity.setContentType("text/html");
                entity.setChunked(chunked);
                response.setEntity((HttpEntity)entity);
                return;
            }
            if (uri.endsWith("?wsdl2")) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 6);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName);
                if (service != null) {
                    final String ip = HttpUtils.getIpAddress();
                    EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                        public void writeTo(OutputStream outstream) throws IOException {
                            service.printWSDL2(outstream, ip, servicePath);
                        }
                    });
                    entity.setContentType("text/xml");
                    entity.setChunked(chunked);
                    response.setEntity((HttpEntity)entity);
                    return;
                }
            }
            if (uri.endsWith("?wsdl")) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 5);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName);
                if (service != null) {
                    final String ip = HttpUtils.getIpAddress();
                    EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                        public void writeTo(OutputStream outstream) throws IOException {
                            service.printWSDL(outstream, ip, servicePath);
                        }
                    });
                    entity.setContentType("text/xml");
                    entity.setChunked(chunked);
                    response.setEntity((HttpEntity)entity);
                    return;
                }
            }
            if (uri.endsWith("?xsd")) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.length() - 4);
                services = configurationContext.getAxisConfiguration().getServices();
                service = (AxisService)services.get(serviceName);
                if (service != null) {
                    EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                        public void writeTo(OutputStream outstream) throws IOException {
                            service.printSchema(outstream);
                        }
                    });
                    entity.setContentType("text/xml");
                    entity.setChunked(chunked);
                    response.setEntity((HttpEntity)entity);
                    return;
                }
            }
            if (uri.indexOf("?xsd=") > 0) {
                serviceName = uri.substring(uri.lastIndexOf("/") + 1, uri.lastIndexOf("?xsd="));
                String schemaName = uri.substring(uri.lastIndexOf("=") + 1);
                HashMap services2 = configurationContext.getAxisConfiguration().getServices();
                AxisService service2 = (AxisService)services2.get(serviceName);
                if (service2 != null) {
                    service2.populateSchemaMappings();
                    Map schemaTable = service2.getSchemaMappingTable();
                    final XmlSchema schema = (XmlSchema)schemaTable.get(schemaName);
                    if (schema != null) {
                        EntityTemplate entity = new EntityTemplate(new ContentProducer(){

                            public void writeTo(OutputStream outstream) {
                                schema.write(outstream);
                            }
                        });
                        entity.setContentType("text/xml");
                        entity.setChunked(chunked);
                        response.setEntity((HttpEntity)entity);
                        return;
                    }
                    response.setStatusLine(new StatusLine(ver, 404, "Schema Not Found!"));
                    return;
                }
            }
            outbuffer = new OutputBuffer();
            msgContext.setProperty("TRANSPORT_OUT", outbuffer);
            msgContext.setProperty("OutTransportInfo", outbuffer);
            boolean processed = HTTPTransportUtils.processHTTPGetRequest(msgContext, outbuffer.getOutputStream(), soapAction, uri, configurationContext, HTTPTransportReceiver.getGetRequestParameters(uri));
            if (processed) {
                outbuffer.setChunked(chunked);
                response.setEntity((HttpEntity)outbuffer);
            } else {
                response.setStatusLine(new StatusLine(ver, 200, "OK"));
                String s = HTTPTransportReceiver.getServicesHTML(configurationContext);
                StringEntity entity = new StringEntity(s);
                entity.setContentType("text/html");
                entity.setChunked(chunked);
                response.setEntity((HttpEntity)entity);
            }
        } else if (method.equals("POST")) {
            outbuffer = new OutputBuffer();
            msgContext.setProperty("TRANSPORT_OUT", outbuffer);
            msgContext.setProperty("OutTransportInfo", outbuffer);
            HttpEntity inentity = ((HttpEntityEnclosingRequest)request).getEntity();
            String contenttype = null;
            if (inentity.getContentType() != null) {
                contenttype = inentity.getContentType().getValue();
            }
            HTTPTransportUtils.processHTTPPostRequest(msgContext, inentity.getContent(), outbuffer.getOutputStream(), contenttype, soapAction, uri);
            outbuffer.setChunked(chunked);
            response.setEntity((HttpEntity)outbuffer);
        } else {
            throw new MethodNotSupportedException(method + " method not supported");
        }
        OperationContext operationContext = msgContext.getOperationContext();
        Object contextWritten = null;
        Object isTwoChannel = null;
        if (operationContext != null) {
            contextWritten = operationContext.getProperty("CONTENT_WRITTEN");
            isTwoChannel = operationContext.getProperty("DIFFERENT_EPR");
        }
        if (contextWritten != null && "true".equals(contextWritten)) {
            if (isTwoChannel != null && "true".equals(isTwoChannel)) {
                response.setStatusLine(new StatusLine(ver, 202, "OK"));
                return;
            }
            response.setStatusLine(new StatusLine(ver, 200, "OK"));
        } else {
            response.setStatusLine(new StatusLine(ver, 202, "OK"));
        }
    }
}

