/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.axis2.transport.http.server.HttpConnectionFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.HttpParams;

public class DefaultHttpConnectionFactory
implements HttpConnectionFactory {
    final HttpParams params;

    public DefaultHttpConnectionFactory(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.params = params;
    }

    public HttpServerConnection newConnection(Socket socket) throws IOException {
        Axis2HttpServerConnection conn = new Axis2HttpServerConnection();
        conn.bind(socket, this.params);
        return conn;
    }

    public class Axis2HttpServerConnection
    extends DefaultHttpServerConnection {
        public String getRemoteIPAddress() {
            SocketAddress sa = this.socket.getRemoteSocketAddress();
            if (sa instanceof InetSocketAddress) {
                return ((InetSocketAddress)sa).getAddress().getHostAddress();
            }
            return sa.toString();
        }

        public String getRemoteHostName() {
            SocketAddress sa = this.socket.getRemoteSocketAddress();
            if (sa instanceof InetSocketAddress) {
                return ((InetSocketAddress)sa).getHostName();
            }
            return sa.toString();
        }
    }
}

