/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import org.apache.axis2.context.MessageContext;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.protocol.HttpContext;

public class ResponseSessionCookie
implements HttpResponseInterceptor {
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String sessionCookie = null;
        MessageContext msgctx = (MessageContext)context.getAttribute("axis.message.context");
        if (msgctx != null) {
            sessionCookie = (String)msgctx.getProperty("Cookie");
        }
        if (sessionCookie == null) {
            sessionCookie = (String)context.getAttribute("Cookie");
        }
        if (sessionCookie != null) {
            CharArrayBuffer buffer = new CharArrayBuffer(sessionCookie.length() + 40);
            buffer.append("axis_session");
            buffer.append("=");
            buffer.append(sessionCookie);
            response.addHeader(new Header("Set-Cookie", buffer.toString()));
            buffer.append("; ");
            int port = response.getParams().getIntParameter("axis.listener.port", 0);
            if (port > 0) {
                buffer.append("Port=\"");
                buffer.append(Integer.toString(port));
                buffer.append("\"; ");
            }
            buffer.append("Version=1");
            response.addHeader(new Header("Set-Cookie2", buffer.toString()));
        }
    }
}

