/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.image_viewer;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class MRIImagePanel
extends JComponent {
    protected Image image;
    protected Image origImage;
    protected Image offScrImage;
    protected Graphics offScrGc;
    protected Image sliceImage = null;
    protected int imWidth = 0;
    protected int imHeight = 0;
    protected int viewerWid;
    protected int viewerHt;
    private int offsetX = 0;
    private int offsetY = 0;
    protected ImagePlus imp;
    protected ImageStack stack;
    protected ImageProcessor ip;

    public MRIImagePanel() {
    }

    public MRIImagePanel(Image img, int wid, int ht) {
        this.origImage = img;
        this.image = img;
        this.imWidth = wid;
        this.imHeight = ht;
        this.setSize(wid, ht);
    }

    public MRIImagePanel(ImagePlus iplus) {
        this.imp = iplus;
        this.stack = this.imp.getStack();
        this.ip = this.imp.getProcessor();
        this.origImage = this.image = this.imp.getImage();
        this.imWidth = this.imp.getWidth();
        this.imHeight = this.imp.getHeight();
        this.setSize(this.imWidth, this.imHeight);
    }

    public void addNotify() {
        super.addNotify();
        this.createOffScreenImage();
    }

    public void createOffScreenImage() {
        Rectangle rect = this.getBounds();
        this.viewerWid = rect.width;
        this.viewerHt = rect.height;
        this.offScrImage = this.createImage(rect.width, rect.height);
        this.offScrGc = this.offScrImage.getGraphics();
        this.offScrGc.setColor(Color.black);
        this.offScrGc.fillRect(0, 0, rect.width, rect.height);
        if (this.image != null) {
            this.offScrGc.drawImage(this.image, 0, 0, this);
        }
    }

    public void setSliceImage(int slice) {
        this.ip = this.stack.getProcessor(slice);
        this.sliceImage = this.ip.createImage();
        this.prepareImage(this.sliceImage, this);
        this.repaint();
    }

    public void setImage(Image image) {
        this.image = image;
        this.createOffScreenImage();
        this.prepareImage(image, this);
    }

    public void drawImage(Image image, int x, int y) {
        this.image = image;
        Rectangle rect = this.getBounds();
        this.viewerWid = rect.width;
        this.viewerHt = rect.height;
        this.offScrImage = this.createImage(rect.width, rect.height);
        this.offScrGc = this.offScrImage.getGraphics();
        this.offScrGc.setColor(Color.black);
        this.offScrGc.fillRect(0, 0, rect.width, rect.height);
        this.offsetX = x;
        this.offsetY = y;
        this.prepareImage(image, this);
    }

    private void drawOffScreen(Image img, int x, int y) {
        this.offScrGc.setColor(Color.black);
        this.offScrGc.fillRect(0, 0, this.viewerWid, this.viewerHt);
        this.offScrGc.drawImage(img, x, y, this);
    }

    public Image getImage() {
        return this.image;
    }

    public Graphics getDisplayedImageGC() {
        return this.offScrGc;
    }

    public void paintComponent(Graphics g) {
        Rectangle rect = this.getBounds();
        g.setColor(Color.black);
        g.fillRect(0, 0, rect.width, rect.height);
        if (this.offScrImage != null) {
            g.drawImage(this.offScrImage, 0, 0, this);
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x40) != 0) {
            System.out.println("ERROR in image load or image draw");
            return false;
        }
        if ((infoflags & 0x30) != 0) {
            this.drawOffScreen(img, this.offsetX, this.offsetY);
            this.repaint();
            this.image = img;
            return false;
        }
        return true;
    }

    public void resetImage() {
        this.offsetX = 0;
        this.offsetY = 0;
        this.setImage(this.origImage);
        this.repaint();
    }
}

