/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.custom;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.mitre.lattice.custom.NeuroLatticeFactory;
import org.mitre.lattice.neuro.custom.AIRRegistration;
import org.mitre.lattice.neuro.custom.NeuroImageUtils;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.LatticeFactory;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;

public class AIRVerification
extends AbstractStep {
    private MraldConnection conn = null;

    public static void main(String[] args) throws WorkflowStepException {
        Config.init((String)"C:\\Program Files\\Apache Software Foundation\\Tomcat 5.5\\webapps\\neuro\\WEB-INF\\props\\");
        Config.setLatticeFactory((LatticeFactory)new NeuroLatticeFactory());
        String[] volumeID = new String[]{"MonicasSample1_AIR_55_1138663432450"};
        String[] action = new String[]{"Reject"};
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("volumeID", volumeID);
        params.put("action", action);
        MsgObject msg = new MsgObject(params);
        User user = new User("pmork@mitre.org");
        AIRVerification local = new AIRVerification();
        local.process(msg, user);
    }

    public void execute(MsgObject msg) throws WorkflowStepException {
        User user = (User)msg.getReq().getSession().getAttribute(Config.getProperty((String)"cookietag"));
        this.process(msg, user);
    }

    private void process(MsgObject msg, User user) throws WorkflowStepException {
        try {
            this.init();
            String action = msg.getValue("action")[0];
            String volumeID = msg.getValue("volumeID")[0];
            StringBuffer errors = new StringBuffer();
            if (this.ownsVolume(user, volumeID)) {
                this.removeTempFiles(volumeID, user, errors);
                if (action.equals("Reject")) {
                    this.backOutDatabaseChanges(volumeID, user, errors);
                }
            } else {
                throw new WorkflowStepException(user.getEmail() + " does not own volume " + volumeID);
            }
            AIRRegistration.generateResponse(msg.getRes(), 200, action.toLowerCase(), volumeID, errors.length() > 0 ? errors.toString() : "Your registered images were " + (action.equals("Reject") ? "not" : "") + " saved in the database.<br/>All temporary files were deleted.");
        }
        catch (Exception e) {
            this.close();
            throw new WorkflowStepException((Throwable)e);
        }
    }

    private void backOutDatabaseChanges(String volumeID, User user, StringBuffer errors) throws WorkflowStepException {
        this.removeRegisteredImages(volumeID, errors);
        String[] queries = new String[]{"DELETE FROM images_label WHERE filename in (SELECT filename FROM images WHERE volume_id='<:ID:>');", "DELETE FROM images WHERE volume_id='<:ID:>'", "DELETE FROM derivation_history WHERE volume_id='<:ID:>'", "DELETE FROM parameters WHERE volume_id='<:ID:>'", "DELETE FROM volume_label WHERE volume_id='<:ID:>'", "DELETE FROM volume WHERE volume_id='<:ID:>'"};
        for (int i = 0; i < queries.length; ++i) {
            queries[i] = queries[i].replaceAll("<:ID:>", volumeID);
        }
        this.executeQueries(queries);
    }

    private void removeRegisteredImages(String volumeID, StringBuffer errors) throws WorkflowStepException {
        String sql = "SELECT filename FROM images WHERE volume_id='<:ID:>'";
        sql = sql.replaceAll("<:ID:>", volumeID);
        try {
            ResultSet rs = this.conn.executeQuery(sql);
            while (rs.next()) {
                String imageFile = rs.getString(1);
                File f = new File(Config.getProperty((String)"imagesDir") + imageFile);
                if (f.delete()) continue;
                errors.append("<br/>Unable to delete " + imageFile);
            }
        }
        catch (SQLException e) {
            throw new WorkflowStepException("Error retrieving files for " + volumeID);
        }
    }

    private void removeTempFiles(String volumeID, User user, StringBuffer errors) throws WorkflowStepException, MraldException {
        File tempDir = NeuroImageUtils.getVolumeTempDir(volumeID);
        File volumeDir = new File(tempDir, volumeID);
        if (!volumeDir.exists()) {
            return;
        }
        for (File imageDir : volumeDir.listFiles()) {
            if (imageDir.isDirectory()) {
                for (File tmpFile : imageDir.listFiles()) {
                    if (tmpFile.delete()) continue;
                    errors.append("<br/>Unable to delete " + tmpFile);
                }
            }
            if (imageDir.delete()) continue;
            errors.append("<br/>Unable to delete " + imageDir);
        }
        if (!volumeDir.delete()) {
            errors.append("<br/>Unable to delete " + volumeDir);
        }
    }

    private boolean ownsVolume(User user, String volumeID) throws WorkflowStepException {
        String sql = "SELECT * FROM volume_label WHERE volume_id='<:ID:>' AND owner='<:user:>'";
        sql = sql.replaceAll("<:ID:>", volumeID);
        sql = sql.replaceAll("<:user:>", user.getEmail());
        try {
            ResultSet rs = this.conn.executeQuery(sql);
            return rs.next();
        }
        catch (SQLException e) {
            throw new WorkflowStepException("Unable to verify " + user.getEmail() + " as owner of " + volumeID);
        }
    }

    private void init() throws ClassNotFoundException, SQLException {
        if (this.conn == null) {
            this.conn = new MraldConnection("main");
            this.conn.setAutoCommit(false);
        }
    }

    private void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void executeQueries(String[] sql) throws WorkflowStepException {
        boolean failure = false;
        for (int i = 0; i < sql.length; ++i) {
            String qry = sql[i];
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("AIR Verification---Executing: " + qry));
            try {
                this.conn.executeUpdate(qry);
                continue;
            }
            catch (SQLException e) {
                MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("AIR Verification---Failed: " + qry));
                failure = true;
            }
        }
        try {
            if (failure) {
                this.conn.rollback();
            } else {
                this.conn.commit();
            }
        }
        catch (SQLException sqle) {
            throw new WorkflowStepException((Throwable)sqle);
        }
    }
}

