/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.output.HTMLOutput;
import org.mitre.mrald.output.OutputManagerException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldOutFile;

public class SubjectListOutput
extends HTMLOutput {
    public static final String KEY = SubjectListOutput.class.getName();
    public int count = 0;
    public static final Logger log = Logger.getLogger(KEY);
    public static final String[] colors = new String[]{"blue"};
    private static String SPACER = "<img alt=\"\" src=\"images/spacer.gif\" width=\"<:width:>\" height=\"1\"/>";
    private boolean lastLevelPrinted = false;
    public static final String ORDER_BY_SUBJECT = "subject_id";
    public static String groupName = "";

    public void prepareOutputAsHTML(MsgObject msg) throws IOException, OutputManagerException, SQLException, ServletException {
        PrintWriter out = msg.getOutPrintWriter();
        out.println("<html><head>");
        out.println("<script type=\"text/javascript\" src=\"checkboxToggle.js\"></script>");
        out.println("\n<!--" + this.dbQuery + " -->\n");
        this.writeFile(new File(Config.getProperty((String)"BasePath"), "title.html"), out);
        out.println("</head><body onload='addCount()'><div id=\"wrap\">");
        this.writeFile(new File(Config.getProperty((String)"BasePath"), "header.html"), out);
        out.println("<div id=\"content\"><h2>Subject <strong><span class=\"blue\"></span><span class=\"gray\">List </span></strong></h2><p>");
        out.println("<center><table width=\"80%\" border='0' cellpadding='3'>");
        out.println("<form name=\"o\" action=\"\" method=\"POST\">");
        this.printHtmlResults(out);
        this.printCount(out);
        out.println("</table></center><p>");
        out.println("</p><center>");
        out.println("</center></form>");
        out.println("</p></div>");
        this.writeFile(new File(Config.getProperty((String)"BasePath"), "menus.html"), out);
        out.println("</body></html>");
    }

    private String[] getOrderBy() {
        String orderBy = "ORDER BY";
        String parseString = this.dbQuery.toUpperCase();
        String[] orderByList = new String[]{ORDER_BY_SUBJECT};
        int indexOfOrderBy = parseString.indexOf(orderBy);
        if (indexOfOrderBy < 0) {
            return orderByList;
        }
        parseString = this.dbQuery.substring(indexOfOrderBy + orderBy.length());
        parseString = parseString.replaceAll(" ASC", "");
        orderByList = parseString.split(",");
        for (int i = 0; i < orderByList.length; ++i) {
            String orderStr = orderByList[i];
            if (orderStr.indexOf(".") > -1) {
                orderStr = orderStr.substring(orderStr.indexOf(".") + 1);
            }
            orderByList[i] = orderStr.trim();
        }
        return orderByList;
    }

    public void writeFile(File inputFile, PrintWriter out) {
        log.entering(KEY, "writeFile", inputFile);
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(inputFile));
            while ((line = br.readLine()) != null) {
                out.print(line);
            }
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.exiting(KEY, "writeFile");
    }

    public void printHtmlResults(PrintWriter out) throws IOException, SQLException, ServletException {
        String orderStr = ORDER_BY_SUBJECT;
        String[] orderByStrings = this.getOrderBy();
        ArrayList list = new ArrayList();
        String rowOutput = this.processResult(this.rs, orderByStrings);
        out.println(rowOutput);
        out.println("<br />");
        out.print("</td>");
        out.println("</tr>");
    }

    private String processResult(ResultSet rs, String[] orderByStrings) throws SQLException {
        StringBuffer output = new StringBuffer();
        boolean firstQuery = true;
        if (!firstQuery) {
            try {
                output.append("<a name=\"Other\"></a><h1>Others</h1>");
                firstQuery = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            firstQuery = false;
        }
        int rowCount = 0;
        int noOfLevels = orderByStrings.length;
        String[] lastGroup = new String[noOfLevels];
        String[] currentGroup = new String[noOfLevels];
        for (int j = 0; j < noOfLevels; ++j) {
            lastGroup[j] = "";
            currentGroup[j] = "";
        }
        int levelNo = 0;
        MraldOutFile.appendToFile((String)"In SubjectListOutput processResult : about to process resultSet ");
        while (rs.next()) {
            MraldOutFile.appendToFile((String)("In SubjectListOutput processResult : in resultSet " + rowCount));
            ++rowCount;
            for (int j = 0; j < noOfLevels; ++j) {
                String ordering = orderByStrings[j].toString();
                currentGroup[j] = rs.getString(ordering);
            }
            int currLevel = 0;
            levelNo = 0;
            while (currLevel < noOfLevels && lastGroup[currLevel].equals(currentGroup[currLevel])) {
                levelNo = currLevel++;
            }
            if (currLevel >= noOfLevels) {
                this.lastLevelPrinted = true;
                currLevel = noOfLevels - 1;
            } else {
                this.lastLevelPrinted = false;
            }
            String rowStr = this.writeRow(rs, orderByStrings, currLevel);
            MraldOutFile.appendToFile((String)("In SubjectListOutput processResult, queries : rowStr " + rowStr));
            for (int i = 0; i < noOfLevels; ++i) {
                lastGroup[i] = currentGroup[i].toString();
            }
            try {
                output.append(rowStr);
                output.append("<br />");
                output.append(Config.NEWLINE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.count = rowCount;
        log.exiting(KEY, "processRows");
        return output.toString();
    }

    private String writeRow(ResultSet rs, String[] orderBy, int currLevel) throws SQLException {
        MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, : currLevel " + currLevel));
        StringBuffer ret = new StringBuffer();
        int lastLevel = orderBy.length - 1;
        if (currLevel == lastLevel) {
            if (!this.lastLevelPrinted) {
                String heading = rs.getString(orderBy[lastLevel]);
                String headStr = this.writeHeading(lastLevel, heading);
                ret.append(headStr);
                MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, 3 : headStr " + headStr));
            }
            String valueStr = this.writeValue(rs, currLevel);
            MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, : valueStr " + valueStr));
            ret.append(valueStr + "<br/>");
        } else if (currLevel == lastLevel - 1) {
            String heading = rs.getString(orderBy[currLevel]);
            String headStr = this.writeHeading(currLevel, heading);
            ret.append(headStr);
            MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, 2 : headStr " + headStr));
            if (!this.lastLevelPrinted) {
                heading = rs.getString(orderBy[lastLevel]);
                String newStr = this.writeHeading(lastLevel, heading);
                ret.append(newStr);
                MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, 2 : newStr " + newStr));
            }
            String valueStr = this.writeValue(rs, lastLevel);
            MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, 2 : valueStr " + valueStr));
            ret.append(valueStr);
        } else if (currLevel == lastLevel - 2) {
            String heading = rs.getString(orderBy[currLevel]);
            MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, 1 : heading " + heading));
            String headingStr = this.writeHeading(currLevel, heading);
            MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, 1 : headingStr " + headingStr));
            ret.append(headingStr);
            heading = rs.getString(orderBy[currLevel + 1]);
            headingStr = this.writeHeading(currLevel + 1, heading);
            MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, 1 : headingStr " + headingStr));
            ret.append(headingStr);
            if (!this.lastLevelPrinted) {
                heading = rs.getString(orderBy[lastLevel]);
                headingStr = this.writeHeading(lastLevel, heading);
                ret.append(headingStr);
            }
            String valueStr = this.writeValue(rs, lastLevel);
            MraldOutFile.appendToFile((String)("In SubjectListOutput writeRow, 1 : valueStr " + valueStr));
            ret.append(valueStr);
        } else if (currLevel == lastLevel - 3) {
            String heading = rs.getString(orderBy[currLevel]);
            ret.append(this.writeHeading(currLevel, heading));
            heading = rs.getString(orderBy[currLevel + 1]);
            ret.append(this.writeHeading(currLevel + 1, heading));
            heading = rs.getString(orderBy[currLevel + 2]);
            ret.append(this.writeHeading(currLevel + 2, heading));
            heading = rs.getString(orderBy[lastLevel]);
            ret.append(this.writeHeading(lastLevel, heading));
            ret.append(this.writeValue(rs, lastLevel));
        }
        return ret.toString();
    }

    private String writeHeading(int levelNo, String heading) {
        if (colors.length == 1) {
            return "";
        }
        String width = new String(levelNo * 25 + "");
        StringBuffer ret = new StringBuffer();
        if (levelNo == 0) {
            ret.append("<a name=\"" + heading + "\"></a><h2 style=\"color:" + colors[levelNo] + "\"><input type=\"checkbox\" name=\"" + heading + "_chkbox\" onclick='if(this.checked==true) CheckGroup(\"" + heading + "\"); else ClearGroup(\"" + heading + "\")'></input>");
            ret.append(SPACER.replaceAll("<:width:>", width) + " " + heading + "</h2>");
            this.setGroupName(heading);
        } else {
            ret.append("<h2 style=\"color:" + colors[levelNo] + "\">" + SPACER.replaceAll("<:width:>", width) + " " + heading + "</h2>");
        }
        return ret.toString();
    }

    private String writeValue(ResultSet rs, int levelNo) throws SQLException {
        String width = new String(levelNo * 25 + "");
        StringBuffer ret = new StringBuffer();
        ret.append(SPACER.replaceAll("<:width:>", width) + SubjectListOutput.toLink(rs.getString(ORDER_BY_SUBJECT), groupName));
        return ret.toString();
    }

    public void printCount(PrintWriter out) {
        out.println("<script type=\"text/javascript\">");
        out.println("function addCount()");
        out.println("{");
        out.println("var ldiv = document.getElementById(\"count\");");
        if (this.count == 1) {
            out.println("var textout = '1 subject found:';");
        } else {
            out.println("var textout = '" + this.count + " subjects found';");
        }
        out.println("ldiv.innerHTML = textout;");
        out.println("}");
        out.println("</script>");
    }

    public void printNavigation(PrintWriter out) {
    }

    private void setGroupName(String newGroupName) {
        groupName = newGroupName;
    }

    public static String toLink(String subject_id, String groupName) {
        StringBuffer ret = new StringBuffer("<input type=\"checkbox\" name=\"subject_id\" value=\"");
        ret.append(subject_id);
        ret.append("\"/> <b><a href=\"subject_info.jsp?subject_id=");
        ret.append(subject_id);
        ret.append("\" target=\"_blank\"> ");
        ret.append(subject_id);
        ret.append("</a></b>");
        return ret.toString();
    }

    static {
        log.setLevel(Level.FINER);
    }
}

