/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.taglib;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mitre.lattice.query.LatticeQuery;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

public abstract class NeuroSpecificTag
extends TagSupport {
    public static final String KEY = NeuroSpecificTag.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    protected int processCount = 0;
    protected static final String DATASOURCE = "main";

    public int doStartTag() throws JspException {
        try {
            User user = (User)this.pageContext.getSession().getAttribute(Config.getProperty((String)"cookietag"));
            StringBuffer ret = new StringBuffer(this.init());
            ret.append(this.processQuery(this.getQuery(), user));
            ret.append(this.endOutput());
            this.pageContext.getOut().print(ret.toString());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        catch (Exception e) {
            throw new JspException(e.getMessage());
        }
        return 0;
    }

    protected String init() {
        return null;
    }

    protected abstract String[] getQuery();

    public String processQuery(String[] query, User user) throws MraldException {
        try {
            StringBuffer ret = new StringBuffer();
            MraldConnection conn = new MraldConnection(DATASOURCE);
            Connection con = conn.getConnection();
            ResultSet rs = null;
            for (int i = 0; i < query.length; ++i) {
                String queryFinal = LatticeQuery.adaptQuery((String)query[i], (User)user);
                StringBuffer logInfo = new StringBuffer();
                long startTime = MiscUtils.logQuery((String)user.getEmail(), (String)DATASOURCE, (String)query[i], (StringBuffer)logInfo);
                Statement stmt = con.createStatement(1004, 1008);
                rs = stmt.executeQuery(queryFinal);
                MiscUtils.logQueryRun((long)startTime, (StringBuffer)logInfo);
                this.processCount = i + 1;
                ret.append(this.processResultSet(rs));
            }
            rs.close();
            conn.close();
            return ret.toString();
        }
        catch (SQLException e) {
            throw new MraldException((Throwable)e);
        }
    }

    protected abstract String processResultSet(ResultSet var1) throws MraldException;

    protected abstract String endOutput();
}

