/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.taglib;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mitre.mrald.taglib.MraldSpecTag;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

public class BrowseVolumesListTag
extends MraldSpecTag {
    public static final String KEY = BrowseVolumesListTag.class.getName();
    public static int CUTOFF = 10;
    public static final Logger log = Logger.getLogger(KEY);
    public static final String ORDER_BY_GENDER = " ORDER BY gender,handedness, \"Subject Lab Name\",\"Subject\",\"Subject\"";
    public static final String ORDER_BY_SUBJECT_LAB = " ORDER BY \"Subject Lab Name\",\"Subject Lab Name\",gender,\"Subject\"";
    public static final String ORDER_BY_VOLUME_LAB = " ORDER BY \"Volume Lab Name\",\"Subject Lab Name\",gender,\"Subject\"";
    public static final String ORDER_BY_SUBJECT = " ORDER BY \"Subject\",\"Subject Lab Name\",gender";
    public static final String ORDER_BY_SUBJECT_AGE = " ORDER BY \"Subject Age\", \"Subject Lab Name\",gender,\"Subject\"";
    public static final String ORDER_BY_MODALITY = " ORDER BY \"Modality\", \"Subject Lab Name\",\"Subject\", gender";
    public static final String[] colors;
    String filter;
    String orderBy;
    String headingStr = "";
    private boolean firstQuery = true;
    private static String SPACER;
    private boolean lastLevelPrinted = false;

    public BrowseVolumesListTag() {
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)"BrowseListTag:  start");
    }

    public void setFilter(String filter) {
        if (filter == null || filter.equals("")) {
            this.filter = filter = "and 1=1";
            return;
        }
        this.filter = filter;
    }

    public void setHeadingStr(String thisHeading) {
        this.headingStr = thisHeading;
    }

    public void setOrderBy(String orderBy) {
        if (orderBy == null || orderBy.equals("")) {
            orderBy = "";
            return;
        }
        this.orderBy = orderBy;
    }

    protected String[] getQuery() {
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)"BrowseListTag: getQuery : start");
        String groupBy = "";
        String subquery = "";
        String bigSegments = "SELECT DISTINCT   subject.subject_id as \"Subject\", subject.lab_name as \"Subject Lab Name\",  gender, volume.lab_name  as \"Volume Lab Name\" From subject, volume, scan_event where subject.subject_id = scan_event.subject_id and volume.scan_id = scan_event.scan_id and <::groupby::> in ( <::subquery::> ) " + this.filter + this.orderBy;
        String smallSegments = "SELECT DISTINCT  subject.subject_id as \"Subject\", subject.lab_name as \"Subject Lab Name\",   gender, volume.lab_name  as \"Volume Lab Name\" From subject, volume, scan_event where subject.subject_id = scan_event.subject_id and volume.scan_id = scan_event.scan_id and <::groupby::> in ( <::subquery::> ) " + this.filter + this.orderBy;
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("BrowseListTag: getQuery : Order by:  " + this.orderBy));
        if (this.orderBy == ORDER_BY_GENDER) {
            CUTOFF = 0;
            bigSegments = "SELECT DISTINCT   subject.subject_id as \"Subject\", subject.lab_name as \"Subject Lab Name\",  gender, handedness, volume.lab_name  as \"Volume Lab Name\" From subject, volume, scan_event where subject.subject_id = scan_event.subject_id and volume.scan_id = scan_event.scan_id and <::groupby::> in ( <::subquery::> ) " + this.filter + this.orderBy;
            smallSegments = "SELECT DISTINCT  subject.subject_id as \"Subject\", subject.lab_name as \"Subject Lab Name\",   gender, handedness, volume.lab_name  as \"Volume Lab Name\" From subject, volume, scan_event where subject.subject_id = scan_event.subject_id and volume.scan_id = scan_event.scan_id and <::groupby::> in ( <::subquery::> ) " + this.filter + this.orderBy;
            groupBy = "subject.gender ";
            subquery = "select gender from subject  where subject.subject_id = subject.subject_id group by gender, handedness having count(subject.subject_id)<::operator::>" + CUTOFF;
        } else if (this.orderBy == ORDER_BY_SUBJECT_AGE) {
            bigSegments = "SELECT DISTINCT   subject.subject_id as \"Subject\", subject.lab_name as \"Subject Lab Name\",  gender, birth_year  as \"Subject Age\" From subject, volume, scan_event where subject.subject_id = scan_event.subject_id and volume.scan_id = scan_event.scan_id and <::groupby::> in ( <::subquery::> ) " + this.filter + this.orderBy;
            smallSegments = "SELECT DISTINCT  subject.subject_id as \"Subject\", subject.lab_name as \"Subject Lab Name\",  gender, birth_year  as \"Subject Age\" From subject, volume, scan_event where subject.subject_id = scan_event.subject_id and volume.scan_id = scan_event.scan_id and <::groupby::> in ( <::subquery::> ) " + this.filter + this.orderBy;
            groupBy = "subject.birth_year";
            subquery = "select subject.birth_year from subject  where subject.subject_id = subject.subject_id group by subject.birth_year having count(subject.subject_id)<::operator::>" + CUTOFF;
        } else if (this.orderBy == ORDER_BY_MODALITY) {
            bigSegments = "SELECT DISTINCT   modality as \"Modality\", subject.lab_name as \"Subject Lab Name\",gender, subject.subject_id as \"Subject\"    From subject, volume, scan_event where subject.subject_id = scan_event.subject_id and volume.scan_id = scan_event.scan_id and <::groupby::> in ( <::subquery::> ) " + this.filter + this.orderBy;
            smallSegments = "SELECT DISTINCT   modality as \"Modality\", subject.lab_name as \"Subject Lab Name\",gender, subject.subject_id as \"Subject\"  From subject, volume, scan_event where subject.subject_id = scan_event.subject_id and volume.scan_id = scan_event.scan_id and <::groupby::> in ( <::subquery::> ) " + this.filter + this.orderBy;
            groupBy = "volume.modality";
            subquery = "select volume.modality from volume  where volume.volume_id = volume.volume_id group by volume.modality having count(volume.volume_id)<::operator::>" + CUTOFF;
        } else if (this.orderBy == ORDER_BY_SUBJECT_LAB) {
            groupBy = "subject.lab_name";
            subquery = "select lab_name from subject  where subject.subject_id = subject.subject_id group by subject.lab_name having count(subject.subject_id)<::operator::>" + CUTOFF;
        } else if (this.orderBy == ORDER_BY_VOLUME_LAB) {
            groupBy = "volume.lab_name";
            subquery = "select lab_name from volume  where volume.volume_id = volume.volume_id group by lab_name having count(volume.volume_id)<::operator::>" + CUTOFF;
        } else if (this.orderBy == ORDER_BY_SUBJECT) {
            groupBy = "subject.subject_id";
            subquery = "select volume_id from subject,scan_event, volume  where subject.subject_id = scan_event.subject_id and scan_event.scan_id = volume.scan_id group by subject.subject_id having count(volume.volume_id)<::operator::>4";
        } else {
            throw new RuntimeException("No version specified");
        }
        bigSegments = bigSegments.replaceAll("<::groupby::>", groupBy);
        bigSegments = bigSegments.replaceAll("<::subquery::>", subquery);
        bigSegments = bigSegments.replaceAll("<::operator::>", ">=");
        smallSegments = smallSegments.replaceAll("<::groupby::>", groupBy);
        smallSegments = smallSegments.replaceAll("<::subquery::>", subquery);
        smallSegments = smallSegments.replaceAll("<::operator::>", "<");
        return new String[]{bigSegments, smallSegments};
    }

    protected String init() {
        this.firstQuery = true;
        return "";
    }

    protected String endOutput() {
        return "";
    }

    protected String processResultSet(ResultSet rs) throws MraldException {
        try {
            StringBuffer ret = new StringBuffer();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            String[] orderByStr = this.getOrderByStrings();
            boolean newline = false;
            boolean count = false;
            String rowsStr = this.processRows(rs, orderByStr);
            ret.append(rowsStr);
            return ret.toString();
        }
        catch (SQLException e) {
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("BrowseListTag: SQLException:  " + e.getMessage()));
            throw new MraldException(e.getMessage());
        }
    }

    private String[] getOrderByStrings() {
        int length = " ORDER BY ".length();
        String parseStr = this.orderBy.substring(length);
        String[] orderByStrings = parseStr.split(",");
        for (int i = 0; i < orderByStrings.length; ++i) {
            orderByStrings[i] = orderByStrings[i].replaceAll("\"", "");
            orderByStrings[i] = orderByStrings[i].trim();
        }
        return orderByStrings;
    }

    private String processRows(ResultSet rs, String[] orderByStrings) throws SQLException {
        log.entering(KEY, "processRows");
        log.finer("first query? " + this.firstQuery);
        if (!this.firstQuery) {
            try {
                this.pageContext.getOut().print("<a name=\"Other\"></a><h2>Others</h2>");
                this.firstQuery = true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.firstQuery = false;
        }
        int count = 0;
        int noOfLevels = orderByStrings.length;
        if (this.orderBy == ORDER_BY_GENDER) {
            --noOfLevels;
        }
        String[] lastGroup = new String[noOfLevels];
        String[] currentGroup = new String[noOfLevels];
        for (int j = 0; j < noOfLevels; ++j) {
            lastGroup[j] = "";
            currentGroup[j] = "";
        }
        int levelNo = 0;
        while (rs.next()) {
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("BrowseListTag:Loop for i :  " + ++count));
            for (int j = 0; j < noOfLevels; ++j) {
                String ordering = orderByStrings[j].toString();
                currentGroup[j] = rs.getString(ordering);
            }
            int currLevel = 0;
            levelNo = 0;
            while (currLevel < noOfLevels && lastGroup[currLevel].equals(currentGroup[currLevel])) {
                levelNo = currLevel++;
            }
            if (currLevel >= noOfLevels) {
                this.lastLevelPrinted = true;
                currLevel = noOfLevels - 1;
            } else {
                this.lastLevelPrinted = false;
            }
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("BrowseListTag: process Rows: about to write for value " + rs.getString("Subject")));
            String rowStr = this.writeRow(rs, orderByStrings, currLevel);
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("BrowseListTag: process Rows: written for value " + rs.getString("Subject")));
            for (int i = 0; i < noOfLevels; ++i) {
                lastGroup[i] = currentGroup[i] != null ? currentGroup[i].toString() : "Unknown";
            }
            try {
                this.pageContext.getOut().print(rowStr);
                this.pageContext.getOut().print("<br />");
                this.pageContext.getOut().print(Config.NEWLINE);
            }
            catch (IOException e) {
                MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("BrowseListTag:IOException :  " + e.getMessage()));
                throw new RuntimeException(e);
            }
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("BrowseListTag:End Loop for i :  " + count));
        }
        log.exiting(KEY, "processRows");
        return "";
    }

    private String writeRow(ResultSet rs, String[] orderBy, int currLevel) throws SQLException {
        StringBuffer ret = new StringBuffer();
        int lastLevel = 3;
        if (currLevel == lastLevel) {
            String heading;
            if (!this.lastLevelPrinted && (heading = rs.getString(orderBy[lastLevel])) == null) {
                heading = "Unknown";
            }
            ret.append(this.writeValue(rs, currLevel));
        } else if (currLevel == lastLevel - 1) {
            String heading = rs.getString(orderBy[currLevel]);
            if (heading == null) {
                heading = "Unknown";
            }
            ret.append(this.writeHeading(currLevel, heading));
            if (!this.lastLevelPrinted) {
                heading = rs.getString(orderBy[lastLevel]);
            }
            ret.append(this.writeValue(rs, lastLevel));
        } else if (currLevel == lastLevel - 2) {
            String heading = rs.getString(orderBy[currLevel]);
            if (heading == null) {
                heading = "Unknown";
            }
            ret.append(this.writeHeading(currLevel, heading));
            heading = rs.getString(orderBy[currLevel + 1]);
            if (heading == null) {
                heading = "Unknown";
            }
            ret.append(this.writeHeading(currLevel + 1, heading));
            if (!this.lastLevelPrinted && (heading = rs.getString(orderBy[lastLevel])) == null) {
                heading = "Unknown";
            }
            ret.append(this.writeValue(rs, lastLevel));
        } else if (currLevel == lastLevel - 3) {
            String heading = rs.getString(orderBy[currLevel]);
            if (heading == null) {
                heading = "Unknown";
            }
            ret.append(this.writeHeading(currLevel, heading));
            heading = rs.getString(orderBy[currLevel + 1]);
            if (heading == null) {
                heading = "Unknown";
            }
            ret.append(this.writeHeading(currLevel + 1, heading));
            heading = rs.getString(orderBy[currLevel + 2]);
            if (heading == null) {
                heading = "Unknown";
            }
            ret.append(this.writeHeading(currLevel + 2, heading));
            heading = rs.getString(orderBy[lastLevel]);
            if (heading == null) {
                heading = "Unknown";
            }
            ret.append(this.writeValue(rs, lastLevel));
        }
        return ret.toString();
    }

    private String writeValue(ResultSet rs, int levelNo) throws SQLException {
        String width = new String(levelNo * 25 + "");
        StringBuffer ret = new StringBuffer();
        ret.append(SPACER.replaceAll("<:width:>", width) + this.toLink(rs.getString("Subject")));
        return ret.toString();
    }

    private String writeHeading(int levelNo, String heading) {
        String width = new String(levelNo * 25 + "");
        StringBuffer ret = new StringBuffer();
        if (levelNo == 0) {
            ret.append("<a name=\"" + heading + "\"></a><h2 style=\"color:" + colors[levelNo] + "\"><input type=\"checkbox\" name=\"" + heading + "_chkbox\" onclick='if(this.checked==true) CheckGroup(\"" + heading + "\"); else ClearGroup(\"" + heading + "\")'></input>");
            ret.append(SPACER.replaceAll("<:width:>", width) + " " + heading + "</h2>");
            this.setHeadingStr(heading);
        } else {
            ret.append("<h3 style=\"color:" + colors[levelNo] + "\">" + SPACER.replaceAll("<:width:>", width) + " " + heading + "</h3>");
        }
        return ret.toString();
    }

    public String toLink(String neuronName) {
        StringBuffer ret = new StringBuffer("<input type=\"checkbox\" name=\"subject_id\" value=\"");
        ret.append(neuronName);
        ret.append("\" id=\"" + this.headingStr + "_chkbox\"");
        ret.append("/> <b><a href=\"subject_info.jsp?subject_id=");
        ret.append(neuronName);
        ret.append("\" target=\"_blank\"> ");
        ret.append(neuronName);
        ret.append("</a></b>");
        return ret.toString();
    }

    static {
        log.setLevel(Level.FINER);
        colors = new String[]{"blue", "green", "brown", "black", "red"};
        SPACER = "<img alt=\"\" src=\"images/spacer.gif\" width=\"<:width:>\" height=\"1\"/>";
    }
}

