/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.cellview;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jgraph.JGraph;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class JGraphDiamondView
extends VertexView {
    final JGraphDiamondRenderer renderer = new JGraphDiamondRenderer(this);

    public JGraphDiamondView(Object object, JGraph jGraph, CellMapper cellMapper) {
        super(object, jGraph, cellMapper);
    }

    public Point2D getPerimeterPoint(Point2D point2D, Point2D point2D2) {
        Point2D point2D3 = this.getCenterPoint();
        double d = this.getBounds().getWidth() / 2.0;
        Point2D.Double double_ = new Point2D.Double(point2D3.getX(), point2D3.getY() - d);
        Point2D.Double double_2 = new Point2D.Double(point2D3.getX(), point2D3.getY() + d);
        Point2D.Double double_3 = new Point2D.Double(point2D3.getX() - d, point2D3.getY());
        Point2D.Double double_4 = new Point2D.Double(point2D3.getX() + d, point2D3.getY());
        if (point2D3.getX() == point2D2.getX()) {
            if (point2D3.getY() > point2D2.getY()) {
                return double_;
            }
            return double_2;
        }
        if (point2D3.getY() == point2D2.getY()) {
            if (point2D3.getX() > point2D2.getX()) {
                return double_3;
            }
            return double_4;
        }
        Point2D point2D4 = point2D2.getX() < point2D3.getX() ? (point2D2.getY() < point2D3.getY() ? this.intersection(point2D2, point2D3, double_, double_3) : this.intersection(point2D2, point2D3, double_2, double_3)) : (point2D2.getY() < point2D3.getY() ? this.intersection(point2D2, point2D3, double_, double_4) : this.intersection(point2D2, point2D3, double_2, double_4));
        return point2D4;
    }

    private Point2D intersection(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d = (point2D2.getY() - point2D.getY()) / (point2D2.getX() - point2D.getX());
        double d2 = point2D.getY() - d * point2D.getX();
        double d3 = (point2D4.getY() - point2D3.getY()) / (point2D4.getX() - point2D3.getX());
        double d4 = point2D3.getY() - d3 * point2D3.getX();
        double d5 = (d2 - d4) / (d3 - d);
        double d6 = d * d5 + d2;
        Point2D point2D5 = this.getAttributes().createPoint(d5, d6);
        return point2D5;
    }

    public CellViewRenderer getRenderer() {
        return this.renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        if (GraphConstants.isSizeable((Map)this.getAllAttributes()) && graphContext.getGraph().isSizeable()) {
            return new JGraphDiamondSizeHandle(this, graphContext);
        }
        return null;
    }

    public class JGraphDiamondSizeHandle
    extends VertexView.SizeHandle {
        public JGraphDiamondSizeHandle(VertexView vertexView, GraphContext graphContext) {
            super(vertexView, graphContext);
        }

        protected Rectangle2D computeBounds(MouseEvent mouseEvent) {
            Rectangle2D rectangle2D = super.computeBounds(mouseEvent);
            if (rectangle2D.getHeight() > rectangle2D.getWidth()) {
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getHeight(), rectangle2D.getHeight());
            }
            if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getWidth());
            }
            return rectangle2D;
        }
    }

    public static class JGraphDiamondRenderer
    extends VertexRenderer {
        JGraphDiamondRenderer(JGraphDiamondView jGraphDiamondView) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            int n = this.borderWidth;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            boolean bl = this.selected;
            int n2 = dimension.width / 2;
            int n3 = dimension.width - n;
            int n4 = (dimension.width - n) / 2;
            int[] nArray = new int[]{n4, n3, n4, 0};
            int[] nArray2 = new int[]{0, n4, n3, n4};
            Polygon polygon = new Polygon(nArray, nArray2, 4);
            if (super.isOpaque()) {
                graphics.setColor(super.getBackground());
                graphics.fillPolygon(polygon);
            }
            try {
                this.setBorder(null);
                this.setOpaque(false);
                this.selected = false;
                super.paint(graphics);
                Object var13_12 = null;
                this.selected = bl;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                this.selected = bl;
                throw throwable;
            }
            if (this.bordercolor != null) {
                graphics.setColor(this.bordercolor);
                graphics2D.setStroke(new BasicStroke(n));
                graphics.drawPolygon(polygon);
            }
            if (this.selected) {
                graphics2D.setStroke(GraphConstants.SELECTION_STROKE);
                graphics.setColor(this.graph.getHighlightColor());
                graphics.drawPolygon(polygon);
            }
        }

        protected void paintBorder(Graphics graphics) {
            super.paintBorder(graphics);
        }
    }
}

