/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.AnnealingLayoutSettings;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;

public class AnnealingLayoutAlgorithm
extends JGraphLayoutAlgorithm
implements GraphModelListener {
    public static final int COUT_COSTFUNCTION = 6;
    public static final int COSTFUNCTION_EDGE_DISTANCE = 1;
    public static final int COSTFUNCTION_EDGE_CROSSING = 2;
    public static final int COSTFUNCTION_EDGE_LENGTH = 4;
    public static final int COSTFUNCTION_BORDERLINE = 8;
    public static final int COSTFUNCTION_NODE_DISTRIBUTION = 16;
    public static final int COSTFUNCTION_NODE_DISTANCE = 32;
    public static final String KEY_CAPTION = "Annealing Layoutalgorithm Attributes";
    public static final String KEY_POSITION = "Position";
    public static final String KEY_RELATIVES = "Relatives";
    public static final String CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES = "costfunction edge distance key for relevant edges";
    public static final String KEY_CLUSTERED_VERTICES = "Clustered Vertices";
    public static final String KEY_CLUSTER = "Cluster";
    public static final String KEY_IS_CLUSTER = "is Cluster";
    public static final String KEY_CLUSTER_INIT_POSITION = "initial Position of the Cluster";
    protected static final int CONFIG_KEY_RUN = 0;
    protected static final int CONFIG_KEY_LAYOUT_UPDATE = 1;
    private double temperature;
    private double initTemperature = 40.0;
    private double minTemperature = 2.0;
    private double minDistance = 50.0;
    private double tempScaleFactor = 0.95;
    private int maxRounds = 10000;
    protected double[] lambdaList = new double[]{1000.0, 100000.0, 0.02, 2000.0, 150.0, 1000000.0};
    private Rectangle bounds = new Rectangle(0, 0, 1000, 700);
    private boolean computePermutation = true;
    private boolean uphillMovesAllowed = true;
    private boolean isLayoutUpdateEnabled = true;
    private int costFunctionConfig = Integer.parseInt("111110", 2);
    private int round;
    private int triesPerCell = 8;
    protected ArrayList cellList;
    protected ArrayList edgeList;
    protected ArrayList applyCellList;
    private JGraph jgraph;
    protected Properties presetConfig;
    private long time = 0L;
    private boolean isDebugging = false;
    private boolean isRunning = false;
    private int luRecursionDepth = 1;
    private double luPerimeterRadius = 100.0;
    private double luPerimeterRadiusInc = 20.0;
    private String luMethod = "Layout Update Method Perimeter";
    private double equalsNull = 0.05;
    private boolean isClusteringEnabled = true;
    private double clusterMoveScaleFactor = 0.1;
    private double clusteringFactor = 8.0;
    protected boolean isOptimizer = false;

    public AnnealingLayoutAlgorithm() {
        this(false);
        this.setMaximumProgress(100);
    }

    public AnnealingLayoutAlgorithm(boolean bl) {
        this.isOptimizer = bl;
    }

    public String toString() {
        return "Annealing";
    }

    public String getHint() {
        return "Ignores selection";
    }

    public JGraphLayoutSettings createSettings() {
        return new AnnealingLayoutSettings(this, false);
    }

    public void run(JGraph jGraph, Object[] objectArray, int n) {
        this.isRunning = true;
        this.setAllowedToRun(true);
        this.setProgress(1);
        this.jgraph = jGraph;
        this.cellList = new ArrayList();
        this.edgeList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.getNodes(this.jgraph, objectArray);
        if (this.applyCellList.size() == 0) {
            return;
        }
        if (this.isLayoutUpdateEnabled) {
            this.jgraph.getModel().addGraphModelListener((GraphModelListener)this);
        }
        this.init(true);
        this.run();
        if (this.isAllowedToRun()) {
            this.moveGraphToNW();
            this.applyChanges();
            this.removeTemporaryData();
        }
        this.isRunning = false;
    }

    public void performOptimization(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, Properties properties) {
        this.cellList = arrayList2;
        this.applyCellList = arrayList;
        this.edgeList = arrayList3;
        this.presetConfig = properties;
        this.loadConfiguration(0);
        this.init(false);
        this.run();
    }

    private void loadConfiguration(int n) {
        if (n == 0) {
            this.initTemperature = Double.parseDouble((String)this.presetConfig.get("Start Temperature"));
            this.minTemperature = Double.parseDouble((String)this.presetConfig.get("min. Temperature"));
            this.minDistance = Double.parseDouble((String)this.presetConfig.get("min. Distance"));
            this.tempScaleFactor = Double.parseDouble((String)this.presetConfig.get("Temperature Scalefactor"));
            this.maxRounds = Integer.parseInt((String)this.presetConfig.get("max. Rounds"));
            this.triesPerCell = Integer.parseInt((String)this.presetConfig.get("tries per cell"));
            ArrayList arrayList = (ArrayList)this.presetConfig.get("Lambda");
            this.lambdaList = new double[6];
            int n2 = 0;
            while (n2 < this.lambdaList.length) {
                this.lambdaList[n2] = (Double)arrayList.get(n2);
                ++n2;
            }
            this.bounds = (Rectangle)this.presetConfig.get("Bounds of resulting graph");
            this.costFunctionConfig = Integer.parseInt((String)this.presetConfig.get("Costfunction Config"), 2);
            this.computePermutation = this.isTrue((String)this.presetConfig.get("should compute per Permutation"));
            this.uphillMovesAllowed = this.isTrue((String)this.presetConfig.get("are Uphill-Moves allowed"));
        } else if (n == 1) {
            this.initTemperature = Double.parseDouble((String)this.presetConfig.get("Layout Update Start Temperature"));
            this.minTemperature = Double.parseDouble((String)this.presetConfig.get("Layout Update min. Temperature"));
            this.minDistance = Double.parseDouble((String)this.presetConfig.get("Layout Update min. Distance"));
            this.tempScaleFactor = Double.parseDouble((String)this.presetConfig.get("Layout Update Temperature Scalefactor"));
            this.maxRounds = Integer.parseInt((String)this.presetConfig.get("Layout Update max. Rounds"));
            this.triesPerCell = Integer.parseInt((String)this.presetConfig.get("Layout Update tries per cell"));
            ArrayList arrayList = (ArrayList)this.presetConfig.get("Layout Update Lambda");
            this.lambdaList = new double[6];
            int n3 = 0;
            while (n3 < this.lambdaList.length) {
                this.lambdaList[n3] = (Double)arrayList.get(n3);
                ++n3;
            }
            this.bounds = (Rectangle)this.presetConfig.get("Layout Update Bounds of resulting graph");
            this.costFunctionConfig = Integer.parseInt((String)this.presetConfig.get("Layout Update Costfunction Config"), 2);
            this.computePermutation = this.isTrue((String)this.presetConfig.get("Layout Update should compute per Permutation"));
            this.uphillMovesAllowed = this.isTrue((String)this.presetConfig.get("Layout Update are Uphill-Moves allowed"));
            this.luRecursionDepth = Integer.parseInt((String)this.presetConfig.get("Layout Update Method Neighbors depth"));
            this.luPerimeterRadius = Double.parseDouble((String)this.presetConfig.get("Layout Update Method Perimeter radius"));
            this.luPerimeterRadiusInc = Double.parseDouble((String)this.presetConfig.get("Layout Update Method Perimeter radius increase"));
            this.luMethod = (String)this.presetConfig.get("Layout Update Method");
            this.isClusteringEnabled = this.isTrue((String)this.presetConfig.get("Layout Update clustering enabled"));
            this.clusteringFactor = Double.parseDouble((String)this.presetConfig.get("Layout Update clustering factor"));
            this.clusterMoveScaleFactor = Double.parseDouble((String)this.presetConfig.get("Layout Update clustering move scaling factor"));
        }
        this.loadAdditionalConfiguration(n);
    }

    protected void loadAdditionalConfiguration(int n) {
    }

    private boolean isTrue(String string) {
        if (string != null) {
            if ("TRUE".equals(string.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(string.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    private void getNodes(JGraph jGraph, Object[] objectArray) {
        Object[] objectArray2 = jGraph.getRoots();
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(objectArray2, false);
        CellView[] cellViewArray2 = jGraph.getGraphLayoutCache().getMapping(objectArray, false);
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] instanceof VertexView) {
                this.cellList.add(cellViewArray[n]);
                this.applyCellList.add(cellViewArray[n]);
            } else if (cellViewArray[n] instanceof EdgeView) {
                this.edgeList.add(cellViewArray[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < cellViewArray2.length) {
            if (cellViewArray2[n2] instanceof VertexView) {
                this.applyCellList.add(cellViewArray2[n2]);
            }
            ++n2;
        }
    }

    private void applyChanges() {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        int n = 0;
        while (n < this.applyCellList.size()) {
            CellView cellView = (CellView)this.applyCellList.get(n);
            Point2D.Double double_ = this.getPosition(cellView);
            Rectangle2D rectangle2D = cellView.getBounds();
            rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            Object object = ((CellView)this.applyCellList.get(n)).getCell();
            AttributeMap attributeMap = new AttributeMap();
            GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
            hashtable.put(object, attributeMap);
            ++n;
        }
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private void removeTemporaryData() {
        int n = 0;
        while (n < this.applyCellList.size()) {
            ((CellView)this.applyCellList.get(n)).getAttributes().clear();
            ++n;
        }
    }

    private void init(boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.applyCellList.size()) {
                if (!((CellView)this.applyCellList.get(n)).getAttributes().containsKey((Object)KEY_POSITION)) {
                    this.setPosition(n, Math.random() * this.bounds.getWidth() + this.bounds.getX(), Math.random() * this.bounds.getHeight() + this.bounds.getY());
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.cellList.size()) {
                if (!((CellView)this.cellList.get(n2)).getAttributes().containsKey((Object)KEY_POSITION)) {
                    this.setPosition((CellView)this.cellList.get(n2), Math.random() * this.bounds.getWidth() + this.bounds.getX(), Math.random() * this.bounds.getHeight() + this.bounds.getY());
                }
                ++n2;
            }
        }
        this.temperature = this.initTemperature;
        this.maxRounds = Math.min(100 * this.applyCellList.size(), this.getMaxRoundsByTemperature(this.temperature));
        this.round = 0;
    }

    private void run() {
        while (this.round <= this.maxRounds && this.isAllowedToRun()) {
            this.performRound();
        }
    }

    private void performRound() {
        double d;
        Point2D.Double[] doubleArray = this.getConfig();
        double d2 = d = this.getGlobalCosts(this.lambdaList);
        double d3 = d2 * 1.1;
        int[] nArray = new int[this.applyCellList.size()];
        if (!this.computePermutation) {
            int n = 0;
            while (n < this.applyCellList.size()) {
                nArray[n] = n;
                ++n;
            }
        }
        int n = 0;
        while (n < this.applyCellList.size()) {
            if (this.computePermutation) {
                nArray = this.createPermutation(this.applyCellList.size());
            }
            double d4 = Math.random() * 2.0 * Math.PI;
            int n2 = 0;
            while (n2 < this.triesPerCell) {
                double d5 = (double)n2 * (Math.PI * 2 / (double)this.triesPerCell);
                Point2D.Double double_ = null;
                double_ = this.isCluster((CellView)this.applyCellList.get(n)) ? new Point2D.Double(this.clusterMoveScaleFactor * this.temperature * Math.cos(d5), this.clusterMoveScaleFactor * this.temperature * Math.sin(d5)) : new Point2D.Double(this.temperature * Math.cos(d5 += d4), this.temperature * Math.sin(d5));
                this.setPosition(nArray[n], doubleArray[nArray[n]].x + double_.x, doubleArray[nArray[n]].y + double_.y);
                d3 = this.getGlobalCosts(this.lambdaList);
                if (d3 < d2 || this.getBolzmanBreak(d2, d3) && this.uphillMovesAllowed) {
                    d2 = d3;
                    doubleArray[nArray[n]] = new Point2D.Double(doubleArray[nArray[n]].x + double_.x, doubleArray[nArray[n]].y + double_.y);
                    break;
                }
                this.setPosition(nArray[n], doubleArray[nArray[n]].x, doubleArray[nArray[n]].y);
                this.setProgress((int)((double)(this.round * this.applyCellList.size() * this.triesPerCell + n * this.triesPerCell + n2) / (double)(this.maxRounds * this.applyCellList.size() * this.triesPerCell) * 100.0));
                if (!this.isAllowedToRun()) break;
                ++n2;
            }
            if (d2 == d * 0.05 || !this.isAllowedToRun()) break;
            ++n;
        }
        this.temperature *= this.tempScaleFactor;
        ++this.round;
    }

    private Point2D.Double[] getConfig() {
        Point2D.Double[] doubleArray = new Point2D.Double[this.applyCellList.size()];
        int n = 0;
        while (n < this.applyCellList.size()) {
            Point2D.Double double_ = this.getPosition((CellView)this.applyCellList.get(n));
            doubleArray[n] = new Point2D.Double(double_.x, double_.y);
            ++n;
        }
        return doubleArray;
    }

    private double getGlobalCosts(double[] dArray) {
        double d = 0.0;
        if ((this.costFunctionConfig & 0x20) != 0) {
            d += this.getNodeDistance(dArray[5]);
        }
        if ((this.costFunctionConfig & 0x10) != 0) {
            d += this.getNodeDistribution(dArray[0]);
        }
        if ((this.costFunctionConfig & 8) != 0) {
            d += this.getBorderline(dArray[1]);
        }
        if ((this.costFunctionConfig & 4) != 0) {
            d += this.getEdgeLength(dArray[2]);
        }
        if ((this.costFunctionConfig & 2) != 0) {
            d += this.getEdgeCrossing(1.0, dArray[3]);
        }
        if ((this.costFunctionConfig & 1) != 0) {
            d += this.getEdgeDistance(dArray[4]);
        }
        return d += this.getAdditionalCosts(this.costFunctionConfig, dArray);
    }

    protected double getAdditionalCosts(int n, double[] dArray) {
        return 0.0;
    }

    public int[] createPermutation(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = (int)(Math.random() * (double)n);
            int n4 = 0;
            while (n4 < n2) {
                if (n3 == nArray[n4]) {
                    n3 = (int)(Math.random() * (double)n);
                    n4 = -1;
                }
                ++n4;
            }
            nArray[n2] = n3;
            ++n2;
        }
        return nArray;
    }

    private boolean getBolzmanBreak(double d, double d2) {
        return Math.random() < Math.pow(Math.E, (d - d2) / this.temperature);
    }

    private int getMaxRoundsByTemperature(double d) {
        return (int)Math.ceil(Math.log(this.minTemperature / d) / Math.log(this.tempScaleFactor));
    }

    private double getNodeDistribution(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.applyCellList.size()) {
            int n2 = 0;
            while (n2 < this.cellList.size()) {
                if (this.applyCellList.get(n) != this.cellList.get(n2)) {
                    double d3 = MathExtensions.getEuclideanDistance(this.getPosition((CellView)this.applyCellList.get(n)), this.getPosition((CellView)this.cellList.get(n2)));
                    if (Math.abs(d3) < this.equalsNull) {
                        d3 = this.equalsNull;
                    }
                    d2 += d / (d3 * d3);
                }
                ++n2;
            }
            ++n;
        }
        return d2;
    }

    private double getBorderline(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.applyCellList.size()) {
            Point2D.Double double_ = this.getPosition((CellView)this.applyCellList.get(n));
            double d3 = double_.y - (double)this.bounds.y;
            double d4 = double_.x - (double)this.bounds.x;
            double d5 = (double)(this.bounds.y + this.bounds.height) - double_.y;
            double d6 = (double)(this.bounds.x + this.bounds.width) - double_.x;
            d2 += d * (1.0 / (d3 * d3) + 1.0 / (d4 * d4) + 1.0 / (d5 * d5) + 1.0 / (d6 * d6));
            ++n;
        }
        return d2;
    }

    private double getEdgeLength(double d) {
        double d2 = 0.0;
        Line2D.Double[] doubleArray = this.getEdgeLines(this.edgeList);
        int n = 0;
        while (n < doubleArray.length) {
            Point2D point2D = doubleArray[n].getP1();
            Point2D point2D2 = doubleArray[n].getP2();
            double d3 = point2D.distance(point2D2);
            d2 += d * d3 * d3;
            ++n;
        }
        return d2;
    }

    private double getEdgeCrossing(double d, double d2) {
        int n = 0;
        Line2D.Double[] doubleArray = this.getEdgeLines(this.edgeList);
        int n2 = 0;
        while (n2 < doubleArray.length) {
            int n3 = n2;
            while (n3 < doubleArray.length) {
                if (n3 != n2 && doubleArray[n2].intersectsLine(doubleArray[n3]) && doubleArray[n2].getP1().getX() != doubleArray[n3].getP1().getX() && doubleArray[n2].getP1().getY() != doubleArray[n3].getP1().getY() && doubleArray[n2].getP1().getX() != doubleArray[n3].getP2().getX() && doubleArray[n2].getP1().getY() != doubleArray[n3].getP2().getY() && doubleArray[n2].getP2().getX() != doubleArray[n3].getP1().getX() && doubleArray[n2].getP2().getY() != doubleArray[n3].getP1().getY() && doubleArray[n2].getP2().getX() != doubleArray[n3].getP2().getX() && doubleArray[n2].getP2().getY() != doubleArray[n3].getP2().getY()) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return d2 * d * (double)n;
    }

    private double getEdgeDistance(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.applyCellList.size()) {
            double d3 = 0.0;
            CellView cellView = (CellView)this.applyCellList.get(n);
            ArrayList arrayList = null;
            if (cellView.getAttributes().containsKey((Object)CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES)) {
                arrayList = (ArrayList)cellView.getAttributes().get((Object)CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES);
            } else {
                arrayList = this.getRelevantEdges(cellView);
                cellView.getAttributes().put((Object)CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES, (Object)arrayList);
            }
            Line2D.Double[] doubleArray = this.getEdgeLines(this.getRelevantEdges(cellView));
            int n2 = 0;
            while (n2 < doubleArray.length) {
                double d4 = doubleArray[n2].ptSegDist(this.getPosition(cellView));
                if (Math.abs(d4) < this.equalsNull) {
                    d4 = this.equalsNull;
                }
                if (d4 != 0.0) {
                    d3 += d / (d4 * d4);
                }
                if (d4 < this.minDistance) {
                    d3 += d / (this.minDistance * this.minDistance);
                }
                ++n2;
            }
            d2 += d3;
            ++n;
        }
        return d2;
    }

    private double getNodeDistance(double d) {
        double d2 = 0.0;
        double d3 = 30.0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.applyCellList.size()) {
            Point2D.Double double_ = (Point2D.Double)((CellView)this.applyCellList.get(n2)).getAttributes().get((Object)KEY_POSITION);
            Rectangle2D rectangle2D = ((CellView)this.applyCellList.get(n2)).getBounds();
            int n3 = 0;
            while (n3 < this.cellList.size()) {
                if (this.applyCellList.get(n2) != this.cellList.get(n3)) {
                    Point2D.Double double_2 = (Point2D.Double)((CellView)this.cellList.get(n3)).getAttributes().get((Object)KEY_POSITION);
                    Rectangle2D rectangle2D2 = ((CellView)this.cellList.get(n3)).getBounds();
                    double d4 = Math.max(2.0 * d3 + Math.max(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0 + Math.max(rectangle2D2.getWidth(), rectangle2D2.getHeight()) / 2.0, this.minDistance);
                    double d5 = Math.abs(double_.distance(double_2));
                    if (Math.abs(d5) < this.equalsNull) {
                        d5 = this.equalsNull;
                    }
                    if (d5 < d4) {
                        d2 += d / (d5 * d5);
                        ++n;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return d2;
    }

    private Line2D.Double[] getEdgeLines(ArrayList arrayList) {
        Line2D.Double[] doubleArray = new Line2D.Double[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            EdgeView edgeView = (EdgeView)arrayList.get(n);
            GraphModel graphModel = edgeView.getModel();
            CellMapper cellMapper = edgeView.getMapper();
            CellView cellView = edgeView.getSource().getParentView();
            CellView cellView2 = edgeView.getTarget().getParentView();
            doubleArray[n] = new Line2D.Double(this.getPosition(cellView), this.getPosition(cellView2));
            ++n;
        }
        return doubleArray;
    }

    private ArrayList getRelevantEdges(CellView cellView) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.edgeList.size()) {
            CellView cellView2 = ((EdgeView)this.edgeList.get(n)).getSource().getParentView();
            if (cellView2 != cellView && this.applyCellList.contains(cellView2)) {
                arrayList.add(this.edgeList.get(n));
            } else {
                cellView2 = ((EdgeView)this.edgeList.get(n)).getTarget().getParentView();
                if (cellView2 != cellView && this.applyCellList.contains(cellView2)) {
                    arrayList.add(this.edgeList.get(n));
                }
            }
            ++n;
        }
        return arrayList;
    }

    public Point2D.Double getRandomVector(double d) {
        double d2 = Math.random() * Math.PI * 2.0;
        double d3 = Math.random() * d;
        return new Point2D.Double(d3 * Math.cos(d2), d3 * Math.sin(d2));
    }

    private void setPosition(CellView cellView, Point2D.Double double_) {
        this.setAttribute(cellView, KEY_POSITION, double_);
    }

    private void setPosition(int n, double d, double d2) {
        this.setPosition((CellView)this.applyCellList.get(n), d, d2);
    }

    private void setPosition(CellView cellView, double d, double d2) {
        this.setPosition(cellView, new Point2D.Double(d, d2));
    }

    private Point2D.Double getPosition(CellView cellView) {
        return (Point2D.Double)this.getAttribute(cellView, KEY_POSITION);
    }

    private void setAttribute(CellView cellView, String string, Object object) {
        if (cellView.getAttributes() == null) {
            cellView.setAttributes(new AttributeMap());
        }
        AttributeMap attributeMap = cellView.getAttributes();
        attributeMap.put(string, object);
    }

    private Object getAttribute(CellView cellView, String string) {
        return cellView.getAttributes().get((Object)string);
    }

    private void moveGraphToNW() {
        Cloneable cloneable;
        Point2D.Double double_;
        Point2D.Double double_2 = this.getPosition((CellView)this.cellList.get(0));
        double d = double_2.x;
        double d2 = double_2.y;
        double d3 = d;
        double d4 = d2;
        int n = 0;
        while (n < this.cellList.size()) {
            CellView cellView = (CellView)this.cellList.get(n);
            double_ = this.getPosition((CellView)this.cellList.get(n));
            cloneable = cellView.getAttributes().createRect(cellView.getBounds());
            if (double_.getX() < d) {
                d = double_.getX();
            } else if (double_.getX() + ((RectangularShape)cloneable).getWidth() > d3) {
                d3 = double_.getX() + ((RectangularShape)cloneable).getWidth();
            }
            if (double_.getY() < d2) {
                d2 = double_.getY();
            } else if (double_.getY() + ((RectangularShape)cloneable).getHeight() > d4) {
                d4 = double_.getY() + ((RectangularShape)cloneable).getHeight();
            }
            ++n;
        }
        d -= 50.0;
        d2 -= 50.0;
        int n2 = 0;
        while (n2 < this.cellList.size()) {
            double_ = (CellView)this.cellList.get(n2);
            cloneable = this.getPosition((CellView)double_);
            this.setPosition((CellView)double_, new Point2D.Double(((Point2D.Double)cloneable).x - d, ((Point2D.Double)cloneable).y - d2));
            ++n2;
        }
    }

    protected ArrayList getRelativesFrom(ArrayList arrayList, CellView cellView) {
        ArrayList arrayList2 = this.getRelatives(cellView);
        ArrayList arrayList3 = new ArrayList();
        int n = 0;
        while (n < arrayList2.size()) {
            if (arrayList.contains(arrayList2.get(n))) {
                arrayList3.add(arrayList2.get(n));
            }
            ++n;
        }
        return arrayList3;
    }

    protected ArrayList getRelatives(CellView cellView) {
        if (cellView.getAttributes().containsKey((Object)KEY_RELATIVES)) {
            return (ArrayList)cellView.getAttributes().get((Object)KEY_RELATIVES);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        VertexView vertexView = (VertexView)cellView;
        if (this.isCluster(cellView)) {
            ArrayList arrayList3 = (ArrayList)vertexView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            int n = 0;
            while (n < arrayList3.size()) {
                ArrayList arrayList4 = this.getRelatives((CellView)arrayList3.get(n));
                int n2 = 0;
                while (n2 < arrayList4.size()) {
                    if (!arrayList.contains(arrayList4.get(n2)) && !arrayList3.contains(arrayList4.get(n2))) {
                        arrayList.add(arrayList4.get(n2));
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            GraphModel graphModel = vertexView.getModel();
            CellMapper cellMapper = vertexView.getMapper();
            Object object = vertexView.getCell();
            int n = 0;
            while (n < graphModel.getChildCount(object)) {
                Object object2 = graphModel.getChild(object, n);
                arrayList2.add(object2);
                ++n;
            }
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                Object e = arrayList2.get(n3);
                Iterator iterator = graphModel.edges(e);
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    Object object3 = null;
                    object3 = graphModel.getSource(e2) != e ? graphModel.getSource(e2) : graphModel.getTarget(e2);
                    CellView cellView2 = cellMapper.getMapping(graphModel.getParent(object3), false);
                    arrayList.add(cellView2);
                }
                ++n3;
            }
        }
        cellView.getAttributes().put((Object)KEY_RELATIVES, arrayList);
        return arrayList;
    }

    private void arrangeLayoutUpdateInsertPlacement(CellView[] cellViewArray) {
        CellView cellView;
        int n = 0;
        while (n < this.cellList.size()) {
            cellView = (CellView)this.cellList.get(n);
            if (!cellView.getAttributes().containsKey((Object)KEY_POSITION)) {
                Point2D.Double double_ = new Point2D.Double(cellView.getBounds().getCenterX(), cellView.getBounds().getCenterY());
                cellView.getAttributes().put((Object)KEY_POSITION, (Object)double_);
            }
            ++n;
        }
        cellView = new ArrayList();
        int n2 = 0;
        while (n2 < cellViewArray.length) {
            cellView.add(cellViewArray[n2]);
            ++n2;
        }
        this.arrangeLayoutUpdateInsertedCellsPlacement((ArrayList)cellView);
    }

    private void arrangeLayoutUpdateInsertedCellsPlacement(ArrayList arrayList) {
        ArrayList<CellView> arrayList2 = new ArrayList<CellView>();
        int n = 0;
        while (n < arrayList.size()) {
            CellView cellView = (CellView)arrayList.get(n);
            if (cellView instanceof VertexView) {
                ArrayList arrayList3 = this.getRelativesFrom(this.cellList, cellView);
                if (arrayList3.size() != 0) {
                    Point2D.Double double_;
                    double d = 0.0;
                    double d2 = 0.0;
                    int n2 = 0;
                    while (n2 < arrayList3.size()) {
                        double_ = (Point2D.Double)((CellView)arrayList3.get(n2)).getAttributes().get((Object)KEY_POSITION);
                        d += double_.x;
                        d2 += double_.y;
                        ++n2;
                    }
                    double_ = new Point2D.Double(Math.cos(Math.random() * 2.0 * Math.PI) * 10.0, Math.sin(Math.random() * 2.0 * Math.PI) * 10.0);
                    cellView.getAttributes().put((Object)KEY_POSITION, (Object)new Point2D.Double(d / (double)arrayList3.size() + double_.x, d2 / (double)arrayList3.size() + double_.y));
                } else {
                    arrayList2.add(cellView);
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            if (arrayList.get(n3) != null && ((CellView)arrayList.get(n3)).getAttributes() != null && ((CellView)arrayList.get(n3)).getAttributes().containsKey((Object)KEY_POSITION)) {
                this.cellList.add(arrayList.get(n3));
            }
            ++n3;
        }
        if (arrayList2.size() != arrayList.size()) {
            this.arrangeLayoutUpdateInsertedCellsPlacement(arrayList2);
        } else {
            int n4 = 0;
            while (n4 < arrayList2.size()) {
                CellView cellView = (CellView)arrayList2.get(n4);
                if (!cellView.getAttributes().containsKey((Object)KEY_POSITION)) {
                    cellView.getAttributes().put((Object)KEY_POSITION, (Object)new Point2D.Double(0.0, 0.0));
                }
                ++n4;
            }
        }
        int n5 = 0;
        while (n5 < this.cellList.size()) {
            if (((CellView)this.cellList.get(n5)).getAttributes().get((Object)KEY_POSITION) == null) {
                System.err.println("WHATCH OUT!!! NODE " + n5 + " == NULL");
            }
            ++n5;
        }
    }

    private void getLayoutUpdateCells(CellView[] cellViewArray) {
        int n;
        int n2 = 0;
        while (n2 < cellViewArray.length) {
            if (cellViewArray[n2] instanceof VertexView) {
                if (!this.applyCellList.contains(cellViewArray[n2])) {
                    this.applyCellList.add(cellViewArray[n2]);
                }
                if (!this.cellList.contains(cellViewArray[n2])) {
                    this.cellList.add(cellViewArray[n2]);
                }
            } else if (cellViewArray[n2] instanceof EdgeView && cellViewArray[n2] != null && !this.edgeList.contains(cellViewArray[n2])) {
                this.edgeList.add(cellViewArray[n2]);
                System.out.println("edge added");
            }
            ++n2;
        }
        if ("Layout Update Method Perimeter".equals(this.luMethod)) {
            Object object;
            Point2D.Double double_;
            int n3;
            Point2D.Double double_2;
            ArrayList<Ellipse2D.Double> arrayList = new ArrayList<Ellipse2D.Double>();
            n = 0;
            while (n < this.applyCellList.size()) {
                VertexView vertexView = (VertexView)this.applyCellList.get(n);
                double_2 = (Point2D.Double)vertexView.getAttributes().get((Object)KEY_POSITION);
                int n4 = 0;
                n3 = 0;
                while (n3 < this.applyCellList.size()) {
                    if (n != n3 && double_2.distance(double_ = (Point2D.Double)(object = (VertexView)this.applyCellList.get(n3)).getAttributes().get((Object)KEY_POSITION)) < this.luPerimeterRadius) {
                        ++n4;
                    }
                    ++n3;
                }
                arrayList.add(new Ellipse2D.Double(double_2.x - (this.luPerimeterRadius + (double)n4 * this.luPerimeterRadiusInc), double_2.y - (this.luPerimeterRadius + (double)n4 * this.luPerimeterRadiusInc), 2.0 * (this.luPerimeterRadius + (double)n4 * this.luPerimeterRadiusInc), 2.0 * (this.luPerimeterRadius + (double)n4 * this.luPerimeterRadiusInc)));
                ++n;
            }
            int n5 = 0;
            while (n5 < this.cellList.size()) {
                double_2 = (VertexView)this.cellList.get(n5);
                Point2D.Double double_3 = (Point2D.Double)double_2.getAttributes().get((Object)KEY_POSITION);
                n3 = 0;
                while (n3 < arrayList.size()) {
                    object = (Ellipse2D.Double)arrayList.get(n3);
                    double_ = new Point2D.Double(((RectangularShape)object).getCenterX(), ((RectangularShape)object).getCenterY());
                    double d = ((RectangularShape)object).getCenterX() - ((Ellipse2D.Double)object).getX();
                    if (double_.distance(double_3) < d && !this.applyCellList.contains(double_2)) {
                        this.applyCellList.add(double_2);
                    }
                    ++n3;
                }
                ++n5;
            }
        }
        if (this.luRecursionDepth > 0) {
            int n6 = 0;
            n = 0;
            while (n < cellViewArray.length) {
                if (cellViewArray[n] instanceof VertexView) {
                    ++n6;
                }
                ++n;
            }
            VertexView[] vertexViewArray = new VertexView[n6];
            n6 = 0;
            int n7 = 0;
            while (n7 < cellViewArray.length) {
                if (cellViewArray[n7] instanceof VertexView) {
                    vertexViewArray[n6++] = (VertexView)cellViewArray[n7];
                }
                ++n7;
            }
            this.addRelativesToList(vertexViewArray, this.luRecursionDepth);
        }
    }

    private void addRelativesToList(VertexView[] vertexViewArray, int n) {
        if (vertexViewArray == null) {
            return;
        }
        if (vertexViewArray.length == 0) {
            return;
        }
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < vertexViewArray.length) {
            ArrayList arrayList = this.getRelatives((CellView)vertexViewArray[n2]);
            VertexView[] vertexViewArray2 = new VertexView[arrayList.size()];
            int n3 = 0;
            while (n3 < arrayList.size()) {
                if (!this.applyCellList.contains(arrayList.get(n3))) {
                    this.applyCellList.add(arrayList.get(n3));
                }
                if (!this.cellList.contains(arrayList.get(n3))) {
                    this.cellList.add(arrayList.get(n3));
                }
                vertexViewArray2[n3] = (VertexView)arrayList.get(n3);
                ++n3;
            }
            this.addRelativesToList(vertexViewArray2, n - 1);
            ++n2;
        }
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        if (!this.isRunning) {
            this.isRunning = true;
            Object[] objectArray = graphModelEvent.getChange().getInserted();
            Object[] objectArray2 = graphModelEvent.getChange().getRemoved();
            if (objectArray != null && objectArray2 == null) {
                if (objectArray.length == 0) {
                    this.isRunning = false;
                    return;
                }
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray, false);
                if (cellViewArray.length == 0) {
                    this.isRunning = false;
                    return;
                }
                this.applyCellList.clear();
                this.loadConfiguration(1);
                boolean bl = false;
                int n = 0;
                while (n < cellViewArray.length) {
                    if (cellViewArray[n] == null) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    this.getAllEdges();
                }
                this.arrangeLayoutUpdateInsertPlacement(cellViewArray);
                this.getLayoutUpdateCells(cellViewArray);
                if (this.applyCellList.size() == 0) {
                    this.isRunning = false;
                    return;
                }
                this.round = 0;
                if (this.isClusteringEnabled) {
                    this.clusterGraph();
                }
                this.init(false);
                this.run();
                if (this.isClusteringEnabled) {
                    this.declusterGraph();
                }
                this.applyChanges();
                this.removeTemporaryData();
            } else if (objectArray == null && objectArray2 != null) {
                this.isRunning = true;
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray2, false);
                int n = 0;
                while (n < cellViewArray.length) {
                    if (cellViewArray[n] instanceof VertexView) {
                        if (this.applyCellList.contains(cellViewArray[n])) {
                            this.applyCellList.remove(cellViewArray[n]);
                        }
                        if (this.cellList.contains(cellViewArray[n])) {
                            this.cellList.remove(cellViewArray[n]);
                        }
                    } else if (cellViewArray[n] instanceof EdgeView) {
                        // empty if block
                    }
                    ++n;
                }
            }
            this.isRunning = false;
        }
    }

    private void showCell(CellView cellView, Color color) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        Point2D.Double double_ = this.getPosition(cellView);
        Rectangle2D rectangle2D = cellView.getBounds();
        rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        Object object = cellView.getCell();
        AttributeMap attributeMap = new AttributeMap();
        GraphConstants.setBackground((Map)attributeMap, (Color)color);
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
        hashtable.put(object, attributeMap);
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private void colorizeClusters(ArrayList arrayList) {
        Color[] colorArray = new Color[]{Color.black, Color.magenta, Color.yellow, Color.blue, Color.green, Color.gray, Color.cyan, Color.red, Color.darkGray, Color.lightGray, Color.orange, Color.pink};
        int n = 0;
        while (n < arrayList.size()) {
            if (n >= colorArray.length) break;
            ArrayList arrayList2 = (ArrayList)((VertexView)arrayList.get(n)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            this.showCellList(arrayList2, colorArray[n]);
            ++n;
        }
    }

    private void showCellList(ArrayList arrayList, Color color) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        int n = 0;
        while (n < arrayList.size()) {
            CellView cellView = (CellView)arrayList.get(n);
            Point2D.Double double_ = this.getPosition(cellView);
            Rectangle2D rectangle2D = cellView.getBounds();
            rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            Object object = cellView.getCell();
            AttributeMap attributeMap = new AttributeMap();
            GraphConstants.setBackground((Map)attributeMap, (Color)color);
            GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
            hashtable.put(object, attributeMap);
            ++n;
        }
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private void getAllEdges() {
        Object[] objectArray = this.jgraph.getRoots();
        CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray, false);
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] instanceof VertexView) {
                VertexView vertexView = (VertexView)cellViewArray[n];
                GraphModel graphModel = vertexView.getModel();
                CellMapper cellMapper = vertexView.getMapper();
                Object object = vertexView.getCell();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n2 = 0;
                while (n2 < graphModel.getChildCount(object)) {
                    Object object2 = graphModel.getChild(object, n2);
                    arrayList.add(object2);
                    ++n2;
                }
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    Object e = arrayList.get(n3);
                    Iterator iterator = graphModel.edges(e);
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        CellView cellView = cellMapper.getMapping(e2, false);
                        if (this.edgeList.contains(cellView) || cellView == null) continue;
                        this.edgeList.add(cellView);
                    }
                    ++n3;
                }
            } else if (cellViewArray[n] instanceof EdgeView && !this.edgeList.contains(cellViewArray[n]) && cellViewArray[n] != null) {
                this.edgeList.add(cellViewArray[n]);
            }
            ++n;
        }
    }

    private synchronized void stop(long l) {
        try {
            this.wait(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void clusterGraph() {
        Point2D.Double double_;
        int n;
        Object object;
        Point2D.Double double_2;
        int n2 = Math.max((int)((double)(this.cellList.size() - this.applyCellList.size()) / this.clusteringFactor), 2);
        if (this.cellList.size() <= 1) {
            System.out.println("cellList.size() <= 1");
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        ArrayList arrayList2 = new ArrayList();
        int n3 = 0;
        while (n3 < this.cellList.size()) {
            if (!this.applyCellList.contains(this.cellList.get(n3))) {
                arrayList2.add(this.cellList.get(n3));
            }
            ++n3;
        }
        VertexView[] vertexViewArray = new VertexView[n2];
        CellMapper cellMapper = ((VertexView)this.cellList.get(0)).getMapper();
        Rectangle rectangle = this.getBoundingBox();
        int n4 = 0;
        while (n4 < vertexViewArray.length) {
            vertexViewArray[n4] = new VertexView(null, this.jgraph, cellMapper);
            AttributeMap attributeMap = vertexViewArray[n4].getAttributes();
            attributeMap.put(KEY_IS_CLUSTER, "true");
            attributeMap.put(KEY_POSITION, new Point2D.Double(Math.random() * (double)rectangle.width, Math.random() * (double)rectangle.height));
            arrayList.add(vertexViewArray[n4]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < arrayList2.size()) {
            VertexView vertexView = (VertexView)arrayList2.get(n5);
            Point2D.Double double_3 = this.getPosition((CellView)vertexView);
            int n6 = 0;
            double_2 = this.getPosition((CellView)arrayList.get(0));
            double d = MathExtensions.getEuclideanDistance(double_3, double_2);
            int n7 = 1;
            while (n7 < arrayList.size()) {
                double_2 = this.getPosition((CellView)((VertexView)arrayList.get(n7)));
                double d2 = MathExtensions.getEuclideanDistance(double_3, double_2);
                if (d > d2) {
                    d = d2;
                    n6 = n7;
                }
                ++n7;
            }
            object = (VertexView)arrayList.get(n6);
            this.moveVerticeToCluster(vertexView, (VertexView)object);
            ++n5;
        }
        boolean bl = false;
        do {
            bl = false;
            n = 0;
            while (n < arrayList2.size()) {
                VertexView vertexView = (VertexView)arrayList2.get(n);
                double_2 = (VertexView)vertexView.getAttributes().get((Object)KEY_CLUSTER);
                Point2D.Double double_4 = this.getPosition((CellView)vertexView);
                double_ = this.getPosition((CellView)double_2);
                double d = MathExtensions.getEuclideanDistance(double_4, double_);
                int n8 = 0;
                while (n8 < arrayList.size()) {
                    double d3;
                    VertexView vertexView2 = (VertexView)arrayList.get(n8);
                    if (vertexView2 != double_2 && (d3 = MathExtensions.getEuclideanDistance(double_4, double_ = this.getPosition((CellView)vertexView2))) < d) {
                        this.moveVerticeToCluster(vertexView, vertexView2);
                        bl = true;
                        break;
                    }
                    ++n8;
                }
                ++n;
            }
        } while (bl);
        n = 0;
        while (n < arrayList.size()) {
            if (!((VertexView)arrayList.get(n)).getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
                arrayList.remove(n--);
            } else if (((ArrayList)((VertexView)arrayList.get(n)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES)).size() == 0) {
                arrayList.remove(n--);
            }
            ++n;
        }
        int n9 = 0;
        while (n9 < arrayList2.size()) {
            this.cellList.remove(arrayList2.get(n9));
            ++n9;
        }
        int n10 = 0;
        while (n10 < arrayList.size()) {
            this.applyCellList.add(arrayList.get(n10));
            this.cellList.add(arrayList.get(n10));
            ++n10;
        }
        int n11 = 0;
        while (n11 < arrayList.size()) {
            double_ = (VertexView)arrayList.get(n11);
            AttributeMap attributeMap = double_.getAttributes();
            object = (Point2D.Double)attributeMap.get(KEY_POSITION);
            attributeMap.put(KEY_CLUSTER_INIT_POSITION, new Point2D.Double(object.x, object.y));
            ++n11;
        }
        int n12 = 0;
        while (n12 < arrayList.size()) {
            VertexView vertexView = (VertexView)arrayList.get(n12);
            vertexView.setCachedBounds((Rectangle2D)this.getBoundingBox((ArrayList)vertexView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES)));
            ++n12;
        }
    }

    protected void moveVerticeToCluster(VertexView vertexView, VertexView vertexView2) {
        if (!vertexView2.getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
            vertexView2.getAttributes().put((Object)KEY_CLUSTERED_VERTICES, new ArrayList());
        }
        ArrayList arrayList = (ArrayList)vertexView2.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        arrayList.add(vertexView);
        if (vertexView.getAttributes().containsKey((Object)KEY_CLUSTER)) {
            VertexView vertexView3 = (VertexView)vertexView.getAttributes().get((Object)KEY_CLUSTER);
            ArrayList arrayList2 = (ArrayList)vertexView3.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            arrayList2.remove(vertexView);
            this.computeClusterPosition(vertexView3);
        }
        vertexView.getAttributes().put((Object)KEY_CLUSTER, (Object)vertexView2);
        this.computeClusterPosition(vertexView2);
    }

    protected void computeClusterPosition(VertexView vertexView) {
        ArrayList arrayList = (ArrayList)vertexView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        Point2D.Double double_ = this.computeBarycenter(arrayList);
        vertexView.getAttributes().put((Object)KEY_POSITION, (Object)double_);
    }

    protected void declusterGraph() {
        if (this.cellList.size() <= 1) {
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        int n = 0;
        while (n < this.cellList.size()) {
            VertexView vertexView = (VertexView)this.cellList.get(n);
            if (this.isCluster((CellView)vertexView)) {
                arrayList.add(vertexView);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.cellList.remove(arrayList.get(n2));
            this.applyCellList.remove(arrayList.get(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            VertexView vertexView = (VertexView)arrayList.get(n3);
            AttributeMap attributeMap = vertexView.getAttributes();
            Point2D.Double double_ = this.getPosition((CellView)vertexView);
            Point2D.Double double_2 = (Point2D.Double)attributeMap.get(KEY_CLUSTER_INIT_POSITION);
            Point2D.Double double_3 = new Point2D.Double(double_.x - double_2.x, double_.y - double_2.y);
            ArrayList arrayList2 = (ArrayList)attributeMap.get(KEY_CLUSTERED_VERTICES);
            int n4 = 0;
            while (n4 < arrayList2.size()) {
                VertexView vertexView2 = (VertexView)arrayList2.get(n4);
                Point2D.Double double_4 = this.getPosition((CellView)vertexView2);
                Point2D.Double double_5 = new Point2D.Double(double_4.x + double_3.x, double_4.y + double_3.y);
                vertexView2.getAttributes().put((Object)KEY_POSITION, (Object)double_5);
                this.cellList.add(vertexView2);
                ++n4;
            }
            ++n3;
        }
    }

    protected boolean isCluster(CellView cellView) {
        if (cellView.getAttributes().containsKey((Object)KEY_IS_CLUSTER)) {
            if (this.isTrue((String)cellView.getAttributes().get((Object)KEY_IS_CLUSTER))) {
                return true;
            }
            System.err.println("FATAL ERROR: CELL CANNOT CLEARLY BE IDENTIFIED AS A CLUSTER!!!");
            return false;
        }
        return false;
    }

    private Point2D.Double computeBarycenter(ArrayList arrayList) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < arrayList.size()) {
            CellView cellView = (CellView)arrayList.get(n);
            Point2D.Double double_ = this.getPosition(cellView);
            d += double_.x;
            d2 += double_.y;
            ++n;
        }
        return new Point2D.Double(d / (double)arrayList.size(), d2 / (double)arrayList.size());
    }

    private Rectangle getBoundingBox(ArrayList arrayList) {
        if (arrayList.size() > 0) {
            Point2D.Double double_ = this.getPosition((CellView)((VertexView)arrayList.get(0)));
            Rectangle2D rectangle2D = ((CellView)arrayList.get(0)).getBounds();
            double d = double_.getX();
            double d2 = double_.getX();
            double d3 = double_.getX() + rectangle2D.getWidth();
            double d4 = double_.getX() + rectangle2D.getHeight();
            int n = 1;
            while (n < arrayList.size()) {
                double_ = this.getPosition((CellView)((VertexView)arrayList.get(n)));
                rectangle2D = ((CellView)arrayList.get(n)).getBounds();
                if (d > double_.getX()) {
                    d = double_.getX();
                }
                if (d2 > double_.getY()) {
                    d2 = double_.getY();
                }
                if (d3 < double_.getX() + rectangle2D.getWidth()) {
                    d3 = double_.getX() + rectangle2D.getWidth();
                }
                if (d4 < double_.getY() + rectangle2D.getHeight()) {
                    d4 = double_.getY() + rectangle2D.getHeight();
                }
                ++n;
            }
            Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)(d3 - d), (int)(d4 - d2));
            return rectangle;
        }
        return null;
    }

    private Rectangle getBoundingBox() {
        return this.getBoundingBox(this.cellList);
    }

    public boolean isOptimizer() {
        return this.isOptimizer;
    }

    public Properties getPresetConfig() {
        return this.presetConfig;
    }

    public void setPresetConfig(Properties properties) {
        this.presetConfig = properties;
        this.loadConfiguration(0);
    }

    public static abstract class MathExtensions {
        public static double sgn(double d) {
            if (d < 0.0) {
                return -1.0;
            }
            if (d > 0.0) {
                return 1.0;
            }
            return 0.0;
        }

        public static double abs(Point2D.Double double_) {
            return Math.sqrt(MathExtensions.getTransposed(double_, double_));
        }

        public static double abs(double d, double d2) {
            return Math.sqrt(d * d + d2 * d2);
        }

        public static double angleBetween(Point2D.Double double_, Point2D.Double double_2) {
            double d;
            double d2;
            double d3 = MathExtensions.getTransposed(double_, double_2);
            double d4 = d3 / ((d2 = Math.sqrt(MathExtensions.getTransposed(double_, double_))) * (d = Math.sqrt(MathExtensions.getTransposed(double_2, double_2))));
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            if (d4 < -1.0) {
                d4 = -1.0;
            }
            return Math.acos(d4);
        }

        public static double getTransposed(Point2D.Double double_, Point2D.Double double_2) {
            return double_.getX() * double_2.getX() + double_.getY() * double_2.getY();
        }

        public static double getEuclideanDistance(Point2D.Double double_, Point2D.Double double_2) {
            return Math.sqrt((double_.x - double_2.x) * (double_.x - double_2.x) + (double_.y - double_2.y) * (double_.y - double_2.y));
        }

        public static Point2D.Double getNormalizedVector(Point2D.Double double_) {
            double d = MathExtensions.abs(double_);
            return new Point2D.Double(double_.x / d, double_.y / d);
        }
    }
}

