/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.AnnealingLayoutAlgorithm;
import org.jgraph.layout.GEMLayoutSettings;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;

public class GEMLayoutAlgorithm
extends JGraphLayoutAlgorithm
implements GraphModelListener {
    public static final String KEY_CAPTION = "GEM-TEMPORARY-DATA";
    public static final String KEY_TEMPERATURE = "Temperature";
    public static final String KEY_CURRENT_IMPULSE = "Current_Impulse";
    public static final String KEY_LAST_IMPULSE = "Last_Impulse";
    public static final String KEY_POSITION = "Position";
    public static final String KEY_SKEWGAUGE = "Skew_Gauge";
    public static final String KEY_RELATIVES = "Relatives";
    public static final String KEY_MASSINDEX = "Mass_Index";
    public static final String KEY_CLUSTERED_VERTICES = "Clustered Vertices";
    public static final String KEY_CLUSTER = "Cluster";
    public static final String KEY_IS_CLUSTER = "is Cluster";
    public static final String KEY_CLUSTER_INIT_POSITION = "initial Position of the Cluster";
    private ArrayList cellList;
    private ArrayList applyCellList;
    private ArrayList edgeList;
    private double equalsNull = 1.0E-17;
    protected double initTemperature = 10.0;
    protected double minTemperature = 3.0;
    protected double maxTemperature = 256.0;
    protected double prefEdgeLength = 100.0;
    protected double gravitation = 0.0625;
    protected double randomImpulseRange = 32.0;
    protected double alphaOsc = Math.toRadians(90.0);
    protected double alphaRot = Math.toRadians(60.0);
    protected double sigmaOsc = 0.3333333333333333;
    protected double sigmaRot = 0.5;
    private int maxRounds;
    private int countRounds;
    private int recursionDepth;
    private double overlapDetectWidth;
    private double overlapPrefDistance;
    private boolean avoidOverlapping;
    private String layoutUpdateMethod;
    private boolean shouldEndPerAverage;
    private boolean shouldComputePermutation;
    private boolean isActive = true;
    private boolean isRunning = false;
    private JGraph jgraph;
    protected Properties config;
    protected static final int VALUES_PUR = 0;
    protected static final int VALUES_INC = 1;
    private AnnealingLayoutAlgorithm optimizationAlgorithm;
    private boolean useOptimizeAlgorithm;
    private Properties optimizationAlgorithmConfig;
    private boolean isClusteringEnabled;
    private double clusterInitTemperature;
    private double clusterForceScalingFactor;
    private double clusteringFactor;
    private double perimeterInitSize;
    private double perimeterSizeInc;
    private boolean isDebugging = false;

    public GEMLayoutAlgorithm(AnnealingLayoutAlgorithm annealingLayoutAlgorithm) {
        this.cellList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.edgeList = new ArrayList();
        this.optimizationAlgorithm = annealingLayoutAlgorithm;
    }

    public String toString() {
        return "GEM";
    }

    public String getHint() {
        return "Ignores selection";
    }

    public JGraphLayoutSettings createSettings() {
        return new GEMLayoutSettings(this);
    }

    public void run(JGraph jGraph, Object[] objectArray, int n) {
        this.isRunning = true;
        this.jgraph = jGraph;
        this.jgraph.getModel().addGraphModelListener((GraphModelListener)this);
        this.cellList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.getNodes(this.jgraph, objectArray);
        long l = System.currentTimeMillis();
        boolean bl = this.initialize();
        if (!bl) {
            bl = this.calculate();
        }
        if (!bl && this.useOptimizeAlgorithm) {
            this.optimizationAlgorithm.performOptimization(this.applyCellList, this.cellList, this.edgeList, this.optimizationAlgorithmConfig);
        }
        if (!bl) {
            this.correctCoordinates();
        }
        if (!bl) {
            bl = this.setNewCoordinates(this.jgraph);
        }
        this.removeTemporaryLayoutDataFromCells();
        this.isRunning = false;
    }

    protected void loadRuntimeValues(int n) {
        this.maxRounds = this.applyCellList.size() * 4;
        this.countRounds = 0;
        this.isActive = this.isTrue((String)this.config.get("Layout Update enabled"));
        this.recursionDepth = Integer.parseInt((String)this.config.get("Layout Update depth"));
        this.layoutUpdateMethod = (String)this.config.get("Layout Update method");
        if (n == 0) {
            this.initTemperature = Double.parseDouble((String)this.config.get("init temperature"));
            this.minTemperature = Double.parseDouble((String)this.config.get("min temperature"));
            this.maxTemperature = Double.parseDouble((String)this.config.get("max temperature"));
            this.prefEdgeLength = Double.parseDouble((String)this.config.get("preferred Edge length"));
            this.gravitation = Double.parseDouble((String)this.config.get("gravitation to barycenter"));
            this.randomImpulseRange = Double.parseDouble((String)this.config.get("random impulse range"));
            this.overlapDetectWidth = Double.parseDouble((String)this.config.get("overlapping detection width"));
            this.overlapPrefDistance = Double.parseDouble((String)this.config.get("overlapping preferred distance"));
            this.shouldEndPerAverage = this.isTrue((String)this.config.get("compute permutation"));
            this.shouldComputePermutation = this.isTrue((String)this.config.get("end condition average"));
            this.avoidOverlapping = this.isTrue((String)this.config.get("avoid overlapping"));
            this.alphaOsc = Double.parseDouble((String)this.config.get("alpha oscillation"));
            this.alphaRot = Double.parseDouble((String)this.config.get("alpha rotation"));
            this.sigmaOsc = Double.parseDouble((String)this.config.get("sigma oscillation"));
            this.sigmaRot = Double.parseDouble((String)this.config.get("sigma rotation"));
            this.useOptimizeAlgorithm = this.isTrue((String)this.config.get("optimization algorithm enabled"));
            this.optimizationAlgorithmConfig = (Properties)this.config.get("optimization algorithm configuration");
        } else if (n == 1) {
            this.initTemperature = Double.parseDouble((String)this.config.get("Layout Update init temperature"));
            this.minTemperature = Double.parseDouble((String)this.config.get("Layout Update min temperature"));
            this.maxTemperature = Double.parseDouble((String)this.config.get("Layout Update max temperature"));
            this.prefEdgeLength = Double.parseDouble((String)this.config.get("Layout Update preferred Edge length"));
            this.gravitation = Double.parseDouble((String)this.config.get("Layout Update gravitation to barycenter"));
            this.randomImpulseRange = Double.parseDouble((String)this.config.get("Layout Update random impulse range"));
            this.overlapDetectWidth = Double.parseDouble((String)this.config.get("Layout Update overlapping detection width"));
            this.overlapPrefDistance = Double.parseDouble((String)this.config.get("Layout Update overlapping preferred distance"));
            this.shouldEndPerAverage = this.isTrue((String)this.config.get("Layout Update compute permutation"));
            this.shouldComputePermutation = this.isTrue((String)this.config.get("Layout Update end condition average"));
            this.avoidOverlapping = this.isTrue((String)this.config.get("Layout Update avoid overlapping"));
            this.alphaOsc = Double.parseDouble((String)this.config.get("Layout Update alpha rotation"));
            this.alphaRot = Double.parseDouble((String)this.config.get("Layout Update alpha oscillation"));
            this.sigmaOsc = Double.parseDouble((String)this.config.get("Layout Update sigma rotation"));
            this.sigmaRot = Double.parseDouble((String)this.config.get("Layout Update sigma oscillation"));
            this.useOptimizeAlgorithm = this.isTrue((String)this.config.get("Layout Update optimization algorithm enabled"));
            this.optimizationAlgorithmConfig = (Properties)this.config.get("Layout Update optimization algorithm configuration");
            this.perimeterInitSize = Double.parseDouble((String)this.config.get("Layout Update method perimeter initial size"));
            this.perimeterSizeInc = Double.parseDouble((String)this.config.get("Layout Update method perimeter size increase value"));
            this.isClusteringEnabled = this.isTrue((String)this.config.get("clustering enabled"));
            this.clusterInitTemperature = Double.parseDouble((String)this.config.get("cluster init temperature"));
            this.clusterForceScalingFactor = Double.parseDouble((String)this.config.get("clustering force scaling factor"));
            this.clusteringFactor = Double.parseDouble((String)this.config.get("cluster size factor"));
        }
        this.sigmaRot *= 1.0 / (double)(this.applyCellList.size() == 0 ? 1 : this.applyCellList.size());
    }

    protected boolean isTrue(String string) {
        if (string != null) {
            if ("TRUE".equals(string.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(string.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    private void getNodes(JGraph jGraph, Object[] objectArray) {
        Object[] objectArray2 = jGraph.getRoots();
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(objectArray2, false);
        CellView[] cellViewArray2 = jGraph.getGraphLayoutCache().getMapping(objectArray, false);
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] instanceof VertexView) {
                this.cellList.add(cellViewArray[n]);
                this.applyCellList.add(cellViewArray[n]);
            } else if (cellViewArray[n] instanceof EdgeView) {
                this.edgeList.add(cellViewArray[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < cellViewArray2.length) {
            if (cellViewArray2[n2] instanceof VertexView) {
                this.applyCellList.add(cellViewArray2[n2]);
            }
            ++n2;
        }
    }

    private boolean initialize() {
        int n = this.cellList.size();
        int n2 = 0;
        while (n2 < n) {
            CellView cellView = (CellView)this.cellList.get(n2);
            this.initializeVertice(cellView);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.applyCellList.size()) {
            this.computeLastImpulse((CellView)this.applyCellList.get(n3));
            ++n3;
        }
        return false;
    }

    private void initializeVertice(CellView cellView) {
        Object object = cellView.getAttributes();
        if (object == null) {
            object = new Hashtable();
        }
        object.put(KEY_CAPTION, KEY_CAPTION);
        this.initPosition(cellView);
        if (this.isCluster(cellView)) {
            object.put(KEY_TEMPERATURE, new Double(this.clusterInitTemperature));
        } else {
            object.put(KEY_TEMPERATURE, new Double(this.initTemperature));
        }
        object.put(KEY_SKEWGAUGE, new Double(0.0));
        object.put(KEY_CURRENT_IMPULSE, new Point2D.Double());
        object.put(KEY_LAST_IMPULSE, new Point2D.Double());
    }

    private boolean calculate() {
        int n = this.applyCellList.size();
        int[] nArray = new int[n];
        boolean bl = false;
        if (!this.shouldComputePermutation) {
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = n2;
                ++n2;
            }
        }
        while (!this.isFrozen() && this.countRounds <= this.maxRounds && !bl) {
            if (this.shouldComputePermutation) {
                nArray = this.createPermutation(n);
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                CellView cellView = (CellView)this.applyCellList.get(nArray[n3]);
                this.computeCurrentImpulse(cellView);
                this.updatePosAndTemp(cellView);
                ++n3;
            }
            ++this.countRounds;
        }
        return false;
    }

    private void computeCurrentImpulse(CellView cellView) {
        Point2D.Double double_ = this.computeImpulse(cellView);
        cellView.getAttributes().put((Object)KEY_CURRENT_IMPULSE, (Object)double_);
    }

    private void computeLastImpulse(CellView cellView) {
        Point2D.Double double_ = this.computeImpulse(cellView);
        cellView.getAttributes().put((Object)KEY_LAST_IMPULSE, (Object)double_);
    }

    private Point2D.Double computeImpulse(CellView cellView) {
        Cloneable cloneable;
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = this.getPosition(cellView);
        boolean bl = this.isCluster(cellView);
        double d = this.getNodeWeight(cellView);
        Point2D.Double double_3 = this.computeBarycenter(this.cellList);
        Point2D.Double double_4 = new Point2D.Double((double_3.getX() - double_2.getX()) * this.gravitation * d, (double_3.getY() - double_2.getY()) * this.gravitation * d);
        Point2D.Double double_5 = this.getRandomVector(this.randomImpulseRange);
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        int n = 0;
        while (n < this.cellList.size()) {
            if (this.cellList.get(n) != cellView) {
                double d2;
                cloneable = this.getPosition(n, this.cellList);
                double d3 = double_2.getX() - ((Point2D.Double)cloneable).getX();
                double d4 = AnnealingLayoutAlgorithm.MathExtensions.abs(d3, d2 = double_2.getY() - ((Point2D.Double)cloneable).getY());
                if (d4 > this.equalsNull) {
                    arrayList.add(new Point2D.Double(d3 * (this.prefEdgeLength * this.prefEdgeLength / (d4 * d4)), d2 * (this.prefEdgeLength * this.prefEdgeLength / (d4 * d4))));
                }
            }
            ++n;
        }
        cloneable = this.getRelativesFrom(this.cellList, cellView);
        ArrayList<Point2D.Double> arrayList2 = new ArrayList<Point2D.Double>(((ArrayList)cloneable).size());
        int n2 = 0;
        while (n2 < ((ArrayList)cloneable).size()) {
            Point2D.Double double_6 = this.getPosition(n2, (ArrayList)cloneable);
            double d5 = double_2.getX() - double_6.getX();
            double d6 = double_2.getY() - double_6.getY();
            double d7 = AnnealingLayoutAlgorithm.MathExtensions.abs(d5, d6);
            arrayList2.add(new Point2D.Double(d5 * (d7 * d7 / (this.prefEdgeLength * this.prefEdgeLength * d)), d6 * (d7 * d7 / (this.prefEdgeLength * this.prefEdgeLength * d))));
            ++n2;
        }
        ArrayList<Point2D.Double> arrayList3 = new ArrayList<Point2D.Double>();
        if (this.avoidOverlapping) {
            Rectangle rectangle = new Rectangle((int)double_2.x, (int)double_2.y, (int)cellView.getBounds().getWidth(), (int)cellView.getBounds().getHeight());
            Rectangle rectangle2 = new Rectangle((int)(rectangle.getX() - this.overlapDetectWidth), (int)(rectangle.getY() - this.overlapDetectWidth), (int)(rectangle.getWidth() + 2.0 * this.overlapDetectWidth), (int)(rectangle.getHeight() + 2.0 * this.overlapDetectWidth));
            int n3 = 0;
            while (n3 < this.cellList.size()) {
                Point2D.Double double_7 = this.getPosition(n3, this.cellList);
                Rectangle rectangle3 = new Rectangle((int)double_7.x, (int)double_7.y, (int)((CellView)this.cellList.get(n3)).getBounds().getWidth(), (int)((CellView)this.cellList.get(n3)).getBounds().getHeight());
                if (cellView != this.cellList.get(n3) && rectangle2.intersects(rectangle3)) {
                    Dimension dimension = rectangle.getSize();
                    Dimension dimension2 = rectangle3.getSize();
                    double d8 = Math.max(dimension.getWidth(), dimension.getHeight()) / 2.0 + Math.max(dimension2.getWidth(), dimension2.getHeight()) / 2.0 + this.overlapPrefDistance;
                    double d9 = double_2.x - double_7.x;
                    double d10 = double_2.y - double_7.y;
                    if (d9 < this.equalsNull && d9 >= 0.0) {
                        d9 = this.equalsNull;
                    } else if (d9 > -this.equalsNull && d9 <= 0.0) {
                        d9 = -this.equalsNull;
                    }
                    if (d10 < this.equalsNull && d10 >= 0.0) {
                        d10 = this.equalsNull;
                    } else if (d10 > -this.equalsNull && d10 <= 0.0) {
                        d10 = -this.equalsNull;
                    }
                    double d11 = AnnealingLayoutAlgorithm.MathExtensions.abs(d9, d10);
                    Point2D.Double double_8 = new Point2D.Double(d9 * (d8 * d8) / (d11 * d11), d10 * (d8 * d8) / (d11 * d11));
                    arrayList3.add(double_8);
                }
                ++n3;
            }
        }
        ArrayList arrayList4 = this.getAdditionalForces((VertexView)cellView);
        double_ = this.add(double_, double_4);
        double_ = this.add(double_, double_5);
        int n4 = 0;
        while (n4 < arrayList.size()) {
            double_ = this.add(double_, (Point2D.Double)arrayList.get(n4));
            ++n4;
        }
        int n5 = 0;
        while (n5 < arrayList2.size()) {
            double_ = this.sub(double_, (Point2D.Double)arrayList2.get(n5));
            ++n5;
        }
        int n6 = 0;
        while (n6 < arrayList3.size()) {
            double_ = this.add(double_, (Point2D.Double)arrayList3.get(n6));
            ++n6;
        }
        int n7 = 0;
        while (n7 < arrayList4.size()) {
            double_ = this.add(double_, (Point2D.Double)arrayList4.get(n7));
            ++n7;
        }
        return double_;
    }

    private void updatePosAndTemp(CellView cellView) {
        Point2D.Double double_ = (Point2D.Double)cellView.getAttributes().get((Object)KEY_CURRENT_IMPULSE);
        Point2D.Double double_2 = (Point2D.Double)cellView.getAttributes().get((Object)KEY_LAST_IMPULSE);
        Point2D.Double double_3 = this.getPosition(cellView);
        double d = (Double)cellView.getAttributes().get((Object)KEY_TEMPERATURE);
        double d2 = (Double)cellView.getAttributes().get((Object)KEY_SKEWGAUGE);
        double d3 = AnnealingLayoutAlgorithm.MathExtensions.abs(double_);
        double d4 = AnnealingLayoutAlgorithm.MathExtensions.abs(double_2);
        if (d3 > this.equalsNull) {
            if (this.isCluster(cellView)) {
                double_.setLocation(double_.getX() * d * this.clusterForceScalingFactor / d3, double_.getY() * d * this.clusterForceScalingFactor / d3);
            } else {
                double_.setLocation(double_.getX() * d / d3, double_.getY() * d / d3);
            }
            cellView.getAttributes().put((Object)KEY_CURRENT_IMPULSE, (Object)double_);
            double_3.setLocation(double_3.getX() + double_.getX(), double_3.getY() + double_.getY());
            cellView.getAttributes().put((Object)KEY_POSITION, (Object)double_3);
        }
        if (d4 > this.equalsNull) {
            double d5 = AnnealingLayoutAlgorithm.MathExtensions.angleBetween(double_, double_2);
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            if (Math.abs(d6) >= Math.sin(1.5707963267948966 + this.alphaRot / 2.0)) {
                d2 += this.sigmaRot * AnnealingLayoutAlgorithm.MathExtensions.sgn(d6);
            }
            if (d7 < Math.cos(Math.PI + this.alphaOsc / 2.0)) {
                d *= this.sigmaOsc * Math.abs(d7);
            }
            d *= 1.0 - Math.abs(d2);
            d = Math.min(d, this.maxTemperature);
        }
        cellView.getAttributes().put((Object)KEY_TEMPERATURE, (Object)new Double(d));
        cellView.getAttributes().put((Object)KEY_POSITION, (Object)double_3);
        cellView.getAttributes().put((Object)KEY_SKEWGAUGE, (Object)new Double(d2));
        cellView.getAttributes().put((Object)KEY_LAST_IMPULSE, (Object)new Point2D.Double(double_.getX(), double_.getY()));
    }

    private Point2D.Double add(Point2D.Double double_, Point2D.Double double_2) {
        return new Point2D.Double(double_.getX() + double_2.getX(), double_.getY() + double_2.getY());
    }

    private Point2D.Double sub(Point2D.Double double_, Point2D.Double double_2) {
        return new Point2D.Double(double_.getX() - double_2.getX(), double_.getY() - double_2.getY());
    }

    private ArrayList getRelativesFrom(ArrayList arrayList, CellView cellView) {
        ArrayList arrayList2 = this.getRelatives(cellView);
        ArrayList arrayList3 = new ArrayList();
        int n = 0;
        while (n < arrayList2.size()) {
            if (arrayList.contains(arrayList2.get(n))) {
                arrayList3.add(arrayList2.get(n));
            }
            ++n;
        }
        return arrayList3;
    }

    private ArrayList getRelatives(CellView cellView) {
        if (!(cellView instanceof VertexView)) {
            new Exception("getRelatives 1").printStackTrace();
            return null;
        }
        if (cellView.getAttributes().containsKey((Object)KEY_RELATIVES)) {
            return (ArrayList)cellView.getAttributes().get((Object)KEY_RELATIVES);
        }
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        if (this.isCluster(cellView)) {
            ArrayList arrayList2 = (ArrayList)cellView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            int n = 0;
            while (n < arrayList2.size()) {
                ArrayList arrayList3 = this.getRelatives((CellView)arrayList2.get(n));
                int n2 = 0;
                while (n2 < arrayList3.size()) {
                    CellView cellView2 = (CellView)arrayList3.get(n2);
                    if (!arrayList2.contains(cellView2) && !arrayList.contains(cellView2)) {
                        arrayList.add(cellView2);
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            VertexView vertexView = (VertexView)cellView;
            GraphModel graphModel = vertexView.getModel();
            CellMapper cellMapper = vertexView.getMapper();
            Object object = vertexView.getCell();
            int n = 0;
            while (n < graphModel.getChildCount(object)) {
                Object object2 = graphModel.getChild(object, n);
                arrayList4.add(object2);
                ++n;
            }
            int n3 = 0;
            while (n3 < arrayList4.size()) {
                Object e = arrayList4.get(n3);
                Iterator iterator = graphModel.edges(e);
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    Object object3 = null;
                    object3 = graphModel.getSource(e2) != e ? graphModel.getSource(e2) : graphModel.getTarget(e2);
                    CellView cellView3 = cellMapper.getMapping(graphModel.getParent(object3), true);
                    arrayList.add(cellView3);
                }
                ++n3;
            }
        }
        cellView.getAttributes().put((Object)KEY_RELATIVES, arrayList);
        return arrayList;
    }

    private double getNodeWeight(CellView cellView) {
        if (cellView.getAttributes().containsKey((Object)KEY_MASSINDEX)) {
            return (Double)cellView.getAttributes().get((Object)KEY_MASSINDEX);
        }
        int n = this.getRelatives(cellView).size();
        double d = (double)(n + 1) / 2.0;
        cellView.getAttributes().put((Object)KEY_MASSINDEX, (Object)new Double(d));
        return d;
    }

    private boolean setNewCoordinates(JGraph jGraph) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        int n = 0;
        while (n < this.cellList.size()) {
            Point2D.Double double_ = this.getPosition(n, this.cellList);
            Rectangle2D rectangle2D = ((CellView)this.cellList.get(n)).getBounds();
            rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            Object object = ((CellView)this.cellList.get(n)).getCell();
            AttributeMap attributeMap = jGraph.getModel().createAttributes();
            GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
            hashtable.put(object, attributeMap);
            ++n;
        }
        jGraph.getGraphLayoutCache().edit(hashtable, null, null, null);
        return false;
    }

    private void removeTemporaryLayoutDataFromCells() {
        int n = 0;
        while (n < this.cellList.size()) {
            ((CellView)this.cellList.get(n)).getAttributes().clear();
            ++n;
        }
    }

    private boolean isFrozen() {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        int n = 0;
        while (n < this.applyCellList.size()) {
            double d3 = this.getTemperature(n, this.applyCellList);
            d += d3;
            boolean bl2 = bl = bl && d3 <= this.minTemperature;
            if (!bl && !this.shouldEndPerAverage) break;
            ++n;
        }
        if (this.shouldEndPerAverage) {
            d2 = d / (double)this.applyCellList.size();
            return d2 < this.minTemperature;
        }
        return bl;
    }

    private int[] createPermutation(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = (int)(Math.random() * (double)n);
            int n4 = 0;
            while (n4 < n2) {
                if (n3 == nArray[n4]) {
                    n3 = (int)(Math.random() * (double)n);
                    n4 = -1;
                }
                ++n4;
            }
            nArray[n2] = n3;
            ++n2;
        }
        return nArray;
    }

    private Point2D.Double getRandomVector(double d) {
        double d2 = Math.random() * Math.PI * 2.0;
        return new Point2D.Double(d * Math.cos(d2), d * Math.sin(d2));
    }

    private Point2D.Double computeBarycenter(ArrayList arrayList) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < arrayList.size()) {
            CellView cellView = (CellView)arrayList.get(n);
            this.initPosition(cellView);
            Point2D.Double double_ = this.getPosition(cellView);
            d += double_.x;
            d2 += double_.y;
            ++n;
        }
        return new Point2D.Double(d / (double)arrayList.size(), d2 / (double)arrayList.size());
    }

    private void initPosition(CellView cellView) {
        if (!cellView.getAttributes().containsKey((Object)KEY_POSITION)) {
            cellView.getAttributes().put((Object)KEY_POSITION, (Object)new Point2D.Double(cellView.getBounds().getCenterX(), cellView.getBounds().getCenterY()));
        }
    }

    private void correctCoordinates() {
        Rectangle rectangle = this.getBoundingBox();
        if (rectangle != null) {
            int n = 0;
            while (n < this.cellList.size()) {
                CellView cellView = (CellView)this.cellList.get(n);
                Point2D.Double double_ = this.getPosition(cellView);
                Point2D.Double double_2 = new Point2D.Double(double_.x - rectangle.getX(), double_.y - rectangle.getY());
                cellView.getAttributes().put((Object)KEY_POSITION, (Object)double_2);
                ++n;
            }
        }
    }

    private Rectangle getBoundingBox() {
        return this.getBoundingBox(this.cellList);
    }

    private Rectangle getBoundingBox(ArrayList arrayList) {
        if (arrayList.size() > 0) {
            Point2D.Double double_ = this.getPosition(0, arrayList);
            Rectangle2D rectangle2D = ((CellView)arrayList.get(0)).getBounds();
            double d = double_.getX();
            double d2 = double_.getX();
            double d3 = double_.getX() + rectangle2D.getWidth();
            double d4 = double_.getX() + rectangle2D.getHeight();
            int n = 1;
            while (n < arrayList.size()) {
                double_ = this.getPosition(n, arrayList);
                rectangle2D = ((CellView)arrayList.get(n)).getBounds();
                if (d > double_.getX()) {
                    d = double_.getX();
                }
                if (d2 > double_.getY()) {
                    d2 = double_.getY();
                }
                if (d3 < double_.getX() + rectangle2D.getWidth()) {
                    d3 = double_.getX() + rectangle2D.getWidth();
                }
                if (d4 < double_.getY() + rectangle2D.getHeight()) {
                    d4 = double_.getY() + rectangle2D.getHeight();
                }
                ++n;
            }
            Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)(d3 - d), (int)(d4 - d2));
            return rectangle;
        }
        return null;
    }

    private Point2D.Double getPosition(int n, ArrayList arrayList) {
        return (Point2D.Double)this.getAttribute(n, KEY_POSITION, arrayList);
    }

    private double getTemperature(int n, ArrayList arrayList) {
        Double d = (Double)this.getAttribute(n, KEY_TEMPERATURE, arrayList);
        return d;
    }

    private Point2D.Double getPosition(CellView cellView) {
        return (Point2D.Double)cellView.getAttributes().get((Object)KEY_POSITION);
    }

    private Object getAttribute(int n, String string, ArrayList arrayList) {
        CellView cellView = (CellView)arrayList.get(n);
        return cellView.getAttributes().get((Object)string);
    }

    private void arrangePlacement(CellView[] cellViewArray) {
        int n = 0;
        while (n < this.cellList.size()) {
            this.initPosition((CellView)this.cellList.get(n));
            ++n;
        }
        if (cellViewArray != null && cellViewArray.length > 0) {
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            int n2 = 0;
            while (n2 < cellViewArray.length) {
                ArrayList arrayList2;
                if (cellViewArray[n2] instanceof VertexView && (arrayList2 = this.getRelativesFrom(this.cellList, cellViewArray[n2])).size() > 0) {
                    if (cellViewArray[n2].getAttributes() == null) {
                        cellViewArray[n2].setAttributes(new AttributeMap());
                    }
                    cellViewArray[n2].getAttributes().put((Object)KEY_POSITION, (Object)this.computeBarycenter(arrayList2));
                    arrayList.add(cellViewArray[n2]);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < arrayList.size()) {
                this.cellList.add(arrayList.get(n3));
                ++n3;
            }
            int n4 = 0;
            CellView[] cellViewArray2 = new CellView[cellViewArray.length - arrayList.size()];
            int n5 = 0;
            while (n5 < cellViewArray.length) {
                if (!arrayList.contains(cellViewArray[n5])) {
                    cellViewArray2[n4++] = cellViewArray[n5];
                }
                ++n5;
            }
            this.arrangePlacement(cellViewArray2);
        }
    }

    public void addApplyableVertices(VertexView[] vertexViewArray) {
        int n = 0;
        while (n < vertexViewArray.length) {
            if (!this.applyCellList.contains(vertexViewArray[n])) {
                this.applyCellList.add(vertexViewArray[n]);
            }
            if (!this.cellList.contains(vertexViewArray[n])) {
                this.cellList.add(vertexViewArray[n]);
            }
            ++n;
        }
        if ("Perimeter".equals(this.layoutUpdateMethod)) {
            int n2 = 0;
            while (n2 < vertexViewArray.length) {
                double d = this.perimeterInitSize;
                Point2D.Double double_ = this.getPosition((CellView)vertexViewArray[n2]);
                int n3 = 0;
                while (n3 < vertexViewArray.length) {
                    Point2D.Double double_2;
                    if (n2 != n3 && Math.abs(double_.distance(double_2 = this.getPosition((CellView)vertexViewArray[n3]))) < this.perimeterInitSize / 2.0) {
                        d += this.perimeterSizeInc;
                    }
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this.cellList.size()) {
                    Point2D.Double double_3 = this.getPosition(n4, this.cellList);
                    if (Math.abs(double_.distance(double_3)) < d / 2.0 && !this.applyCellList.contains(this.cellList.get(n4))) {
                        this.applyCellList.add(this.cellList.get(n4));
                    }
                    ++n4;
                }
                ++n2;
            }
            vertexViewArray = new VertexView[this.applyCellList.size()];
            int n5 = 0;
            while (n5 < this.applyCellList.size()) {
                vertexViewArray[n5] = (VertexView)this.applyCellList.get(n5);
                ++n5;
            }
        }
        if (this.recursionDepth > 0) {
            this.addRelativesToList(vertexViewArray, this.recursionDepth);
        }
    }

    private void addRelativesToList(VertexView[] vertexViewArray, int n) {
        if (vertexViewArray == null) {
            return;
        }
        if (vertexViewArray.length == 0) {
            return;
        }
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < vertexViewArray.length) {
            ArrayList arrayList = this.getRelatives((CellView)vertexViewArray[n2]);
            VertexView[] vertexViewArray2 = new VertexView[arrayList.size()];
            int n3 = 0;
            while (n3 < arrayList.size()) {
                if (!this.applyCellList.contains(arrayList.get(n3))) {
                    this.applyCellList.add(arrayList.get(n3));
                }
                if (!this.cellList.contains(arrayList.get(n3))) {
                    this.cellList.add(arrayList.get(n3));
                }
                vertexViewArray2[n3] = (VertexView)arrayList.get(n3);
                ++n3;
            }
            this.addRelativesToList(vertexViewArray2, n - 1);
            ++n2;
        }
    }

    protected ArrayList getAdditionalForces(VertexView vertexView) {
        return new ArrayList();
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        if (!this.isRunning && this.isActive) {
            this.isRunning = true;
            GraphModelEvent.GraphModelChange graphModelChange = graphModelEvent.getChange();
            Object[] objectArray = graphModelChange.getRemoved();
            Object[] objectArray2 = graphModelChange.getInserted();
            if (objectArray == null && objectArray2 != null) {
                int n = 0;
                while (n < this.cellList.size()) {
                    this.initPosition((CellView)this.cellList.get(n));
                    ++n;
                }
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray2, false);
                this.applyCellList = new ArrayList();
                int n2 = 0;
                int n3 = 0;
                while (n3 < cellViewArray.length) {
                    if (cellViewArray[n3] instanceof VertexView) {
                        ++n2;
                    }
                    ++n3;
                }
                VertexView[] vertexViewArray = new VertexView[n2];
                n2 = 0;
                int n4 = 0;
                while (n4 < cellViewArray.length) {
                    if (cellViewArray[n4] instanceof VertexView) {
                        vertexViewArray[n2++] = (VertexView)cellViewArray[n4];
                    }
                    ++n4;
                }
                if (vertexViewArray.length == 0) {
                    this.isRunning = false;
                    return;
                }
                this.loadRuntimeValues(1);
                this.sigmaRot /= 1.0 / (double)this.applyCellList.size();
                this.arrangePlacement((CellView[])vertexViewArray);
                this.addApplyableVertices(vertexViewArray);
                if (this.applyCellList.size() == 0) {
                    this.isRunning = false;
                    return;
                }
                if (this.isClusteringEnabled) {
                    this.clusterGraph();
                }
                this.sigmaRot *= 1.0 / (double)this.applyCellList.size();
                this.maxRounds = this.applyCellList.size() * 4;
                this.initialize();
                this.calculate();
                if (this.isClusteringEnabled) {
                    this.declusterGraph();
                }
                if (this.useOptimizeAlgorithm) {
                    this.optimizationAlgorithm.run(this.jgraph, this.jgraph.getRoots());
                }
                this.correctCoordinates();
                this.setNewCoordinates(this.jgraph);
                this.removeTemporaryLayoutDataFromCells();
            } else if (objectArray != null && objectArray2 == null) {
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray, false);
                int n = 0;
                while (n < cellViewArray.length) {
                    if (cellViewArray[n] instanceof VertexView && this.cellList.contains(cellViewArray[n])) {
                        this.applyCellList.remove(cellViewArray[n]);
                        this.cellList.remove(cellViewArray[n]);
                    }
                    ++n;
                }
            }
            this.isRunning = false;
        }
    }

    protected void clusterGraph() {
        Point2D.Double double_;
        int n;
        Object object;
        Point2D.Double double_2;
        int n2 = (int)((double)(this.cellList.size() - this.applyCellList.size()) / this.clusteringFactor);
        if (n2 == 0) {
            System.out.println("maxClusters = 0");
            return;
        }
        if (this.cellList.size() <= 1) {
            System.out.println("cellList.size() <= 1");
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        ArrayList arrayList2 = new ArrayList();
        int n3 = 0;
        while (n3 < this.cellList.size()) {
            if (!this.applyCellList.contains(this.cellList.get(n3))) {
                arrayList2.add(this.cellList.get(n3));
            }
            ++n3;
        }
        VertexView[] vertexViewArray = new VertexView[n2];
        CellMapper cellMapper = ((VertexView)this.cellList.get(0)).getMapper();
        Rectangle rectangle = this.getBoundingBox();
        int n4 = 0;
        while (n4 < vertexViewArray.length) {
            vertexViewArray[n4] = new VertexView(null, this.jgraph, cellMapper);
            AttributeMap attributeMap = vertexViewArray[n4].getAttributes();
            attributeMap.put(KEY_IS_CLUSTER, "true");
            attributeMap.put(KEY_POSITION, new Point2D.Double(Math.random() * (double)rectangle.width, Math.random() * (double)rectangle.height));
            arrayList.add(vertexViewArray[n4]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < arrayList2.size()) {
            VertexView vertexView = (VertexView)arrayList2.get(n5);
            Point2D.Double double_3 = this.getPosition((CellView)vertexView);
            int n6 = 0;
            double_2 = this.getPosition((CellView)arrayList.get(0));
            double d = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance(double_3, double_2);
            int n7 = 1;
            while (n7 < arrayList.size()) {
                double_2 = this.getPosition(n7, arrayList);
                double d2 = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance(double_3, double_2);
                if (d > d2) {
                    d = d2;
                    n6 = n7;
                }
                ++n7;
            }
            object = (VertexView)arrayList.get(n6);
            this.moveVerticeToCluster(vertexView, (VertexView)object);
            ++n5;
        }
        boolean bl = false;
        do {
            bl = false;
            n = 0;
            while (n < arrayList2.size()) {
                VertexView vertexView = (VertexView)arrayList2.get(n);
                double_2 = (VertexView)vertexView.getAttributes().get((Object)KEY_CLUSTER);
                Point2D.Double double_4 = this.getPosition((CellView)vertexView);
                double_ = this.getPosition((CellView)double_2);
                double d = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance(double_4, double_);
                int n8 = 0;
                while (n8 < arrayList.size()) {
                    double d3;
                    VertexView vertexView2 = (VertexView)arrayList.get(n8);
                    if (vertexView2 != double_2 && (d3 = AnnealingLayoutAlgorithm.MathExtensions.getEuclideanDistance(double_4, double_ = this.getPosition((CellView)vertexView2))) < d) {
                        this.moveVerticeToCluster(vertexView, vertexView2);
                        bl = true;
                        break;
                    }
                    ++n8;
                }
                ++n;
            }
        } while (bl);
        n = 0;
        while (n < arrayList.size()) {
            if (!((VertexView)arrayList.get(n)).getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
                arrayList.remove(n--);
            } else if (((ArrayList)((VertexView)arrayList.get(n)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES)).size() == 0) {
                arrayList.remove(n--);
            }
            ++n;
        }
        int n9 = 0;
        while (n9 < arrayList2.size()) {
            this.cellList.remove(arrayList2.get(n9));
            ++n9;
        }
        int n10 = 0;
        while (n10 < arrayList.size()) {
            this.applyCellList.add(arrayList.get(n10));
            this.cellList.add(arrayList.get(n10));
            ++n10;
        }
        int n11 = 0;
        while (n11 < arrayList.size()) {
            double_ = (VertexView)arrayList.get(n11);
            AttributeMap attributeMap = double_.getAttributes();
            object = (Point2D.Double)attributeMap.get(KEY_POSITION);
            attributeMap.put(KEY_CLUSTER_INIT_POSITION, new Point2D.Double(object.x, object.y));
            ++n11;
        }
        int n12 = 0;
        while (n12 < arrayList.size()) {
            VertexView vertexView = (VertexView)arrayList.get(n12);
            vertexView.setCachedBounds((Rectangle2D)this.getBoundingBox((ArrayList)vertexView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES)));
            ++n12;
        }
        this.colorizeClusters(arrayList);
        this.stop(20);
    }

    protected void moveVerticeToCluster(VertexView vertexView, VertexView vertexView2) {
        if (!vertexView2.getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
            vertexView2.getAttributes().put((Object)KEY_CLUSTERED_VERTICES, new ArrayList());
        }
        ArrayList arrayList = (ArrayList)vertexView2.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        arrayList.add(vertexView);
        if (vertexView.getAttributes().containsKey((Object)KEY_CLUSTER)) {
            VertexView vertexView3 = (VertexView)vertexView.getAttributes().get((Object)KEY_CLUSTER);
            ArrayList arrayList2 = (ArrayList)vertexView3.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            arrayList2.remove(vertexView);
            this.computeClusterPosition(vertexView3);
        }
        vertexView.getAttributes().put((Object)KEY_CLUSTER, (Object)vertexView2);
        this.computeClusterPosition(vertexView2);
    }

    protected void computeClusterPosition(VertexView vertexView) {
        ArrayList arrayList = (ArrayList)vertexView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        Point2D.Double double_ = this.computeBarycenter(arrayList);
        vertexView.getAttributes().put((Object)KEY_POSITION, (Object)double_);
    }

    protected void declusterGraph() {
        if (this.cellList.size() <= 1) {
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        int n = 0;
        while (n < this.cellList.size()) {
            VertexView vertexView = (VertexView)this.cellList.get(n);
            if (this.isCluster((CellView)vertexView)) {
                arrayList.add(vertexView);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.cellList.remove(arrayList.get(n2));
            this.applyCellList.remove(arrayList.get(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            VertexView vertexView = (VertexView)arrayList.get(n3);
            AttributeMap attributeMap = vertexView.getAttributes();
            Point2D.Double double_ = this.getPosition((CellView)vertexView);
            Point2D.Double double_2 = (Point2D.Double)attributeMap.get(KEY_CLUSTER_INIT_POSITION);
            Point2D.Double double_3 = new Point2D.Double(double_.x - double_2.x, double_.y - double_2.y);
            ArrayList arrayList2 = (ArrayList)attributeMap.get(KEY_CLUSTERED_VERTICES);
            int n4 = 0;
            while (n4 < arrayList2.size()) {
                VertexView vertexView2 = (VertexView)arrayList2.get(n4);
                Point2D.Double double_4 = this.getPosition((CellView)vertexView2);
                Point2D.Double double_5 = new Point2D.Double(double_4.x + double_3.x, double_4.y + double_3.y);
                vertexView2.getAttributes().put((Object)KEY_POSITION, (Object)double_5);
                this.cellList.add(vertexView2);
                ++n4;
            }
            ++n3;
        }
    }

    protected boolean isCluster(CellView cellView) {
        if (cellView.getAttributes().containsKey((Object)KEY_IS_CLUSTER)) {
            if (this.isTrue((String)cellView.getAttributes().get((Object)KEY_IS_CLUSTER))) {
                return true;
            }
            System.err.println("FATAL ERROR: CELL CANNOT CLEARLY BE IDENTIFIED AS A CLUSTER!!!");
            return false;
        }
        return false;
    }

    private void colorizeClusters(ArrayList arrayList) {
        Color[] colorArray = new Color[]{Color.black, Color.magenta, Color.yellow, Color.blue, Color.green, Color.gray, Color.cyan, Color.red, Color.darkGray, Color.lightGray, Color.orange, Color.pink};
        int n = 0;
        while (n < arrayList.size()) {
            if (n < colorArray.length) {
                ArrayList arrayList2 = (ArrayList)((CellView)arrayList.get(n)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
                this.showCellList(arrayList2, colorArray[n]);
            }
            ++n;
        }
    }

    private void showCellList(ArrayList arrayList, Color color) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        int n = 0;
        while (n < arrayList.size()) {
            CellView cellView = (CellView)arrayList.get(n);
            Point2D.Double double_ = this.getPosition(n, arrayList);
            Rectangle2D rectangle2D = cellView.getBounds();
            rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            Object object = cellView.getCell();
            AttributeMap attributeMap = new AttributeMap();
            GraphConstants.setBackground((Map)attributeMap, (Color)color);
            GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
            hashtable.put(object, attributeMap);
            ++n;
        }
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private synchronized void stop(double d) {
        try {
            this.wait((long)(d * 1000.0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void stop(int n) {
        this.stop((double)n);
    }

    public AnnealingLayoutAlgorithm getOptimizationAlgorithm() {
        return this.optimizationAlgorithm;
    }

    public Properties getConfig() {
        return this.config;
    }

    public void setConfig(Properties properties) {
        this.config = properties;
        this.loadRuntimeValues(0);
    }
}

