/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.JGraphLayoutAlgorithm;

public class SpringEmbeddedLayoutAlgorithm
extends JGraphLayoutAlgorithm {
    public static final String SPRING_EMBEDDED_DISP = "SpringEmbeddedDisp";
    public static final String SPRING_EMBEDDED_POS = "SpringEmbeddedPos";
    private Rectangle myFrame = null;
    private int myMaxIterations = -1;

    public SpringEmbeddedLayoutAlgorithm() {
        this.myFrame = new Rectangle(0, 0, 320, 200);
        this.myMaxIterations = 100;
    }

    public SpringEmbeddedLayoutAlgorithm(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException("frame may not be null");
        }
        if (rectangle.width <= 0) {
            throw new IllegalArgumentException("frame width must be positive");
        }
        if (rectangle.height <= 0) {
            throw new IllegalArgumentException("frame height must be positive");
        }
        this.myFrame = rectangle;
        if (n < 0) {
            throw new IllegalArgumentException("maxIterations must be a positive integer");
        }
        this.myMaxIterations = n;
    }

    public void setFrame(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException("Frame may not be null");
        }
        if (rectangle.width <= 0) {
            throw new IllegalArgumentException("frame width must be positive");
        }
        if (rectangle.height <= 0) {
            throw new IllegalArgumentException("frame height must be positive");
        }
        this.myFrame = rectangle;
    }

    public String toString() {
        return "Spring Embedded";
    }

    public void setMaxIterations(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxIterations must be a positive integer");
        }
        this.myMaxIterations = n;
    }

    public void run(JGraph jGraph, Object[] objectArray, int n) {
        GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n2 = 20;
        CellView[] cellViewArray = graphLayoutCache.getMapping(objectArray, false);
        this.partitionCells(cellViewArray, arrayList, arrayList2);
        double d = this.myFrame.getWidth();
        double d2 = this.myFrame.getHeight();
        double d3 = d * d2;
        this.randomizeVertexPositions(arrayList);
        double d4 = Math.sqrt(d3 / (double)arrayList.size());
        int n3 = 0;
        while (n3 < this.myMaxIterations) {
            this.calculateRepulsiveForces(arrayList, d4);
            this.calculateAttractiveForces(arrayList2, d4);
            this.calculateNewPositions(arrayList, n3);
            ++n3;
        }
        Rectangle rectangle = this.calculateNewFrame(arrayList);
        double d5 = (double)this.myFrame.width / (double)rectangle.width;
        double d6 = (double)this.myFrame.width / (double)rectangle.width;
        int n4 = this.myFrame.x - rectangle.x;
        int n5 = this.myFrame.y - rectangle.y;
        Map map = this.drawGraph(graphLayoutCache.getMapping(objectArray, false), jGraph.getModel(), n4, d5, n5, d6);
        graphLayoutCache.edit(map, null, null, null);
    }

    private void partitionCells(CellView[] cellViewArray, List list, List list2) {
        int n = 0;
        while (n < cellViewArray.length) {
            CellView cellView = cellViewArray[n];
            if (cellView != null) {
                EdgeView edgeView;
                if (cellView instanceof EdgeView) {
                    edgeView = (EdgeView)cellView;
                    list2.add(edgeView);
                } else if (cellView instanceof VertexView) {
                    int n2;
                    int n3;
                    edgeView = (VertexView)cellView;
                    list.add(edgeView);
                    Rectangle2D rectangle2D = edgeView.getBounds();
                    Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                    if (rectangle.x < this.myFrame.x) {
                        this.myFrame.x = rectangle.x;
                    }
                    if (rectangle.y < this.myFrame.y) {
                        this.myFrame.y = rectangle.y;
                    }
                    if ((n3 = rectangle.x - this.myFrame.x) > this.myFrame.width) {
                        this.myFrame.width = n3;
                    }
                    if ((n2 = rectangle.y - rectangle.y) > rectangle.height) {
                        rectangle.height = n2;
                    }
                }
            }
            ++n;
        }
    }

    private void randomizeVertexPositions(List list) {
        Random random = new Random();
        int n = 0;
        while (n < list.size()) {
            VertexView vertexView = (VertexView)list.get(n);
            int n2 = (int)vertexView.getBounds().getWidth();
            int n3 = (int)vertexView.getBounds().getHeight();
            int n4 = this.myFrame.width;
            int n5 = this.myFrame.height;
            int n6 = random.nextInt(n4);
            int n7 = random.nextInt(n5);
            Rectangle rectangle = new Rectangle(n6, n7, n2, n3);
            this.updateVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS, rectangle);
            ++n;
        }
    }

    private void calculateRepulsiveForces(List list, double d) {
        int n = 0;
        while (n < list.size()) {
            VertexView vertexView = (VertexView)list.get(n);
            Rectangle rectangle = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
            Rectangle rectangle2 = new Rectangle(0, 0);
            int n2 = 0;
            while (n2 < list.size()) {
                VertexView vertexView2 = (VertexView)list.get(n2);
                if (vertexView2 != vertexView) {
                    Rectangle rectangle3 = this.getVertexPosition((CellView)vertexView2, SPRING_EMBEDDED_POS);
                    Rectangle rectangle4 = new Rectangle();
                    rectangle4.x = rectangle.x - rectangle3.x;
                    rectangle4.y = rectangle.y - rectangle3.y;
                    double d2 = this.fr(this.norm(rectangle4), d);
                    double d3 = (double)rectangle4.x / this.norm(rectangle4);
                    double d4 = d3 * d2;
                    double d5 = (double)rectangle4.y / this.norm(rectangle4);
                    double d6 = d5 * d2;
                    rectangle2.x += (int)d4;
                    rectangle2.y += (int)d6;
                }
                ++n2;
            }
            this.updateVertexPosition((CellView)vertexView, SPRING_EMBEDDED_DISP, rectangle2);
            ++n;
        }
    }

    private void calculateAttractiveForces(List list, double d) {
        int n = 0;
        while (n < list.size()) {
            CellView cellView;
            CellView cellView2;
            EdgeView edgeView = (EdgeView)list.get(n);
            if (edgeView.getSource() != null && edgeView.getTarget() != null && edgeView.getSource() != edgeView.getTarget() && (cellView2 = ((PortView)edgeView.getSource()).getParentView()) != (cellView = ((PortView)edgeView.getTarget()).getParentView())) {
                Rectangle rectangle = this.getVertexPosition(cellView2, SPRING_EMBEDDED_POS);
                Rectangle rectangle2 = this.getVertexPosition(cellView, SPRING_EMBEDDED_POS);
                if (rectangle != null && rectangle2 != null) {
                    Rectangle rectangle3 = this.getVertexPosition(cellView2, SPRING_EMBEDDED_DISP);
                    Rectangle rectangle4 = this.getVertexPosition(cellView, SPRING_EMBEDDED_DISP);
                    if (rectangle3 != null && rectangle4 != null) {
                        Rectangle rectangle5 = new Rectangle();
                        rectangle5.x = rectangle.x - rectangle2.x;
                        rectangle5.y = rectangle.y - rectangle2.y;
                        double d2 = this.fa(this.norm(rectangle5), d);
                        double d3 = (double)rectangle5.x / this.norm(rectangle5);
                        double d4 = (double)rectangle5.y / this.norm(rectangle5);
                        double d5 = d3 * d2;
                        double d6 = d4 * d2;
                        rectangle3.x -= (int)d5;
                        rectangle3.y -= (int)d6;
                        rectangle4.x += (int)d5;
                        rectangle4.y += (int)d6;
                        this.updateVertexPosition(cellView2, SPRING_EMBEDDED_DISP, rectangle3);
                        this.updateVertexPosition(cellView, SPRING_EMBEDDED_DISP, rectangle4);
                    }
                }
            }
            ++n;
        }
    }

    private void calculateNewPositions(List list, int n) {
        double d = Math.sqrt(Math.pow(this.myFrame.width, 2.0) + Math.pow(this.myFrame.height, 2.0)) * ((double)this.myMaxIterations / (double)(n + 1) / (double)this.myMaxIterations);
        int n2 = 0;
        while (n2 < list.size()) {
            VertexView vertexView = (VertexView)list.get(n2);
            Rectangle rectangle = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_DISP);
            Rectangle rectangle2 = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
            double d2 = (double)rectangle.x / this.norm(rectangle);
            double d3 = Math.min((double)Math.abs(rectangle.x), d);
            double d4 = (double)rectangle.y / this.norm(rectangle);
            double d5 = Math.min((double)Math.abs(rectangle.y), d);
            rectangle2.x = (int)((double)rectangle2.x + d2 * d3);
            rectangle2.y = (int)((double)rectangle2.y + d4 * d5);
            this.updateVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS, rectangle2);
            ++n2;
        }
    }

    private Rectangle calculateNewFrame(List list) {
        Rectangle rectangle = new Rectangle();
        int n = 0;
        while (n < list.size()) {
            int n2;
            int n3;
            VertexView vertexView = (VertexView)list.get(n);
            Rectangle rectangle2 = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
            if (rectangle2.x < rectangle.x) {
                rectangle.x = rectangle2.x;
            }
            if (rectangle2.y < rectangle.y) {
                rectangle.y = rectangle2.y;
            }
            if ((n3 = rectangle2.x - rectangle.x) > rectangle.width) {
                rectangle.width = n3;
            }
            if ((n2 = rectangle2.y - rectangle.y) > rectangle.height) {
                rectangle.height = n2;
            }
            ++n;
        }
        return rectangle;
    }

    private Map drawGraph(CellView[] cellViewArray, GraphModel graphModel, int n, double d, int n2, double d2) {
        Hashtable<CellView, AttributeMap> hashtable = new Hashtable<CellView, AttributeMap>();
        int n3 = 0;
        while (n3 < cellViewArray.length) {
            CellView cellView = cellViewArray[n3];
            if (cellView != null) {
                if (cellView instanceof EdgeView) {
                    cellView.update();
                } else if (cellView instanceof VertexView) {
                    VertexView vertexView = (VertexView)cellView;
                    Rectangle rectangle = this.removeVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
                    this.removeVertexPosition((CellView)vertexView, SPRING_EMBEDDED_DISP);
                    rectangle.x = (int)((double)(rectangle.x + n) * d);
                    rectangle.y = (int)((double)(rectangle.y + n2) * d2);
                    AttributeMap attributeMap = graphModel.createAttributes();
                    GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle);
                    vertexView.setAttributes(attributeMap);
                    hashtable.put(cellViewArray[n3], attributeMap);
                }
            }
            ++n3;
        }
        return hashtable;
    }

    private void updateVertexPosition(CellView cellView, String string, Rectangle rectangle) {
        AttributeMap attributeMap = cellView.getAllAttributes();
        attributeMap.put((Object)string, (Object)rectangle);
        cellView.setAttributes(attributeMap);
    }

    private Rectangle getVertexPosition(CellView cellView, String string) {
        AttributeMap attributeMap = cellView.getAllAttributes();
        Rectangle rectangle = (Rectangle)attributeMap.get((Object)string);
        return rectangle;
    }

    private Rectangle removeVertexPosition(CellView cellView, String string) {
        AttributeMap attributeMap = cellView.getAllAttributes();
        Rectangle rectangle = (Rectangle)attributeMap.remove((Object)string);
        cellView.setAttributes(attributeMap);
        return rectangle;
    }

    protected double fa(double d, double d2) {
        double d3 = d * d / d2;
        return d3;
    }

    protected double fr(double d, double d2) {
        double d3 = d2 * d2 / d;
        return d3;
    }

    protected double norm(Rectangle rectangle) {
        double d = rectangle.x;
        double d2 = rectangle.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        return d3;
    }
}

