/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.image_viewer;

import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JApplet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.mitre.image_viewer.AppletVolumeViewer_jMenuItem1_actionAdapter;
import org.mitre.image_viewer.SlicePanel;

public class AppletVolumeViewer
extends JApplet {
    BorderLayout borderLayout1 = new BorderLayout();
    ImagePlus m_imp = null;
    SlicePanel slicePanel;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    String imageFile = null;
    String imageDir = null;
    String url = null;
    private int xdim = 0;
    private int ydim = 0;
    private int zdim = 0;

    public void init() {
        this.getParams();
        this.getContentPane().setLayout(this.borderLayout1);
        try {
            this.openVolume(this.url, this.imageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.slicePanel = new SlicePanel(this.m_imp);
        this.setJMenuBar(this.jMenuBar1);
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new AppletVolumeViewer_jMenuItem1_actionAdapter(this));
        this.getContentPane().add(this.slicePanel);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu1.add(this.jMenuItem1);
        this.setSize(800, 600);
        this.slicePanel.nextButton.doClick();
    }

    public void stop() {
    }

    public void getParams() {
        this.imageFile = this.getParameter("imageFile");
        String imageSubDir = this.imageFile.substring(this.imageFile.indexOf("/"), this.imageFile.length());
        System.out.println("AppletVolumeViewer: SubDir " + imageSubDir);
        this.imageDir = this.getParameter("imageDir");
        System.out.println("AppletVolumeViewer: imageDir " + this.imageDir);
        System.out.println("AppletVolumeViewer: imageFile " + this.imageFile);
        this.url = this.getParameter("url");
        if (this.imageDir != null) {
            this.url = this.url + this.imageDir;
        }
        System.out.println("AppletVolumeViewer: url" + this.url);
        this.xdim = Integer.parseInt(this.getParameter("xdimension"));
        System.out.println("AppletVolumeViewer: xdimension " + this.xdim);
        this.ydim = Integer.parseInt(this.getParameter("ydimension"));
        System.out.println("AppletVolumeViewer: xdimension " + this.ydim);
        this.zdim = Integer.parseInt(this.getParameter("zdimension"));
        System.out.println("AppletVolumeViewer: xdimension " + this.zdim);
    }

    public void openVolume(String url, String file) throws IOException {
        System.out.println("AppletVolumeViewer: File " + file);
        System.out.println("AppletVolumeViewer:URL " + url.toString());
        FileInfo fi = new FileInfo();
        fi.fileName = file;
        fi.url = url;
        fi.fileType = 2;
        fi.width = this.xdim;
        fi.height = this.ydim;
        fi.nImages = this.zdim;
        fi.offset = 0;
        fi.gapBetweenImages = 0;
        fi.intelByteOrder = false;
        fi.whiteIsZero = false;
        this.m_imp = new FileOpener(fi).open(false);
    }

    public void openVolume() {
    }

    public static void main(String[] args) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                new AppletVolumeViewer();
                return null;
            }
        });
    }

    public void downLoadFile(InputStream in, String outFileName) throws IOException, FileNotFoundException {
        int len;
        File outFile = new File(outFileName);
        FileOutputStream out = new FileOutputStream(outFile);
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        in.close();
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

