/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.image_viewer;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mitre.image_viewer.MRIImagePanel;

public class SlicePanel
extends JPanel
implements ChangeListener {
    int m_numSlices;
    private JSlider slider;
    JButton prevButton;
    JButton nextButton;
    JLabel MRILabel = new JLabel();
    JLabel m_coronalLabel = new JLabel();
    JLabel m_axialLabel = new JLabel();
    JLabel m_sagitalLabel = new JLabel();
    int m_currSlice = 99;
    int m_coronalCurrSlice = 99;
    int m_sagitalCurrSlice = 99;
    int m_axialCurrSlice = 99;
    ImageStack stack;
    ImageStack m_coronalStack;
    ImageStack m_sagitalStack;
    ImageStack m_axialStack;
    int m_coronalNumSlices;
    int m_sagitalNumSlices;
    int m_axialNumSlices;
    MRIImagePanel viewer;
    MRIImagePanel coronalPanel;
    MRIImagePanel axialPanel;
    MRIImagePanel sagitalPanel;
    Image img;
    ImagePlus m_imp;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JButton jButton3 = new JButton();
    public static final int AXIAL_RIGHT = 0;
    public static final int AXIAL_LEFT = 1;
    public static final int CORONAL_RIGHT = 2;
    public static final int CORONAL_LEFT = 3;
    public static final int SAGITAL_RIGHT = 4;
    public static final int SAGITAL_LEFT = 5;
    private int imageWidth;
    private int imageHeight;
    int w;
    int h;
    int size;
    int numSlices;
    int m_coronalWidth;
    int m_coronalHeight;
    int m_axialWidth;
    int m_axialHeight;
    int m_sagitalWidth;
    int m_sagitalHeight;
    int m_outOrientation;
    int m_inOrientation;

    public SlicePanel() {
    }

    public SlicePanel(ImagePlus iplus) {
        this.m_imp = iplus;
        this.imageWidth = this.m_imp.getWidth();
        this.imageHeight = this.m_imp.getHeight();
        this.numSlices = this.m_imp.getStackSize();
        this.stack = this.m_imp.getStack();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.m_numSlices = this.stack.getSize();
        ImagePlus ipCoronal = this.ImageConvertToCoronal(0, 2);
        this.m_coronalWidth = ipCoronal.getWidth();
        this.m_coronalHeight = ipCoronal.getHeight();
        this.m_coronalStack = ipCoronal.getStack();
        this.m_coronalNumSlices = this.m_coronalStack.getSize();
        this.coronalPanel = new MRIImagePanel(ipCoronal);
        this.coronalPanel.setPreferredSize(new Dimension(ipCoronal.getWidth(), ipCoronal.getHeight()));
        this.coronalPanel.setMinimumSize(new Dimension(ipCoronal.getWidth(), ipCoronal.getHeight()));
        ImagePlus ipSagital = this.ImageConvertToSagital(0, 5);
        this.m_sagitalWidth = ipSagital.getWidth();
        this.m_sagitalHeight = ipSagital.getHeight();
        this.m_sagitalStack = ipSagital.getStack();
        this.m_sagitalNumSlices = this.m_sagitalStack.getSize();
        this.sagitalPanel = new MRIImagePanel(ipSagital);
        this.sagitalPanel.setPreferredSize(new Dimension(ipSagital.getWidth(), ipSagital.getHeight()));
        this.sagitalPanel.setMinimumSize(new Dimension(ipSagital.getWidth(), ipSagital.getHeight()));
        this.setLabels();
        this.viewer = new MRIImagePanel(this.m_imp);
        this.viewer.setPreferredSize(new Dimension(this.m_imp.getWidth(), this.m_imp.getHeight()));
        this.setButtons();
        this.initSlider();
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        this.add((Component)this.MRILabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 21;
        this.add((Component)this.m_coronalLabel, c);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 21;
        this.add((Component)this.m_sagitalLabel, c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.viewer, c);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)this.coronalPanel, c);
        c.gridx = 2;
        c.gridy = 1;
        this.add((Component)this.sagitalPanel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 21;
        this.add((Component)this.prevButton, c);
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 22;
        this.add((Component)this.nextButton, c);
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 10;
        this.add((Component)this.slider, c);
    }

    private void initSlider() {
        int maxSlices = Math.max(Math.max(this.numSlices, this.m_coronalNumSlices), this.m_sagitalNumSlices);
        this.slider = new JSlider(0, 1, maxSlices, 20);
        this.slider.setMajorTickSpacing(maxSlices - 1);
        this.slider.setMinorTickSpacing(10);
        this.slider.addChangeListener(this);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTrack(true);
    }

    public void setButtons() {
        this.prevButton = new JButton("<");
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                --SlicePanel.this.m_currSlice;
                --SlicePanel.this.m_coronalCurrSlice;
                --SlicePanel.this.m_axialCurrSlice;
                --SlicePanel.this.m_sagitalCurrSlice;
                if (SlicePanel.this.m_currSlice < 1) {
                    SlicePanel.this.m_currSlice = 1;
                }
                SlicePanel.this.viewer.setSliceImage(SlicePanel.this.m_currSlice);
                if (SlicePanel.this.m_coronalCurrSlice < 1) {
                    SlicePanel.this.m_coronalCurrSlice = 1;
                }
                SlicePanel.this.coronalPanel.setSliceImage(SlicePanel.this.m_coronalCurrSlice);
                if (SlicePanel.this.m_sagitalCurrSlice < 1) {
                    SlicePanel.this.m_sagitalCurrSlice = 1;
                }
                SlicePanel.this.sagitalPanel.setSliceImage(SlicePanel.this.m_sagitalCurrSlice);
                System.out.println("Current Slice: " + SlicePanel.this.m_currSlice);
                SlicePanel.this.updateMRILabel(SlicePanel.this.m_currSlice);
                SlicePanel.this.updateCoronalLabel(SlicePanel.this.m_coronalCurrSlice);
                SlicePanel.this.updateSagitalLabel(SlicePanel.this.m_sagitalCurrSlice);
            }
        });
        this.nextButton = new JButton(">");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ++SlicePanel.this.m_currSlice;
                ++SlicePanel.this.m_coronalCurrSlice;
                ++SlicePanel.this.m_axialCurrSlice;
                ++SlicePanel.this.m_sagitalCurrSlice;
                if (SlicePanel.this.m_currSlice > SlicePanel.this.m_numSlices) {
                    SlicePanel.this.m_currSlice = SlicePanel.this.m_numSlices;
                }
                SlicePanel.this.viewer.setSliceImage(SlicePanel.this.m_currSlice);
                if (SlicePanel.this.m_coronalCurrSlice > SlicePanel.this.m_coronalNumSlices) {
                    SlicePanel.this.m_coronalCurrSlice = SlicePanel.this.m_coronalNumSlices;
                }
                SlicePanel.this.coronalPanel.setSliceImage(SlicePanel.this.m_coronalCurrSlice);
                if (SlicePanel.this.m_sagitalCurrSlice > SlicePanel.this.m_sagitalNumSlices) {
                    SlicePanel.this.m_sagitalCurrSlice = SlicePanel.this.m_sagitalNumSlices;
                }
                SlicePanel.this.sagitalPanel.setSliceImage(SlicePanel.this.m_sagitalCurrSlice);
                System.out.println("Current Slice: " + SlicePanel.this.m_currSlice);
                SlicePanel.this.updateMRILabel(SlicePanel.this.m_currSlice);
                SlicePanel.this.updateCoronalLabel(SlicePanel.this.m_coronalCurrSlice);
                SlicePanel.this.updateSagitalLabel(SlicePanel.this.m_sagitalCurrSlice);
            }
        });
    }

    private ImagePlus ImageConvertToCoronal(int inOrientation, int outOrientation) {
        ImagePlus imgPlus = null;
        this.m_inOrientation = inOrientation;
        this.m_outOrientation = outOrientation;
        switch (inOrientation) {
            case 0: {
                this.w = this.imageWidth;
                this.h = this.numSlices;
                this.size = this.imageHeight;
                break;
            }
            case 1: {
                this.w = this.imageWidth;
                this.h = this.numSlices;
                this.size = this.imageHeight;
                break;
            }
            case 2: {
                this.w = this.imageWidth;
                this.h = this.imageHeight;
                this.size = this.numSlices;
                break;
            }
            case 3: {
                this.w = this.imageWidth;
                this.h = this.imageHeight;
                this.size = this.numSlices;
                break;
            }
            case 4: {
                this.w = this.numSlices;
                this.h = this.imageHeight;
                this.size = this.imageWidth;
                break;
            }
            case 5: {
                this.w = this.numSlices;
                this.h = this.imageHeight;
                this.size = this.imageWidth;
            }
        }
        imgPlus = this.convertCoronal();
        return imgPlus;
    }

    public static ImagePlus ImageConvertToCoronal(ImagePlus imgPlus, int inOrientation, int outOrientation, int imageWidth, int imageHeight, int numSlices) {
        ImagePlus newImg = null;
        int width = 0;
        int height = 0;
        int size = 0;
        switch (inOrientation) {
            case 0: {
                width = imageWidth;
                height = numSlices;
                size = imageHeight;
                break;
            }
            case 1: {
                width = imageWidth;
                height = numSlices;
                size = imageHeight;
                break;
            }
            case 2: {
                width = imageWidth;
                height = imageHeight;
                size = numSlices;
                break;
            }
            case 3: {
                width = imageWidth;
                height = imageHeight;
                size = numSlices;
                break;
            }
            case 4: {
                width = numSlices;
                height = imageHeight;
                size = imageWidth;
                break;
            }
            case 5: {
                width = numSlices;
                height = imageHeight;
                size = imageWidth;
            }
        }
        newImg = SlicePanel.convertCoronal(imgPlus, width, height, size, inOrientation, outOrientation);
        return newImg;
    }

    private ImagePlus ImageConvertToSagital(int inOrientation, int outOrientation) {
        ImagePlus imgPlus = null;
        this.m_inOrientation = inOrientation;
        this.m_outOrientation = outOrientation;
        switch (inOrientation) {
            case 0: {
                this.w = this.imageHeight;
                this.h = this.numSlices;
                this.size = this.imageWidth;
                break;
            }
            case 1: {
                this.w = this.imageHeight;
                this.h = this.numSlices;
                this.size = this.imageWidth;
                break;
            }
            case 2: {
                this.w = this.numSlices;
                this.h = this.imageHeight;
                this.size = this.imageWidth;
                break;
            }
            case 3: {
                this.w = this.numSlices;
                this.h = this.imageHeight;
                this.size = this.imageWidth;
                break;
            }
            case 4: {
                this.w = this.imageWidth;
                this.h = this.imageHeight;
                this.size = this.numSlices;
                break;
            }
            case 5: {
                this.w = this.imageWidth;
                this.h = this.imageHeight;
                this.size = this.numSlices;
            }
        }
        imgPlus = this.convertSagital();
        return imgPlus;
    }

    public static ImagePlus ImageConvertToSagital(ImagePlus imgPlus, int inOrientation, int outOrientation, int imageWidth, int imageHeight, int numSlices) {
        ImagePlus newImg = null;
        int width = 0;
        int height = 0;
        int size = 0;
        switch (inOrientation) {
            case 0: {
                width = imageHeight;
                height = numSlices;
                size = imageWidth;
                break;
            }
            case 1: {
                width = imageHeight;
                height = numSlices;
                size = imageWidth;
                break;
            }
            case 2: {
                width = numSlices;
                height = imageHeight;
                size = imageWidth;
                break;
            }
            case 3: {
                width = numSlices;
                height = imageHeight;
                size = imageWidth;
                break;
            }
            case 4: {
                width = imageWidth;
                height = imageHeight;
                size = numSlices;
                break;
            }
            case 5: {
                width = imageWidth;
                height = imageHeight;
                size = numSlices;
            }
        }
        newImg = SlicePanel.convertSagital(imgPlus, width, height, size, inOrientation, outOrientation);
        return newImg;
    }

    private ImagePlus convertCoronal() {
        int n;
        ImageProcessor ip = this.m_imp.getProcessor();
        int wIn = this.m_imp.getWidth();
        int sizeIn = this.m_imp.getStackSize();
        short[][] pixelsS = new short[this.size][this.w * this.h];
        Object[] pixelsOut = (Object[])pixelsS;
        Object[] pixelsIn = new Object[sizeIn];
        for (n = 0; n < sizeIn; ++n) {
            pixelsIn[n] = this.m_imp.getStack().getPixels(n + 1);
        }
        for (n = 0; n < this.size; ++n) {
            for (int j = 0; j < this.h; ++j) {
                for (int i = 0; i < this.w; ++i) {
                    int n2 = 0;
                    int j2 = 0;
                    int i2 = 0;
                    switch (this.m_inOrientation) {
                        case 0: {
                            n2 = this.h - 1 - j;
                            j2 = n;
                            i2 = i;
                            break;
                        }
                        case 1: {
                            n2 = j;
                            j2 = n;
                            i2 = i;
                            break;
                        }
                        case 2: {
                            n2 = n;
                            j2 = j;
                            i2 = i;
                            break;
                        }
                        case 3: {
                            n2 = this.size - 1 - n;
                            j2 = j;
                            i2 = i;
                            break;
                        }
                        case 4: {
                            n2 = this.w - 1 - i;
                            j2 = j;
                            i2 = n;
                            break;
                        }
                        case 5: {
                            n2 = i;
                            j2 = j;
                            i2 = n;
                        }
                    }
                    if (this.m_outOrientation == 1) {
                        n = this.size - 1 - n;
                    }
                    pixelsS[n][j * this.w + i] = ((short[])pixelsIn[n2])[j2 * wIn + i2];
                }
            }
        }
        ImageStack stackOut = new ImageStack(this.w, this.h);
        for (int n2 = 0; n2 < this.size; ++n2) {
            ImageProcessor ipOut = ip.createProcessor(this.w, this.h);
            ipOut.setPixels(pixelsOut[n2]);
            stackOut.addSlice("", ipOut);
        }
        ImagePlus impOut = new ImagePlus(this.m_imp.getTitle(), stackOut);
        return impOut;
    }

    private static ImagePlus convertCoronal(ImagePlus imp, int width, int height, int size, int inOrientation, int outOrientation) {
        int n;
        ImageProcessor ip = imp.getProcessor();
        int wIn = imp.getWidth();
        int sizeIn = imp.getStackSize();
        short[][] pixelsS = new short[size][width * height];
        Object[] pixelsOut = (Object[])pixelsS;
        Object[] pixelsIn = new Object[sizeIn];
        for (n = 0; n < sizeIn; ++n) {
            pixelsIn[n] = imp.getStack().getPixels(n + 1);
        }
        for (n = 0; n < size; ++n) {
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    int n2 = 0;
                    int j2 = 0;
                    int i2 = 0;
                    switch (inOrientation) {
                        case 0: {
                            n2 = height - 1 - j;
                            j2 = n;
                            i2 = i;
                            break;
                        }
                        case 1: {
                            n2 = j;
                            j2 = n;
                            i2 = i;
                            break;
                        }
                        case 2: {
                            n2 = n;
                            j2 = j;
                            i2 = i;
                            break;
                        }
                        case 3: {
                            n2 = size - 1 - n;
                            j2 = j;
                            i2 = i;
                            break;
                        }
                        case 4: {
                            n2 = width - 1 - i;
                            j2 = j;
                            i2 = n;
                            break;
                        }
                        case 5: {
                            n2 = i;
                            j2 = j;
                            i2 = n;
                        }
                    }
                    if (outOrientation == 1) {
                        n = size - 1 - n;
                    }
                    pixelsS[n][j * width + i] = ((short[])pixelsIn[n2])[j2 * wIn + i2];
                }
            }
        }
        ImageStack stackOut = new ImageStack(width, height);
        for (int n2 = 0; n2 < size; ++n2) {
            ImageProcessor ipOut = ip.createProcessor(width, height);
            ipOut.setPixels(pixelsOut[n2]);
            stackOut.addSlice("", ipOut);
        }
        ImagePlus impOut = new ImagePlus(imp.getTitle(), stackOut);
        return impOut;
    }

    private ImagePlus convertSagital() {
        int n;
        ImageProcessor ip = this.m_imp.getProcessor();
        int wIn = this.m_imp.getWidth();
        int sizeIn = this.m_imp.getStackSize();
        short[][] pixelsS = new short[this.size][this.w * this.h];
        Object[] pixelsOut = (Object[])pixelsS;
        Object[] pixelsIn = new Object[sizeIn];
        for (n = 0; n < sizeIn; ++n) {
            pixelsIn[n] = this.m_imp.getStack().getPixels(n + 1);
        }
        for (n = 0; n < this.size; ++n) {
            for (int j = 0; j < this.h; ++j) {
                for (int i = 0; i < this.w; ++i) {
                    int n2 = 0;
                    int j2 = 0;
                    int i2 = 0;
                    switch (this.m_inOrientation) {
                        case 0: {
                            n2 = this.h - 1 - j;
                            j2 = i;
                            i2 = this.size - 1 - n;
                            break;
                        }
                        case 1: {
                            n2 = j;
                            j2 = i;
                            i2 = this.size - 1 - n;
                            break;
                        }
                        case 2: {
                            n2 = i;
                            j2 = j;
                            i2 = this.size - 1 - n;
                            break;
                        }
                        case 3: {
                            n2 = this.w - 1 - i;
                            j2 = j;
                            i2 = this.size - 1 - n;
                            break;
                        }
                        case 4: {
                            n2 = n;
                            j2 = j;
                            i2 = i;
                            break;
                        }
                        case 5: {
                            n2 = this.size - 1 - n;
                            j2 = j;
                            i2 = i;
                        }
                    }
                    if (this.m_outOrientation == 1) {
                        n = this.size - 1 - n;
                    }
                    pixelsS[n][j * this.w + i] = ((short[])pixelsIn[n2])[j2 * wIn + i2];
                }
            }
        }
        ImageStack stackOut = new ImageStack(this.w, this.h);
        for (int n2 = 0; n2 < this.size; ++n2) {
            ImageProcessor ipOut = ip.createProcessor(this.w, this.h);
            ipOut.setPixels(pixelsOut[n2]);
            stackOut.addSlice("", ipOut);
        }
        ImagePlus impOut = new ImagePlus(this.m_imp.getTitle(), stackOut);
        return impOut;
    }

    private static ImagePlus convertSagital(ImagePlus imp, int width, int height, int size, int inOrientation, int outOrientation) {
        int n;
        ImageProcessor ip = imp.getProcessor();
        int wIn = imp.getWidth();
        int sizeIn = imp.getStackSize();
        short[][] pixelsS = new short[size][width * height];
        Object[] pixelsOut = (Object[])pixelsS;
        Object[] pixelsIn = new Object[sizeIn];
        for (n = 0; n < sizeIn; ++n) {
            pixelsIn[n] = imp.getStack().getPixels(n + 1);
        }
        for (n = 0; n < size; ++n) {
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    int n2 = 0;
                    int j2 = 0;
                    int i2 = 0;
                    switch (inOrientation) {
                        case 0: {
                            n2 = height - 1 - j;
                            j2 = i;
                            i2 = size - 1 - n;
                            break;
                        }
                        case 1: {
                            n2 = j;
                            j2 = i;
                            i2 = size - 1 - n;
                            break;
                        }
                        case 2: {
                            n2 = i;
                            j2 = j;
                            i2 = size - 1 - n;
                            break;
                        }
                        case 3: {
                            n2 = width - 1 - i;
                            j2 = j;
                            i2 = size - 1 - n;
                            break;
                        }
                        case 4: {
                            n2 = n;
                            j2 = j;
                            i2 = i;
                            break;
                        }
                        case 5: {
                            n2 = size - 1 - n;
                            j2 = j;
                            i2 = i;
                        }
                    }
                    if (outOrientation == 1) {
                        n = size - 1 - n;
                    }
                    pixelsS[n][j * width + i] = ((short[])pixelsIn[n2])[j2 * wIn + i2];
                }
            }
        }
        ImageStack stackOut = new ImageStack(width, height);
        for (int n2 = 0; n2 < size; ++n2) {
            ImageProcessor ipOut = ip.createProcessor(width, height);
            ipOut.setPixels(pixelsOut[n2]);
            stackOut.addSlice("", ipOut);
        }
        ImagePlus impOut = new ImagePlus(imp.getTitle(), stackOut);
        return impOut;
    }

    private void updateMRILabel(int slicenum) {
        DecimalFormat decFormat = new DecimalFormat("000");
        String formatStr = decFormat.format(slicenum);
        String sliceText = "Slice (" + formatStr + "/" + this.m_numSlices + ")";
        String sizeText = "Size: " + this.imageWidth + "x" + this.imageHeight;
        this.MRILabel.setText(sliceText + " ; " + sizeText);
    }

    private void updateCoronalLabel(int slicenum) {
        DecimalFormat decFormat = new DecimalFormat("000");
        String formatStr = decFormat.format(slicenum);
        String sliceText = "| Slice (" + formatStr + "/" + this.m_coronalNumSlices + ")";
        String sizeText = "Size: " + this.m_coronalWidth + "x" + this.m_coronalHeight;
        this.m_coronalLabel.setText(sliceText + " ; " + sizeText);
    }

    private void updateSagitalLabel(int slicenum) {
        DecimalFormat decFormat = new DecimalFormat("000");
        String formatStr = decFormat.format(slicenum);
        String sliceText = "| Slice (" + formatStr + "/" + this.m_sagitalNumSlices + ")";
        String sizeText = "Size: " + this.m_sagitalWidth + "x" + this.m_sagitalHeight;
        this.m_sagitalLabel.setText(sliceText + " ; " + sizeText);
    }

    private void setLabels() {
        String sliceText = "Slice: (1/" + this.m_numSlices + ")";
        String sizeText = "Size: " + this.imageWidth + "x" + this.imageHeight;
        this.MRILabel.setText(sliceText + " ; " + sizeText);
        sliceText = "| Slice: (1/" + this.m_coronalNumSlices + ")";
        sizeText = " Size: " + this.m_coronalWidth + "x" + this.m_coronalHeight;
        this.m_coronalLabel.setText(sliceText + " ; " + sizeText);
        sliceText = "| Slice: (1/" + this.m_axialNumSlices + ")";
        sizeText = " Size: " + this.m_axialWidth + "x" + this.m_axialHeight;
        this.m_axialLabel.setText(sliceText + " ; " + sizeText);
        sliceText = "| Slice: (1/" + this.m_sagitalNumSlices + ")";
        sizeText = " Size: " + this.m_sagitalWidth + "x" + this.m_sagitalHeight;
        this.m_sagitalLabel.setText(sliceText + " ; " + sizeText);
    }

    public void stateChanged(ChangeEvent e) {
        int currSlice;
        JSlider source = (JSlider)e.getSource();
        this.m_currSlice = currSlice = source.getValue();
        this.m_coronalCurrSlice = currSlice;
        this.m_sagitalCurrSlice = currSlice;
        if (currSlice > this.m_numSlices) {
            this.m_currSlice = this.m_numSlices;
        }
        if (currSlice > this.m_coronalNumSlices) {
            this.m_coronalCurrSlice = this.m_coronalNumSlices;
        }
        if (currSlice > this.m_sagitalNumSlices) {
            this.m_sagitalCurrSlice = this.m_sagitalNumSlices;
        }
        this.viewer.setSliceImage(this.m_currSlice);
        this.coronalPanel.setSliceImage(this.m_coronalCurrSlice);
        this.sagitalPanel.setSliceImage(this.m_sagitalCurrSlice);
        this.updateMRILabel(this.m_currSlice);
        this.updateCoronalLabel(this.m_coronalCurrSlice);
        this.updateSagitalLabel(this.m_sagitalCurrSlice);
    }
}

