/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.custom;

import java.util.ArrayList;
import java.util.Properties;
import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.VertexView;
import org.mitre.lattice.graph.EllipseCell;
import org.mitre.lattice.lattice.LatticeFunctionsImpl;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.neuro.custom.NeuroConstants;
import org.mitre.lattice.neuro.custom.NeuroEllipseCell;
import org.mitre.lattice.neuro.custom.NeuroEllipseView;
import org.mitre.lattice.neuro.custom.NeuroGroupModifyListTag;
import org.mitre.lattice.neuro.custom.NeuroImageUtils;
import org.mitre.lattice.neuro.custom.NeuroLatticeFunctionsImpl;
import org.mitre.lattice.neuro.custom.NeuroNode;
import org.mitre.lattice.taglib.GroupModifyListTag;
import org.mitre.lattice.util.Constants;
import org.mitre.lattice.util.ImageUtils;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.LatticeFactory;
import org.mitre.mrald.util.MraldOutFile;

public class NeuroLatticeFactory
extends LatticeFactory {
    public final boolean usingLatticeSecurityModel = true;

    public boolean getUsingLatticeSecurityModel() {
        return true;
    }

    public LatticeNode createNode(LatticeNode newNode) {
        return new NeuroNode(newNode);
    }

    public LatticeNode createNode(String nodeName, ArrayList children, ArrayList parents) {
        return new NeuroNode(nodeName, children, parents);
    }

    public LatticeNode createNode(String nodeName) {
        return new NeuroNode(nodeName);
    }

    public LatticeNode createNodeWithoutChildren(LatticeNode newNode) {
        return new NeuroNode(newNode.getName(), new ArrayList(), newNode.getParents());
    }

    public LatticeNode copyNode(LatticeNode newNode) {
        boolean isCopy = true;
        return new NeuroNode(newNode, isCopy);
    }

    public EllipseCell createCell(LatticeNode newNode) {
        return new NeuroEllipseCell(newNode);
    }

    public EllipseCell createCell(String name, String type) {
        return new NeuroEllipseCell(name, type);
    }

    public VertexView createView(Object v, JGraph graph, CellMapper cm) {
        return new NeuroEllipseView(v, graph, cm);
    }

    public LatticeFunctionsImpl getLatticeFunctionImpl() {
        return new NeuroLatticeFunctionsImpl();
    }

    public GroupModifyListTag getGroupModifyListTag() {
        return new NeuroGroupModifyListTag();
    }

    public Constants getConstants() {
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)"Neuro Lattice Factory: Getting Neuro Constants ");
        return new NeuroConstants();
    }

    public Properties getProperties() {
        return NeuroConstants.getProperties();
    }

    public String[] getNodeTypes() {
        return NeuroConstants.getNodeTypes();
    }

    public ImageUtils getImageUtils() {
        return new NeuroImageUtils();
    }
}

