/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.custom;

import Jama.Matrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mitre.lattice.custom.NeuroLatticeFactory;
import org.mitre.lattice.neuro.custom.NeuroImageUtils;
import org.mitre.lattice.query.LatticeQuery;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.LatticeFactory;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;
import org.mitre.neuro.util.EndianCorrectedChannel;
import org.mitre.neuro.util.GraphPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIRAlgorithm
implements Runnable {
    public static final String KEY = AIRAlgorithm.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    public static final String DATASOURCE = "main";
    private String sourceVolumeId;
    private String derivedVolumeId;
    private File[] sourceFiles;
    private File[] derivedFiles;
    private HashMap<String, String> parameters = new HashMap();
    private int templateOrientation;
    private int maxOrientations;
    private int threshold;
    private File tempDir;
    private File imageDir;
    private File appDir;
    private String userEmail;
    private User user;
    private MraldConnection db;
    private PrintWriter out;
    private boolean doRegistration = true;
    private Callback callback = null;
    private boolean success = true;
    public static final String IMAGE_SUFFIX = ".img";
    public static final String AIR_SUFFIX = ".air";

    public String getSourceId() {
        return this.sourceVolumeId;
    }

    public String getDerivedId() {
        return this.derivedVolumeId;
    }

    public File[] getSourceFiles() {
        return this.sourceFiles;
    }

    public File[] getDerivedFiles() {
        return this.derivedFiles;
    }

    public HashMap<String, String> getParamters() {
        return this.parameters;
    }

    public int getTemplateOrientation() {
        return this.templateOrientation;
    }

    public int getMaxOrientations() {
        return this.maxOrientations;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public File getImageDir() {
        return this.imageDir;
    }

    public File getAppDir() {
        return this.appDir;
    }

    public String getUserEmailSansDomain() {
        return this.userEmail;
    }

    public User getUser() {
        return this.user;
    }

    public MraldConnection getDb() {
        return this.db;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public boolean isRegistering() {
        return this.doRegistration;
    }

    public Callback getCode() {
        return this.callback;
    }

    public boolean getSuccessStatus() {
        return this.success;
    }

    public AIRAlgorithm(User user, String volumeId, int templateOrientation, int maxOrientations, int threshold, MraldConnection connection) throws ClassNotFoundException, SQLException, NullPointerException, MraldException {
        this.user = user;
        this.userEmail = AIRAlgorithm.extractUserEmailSansDomain(user);
        this.imageDir = new File(Config.getProperty((String)"imagesDir"));
        this.tempDir = NeuroImageUtils.getVolumeTempDir(volumeId);
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
        this.appDir = new File(Config.getProperty((String)"neuroLib"));
        this.sourceVolumeId = volumeId;
        this.templateOrientation = templateOrientation;
        this.maxOrientations = maxOrientations;
        this.threshold = threshold;
        this.db = connection == null ? new MraldConnection(DATASOURCE) : connection;
    }

    public static String extractUserEmailSansDomain(User user) {
        String email = user.getEmail();
        return email.indexOf("@") > 0 ? email.substring(0, email.indexOf("@")) : email;
    }

    public void execute(String action, PrintWriter out, Callback code) throws WorkflowStepException {
        this.out = out;
        this.callback = code;
        try {
            this.init();
            if (action.equals("Print")) {
                this.printParams();
            }
            if (action.equals("Split")) {
                this.doRegistration = false;
                this.processFiles();
            } else {
                this.processFiles();
            }
        }
        catch (Exception e) {
            this.close();
            throw new WorkflowStepException((Throwable)e);
        }
    }

    private void printParams() throws MraldException {
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("AIR Registration: Print " + this.sourceVolumeId));
        try {
            this.out.println("<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'>");
            this.out.println(Config.getProperty((String)"CSS"));
            this.out.println("<TABLE ALIGN=\"CENTER\" SUMMARY=\"\" WIDTH=\"50%\" BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\"><TR><TD CLASS=\"bord\">");
            this.out.println("<TABLE SUMMARY=\"\" WIDTH=\"100%\" BORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"0\"><TR><TH colspan=2><H1> AIR Registration Parameters</H1></TH></TR>");
            this.generateCommands();
            this.out.println("</TABLE></TD></TR></TABLE>");
            this.out.flush();
        }
        catch (Exception e) {
            throw new MraldException((Throwable)e);
        }
        this.close();
    }

    private void processFiles() {
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("AIR Registration: Process " + this.doRegistration + ": " + this.sourceVolumeId));
        new Thread(this).start();
    }

    @Override
    public void run() {
        boolean failed = false;
        if (this.doRegistration) {
            try {
                this.generateDerivedFiles();
            }
            catch (Exception e) {
                failed = true;
                MraldOutFile.logToFile((Throwable)e);
                this.error("Error generating derived filenames ==> " + e.getMessage());
            }
        }
        if (failed) {
            return;
        }
        File template = null;
        for (int i = 0; i < this.sourceFiles.length; ++i) {
            File sourceFile = this.sourceFiles[i];
            try {
                File[] orientations = this.splitFile(sourceFile);
                if (template == null) {
                    template = orientations[this.templateOrientation - 1];
                }
                this.copyTemplate(orientations, template);
                if (!this.doRegistration) continue;
                this.processImages(orientations);
                this.reassembleImages(this.derivedFiles[i], orientations);
                continue;
            }
            catch (Exception e) {
                MraldOutFile.logToFile((Throwable)e);
                this.error(sourceFile + " ==> " + e.getMessage());
            }
        }
        if (this.doRegistration && this.success) {
            try {
                this.saveImages();
            }
            catch (Exception e) {
                MraldOutFile.logToFile((Throwable)e);
                this.error("Error saving to database ==> " + e.getMessage());
            }
        }
        this.close();
        if (this.callback != null) {
            this.callback.run(this);
        }
    }

    public void error(String msg) {
        this.success = false;
        this.out.println(msg);
        log.log(Level.SEVERE, msg);
    }

    private void init() throws MraldException {
        try {
            this.loadSourceFiles();
            this.loadParameters();
            this.verifyFileSizes();
            this.generateDerivedId();
        }
        catch (Exception e) {
            throw new MraldException((Throwable)e);
        }
    }

    private void close() {
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadSourceFiles() throws MraldException {
        try {
            ArrayList<String> fileNames = new ArrayList<String>();
            String query = "Select distinct images.fileName from Images  where images.volume_id = '<:VolumeId:>'";
            query = query.replaceAll("<:VolumeId:>", this.sourceVolumeId);
            query = LatticeQuery.adaptQuery((String)query, (String)this.user.getGroup());
            log.info(query);
            ResultSet rs = this.db.executeQuery(query);
            while (rs.next()) {
                fileNames.add(rs.getString("fileName"));
            }
            rs.close();
            this.sourceFiles = new File[fileNames.size()];
            for (int i = 0; i < this.sourceFiles.length; ++i) {
                File absoluteFile = new File(this.imageDir, (String)fileNames.get(i));
                this.sourceFiles[i] = new File(absoluteFile.getCanonicalPath());
                MraldOutFile.logToFile((String)("AIR Algorithm: loadSourceFiles : Adding sourec file : " + this.sourceFiles[i]));
                log.fine("Adding: " + this.sourceFiles[i].getCanonicalPath());
            }
        }
        catch (SQLException c) {
            throw new MraldException((Throwable)c);
        }
        catch (IOException e) {
            throw new MraldException((Throwable)e);
        }
    }

    private void loadParameters() throws SQLException, MraldException, ClassNotFoundException {
        String query = "select modality, file_format, numerical_format, endianness, xfov, xdimension, xstep, xstart, xorientation, xresolution, yfov, ydimension, ystep, ystart, yorientation, yresolution, zfov, zdimension, zstep, zstart, zorientation, zresolution, scan_id from Volume where volume.volume_id = '<:VolumeId:>'";
        query = query.replaceAll("<:VolumeId:>", this.sourceVolumeId);
        query = LatticeQuery.adaptQuery((String)query, (String)this.user.getGroup());
        log.info(query);
        ResultSet rs = this.db.executeQuery(query);
        if (rs.next()) {
            this.parameters.put("modality", rs.getString("modality"));
            this.parameters.put("file_format", rs.getString("file_format"));
            this.parameters.put("numerical_format", rs.getString("numerical_format"));
            this.parameters.put("endianness", rs.getString("endianness"));
            this.parameters.put("xfov", new Double(rs.getDouble("xfov")).toString());
            this.parameters.put("yfov", new Double(rs.getDouble("yfov")).toString());
            this.parameters.put("zfov", new Double(rs.getDouble("zfov")).toString());
            this.parameters.put("xdimension", new Integer(rs.getInt("xdimension")).toString());
            this.parameters.put("ydimension", new Integer(rs.getInt("ydimension")).toString());
            this.parameters.put("zdimension", new Integer(rs.getInt("zdimension")).toString());
            this.parameters.put("xstep", new Double(rs.getDouble("xstep")).toString());
            this.parameters.put("ystep", new Double(rs.getDouble("ystep")).toString());
            this.parameters.put("zstep", new Double(rs.getDouble("zstep")).toString());
            this.parameters.put("xstart", new Double(rs.getDouble("xstart")).toString());
            this.parameters.put("ystart", new Double(rs.getDouble("ystart")).toString());
            this.parameters.put("zstart", new Double(rs.getDouble("zstart")).toString());
            this.parameters.put("xorientation", rs.getString("xorientation"));
            this.parameters.put("yorientation", rs.getString("yorientation"));
            this.parameters.put("zorientation", rs.getString("zorientation"));
            this.parameters.put("xresolution", new Double(rs.getDouble("xresolution")).toString());
            this.parameters.put("yresolution", new Double(rs.getDouble("yresolution")).toString());
            this.parameters.put("zresolution", new Double(rs.getDouble("zresolution")).toString());
            this.parameters.put("scan_id", new Integer(rs.getInt("scan_id")).toString());
        }
        rs.close();
    }

    private void verifyFileSizes() throws MraldException {
        boolean failure = false;
        for (File sourceImage : this.sourceFiles) {
            try {
                this.checkFileSize(sourceImage);
            }
            catch (MraldException e) {
                failure = true;
            }
        }
        if (failure) {
            throw new MraldException("Unable to verify file sizes");
        }
    }

    private void generateDerivedId() {
        String now = Long.toString(System.currentTimeMillis());
        this.derivedVolumeId = this.sourceVolumeId + "_AIR_" + this.threshold + "_" + now;
    }

    private void checkFileSize(File recFile) throws MraldException {
        int imageSize;
        int xdim = Integer.parseInt(this.parameters.get("xdimension").toString());
        int ydim = Integer.parseInt(this.parameters.get("ydimension").toString());
        int zdim = Integer.parseInt(this.parameters.get("zdimension").toString());
        long fileLength = recFile.length();
        if (fileLength % (long)(imageSize = xdim * ydim * zdim * 2) != 0L) {
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("AIR Registration:   Check no of bytes : The Rec File size : " + fileLength + ". is not a multiple of ImageSize " + imageSize));
            throw new MraldException("The Rec File size : " + fileLength + ". is not a multiple of ImageSize " + imageSize);
        }
    }

    private void generateCommands() throws MraldException {
        for (File sourceImage : this.sourceFiles) {
            File[] orientations = this.getOrientationFilesFor(sourceImage, false);
            File template = this.getTemplateFileFor(sourceImage);
            String[] cmd = this.createHeaderCommand(template);
            String[] cmt = this.createHeaderComments();
            this.logArgs(cmd, cmt, "Make header");
            for (File orientation : orientations) {
                cmd = this.createHeaderCommand(orientation);
                cmt = this.createHeaderComments();
                this.logArgs(cmd, cmt, "Make header");
                cmd = this.createAlignCommand(orientation, template);
                cmt = this.createAlignComments();
                this.logArgs(cmd, cmt, "Align linear");
                cmd = this.createScanairCommand(orientation);
                cmt = this.createScanairComments();
                this.logArgs(cmd, cmt, "Scanair");
                cmd = this.createResliceCommand(orientation);
                cmt = this.createResliceComments();
                this.logArgs(cmd, cmt, "Reslice");
            }
        }
    }

    private File[] getOrientationFilesFor(File sourceImage, boolean make) {
        File[] result = new File[this.maxOrientations];
        File dir = new File(this.tempDir + "/" + this.derivedVolumeId + "/" + sourceImage.getName());
        if (make) {
            dir.mkdirs();
        }
        for (int i = 0; i < result.length; ++i) {
            String fileName = MiscUtils.appendSuffix((String)(dir + "/" + i), (String)IMAGE_SUFFIX);
            result[i] = new File(fileName);
        }
        return result;
    }

    public File[] getOrientationFilesFor(File sourceImage) {
        return this.getOrientationFilesFor(sourceImage, false);
    }

    private File getTemplateFileFor(File sourceImage) {
        String filename = this.tempDir + "/" + this.derivedVolumeId + "/" + "template";
        filename = MiscUtils.appendSuffix((String)filename, (String)IMAGE_SUFFIX);
        return new File(filename);
    }

    private void logArgs(String[] cmds, String[] comments, String title) throws MraldException {
        int i;
        this.out.println("<tr></tr><tr><th colspan=\"2\">" + title + "</th></tr>");
        for (i = 0; i < cmds.length; ++i) {
            this.out.println("<tr><td>" + comments[i] + "</td><td>" + cmds[i] + "</td></tr> ");
        }
        this.out.println("<tr><th colspan=\"2\">To execute from command Line (cut and paste): </th></tr><tr><td colspan=\"2\"><textarea cols=\"100\" rows=\"6\">");
        for (i = 0; i < cmds.length; ++i) {
            this.out.println(" " + cmds[i]);
        }
        this.out.println("</textarea></td></tr>");
    }

    private String[] createHeaderCommand(File orientation) {
        String[] result = new String[]{this.appDir + "/" + "makeaheader", orientation.toString(), "2", this.parameters.get("xdimension").toString(), this.parameters.get("ydimension").toString(), this.parameters.get("zdimension").toString(), this.parameters.get("xresolution").toString(), this.parameters.get("yresolution").toString(), this.parameters.get("zresolution").toString()};
        return result;
    }

    private String[] createHeaderComments() {
        String[] result = new String[]{"Executable file", "Temporary 3D image", "", "X dimension", "Y dimension", "Z dimension", "X resolution", "Y resolution", "Z resolution"};
        return result;
    }

    private String[] createAlignCommand(File orientation, File template) {
        String[] result = new String[]{this.appDir + "/" + "alignlinear", template.toString(), orientation.toString(), MiscUtils.replaceSuffix((String)orientation.toString(), (String)AIR_SUFFIX), "-m", "6", "-t1", Integer.toString(this.threshold), "-t2", Integer.toString(this.threshold), "-b1", this.parameters.get("xresolution").toString(), this.parameters.get("yresolution").toString(), this.parameters.get("zresolution").toString(), "-b2", this.parameters.get("xresolution").toString(), this.parameters.get("yresolution").toString(), this.parameters.get("zresolution").toString(), "-p1", "1", "-p2", "1", "-x", "1", "-s", "81", "1", "3", "-r", "25", "-h", "5", "-c", "0.00001"};
        return result;
    }

    private String[] createAlignComments() {
        String[] result = new String[]{" Executable", " Template file", " Temporary 3D image", " Save as", " ", "Rigid body 6 parameter model ", " ", "Threshold for standard-file ", " ", " Threshold for reslice-file", " ", " X Resolution", " Y Resolution", " Z Resolution", "", " X Resolution", " Y Resolution", "Z Resolution", "", "Partition1", "", "Partition 2", "", "Cost function : min Std. Dev", "", "Initial", "Final", "Decrement", "Decrement", "Max Iterations", "", "Unimproved", "", "Converge"};
        return result;
    }

    private String[] createResliceCommand(File orientation) {
        String[] result = new String[]{this.appDir + "/" + "reslice", MiscUtils.replaceSuffix((String)orientation.toString(), (String)AIR_SUFFIX), orientation.toString(), "-o", "-k", "-n", "1"};
        return result;
    }

    private String[] createResliceComments() {
        String[] result = new String[]{"Executable", "Alignment matrix", "Registered 3D image", "Grants permission to overwrite output", "Retains the standard file's voxel dimensions", "Changes interpolation model", "Trilinear"};
        return result;
    }

    private String[] createScanairCommand(File orientation) {
        String[] result = new String[]{this.appDir + "/" + "scanair", MiscUtils.replaceSuffix((String)orientation.toString(), (String)AIR_SUFFIX), "-r"};
        return result;
    }

    private String[] createScanairComments() {
        String[] result = new String[]{"Executable", "Alignment matrix", "Create real-world transformation matrix"};
        return result;
    }

    private File[] splitFile(File sourceImage) throws MraldException {
        File[] result = this.getOrientationFilesFor(sourceImage, true);
        try {
            EndianCorrectedChannel rawData = new EndianCorrectedChannel(new FileInputStream(sourceImage).getChannel(), this.parameters.get("endianness"));
            for (File orientation : result) {
                this.createFile(rawData, orientation);
            }
            rawData.close();
        }
        catch (Exception e) {
            throw new MraldException((Throwable)e);
        }
        return result;
    }

    private void createFile(EndianCorrectedChannel source, File targetFile) throws IOException {
        FileChannel target = new FileOutputStream(targetFile).getChannel();
        int xdim = Integer.parseInt(this.parameters.get("xdimension").toString());
        int ydim = Integer.parseInt(this.parameters.get("ydimension").toString());
        int zdim = Integer.parseInt(this.parameters.get("zdimension").toString());
        int imageSize = xdim * ydim * zdim * 2;
        ByteBuffer buffer = ByteBuffer.allocate(imageSize);
        source.read(buffer);
        buffer.position(0);
        target.write(buffer);
        target.close();
    }

    private void copyTemplate(File[] orientations, File template) throws IOException {
        FileChannel source = new FileInputStream(template).getChannel();
        File targetFile = this.getTemplateFile(orientations[0]);
        FileChannel target = new FileOutputStream(targetFile).getChannel();
        source.transferTo(0L, source.size(), target);
        source.close();
        target.close();
    }

    private File getTemplateFile(File sourceFile) {
        return new File(MiscUtils.appendSuffix((String)(sourceFile.getParent() + "/" + "template"), (String)IMAGE_SUFFIX));
    }

    private void generateDerivedFiles() throws IOException {
        try {
            this.derivedFiles = new File[this.sourceFiles.length];
            for (int i = 0; i < this.derivedFiles.length; ++i) {
                MraldOutFile.logToFile((String)("Generate Derived Files: for :" + this.sourceFiles[i].getCanonicalPath()));
                File targetFile = new File(MiscUtils.insertSuffixInFileName((String)this.sourceFiles[i].getCanonicalPath(), (String)AIR_SUFFIX));
                MraldOutFile.logToFile((String)("Generate Derived Files: Absolute path :" + targetFile.getAbsolutePath()));
                MraldOutFile.logToFile((String)("Generate Derived Files: Canonical path :" + targetFile.getCanonicalPath()));
                while (!targetFile.createNewFile()) {
                    String now = Long.toString(System.currentTimeMillis());
                    String timeBasedName = MiscUtils.insertSuffix((String)this.sourceFiles[i].getCanonicalPath(), (String)("_" + now));
                    targetFile = new File(MiscUtils.insertSuffix((String)timeBasedName, (String)AIR_SUFFIX));
                }
                this.derivedFiles[i] = targetFile;
            }
        }
        catch (IOException ioe) {
            MraldOutFile.logToFile((Throwable)ioe);
            throw ioe;
        }
        catch (Exception ioe) {
            MraldOutFile.logToFile((Throwable)ioe);
        }
    }

    private void processImages(File[] orientations) throws IOException, InterruptedException, MraldException {
        File template = this.getTemplateFile(orientations[this.templateOrientation - 1]);
        File workingDir = template.getParentFile();
        this.executeCommand(this.createHeaderCommand(template), workingDir, null);
        for (File orientation : orientations) {
            this.executeCommand(this.createHeaderCommand(orientation), workingDir, null);
            this.executeCommand(this.createAlignCommand(orientation, template), workingDir, null);
            File txt = new File(MiscUtils.replaceSuffix((String)orientation.toString(), (String)".txt"));
            this.executeCommand(this.createScanairCommand(orientation), workingDir, new PrintWriter(txt));
            this.executeCommand(this.createResliceCommand(orientation), workingDir, null);
        }
    }

    private void reassembleImages(File targetFile, File[] orientations) throws IOException {
        log.entering(KEY, "reassembleImages", new Object[]{targetFile, orientations});
        int xdim = Integer.parseInt(this.parameters.get("xdimension").toString());
        int ydim = Integer.parseInt(this.parameters.get("ydimension").toString());
        int zdim = Integer.parseInt(this.parameters.get("zdimension").toString());
        int imageSize = xdim * ydim * zdim * 2;
        ByteBuffer buffer = ByteBuffer.allocate(imageSize);
        EndianCorrectedChannel target = new EndianCorrectedChannel(new FileOutputStream(targetFile).getChannel(), this.parameters.get("endianness"));
        for (File orientation : orientations) {
            FileChannel source = new FileInputStream(orientation).getChannel();
            buffer.position(0);
            source.read(buffer);
            buffer.position(0);
            target.write(buffer);
            source.close();
        }
        target.close();
    }

    private void saveImages() throws MraldException {
        ArrayList<String> queries = new ArrayList<String>();
        try {
            this.db.setAutoCommit(false);
            this.insertVolume(queries);
            this.insertDerivation(queries);
            this.insertImages(queries);
            this.executeQueries(queries);
            this.db.commit();
        }
        catch (SQLException commitException) {
            try {
                this.db.rollback();
            }
            catch (SQLException rollbackException) {
                throw new MraldException((Throwable)rollbackException);
            }
            throw new MraldException((Throwable)commitException);
        }
    }

    private String getAIRAlgorithm() throws SQLException {
        String result = null;
        String lookup = "SELECT algorithm_id FROM algorithm WHERE algorithm_id = 'AIR' OR name LIKE '%AIR%'";
        ResultSet rs = this.db.executeQuery(lookup);
        if (rs.next()) {
            result = rs.getString("algorithm_id");
        } else {
            String insert = "INSERT INTO algorithm (algorithm_id, name, version, description ) VALUES ('AIR','AIR algorithm', 'V5.2', 'Latest AIR Registration Algorithm')";
            this.db.executeUpdate(insert);
            result = "AIR";
        }
        rs.close();
        return result;
    }

    private void insertVolume(ArrayList<String> queries) throws SQLException {
        String insertVolume = "Insert into volume (volume_id, modality, state, file_format, numerical_format, endianness, algorithm_id, xfov, xdimension, xstep, xstart, xorientation, xresolution, yfov, ydimension, ystep, ystart, yorientation, yresolution, zfov, zdimension, zstep, zstart, zorientation, zresolution, scan_id)  values ('<:volume_id:>', '<:modality:>', '<:state:>', '<:file_format:>', '<:numerical_format:>', '<:endianness:>', '<:algorithm_id:>', '<:xfov:>', '<:xdimension:>', '<:xstep:>', '<:xstart:>', '<:xorientation:>', '<:xresolution:>', '<:yfov:>', '<:ydimension:>', '<:ystep:>', '<:ystart:>', '<:yorientation:>', '<:yresolution:>', '<:zfov:>', '<:zdimension:>', '<:zstep:>', '<:zstart:>', '<:zorientation:>', '<:zresolution:>', '<:scan_id:>')";
        insertVolume = insertVolume.replaceAll("<:volume_id:>", this.derivedVolumeId);
        insertVolume = insertVolume.replaceAll("<:modality:>", this.parameters.get("modality").toString());
        insertVolume = insertVolume.replaceAll("<:state:>", "Registerd (Intra-subject)");
        insertVolume = insertVolume.replaceAll("<:file_format:>", this.parameters.get("file_format").toString());
        insertVolume = insertVolume.replaceAll("<:numerical_format:>", this.parameters.get("numerical_format").toString());
        insertVolume = insertVolume.replaceAll("<:endianness:>", this.parameters.get("endianness").toString());
        insertVolume = insertVolume.replaceAll("<:algorithm_id:>", this.getAIRAlgorithm());
        insertVolume = insertVolume.replaceAll("<:xfov:>", this.parameters.get("xfov").toString());
        insertVolume = insertVolume.replaceAll("<:yfov:>", this.parameters.get("yfov").toString());
        insertVolume = insertVolume.replaceAll("<:zfov:>", this.parameters.get("zfov").toString());
        insertVolume = insertVolume.replaceAll("<:xdimension:>", this.parameters.get("xdimension").toString());
        insertVolume = insertVolume.replaceAll("<:ydimension:>", this.parameters.get("ydimension").toString());
        insertVolume = insertVolume.replaceAll("<:zdimension:>", this.parameters.get("zdimension").toString());
        insertVolume = insertVolume.replaceAll("<:xstep:>", this.parameters.get("xstep").toString());
        insertVolume = insertVolume.replaceAll("<:ystep:>", this.parameters.get("ystep").toString());
        insertVolume = insertVolume.replaceAll("<:zstep:>", this.parameters.get("zstep").toString());
        insertVolume = insertVolume.replaceAll("<:xstart:>", this.parameters.get("xstart").toString());
        insertVolume = insertVolume.replaceAll("<:ystart:>", this.parameters.get("ystart").toString());
        insertVolume = insertVolume.replaceAll("<:zstart:>", this.parameters.get("zstart").toString());
        insertVolume = insertVolume.replaceAll("<:xorientation:>", this.parameters.get("xorientation").toString());
        insertVolume = insertVolume.replaceAll("<:yorientation:>", this.parameters.get("yorientation").toString());
        insertVolume = insertVolume.replaceAll("<:zorientation:>", this.parameters.get("zorientation").toString());
        insertVolume = insertVolume.replaceAll("<:xresolution:>", this.parameters.get("xresolution").toString());
        insertVolume = insertVolume.replaceAll("<:yresolution:>", this.parameters.get("yresolution").toString());
        insertVolume = insertVolume.replaceAll("<:zresolution:>", this.parameters.get("zresolution").toString());
        insertVolume = insertVolume.replaceAll("<:scan_id:>", this.parameters.get("scan_id").toString());
        queries.add(insertVolume);
        this.updateVolumeLabel(queries);
    }

    private void updateVolumeLabel(ArrayList<String> queries) {
        String lookupLabel = "SELECT label FROM volume_label WHERE volume_id='<:srcId:>'";
        String updateLabel = "UPDATE volume_label SET owner='" + MiscUtils.checkApostrophe((String)this.user.getEmail()) + "', label = (" + lookupLabel + ") WHERE volume_label.volume_id = '<:tgtId:>'";
        updateLabel = updateLabel.replaceAll("<:tgtId:>", this.derivedVolumeId);
        updateLabel = updateLabel.replaceAll("<:srcId:>", this.sourceVolumeId);
        queries.add(updateLabel);
    }

    private void insertDerivation(ArrayList<String> queries) {
        String insertDerivation = "INSERT INTO derivation_history VALUES ('<:volume_id:>','<:source_volume_id:>')";
        insertDerivation = insertDerivation.replaceAll("<:volume_id:>", this.derivedVolumeId);
        insertDerivation = insertDerivation.replaceAll("<:source_volume_id:>", this.sourceVolumeId);
        queries.add(insertDerivation);
        String insertParameters = "INSERT INTO parameters (volume_id, parameter, value) VALUES ('<:volume_id:>', 'threshold', '<:value:>')";
        insertParameters = insertParameters.replaceAll("<:volume_id:>", this.derivedVolumeId);
        insertParameters = insertParameters.replaceAll("<:value:>", Integer.toString(this.threshold));
        queries.add(insertParameters);
    }

    private void insertImages(ArrayList<String> queries) {
        String insertTemplate = "INSERT INTO images VALUES ('<:volume_id:>', '<:fileName:>')";
        for (int i = 0; i < this.sourceFiles.length; ++i) {
            File sourceFile = this.sourceFiles[i];
            File derivedFile = this.derivedFiles[i];
            String insertImage = insertTemplate.replaceAll("<:volume_id:>", this.derivedVolumeId);
            try {
                insertImage = insertImage.replaceAll("<:fileName:>", NeuroImageUtils.getTruncFileName(derivedFile));
            }
            catch (IOException e) {
                MraldOutFile.logToFile((Throwable)e);
                this.error("Error extracting the DB file name ==> " + e.getMessage());
            }
            queries.add(insertImage);
            this.updateImageLabel(sourceFile, derivedFile, queries);
        }
    }

    private void updateImageLabel(File sourceImage, File derivedImage, ArrayList<String> queries) {
        String lookupLabel = "SELECT label FROM images_label WHERE filename='<:srcImage:>'";
        String updateLabel = "UPDATE images_label SET owner='" + MiscUtils.checkApostrophe((String)this.user.getEmail()) + "', label = (" + lookupLabel + ") WHERE images_label.fileName = '<:tgtImage:>'";
        try {
            updateLabel = updateLabel.replaceAll("<:tgtImage:>", NeuroImageUtils.getTruncFileName(derivedImage));
            updateLabel = updateLabel.replaceAll("<:srcImage:>", NeuroImageUtils.getTruncFileName(sourceImage));
            queries.add(updateLabel);
        }
        catch (IOException e) {
            MraldOutFile.logToFile((Throwable)e);
            this.error("Error extracting the DB file name ==> " + e.getMessage());
        }
    }

    private void executeQueries(ArrayList<String> queries) throws SQLException {
        boolean failure = false;
        for (String query : queries) {
            try {
                log.fine("Attempting query: " + query);
                this.db.executeUpdate(query);
            }
            catch (SQLException e) {
                MraldOutFile.logToFile((Throwable)e);
                this.out.println(e.getMessage());
                failure = true;
            }
        }
        if (failure) {
            throw new SQLException("At least one query failed; rollback is needed.");
        }
    }

    private void executeCommand(String[] cmd, File workingDir, PrintWriter redirect) throws MraldException {
        try {
            String line;
            log.fine("Executing: " + Arrays.toString(cmd));
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("AIRAlgorithm: execute Command : Executing: " + Arrays.toString(cmd)));
            Process process = Runtime.getRuntime().exec(cmd, null, workingDir);
            if (redirect != null) {
                BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = output.readLine()) != null) {
                    redirect.println(line);
                }
                redirect.flush();
                redirect.close();
            }
            BufferedReader errors = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = errors.readLine()) != null) {
                this.out.println(line);
            }
            process.waitFor();
            errors.close();
        }
        catch (Exception e) {
            throw new MraldException((Throwable)e);
        }
    }

    public ArrayList<Object> getDeltas(File sourceImage) {
        ArrayList<Object> result = new ArrayList<Object>();
        String[] types = new String[]{"Rotation Deltas (Degrees)", "Euclidean Distance (mm)"};
        result.add(types);
        for (File orientation : this.getOrientationFilesFor(sourceImage)) {
            Matrix matrix = AIRAlgorithm.getMatrix(MiscUtils.replaceSuffix((String)orientation.toString(), (String)".txt"));
            double[] deltaArray = AIRAlgorithm.getImageDelta(matrix);
            GraphPoint[] points = AIRAlgorithm.groupIntoGraphs(deltaArray);
            result.add(points);
        }
        return result;
    }

    private static Matrix getMatrix(String filename) {
        Matrix result = new Matrix(5, 5);
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while (in.readLine().indexOf("R=") < 0) {
            }
            for (int row = 1; row <= 4; ++row) {
                String line = in.readLine();
                if (line.startsWith("[")) {
                    line = line.substring(1);
                }
                if (line.endsWith("]")) {
                    line = line.substring(0, line.length() - 1);
                }
                String[] values = line.split(" ");
                for (int col = 1; col <= 4; ++col) {
                    double value = Double.parseDouble(values[col - 1]);
                    result.set(row, col, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    private static double[] getImageDelta(Matrix matrix) {
        double distsqr;
        double[] result = new double[4];
        double omega = Math.asin(matrix.get(2, 3));
        double theta = Math.asin(matrix.get(1, 3)) / Math.cos(omega);
        double phi = Math.acos(matrix.get(2, 2)) / Math.cos(omega);
        double toDegrees = 57.29577951308232;
        result[0] = omega * toDegrees;
        result[1] = theta * toDegrees;
        result[2] = phi * toDegrees;
        double x = matrix.get(1, 4);
        double y = matrix.get(2, 4);
        double z = matrix.get(3, 4);
        result[3] = distsqr = Math.sqrt(x * x + y * y + z * z);
        return result;
    }

    private static GraphPoint[] groupIntoGraphs(double[] deltas) {
        GraphPoint[] result = new GraphPoint[2];
        String[] firstDeltaTypes = new String[]{"Rotation About Y Axis", "Rotation About X Axis", "Rotation About Z Axis"};
        String[] secondDeltaTypes = new String[]{"Euclidean Distance (mm)"};
        double[] firstPoint = new double[]{deltas[0], deltas[1], deltas[2]};
        double[] secondPoint = new double[]{deltas[3]};
        result[0] = new GraphPoint(firstPoint, firstDeltaTypes);
        result[1] = new GraphPoint(secondPoint, secondDeltaTypes);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws MraldException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        System.out.println(EndianCorrectedChannel.SYSTEM_ENDIANNESS);
        Config.init((String)"C:\\Program Files\\Apache Software Foundation\\Tomcat 5.5\\webapps\\neuro\\WEB-INF\\props\\");
        Config.setLatticeFactory((LatticeFactory)new NeuroLatticeFactory());
        Callback exit = new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(AIRAlgorithm a) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }
        };
        String volumeId = "MonicasSample1";
        User user = new User("pmork@mitre.org");
        user.setGroup("JHU");
        AIRAlgorithm local = new AIRAlgorithm(user, volumeId, 1, 35, 55, null);
        local.execute("", new PrintWriter(System.out), exit);
        Callback callback = exit;
        synchronized (callback) {
            exit.wait();
        }
    }

    static {
        log.setLevel(Level.FINER);
    }

    public static interface Callback {
        public void run(AIRAlgorithm var1);
    }
}

