/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.custom;

import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.plugin.JpegWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.mitre.lattice.neuro.custom.AIRAlgorithm;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.Mailer;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;
import org.mitre.neuro.util.GraphMetrics;

public class AIRRegistration
extends AbstractStep {
    public static final String KEY = AIRRegistration.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    protected AIRAlgorithm delegate;

    public void execute(MsgObject msg) throws WorkflowStepException {
        try {
            MraldConnection conn = new MraldConnection("main");
            User user = (User)msg.getReq().getSession().getAttribute(Config.getProperty((String)"cookietag"));
            String volumeId = msg.getValue("VolumeId")[0];
            int templateOrientation = Integer.parseInt(msg.getValue("templateNumber")[0]);
            int numOrientations = this.getOrientationCount(conn, volumeId);
            int threshold = Integer.parseInt(msg.getValue("threshold")[0]);
            conn = new MraldConnection("main");
            this.delegate = new AIRAlgorithm(user, volumeId, templateOrientation, numOrientations, threshold, conn);
            String action = msg.getValue("action")[0];
            if (action.equals("Print")) {
                this.delegate.execute(action, msg.getRes().getWriter(), null);
            } else {
                StringWriter errors = new StringWriter();
                PrintWriter output = new PrintWriter(errors);
                SendResponse code = new SendResponse(errors);
                this.delegate.execute(action, output, code);
                AIRRegistration.generateResponse(msg.getRes(), 202, "register", volumeId, "You will receive an email once registration is complete.");
            }
        }
        catch (Exception e) {
            throw new WorkflowStepException((Throwable)e);
        }
    }

    protected void generateVerificationImages() {
        if (this.delegate.isRegistering()) {
            this.generateMovieImages();
            this.generateCharts();
        }
        log.log(Level.SEVERE, "GenVI5");
    }

    private void generateMovieImages() {
        for (File sourceFile : this.delegate.getSourceFiles()) {
            for (File orientation : this.delegate.getOrientationFilesFor(sourceFile)) {
                this.createSampleSlice(orientation);
            }
        }
    }

    private void generateCharts() {
        for (File sourceFile : this.delegate.getSourceFiles()) {
            this.createChart(sourceFile);
        }
    }

    public static void generateResponse(HttpServletResponse response, int status, String request, String volumeId, String msg) throws IOException {
        response.setStatus(status);
        PrintWriter writer = response.getWriter();
        writer.append("<head><title>Request received</title></head>");
        writer.append("<body>Your request to ").append(request).append(" volume ").append(volumeId).append(" was received.<br/>");
        writer.append(msg).append("</body>");
    }

    private int getOrientationCount(MraldConnection db, String volumeId) throws SQLException {
        String SQL = "Select count(*) from volume natural join dti_scan_event natural join gradient_bvalue natural join gradient_orientation where volume_id='<:volume_id:>';";
        ResultSet rs = db.executeQuery(SQL = SQL.replaceAll("<:volume_id:>", volumeId));
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    private void createSampleSlice(File orientation) {
        try {
            FileInfo fi = new FileInfo();
            fi.fileName = orientation.getName();
            fi.directory = orientation.getParent();
            fi.fileFormat = 1;
            fi.fileType = 2;
            fi.width = Integer.parseInt(this.delegate.getParamters().get("xdimension"));
            fi.height = Integer.parseInt(this.delegate.getParamters().get("ydimension"));
            fi.nImages = Integer.parseInt(this.delegate.getParamters().get("zdimension"));
            fi.offset = 0;
            fi.gapBetweenImages = 0;
            fi.intelByteOrder = false;
            fi.whiteIsZero = false;
            ImagePlus result = new FileOpener(fi).open(false);
            result.setSlice(fi.nImages / 2);
            String destination = MiscUtils.replaceSuffix((String)orientation.toString(), (String)".jpg");
            new JpegWrapper().save(result, destination);
        }
        catch (Exception e) {
            MraldOutFile.logToFile((Throwable)e);
        }
    }

    protected void createChart(File sourceImage) {
        String title = sourceImage.getName();
        String type = "MultiPoint";
        String[] labels = new String[this.delegate.getMaxOrientations()];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = "Orientation " + i;
        }
        ArrayList<Object> deltas = this.delegate.getDeltas(sourceImage);
        Object data = GraphMetrics.createDataset(type, deltas, labels, 1);
        JFreeChart result = GraphMetrics.createChart(title, data, type, labels);
        String destination = MiscUtils.appendSuffix((String)(this.delegate.getTempDir() + "/" + this.delegate.getDerivedId() + "/" + sourceImage.getName()), (String)".jpg");
        try {
            ChartUtilities.saveChartAsJPEG((File)new File(destination), (JFreeChart)result, (int)800, (int)600);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class SendResponse
    implements AIRAlgorithm.Callback {
        public final StringWriter errors;

        public SendResponse(StringWriter errors) {
            this.errors = errors;
        }

        public void run(AIRAlgorithm air) {
            String to = AIRRegistration.this.delegate.getUser().getEmail();
            String from = Config.getProperty((String)"MAILTO");
            String host = Config.getProperty((String)"SMTPHOST");
            try {
                if (AIRRegistration.this.delegate.getSuccessStatus()) {
                    AIRRegistration.this.generateVerificationImages();
                    this.reportSuccess(to, from, host);
                } else {
                    this.reportFailure(to, from, host);
                }
            }
            catch (Exception e) {
                AIRRegistration.this.delegate.error("Unable to generate verification page==>" + e.getMessage());
                this.reportFailure(to, from, host);
            }
        }

        public void reportSuccess(String to, String from, String host) {
            String newId = AIRRegistration.this.delegate.getDerivedId();
            int slices = AIRRegistration.this.delegate.getMaxOrientations();
            String verifyURL = Config.getProperty((String)"BaseUrl") + "/AIRVerification.jsp?" + "volume=" + newId + "&slices=" + slices;
            String message = "Volume " + AIRRegistration.this.delegate.getSourceId() + " has been registered as " + newId + "." + "  Please visit " + verifyURL + " at your convenience to verify the registration.";
            String subject = "AIR registration complete; please verify.";
            try {
                Mailer.send((String)to, (String)from, (String)host, (String)message, (String)subject);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Email concerning " + verifyURL + " failed.", e);
            }
        }

        public void reportFailure(String to, String from, String host) {
            String err = this.errors.toString();
            String message = "Unable to register " + AIRRegistration.this.delegate.getSourceId() + " due to errors: " + err;
            String subject = "AIR registration error.";
            log.log(Level.SEVERE, message);
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("AIRRegistration: Report Failure: Message: " + message));
            try {
                Mailer.send((String)to, (String)from, (String)host, (String)message, (String)subject);
            }
            catch (Exception e) {
                MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("AIRRegistration: Email concerning " + err + " failed."));
                log.throwing(KEY, "Email concerning " + err + " failed.", e);
            }
        }
    }
}

