/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.custom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.Properties;
import javax.swing.BorderFactory;
import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellViewRenderer;
import org.mitre.lattice.graph.EllipseView;
import org.mitre.lattice.neuro.custom.NeuroEllipseCell;
import org.mitre.mrald.util.Config;

public class NeuroEllipseView
extends EllipseView {
    public NeuroEllipseRenderer renderer = new NeuroEllipseRenderer();
    public String type = null;

    public NeuroEllipseView(Object cell, JGraph graph, CellMapper cm) {
        super(cell, graph, cm);
        this.type = ((NeuroEllipseCell)((Object)cell)).getType();
    }

    public CellViewRenderer getRenderer() {
        return this.renderer;
    }

    public class NeuroEllipseRenderer
    extends EllipseView.EllipseRenderer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            int b = this.borderWidth;
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            Properties props = Config.getLatticeFactory().getProperties();
            String temp = props.getProperty(NeuroEllipseView.this.type + "ColorEnd");
            if (temp == null) {
                temp = "rgb(255,255,255)";
            }
            temp = temp.substring(temp.indexOf("(") + 1, temp.length() - 1);
            String[] nodeEndInts = temp.split(",");
            temp = props.getProperty(NeuroEllipseView.this.type + "ColorStart");
            if (temp == null) {
                temp = "rgb(255,255,255)";
            }
            temp = temp.substring(temp.indexOf("(") + 1, temp.length() - 1);
            String[] nodeStartInts = temp.split(",");
            Color nodeEndCol = new Color(Integer.parseInt(nodeEndInts[0].trim()), Integer.parseInt(nodeEndInts[1].trim()), Integer.parseInt(nodeEndInts[2].trim()));
            Color nodeStartCol = new Color(Integer.parseInt(nodeStartInts[0].trim()), Integer.parseInt(nodeStartInts[1].trim()), Integer.parseInt(nodeStartInts[2].trim()));
            GradientPaint nodeCol = new GradientPaint(b - 1, b - 1, nodeStartCol, d.width - b, d.height - b, nodeEndCol);
            boolean tmp = this.selected;
            if (super.isOpaque()) {
                g2.setPaint(nodeCol);
                g2.fill(new Ellipse2D.Double(b - 1, b - 1, d.width - b, d.height - b));
            }
            try {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
                this.setOpaque(false);
                this.selected = false;
                super.paint(g);
            }
            finally {
                this.selected = tmp;
            }
            if (this.bordercolor != null) {
                g.setColor(this.bordercolor);
                g2.setStroke(new BasicStroke(b));
                g.drawOval(b - 1, b - 1, d.width - b, d.height - b);
            }
            if (this.selected) {
                g2.setStroke(new BasicStroke(b));
                g.setColor(this.graph.getHighlightColor());
            }
        }
    }
}

