/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.custom;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.mitre.lattice.util.ImageUtils;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;

public class NeuroImageUtils
extends ImageUtils {
    public static final String KEY = NeuroImageUtils.class.getName();
    private static final String DATASOURCE = "main";
    public static final Logger log = Logger.getLogger(KEY);

    protected int doDbUpdate(String query) {
        MraldConnection mconn = null;
        int numAffected = 0;
        try {
            mconn = new MraldConnection(DATASOURCE);
            numAffected = mconn.executeUpdate(query);
            StringBuffer logInfo = new StringBuffer(query);
            long startTime = MiscUtils.logQuery((String)"NeuroImageUtils", (String)DATASOURCE, (String)query, (StringBuffer)logInfo);
            MiscUtils.logQueryRun((long)startTime, (StringBuffer)logInfo);
        }
        catch (Exception e) {
            try {
                mconn.close();
            }
            catch (SQLException me) {
                // empty catch block
            }
            log.throwing(KEY, "associateMetaData", e);
            throw new MraldError((Throwable)e);
        }
        finally {
            try {
                mconn.close();
            }
            catch (SQLException me) {}
        }
        return numAffected;
    }

    protected void dbUpdateLabel(User user, String imageFileName) {
        String truncFileName = NeuroImageUtils.getTruncFileName(imageFileName);
        String label = user.getGroup();
        String updateStart = "Update images_label set LABEL = '" + MiscUtils.checkApostrophe((String)label) + "', OWNER='" + user.getEmail() + "' WHERE filename  = '" + truncFileName + "' ";
        this.doDbUpdate(updateStart);
    }

    public static String getTruncFileName(String imageFileName) {
        File file = new File(imageFileName);
        try {
            return NeuroImageUtils.getTruncFileName(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTruncFileName(File file) throws IOException {
        String fileName = "";
        try {
            File imageDir = new File(Config.getProperty((String)"imagesDir"));
            fileName = file.getCanonicalPath().substring(imageDir.getCanonicalPath().length());
            while (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') {
                fileName = fileName.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileName;
    }

    protected void setImageFileName(HttpServletResponse response, int userId) {
        response.setContentType("text/plain");
        response.setHeader("Content-Disposition", "inline;");
    }

    protected void associateMetaData(String userid, String imageFileName, String volumeId) {
        String truncFileName = NeuroImageUtils.getTruncFileName(imageFileName);
        volumeId = MiscUtils.checkApostrophe((String)volumeId);
        String query = "Insert into images values ('<:volume_id:>', '<:fileName:>')";
        query = query.replaceAll("<:fileName:>", truncFileName);
        query = query.replaceAll("<:volume_id:>", volumeId);
        this.doDbUpdate(query);
    }

    public boolean storeImage(HttpServletRequest req, User user) throws JspException, FileUploadException, IOException, Exception {
        Set filenameKeys;
        boolean isMultipart = FileUpload.isMultipartContent((HttpServletRequest)req);
        if (!isMultipart) {
            throw new JspException("The form that submitted this request was not created correctly.  Please contact your administrator");
        }
        DiskFileUpload upload = new DiskFileUpload();
        List items = upload.parseRequest(req);
        Iterator iter = items.iterator();
        HashMap<String, FileItem> images = new HashMap<String, FileItem>();
        HashMap<String, FileItem> filenames = new HashMap<String, FileItem>();
        FileItem volume = null;
        String fileType = null;
        while (iter.hasNext()) {
            FileItem item = (FileItem)iter.next();
            String itemName = item.getFieldName();
            if (itemName.startsWith("image")) {
                images.put(itemName.substring(5), item);
                continue;
            }
            if (itemName.startsWith("fileName")) {
                filenames.put(itemName.substring(8), item);
                continue;
            }
            if (itemName.equals("volumeId")) {
                volume = item;
                continue;
            }
            if (!itemName.startsWith("fileType")) continue;
            fileType = item.getString();
        }
        if (images.size() < 1) {
            throw new JspException("No image file was specified for upload.");
        }
        Set imageKeys = images.keySet();
        if (!((Object)imageKeys).equals(filenameKeys = filenames.keySet())) {
            throw new JspException("There should have been a matching set of images to filenames");
        }
        String volumeId = volume.getString();
        this.saveImages(imageKeys, filenames, images, user, volumeId);
        return true;
    }

    private void saveImages(Set imageKeys, HashMap filenames, HashMap images, User user, String volumeId) throws MraldException {
        try {
            boolean created;
            log.info(" Saving Non MRI Images");
            File volumeDir = NeuroImageUtils.getVolumeDir(volumeId);
            if (!volumeDir.exists() && !(created = volumeDir.mkdirs())) {
                throw new IOException("Couldn't create the directory \"" + volumeDir + "\".  Check your file system, though, as some intermediate directories may have been created");
            }
            Iterator iter = imageKeys.iterator();
            File fileFinalLocation = null;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                FileItem fileImagesItem = (FileItem)images.get(key);
                String fileName = ((FileItem)filenames.get(key)).getString();
                fileFinalLocation = new File(volumeDir, fileName);
                fileImagesItem.write(fileFinalLocation);
                this.associateMetaData(user.getEmail(), fileFinalLocation.getPath(), volumeId);
                this.dbUpdateLabel(user, fileFinalLocation.getPath());
            }
            this.setEndianness(fileFinalLocation, volumeId);
            log.finer("Successfully saved Non MRI Images");
        }
        catch (Exception e) {
            throw new MraldException((Throwable)e);
        }
    }

    public static File getVolumeDir(String volumeId) {
        String projectId;
        String piEmail;
        String subjectId;
        block14: {
            boolean volumeFound = false;
            subjectId = null;
            String checkQuery = "select scan_event.grant_no from  scan_event, volume where volume.volume_id = '" + volumeId + "'  and volume.scan_id = scan_event.scan_id";
            String query = "select p.pi_email, p.grant_no, subject_id from project p, scan_event, volume where volume.volume_id = '" + volumeId + "' and p.grant_no = scan_event.grant_no and volume.scan_id = scan_event.scan_id";
            log.info(query);
            MraldConnection conn = null;
            try {
                conn = new MraldConnection(DATASOURCE);
                ResultSet rs = conn.executeQuery(checkQuery);
                if (rs.next()) {
                    volumeFound = true;
                }
                if ((rs = conn.executeQuery(query)).next()) {
                    piEmail = rs.getString(1);
                    projectId = rs.getString(2);
                    subjectId = rs.getString(3);
                    break block14;
                }
                if (volumeFound) {
                    throw new MraldError("Project number for Volume  " + volumeId + " was not specified.");
                }
                throw new MraldError("Volume " + volumeId + " was not found.");
            }
            catch (Exception e) {
                try {
                    conn.close();
                }
                catch (SQLException me) {
                    // empty catch block
                }
                log.throwing(KEY, "populateProjectInfo", e);
                throw new MraldError((Throwable)e);
            }
            finally {
                log.finer("in finally");
                try {
                    conn.close();
                }
                catch (SQLException me) {}
            }
        }
        return new File(Config.getProperty((String)"imagesDir") + piEmail + "/" + projectId + "/" + subjectId);
    }

    public static File getVolumeTempDir(String volumeId) throws MraldException {
        try {
            return new File(Config.getProperty((String)"imagesDir"), "temp").getCanonicalFile();
        }
        catch (IOException e) {
            MraldOutFile.logToFile((Throwable)e);
            throw new MraldException((Throwable)e);
        }
    }

    protected void setEndianness(File file, String volumeId) {
        MraldConnection mconn = null;
        String query = "select xdimension, ydimension, zdimension from volume where volume_id = '" + volumeId + "'";
        try {
            mconn = new MraldConnection(DATASOURCE);
            StringBuffer logInfo = new StringBuffer(query);
            long startTime = MiscUtils.logQuery((String)"NeuroImageUtils", (String)DATASOURCE, (String)query, (StringBuffer)logInfo);
            ResultSet rs = mconn.executeQuery(query);
            MiscUtils.logQueryRun((long)startTime, (StringBuffer)logInfo);
            try {
                rs.next();
            }
            catch (SQLException e) {
                throw new MraldError("Volume " + volumeId + " was not found.");
            }
            int x = rs.getInt(1);
            int y = rs.getInt(2);
            int z = rs.getInt(3);
            rs.close();
            String endianness = NeuroImageUtils.calculateEndianness(file, x, y, z);
            query = "update volume set endianness='" + endianness + "' where volume_id = '" + volumeId + "'";
            logInfo = new StringBuffer(query);
            startTime = MiscUtils.logQuery((String)"NeuroImageUtils", (String)DATASOURCE, (String)query, (StringBuffer)logInfo);
            int numAffected = mconn.executeUpdate(query);
            MiscUtils.logQueryRun((long)startTime, (StringBuffer)logInfo);
            if (numAffected == 0) {
                throw new MraldError("Endianness not set for volume " + volumeId);
            }
        }
        catch (Exception e) {
            try {
                mconn.close();
            }
            catch (SQLException me) {
                // empty catch block
            }
            log.throwing(KEY, "associateMetaData", e);
            throw new MraldError((Throwable)e);
        }
        finally {
            try {
                mconn.close();
            }
            catch (SQLException me) {}
        }
    }

    public static String calculateEndianness(File file, int xPixels, int yPixels, int slices) {
        try {
            FileInputStream in = new FileInputStream(file);
            DataInputStream din = new DataInputStream(in);
            int skip = xPixels * yPixels * 2 * (slices / 2);
            din.skipBytes(skip);
            short intensity = 0;
            short min = 0;
            short max = 0;
            for (int i = 0; i < xPixels * yPixels; ++i) {
                intensity = din.readShort();
                if (intensity > max) {
                    max = intensity;
                    continue;
                }
                if (intensity >= min) continue;
                min = intensity;
            }
            if (min < 0 || max > 4096) {
                return "little";
            }
            return "big";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    static {
        log.setLevel(Level.FINER);
    }
}

