/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.custom;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.mitre.lattice.lattice.InvalidLatticeStructureException;
import org.mitre.lattice.lattice.LatticeFunctionsImpl;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.lattice.lattice.NodeNotFoundException;
import org.mitre.lattice.lattice.NullLatticeNodeException;
import org.mitre.lattice.neuro.custom.NeuroNode;
import org.mitre.lattice.util.Constants;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldOutFile;

public class NeuroLatticeFunctionsImpl
extends LatticeFunctionsImpl {
    public static final String KEY = NeuroLatticeFunctionsImpl.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    private static int labLevel = 0;

    public NeuroLatticeFunctionsImpl() {
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)"NeuroLatticeFunctionsImpl : Start ");
    }

    public void setLabLevel(LatticeNode rootNode) {
        this.resetLabLevel();
        this.findLabLevel(rootNode, 0);
    }

    public void resetLabLevel() {
        labLevel = 0;
    }

    public void findLabLevel(LatticeNode node, int level) {
        ArrayList parents = node.getParents();
        ++level;
        for (int i = 0; i < node.countParentNodes(); ++i) {
            NeuroNode parentNode = (NeuroNode)((Object)parents.get(i));
            if (parentNode.getType().equals("Lab")) {
                if (level <= labLevel) continue;
                labLevel = level;
                continue;
            }
            this.findLabLevel(parentNode, level);
        }
    }

    public ArrayList getFlatLattice(Object root) {
        this.setLabLevel((LatticeNode)root);
        return super.getFlatLattice(root);
    }

    public ArrayList flattenLattice(ArrayList flatLattice, LatticeNode rootNode, int level) {
        int i;
        ArrayList<Integer> newLevels = new ArrayList<Integer>();
        if (rootNode == null) {
            System.out.print("In LF: flattenLattice(). Root node is null : ");
            return flatLattice;
        }
        ArrayList parents = rootNode.getParents();
        int geneIndex = flatLattice.size() - 1;
        this.checkMaxLevel(++level);
        for (i = 0; i < rootNode.countParentNodes(); ++i) {
            if (!flatLattice.contains(parents.get(i))) {
                flatLattice.add(parents.get(i));
                geneIndex = flatLattice.size() - 1;
                this.getMapGeneToNode().put(new Integer(geneIndex), parents.get(i));
                this.getMapNodeToGene().put(parents.get(i), new Integer(geneIndex));
            }
            newLevels.add(new Integer(this.changeNodesPerLevel((LatticeNode)parents.get(i), new Integer(level))));
        }
        for (i = 0; i < rootNode.countParentNodes(); ++i) {
            this.flattenLattice(flatLattice, (LatticeNode)parents.get(i), (Integer)newLevels.get(i));
        }
        if (level == 1) {
            NO_OF_NODES = flatLattice.size();
        }
        return flatLattice;
    }

    public int initialize(Object root) {
        Constants.init();
        screenWidth = Integer.parseInt(Config.getLatticeFactory().getProperties().getProperty("ScreenWidth"));
        screenHeight = Integer.parseInt(Config.getLatticeFactory().getProperties().getProperty("ScreenHeight")) - 100;
        if (!this.getIsSet()) {
            this.setLabLevel((LatticeNode)root);
        }
        return super.initialize(root);
    }

    public int changeNodesPerLevel(LatticeNode node, Integer newLevel) {
        int intLevel = newLevel;
        if (((NeuroNode)node).getType().equals("Lab")) {
            if (labLevel > intLevel) {
                intLevel = labLevel;
            } else {
                labLevel = intLevel;
            }
        }
        return super.changeNodesPerLevel(node, new Integer(intLevel));
    }

    public int getY(Integer nodeInteger) {
        int posY = super.getY(nodeInteger);
        return posY - this.getBoxHeight() / 2;
    }

    public Object getSubTree(LatticeTree childTree, LatticeNode rootNode) throws NullLatticeNodeException, InvalidLatticeStructureException {
        log.info("In Start of getSubTree");
        LatticeNode childRoot = childTree.getRootNode();
        ArrayList labNodes = new ArrayList();
        labNodes = this.addLabNodes(rootNode, labNodes);
        log.info("No of Lab Nodes: " + labNodes.size());
        for (int i = 0; i < labNodes.size(); ++i) {
            LatticeNode currNode = Config.getLatticeFactory().copyNode((LatticeNode)labNodes.get(i));
            try {
                childTree.searchTree(currNode);
                continue;
            }
            catch (NodeNotFoundException e) {
                log.info("Adding currNode " + currNode.getName());
                childRoot.addParent(currNode);
                currNode.addChild(childRoot);
            }
        }
        return childRoot;
    }

    public ArrayList getNodesOnLevel(int level) {
        if (level < 100) {
            return super.getNodesOnLevel(level);
        }
        ArrayList labNodes = this.getNodesOnLevel(labLevel);
        log.info(level + "  Nodes on same level " + labLevel + " : " + labNodes.size());
        return labNodes;
    }

    private ArrayList addLabNodes(LatticeNode rootNode, ArrayList labNodes) throws NullLatticeNodeException, InvalidLatticeStructureException {
        ArrayList parents = rootNode.getParents();
        for (int i = 0; i < parents.size(); ++i) {
            NeuroNode currNode = (NeuroNode)((Object)parents.get(i));
            if (currNode.getType().equals("Lab") && !labNodes.contains((Object)currNode)) {
                labNodes.add(currNode);
            }
            labNodes = this.addLabNodes(currNode, labNodes);
        }
        return labNodes;
    }
}

