/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.custom;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.mitre.lattice.lattice.LatticeNode;

public class NeuroNode
extends LatticeNode {
    public static final String KEY = NeuroNode.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    private String type = null;

    public NeuroNode() {
        this.type = "Public";
    }

    public NeuroNode(String nodeName) {
        super(nodeName);
        this.type = "Public";
    }

    public NeuroNode(String nodeName, ArrayList children, ArrayList parents) {
        super(nodeName, children, parents);
        this.type = "Public";
    }

    public NeuroNode(LatticeNode newNode) {
        super(newNode);
        this.type = ((NeuroNode)newNode).getType();
    }

    public NeuroNode(LatticeNode newNode, boolean isCopy) {
        super(newNode.getName());
        this.type = ((NeuroNode)newNode).getType();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean checkIsActionValid(boolean isParent, LatticeNode newNode) {
        if (isParent) {
            NeuroNode parent = (NeuroNode)newNode;
            if (this.type.equals("Priv") ? !parent.getType().equals("Priv") : (this.type.equals("Lab") ? !parent.getType().equals("Priv") : (this.type.equals("Colab") ? parent.getType().equals("Org") || parent.getType().equals("Priv") || parent.getType().equals("Public") : this.type.equals("Org") && (parent.getType().equals("Priv") || parent.getType().equals("Public"))))) {
                return false;
            }
        } else {
            NeuroNode child = (NeuroNode)newNode;
            if (this.type.equals("Priv") ? !child.getType().equals("Lab") && !child.getType().equals("Public") : (this.type.equals("Lab") ? child.getType().equals("Priv") || child.getType().equals("Lab") : (this.type.equals("Colab") ? child.getType().equals("Lab") || child.getType().equals("Priv") : this.type.equals("Org") && !child.getType().equals("Public")))) {
                return false;
            }
        }
        return true;
    }
}

