/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.custom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mitre.lattice.custom.NeuroLatticeFactory;
import org.mitre.lattice.neuro.custom.NeuroImageUtils;
import org.mitre.lattice.neuro.custom.Orientation;
import org.mitre.lattice.query.LatticeQuery;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.LatticeFactory;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;
import org.mitre.neuro.util.EndianCorrectedChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TensorCalculation
implements Runnable {
    public static final String KEY = TensorCalculation.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    private boolean success = true;
    private File imageDir;
    private PrintWriter out;
    private String userEmail;
    private User user;
    private ArrayList<HashMap> parameters = new ArrayList();
    private HashMap<String, String> outFileList = new HashMap();
    ArrayList<Orientation> orientations = new ArrayList();
    HashMap<Integer, Integer> bValues = new HashMap();
    private File appDir;
    private String dataDir;
    private static final String DATASOURCE = "main";
    private String sourceVolumeId;
    private String derivedVolumeId;
    private MraldConnection db;
    private Callback callback = null;

    public TensorCalculation(User user, String volumeId, MraldConnection connection) throws ClassNotFoundException, SQLException, NullPointerException {
        this.user = user;
        this.sourceVolumeId = volumeId;
        this.userEmail = TensorCalculation.extractUserEmailSansDomain(user);
        this.db = connection == null ? new MraldConnection(DATASOURCE) : connection;
        this.init();
    }

    private void init() {
        this.appDir = new File(Config.getProperty((String)"neuroLib"));
        if (this.imageDir == null) {
            this.imageDir = new File(Config.getProperty((String)"imagesDir"));
        }
        this.addOutFileList("OutFileTensor", this.sourceVolumeId + "_Tensor.dat");
        this.addOutFileList("OutFileRefB0", "RefB0.dat");
        this.addOutFileList("OutFileEigenVal0", "EgVal0.dat");
        this.addOutFileList("OutFileEigenVal1", "EgVal1.dat");
        this.addOutFileList("OutFileEigenVal2", "EgVal2.dat");
        this.addOutFileList("OutFileEigenVec0", "EgVec0.dat");
        this.addOutFileList("OutFileEigenVec1", "EgVec1.dat");
        this.addOutFileList("OutFileEigenVec2", "EgVec2.dat");
        this.addOutFileList("OutFileFA", "FaMap.dat");
        this.addOutFileList("OutFileRA", "RaMap.dat");
        this.addOutFileList("OutFileVR", "VrMap.dat");
        this.addOutFileList("OutFileColorMap0", "ColorMap0.dat");
        this.addOutFileList("OutFileColorMap1", "ColorMap1.dat");
        this.addOutFileList("OutFileColorMap2", "ColorMap2.dat");
    }

    public String getSourceId() {
        return this.sourceVolumeId;
    }

    public String getDerivedId() {
        return this.derivedVolumeId;
    }

    public File getAppDir() {
        return this.appDir;
    }

    public boolean getSuccessStatus() {
        return this.success;
    }

    public ArrayList<HashMap> getParamters() {
        return this.parameters;
    }

    public void addOutFileList(String outFileListKey, String outFileListValue) {
        this.outFileList.put(outFileListKey, outFileListValue);
    }

    public void setOutFileList(HashMap<String, String> outFileList) {
        this.outFileList = outFileList;
    }

    public User getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws MraldException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        Config.init((String)"file:/devel/gail/digilib/tomcat/webapps/ROOT/WEB-INF/props");
        Config.setLatticeFactory((LatticeFactory)new NeuroLatticeFactory());
        Callback exit = new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(TensorCalculation t) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }
        };
        String volumeId = "MITRE_001_1";
        User user = new User("admin@mitre.org");
        user.setGroup("Public");
        TensorCalculation local = new TensorCalculation(user, volumeId, null);
        local.execute("", new PrintWriter(System.out), exit);
        Callback callback = exit;
        synchronized (callback) {
            exit.wait();
        }
    }

    public void execute(String action, PrintWriter out, Callback code) throws WorkflowStepException {
        this.out = out;
        this.callback = code;
        try {
            this.calculateTensor();
        }
        catch (Exception e) {
            this.close();
            throw new WorkflowStepException((Throwable)e);
        }
    }

    private void calculateTensor() throws MraldException {
        new Thread(this).start();
    }

    private void loadParams() throws MraldException {
        try {
            String query = "select images.filename, gradient_bvalue.bvalue, scan_event.scan_id, xdimension, ydimension, zdimension, orientation_no,  x, y, z,  volume.modality, volume.state, volume.file_format, volume.numerical_format, volume.endianness, xfov, yfov, zfov, xstep, ystep, zstep,  xstart, ystart, zstart, xorientation, yorientation,zorientation, xresolution, yresolution, zresolution, slice_thickness  from volume, gradient, gradient_orientation, images, dti_scan_event, scan_event  where volume.volume_id = images.volume_id and  scan_event.scan_id = dti_scan_event.scan_id and  scan_event.scan_id = volume.scan_id and  gradient.gradient_name = dti_scan_event.gradient_name and  gradient.gradient_name = gradient_bvalue.gradient_name and  gradient_bvalue.gradient_name = gradient_orientation.gradient_name and  gradient_bvalue.bvalue = gradient_orientation.bvalue and  gradient.gradient_name = gradient_bvalue.gradient_name  and volume.volume_id= '<:VolumeId:>'  order by images.filename, orientation_no";
            query = query.replaceAll("<:VolumeId:>", this.sourceVolumeId);
            query = LatticeQuery.adaptQuery((String)query, (String)this.user.getGroup());
            log.info(query);
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Tensor Calculation :About to execute query " + query));
            ResultSet rs = this.db.executeQuery(query);
            boolean count = false;
            String imageDir = Config.getProperty((String)"imagesDir");
            String firstFileName = "";
            boolean first = true;
            HashMap<Integer, Integer> bValueCount = new HashMap<Integer, Integer>();
            while (rs.next()) {
                String fileName = rs.getString("filename");
                MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Tensor Calculation :Filename" + fileName));
                if (first) {
                    firstFileName = fileName;
                    first = false;
                }
                MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Tensor Calculation :First Filename" + firstFileName));
                HashMap<String, String> rowParams = new HashMap<String, String>();
                int orientationNo = rs.getInt("orientation_no") - 1;
                double x = rs.getDouble("x");
                double y = rs.getDouble("y");
                double z = rs.getDouble("z");
                int bNumber = 0;
                if (fileName.equals(firstFileName)) {
                    Orientation orientation = new Orientation();
                    int bValue = rs.getInt("bvalue");
                    if (!this.bValues.containsKey(bValue)) {
                        bNumber = this.bValues.size();
                        this.bValues.put(bValue, bNumber);
                    } else {
                        bNumber = this.bValues.get(bValue);
                    }
                    bValueCount = this.incrementBCount(bValueCount, bValue);
                    orientation.setXValue(x);
                    orientation.setYValue(y);
                    orientation.setZValue(z);
                    orientation.setBValue(bValue);
                    orientation.setBNo(bNumber);
                    orientation.setOrientationNo(orientationNo);
                    this.orientations.add(orientation);
                }
                rowParams.put("xdimension", new Integer(rs.getInt("xdimension")).toString());
                rowParams.put("ydimension", new Integer(rs.getInt("ydimension")).toString());
                rowParams.put("zdimension", new Integer(rs.getInt("zdimension")).toString());
                fileName = imageDir + "/" + rs.getString("filename");
                float thickness = rs.getFloat("slice_thickness");
                rowParams.put("slice_thickness", thickness + "");
                rowParams.put("scan_id", new Integer(rs.getInt("scan_id")).toString());
                rowParams.put("filename", fileName);
                this.dataDir = this.extractDBFileNamePath(fileName);
                rowParams.put("procSliceStart", "0");
                int noOfSlices = Integer.parseInt(rs.getString("zdimension")) - 1;
                rowParams.put("procSliceEnd", noOfSlices + "");
                rowParams.put("noiseLevel", "10");
                rowParams.put("modality", rs.getString("modality"));
                rowParams.put("file_format", rs.getString("file_format"));
                rowParams.put("numerical_format", rs.getString("numerical_format"));
                rowParams.put("endianness", rs.getString("endianness"));
                rowParams.put("xfov", rs.getString("xfov"));
                rowParams.put("yfov", rs.getString("yfov"));
                rowParams.put("zfov", rs.getString("zfov"));
                String xstep = rs.getString("xstep");
                if (xstep != null) {
                    rowParams.put("xstep", rs.getString("xstep"));
                }
                rowParams.put("ystep", rs.getString("ystep"));
                rowParams.put("zstep", rs.getString("zstep"));
                rowParams.put("xstart", rs.getString("xstart"));
                rowParams.put("ystart", rs.getString("ystart"));
                rowParams.put("zstart", rs.getString("zstart"));
                rowParams.put("xorientation", rs.getString("xorientation"));
                rowParams.put("yorientation", rs.getString("yorientation"));
                rowParams.put("zorientation", rs.getString("zorientation"));
                rowParams.put("xresolution", rs.getString("xresolution"));
                rowParams.put("yresolution", rs.getString("yresolution"));
                rowParams.put("zresolution", rs.getString("zresolution"));
                this.parameters.add(rowParams);
            }
            this.getBOrder(bValueCount);
            rs.close();
        }
        catch (SQLException sqe) {
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Tensor Calculation :LoadParams : Error " + sqe.getMessage()));
            throw new MraldException(sqe.getMessage());
        }
    }

    private HashMap<Integer, Integer> incrementBCount(HashMap<Integer, Integer> bValueCount, Integer bValue) {
        if (bValueCount.containsKey(new Integer(bValue))) {
            Integer bcount = bValueCount.get(new Integer(bValue));
            int bCountInt = bcount;
            bValueCount.put(bValue, new Integer(++bCountInt));
        } else {
            bValueCount.put(new Integer(bValue), new Integer(1));
        }
        return bValueCount;
    }

    private String[] sortParameters(HashMap<Integer, Integer> unsortedMap, String[] commands, HashMap<Integer, Integer> bValueCount) {
        ArrayList<Integer> mapKeys = new ArrayList<Integer>(unsortedMap.keySet());
        ArrayList<Integer> mapValues = new ArrayList<Integer>(unsortedMap.values());
        TreeSet<Integer> sortedSet = new TreeSet<Integer>(mapKeys);
        Object[] sortedArray = sortedSet.toArray();
        int size = sortedArray.length;
        int totalNoOfImages = 0;
        for (int i = 0; i < size; ++i) {
            Integer bValue = (Integer)sortedArray[i];
            Integer noOfBvalues = bValueCount.get(bValue);
            Integer bValueNo = unsortedMap.get(bValue);
            totalNoOfImages += noOfBvalues.intValue();
            commands[i + 7] = noOfBvalues.toString();
        }
        commands[5] = totalNoOfImages + "";
        return commands;
    }

    private HashMap<String, Orientation> getBOrder(HashMap<Integer, Integer> bValueCount) {
        HashMap<String, Orientation> reordGradients = new HashMap<String, Orientation>();
        HashMap rowParams = this.parameters.get(0);
        String fileName = (String)rowParams.get("filename");
        String imgWidth = (String)rowParams.get("xdimension");
        String imgHeight = (String)rowParams.get("ydimension");
        String noOfSlices = (String)rowParams.get("zdimension");
        String noOfBValues = bValueCount.size() + "";
        String outputFile = this.dataDir + "/" + this.sourceVolumeId + "_FindBValues.txt";
        String dtiMapSrc = this.appDir.getPath();
        int noOfParams = bValueCount.size() + 9;
        String[] commands = new String[noOfParams];
        commands[0] = dtiMapSrc + "/" + "FindB";
        commands[1] = fileName;
        commands[2] = imgWidth;
        commands[3] = imgHeight;
        commands[4] = noOfSlices;
        boolean totalNoOfImages = false;
        boolean i = false;
        commands = this.sortParameters(this.bValues, commands, bValueCount);
        commands[6] = noOfBValues;
        String swapBytes = "n";
        String endianness = (String)rowParams.get("endianness");
        swapBytes = !EndianCorrectedChannel.SYSTEM_ENDIANNESS.equals(endianness) ? "y" : "n";
        commands[noOfParams - 2] = swapBytes;
        commands[noOfParams - 1] = outputFile;
        File dtiWorkDir = new File(dtiMapSrc);
        try {
            this.executeCommand(commands, dtiWorkDir, this.out);
        }
        catch (MraldException e) {
            e.printStackTrace();
        }
        return reordGradients;
    }

    private File createDpfFile() throws MraldException {
        try {
            String lineSep = this.getLineSeparator();
            String inputImgOrder = "Gradient_By_Gradient";
            Writer fileOut = null;
            File dpfFile = null;
            String fileName = "";
            int count = 0;
            ArrayList<String> filenames = new ArrayList<String>();
            String firstFileName = "";
            for (HashMap rowParams : this.parameters) {
                rowParams = this.parameters.get(count);
                fileName = rowParams.get("filename").toString();
                MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Tensor Calculation : Create DPF  :  FileName Dir " + fileName));
                if (!filenames.contains(fileName)) {
                    filenames.add(fileName);
                }
                if (count == 0) {
                    firstFileName = rowParams.get("filename").toString();
                    String dtiMapDir = this.extractDBFileNamePath(fileName);
                    File dpfDir = new File(dtiMapDir);
                    if (!dpfDir.exists()) {
                        dpfDir.mkdir();
                    }
                    dpfFile = new File(dtiMapDir + "/" + this.sourceVolumeId + "_dpf.dpf");
                    fileOut = new FileWriter(dpfFile);
                    fileOut.write(lineSep);
                    fileOut = this.writeOutParams((FileWriter)fileOut, rowParams);
                    fileOut.write("Begin_Of_Gradient_Table" + lineSep);
                }
                if (fileName.equals(firstFileName)) continue;
            }
            ArrayList<Orientation> orderedGradients = this.reorderGradients();
            int orientCount = -1;
            for (Orientation orientation : orderedGradients) {
                ++orientCount;
                String bvalue = orientation.getBValue() + "";
                String x = orientation.getXValue() + "";
                String y = orientation.getYValue() + "";
                String z = orientation.getZValue() + "";
                String orientationNo = orientation.getOrientationNo() + "";
                fileOut.write(orientCount + ": ");
                fileOut.write(x + ", ");
                fileOut.write(y + ", ");
                fileOut.write(z + ", ");
                fileOut.write(bvalue + lineSep);
                ++count;
            }
            fileOut.write("End_Of_Gradient_Table" + lineSep);
            for (String inputFileName : filenames) {
                fileOut.write("InputImgFile: " + inputFileName + lineSep);
            }
            fileOut.write("InputImgOrder: " + inputImgOrder + lineSep);
            fileOut = this.writeOutFiles((FileWriter)fileOut);
            fileOut.write(lineSep + "End" + lineSep + lineSep);
            ((OutputStreamWriter)fileOut).flush();
            ((OutputStreamWriter)fileOut).close();
            return dpfFile;
        }
        catch (IOException e) {
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Tensor Calculation : Create DPF  :  Error " + e.getMessage()));
            e.printStackTrace();
            throw new MraldException(e.getMessage());
        }
    }

    private ArrayList<Orientation> reorderGradients() throws MraldException {
        try {
            String line;
            String outputFile = this.dataDir + "/" + this.sourceVolumeId + "_FindBValues.txt";
            ArrayList<Orientation> orderedGradients = new ArrayList<Orientation>();
            File paramFile = new File(outputFile);
            if (!paramFile.canRead()) {
                throw new MraldException("File " + outputFile + " cannot be found.");
            }
            FileInputStream inFile = new FileInputStream(paramFile);
            BufferedReader input = new BufferedReader(new InputStreamReader(inFile));
            boolean readInput = false;
            while ((line = input.readLine()) != null) {
                String[] results;
                String bValue;
                if (readInput && line.contains(" ") && (bValue = (results = line.split(" "))[1]) != null) {
                    bValue = bValue.substring(1, bValue.length());
                    int bValueNo = Integer.parseInt(bValue);
                    boolean found = false;
                    for (Orientation orientation : this.orientations) {
                        if (found || orientation.getBNo() != bValueNo || orderedGradients.contains(orientation)) continue;
                        orderedGradients.add(orientation);
                        found = true;
                    }
                }
                if (line.length() != 0) continue;
                readInput = true;
            }
            input.close();
            inFile.close();
            return orderedGradients;
        }
        catch (FileNotFoundException ie) {
            throw new MraldException(ie.getMessage());
        }
        catch (IOException ie) {
            throw new MraldException(ie.getMessage());
        }
    }

    private void runTensorCalc(String dpfFile) throws MraldException {
        String dtiMapSrc = this.appDir.getPath();
        String[] commands = new String[]{dtiMapSrc + "/" + "DtiMap", dpfFile};
        File dtiWorkDir = new File(dtiMapSrc);
        this.executeCommand(commands, dtiWorkDir, this.out);
    }

    private void executeCommand(String[] cmd, File workingDir, PrintWriter redirect) throws MraldException {
        try {
            String line;
            log.fine("Executing: " + Arrays.toString(cmd));
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Tensor Calculation: ExecuteCommand: " + Arrays.toString(cmd)));
            Process process = Runtime.getRuntime().exec(cmd, null, workingDir);
            if (redirect != null) {
                BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = output.readLine()) != null) {
                    redirect.println(line);
                }
                redirect.flush();
                redirect.close();
            }
            BufferedReader errors = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = errors.readLine()) != null) {
                this.out.println(line);
            }
            process.waitFor();
            errors.close();
        }
        catch (Exception e) {
            throw new MraldException((Throwable)e);
        }
    }

    private FileWriter writeOutFiles(FileWriter fileOut) throws IOException {
        String lineSep = this.getLineSeparator();
        fileOut.write(lineSep);
        for (String outputFile : this.outFileList.keySet()) {
            fileOut.write(outputFile + ": " + this.dataDir + "/" + this.sourceVolumeId + "_" + this.outFileList.get(outputFile) + lineSep);
        }
        return fileOut;
    }

    private FileWriter writeOutParams(FileWriter fileOut, HashMap rowParams) throws IOException {
        String xDim = rowParams.get("xdimension").toString();
        String lineSep = this.getLineSeparator();
        fileOut.write("Begin");
        fileOut.write(lineSep);
        String yDim = rowParams.get("ydimension").toString();
        String zDim = rowParams.get("zdimension").toString();
        String xfov = rowParams.get("xfov").toString();
        String yfov = rowParams.get("yfov").toString();
        String slice_thickness = rowParams.get("slice_thickness").toString();
        String procSliceStart = rowParams.get("procSliceStart").toString();
        String procSliceEnd = rowParams.get("procSliceEnd").toString();
        String noiseLevel = rowParams.get("noiseLevel").toString();
        String endianness = rowParams.get("endianness").toString();
        String swapBytes = "No";
        swapBytes = !EndianCorrectedChannel.SYSTEM_ENDIANNESS.equals(endianness) ? "Yes" : "No";
        fileOut.write("ImageWidth: " + xDim + lineSep);
        fileOut.write("ImageHeight: " + yDim + lineSep);
        fileOut.write("ImageSlices: " + zDim + lineSep);
        fileOut.write("FieldOfView(X): " + xfov + lineSep);
        fileOut.write("FieldOfView(Y): " + yfov + lineSep);
        fileOut.write("SliceThickness: " + slice_thickness + lineSep);
        fileOut.write("ProcSliceStart: " + procSliceStart + lineSep);
        fileOut.write("ProcSliceEnd: " + procSliceEnd + lineSep);
        fileOut.write("SwapBytes: " + swapBytes + lineSep);
        fileOut.write("ImgNoiseLevel: " + noiseLevel + lineSep);
        return fileOut;
    }

    private String extractDBFileName(File file) {
        return file.getPath().substring(this.imageDir.getPath().length());
    }

    private String extractDBFileNamePath(File file) {
        if (this.imageDir == null) {
            this.imageDir = new File(Config.getProperty((String)"imagesDir"));
        }
        return file.getPath().substring(this.imageDir.getPath().length(), file.getParent().length());
    }

    private String extractFileNameToSave(String fileName) {
        try {
            File file = new File(fileName);
            fileName = file.getCanonicalPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return NeuroImageUtils.getTruncFileName(fileName);
    }

    private String extractDBFileNamePath(String fileName) {
        int fileSepPos = fileName.lastIndexOf("/");
        String rtnStr = fileName.substring(0, fileSepPos);
        return rtnStr;
    }

    @Override
    public void run() {
        try {
            this.loadParams();
            File dpfFile = this.createDpfFile();
            this.runTensorCalc(dpfFile.getPath());
            if (this.success) {
                try {
                    this.saveImages();
                }
                catch (Exception e) {
                    this.error("Error saving to database==>" + e.getMessage());
                }
            }
            this.close();
        }
        catch (Exception e) {
            this.error("Error generating derived filenames==>" + e.getMessage());
        }
        this.close();
        if (this.callback != null) {
            this.callback.run(this);
        }
    }

    private void saveImages() throws MraldException {
        ArrayList<String> queries = new ArrayList<String>();
        try {
            this.db.setAutoCommit(false);
            HashMap<String, String> derivedVolumes = this.insertVolume(queries);
            this.insertDerivation(queries, derivedVolumes);
            this.insertImages(queries, derivedVolumes);
            this.executeQueries(queries);
            this.db.commit();
        }
        catch (SQLException commitException) {
            try {
                this.db.rollback();
            }
            catch (SQLException rollbackException) {
                throw new MraldException((Throwable)rollbackException);
            }
            throw new MraldException((Throwable)commitException);
        }
    }

    private String generateDerivedId(String fileOutName) {
        String derivedFileName = fileOutName;
        if (derivedFileName.indexOf(".") > -1) {
            derivedFileName = derivedFileName.substring(0, fileOutName.lastIndexOf("."));
        }
        derivedFileName = this.sourceVolumeId + "_" + derivedFileName;
        return derivedFileName;
    }

    private void executeQueries(ArrayList<String> queries) throws SQLException {
        boolean failure = false;
        for (String query : queries) {
            try {
                MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Tensor Calculation : About to execute query:  " + query));
                this.db.executeUpdate(query);
            }
            catch (SQLException e) {
                MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Tensor Calculation : Failure to execute query:  " + query + "because : " + e.getMessage()));
                this.out.println(e.getMessage());
                failure = true;
            }
        }
        if (failure) {
            throw new SQLException("At least one query failed; rollback is needed.");
        }
    }

    private void insertDerivation(ArrayList<String> queries, HashMap<String, String> derivationVolumesImages) {
        for (String derivationVolumeId : derivationVolumesImages.keySet()) {
            String insertDerivation = "INSERT INTO derivation_history VALUES ('<:volume_id:>','<:source_volume_id:>')";
            insertDerivation = insertDerivation.replaceAll("<:volume_id:>", derivationVolumeId);
            insertDerivation = insertDerivation.replaceAll("<:source_volume_id:>", this.sourceVolumeId);
            queries.add(insertDerivation);
        }
    }

    private void insertImages(ArrayList<String> queries, HashMap<String, String> volImages) {
        String insertTemplate = "INSERT INTO images VALUES ('<:volume_id:>', '<:fileName:>')";
        HashMap rowParams = this.parameters.get(0);
        String sourceFileName = (String)rowParams.get("filename");
        sourceFileName = this.sourceVolumeId + "_" + sourceFileName;
        sourceFileName = this.extractFileNameToSave(sourceFileName);
        for (String derivedVolume : volImages.keySet()) {
            String insertImage = insertTemplate.replaceAll("<:volume_id:>", derivedVolume);
            String derivedImage = volImages.get(derivedVolume);
            insertImage = insertImage.replaceAll("<:fileName:>", derivedImage);
            queries.add(insertImage);
            this.updateImageLabel(sourceFileName, derivedImage, queries);
        }
    }

    private void updateImageLabel(String sourceImage, String derivedImage, ArrayList<String> queries) {
        String lookupLabel = "SELECT label FROM images_label WHERE filename='<:srcImage:>'";
        String updateLabel = "UPDATE images_label SET owner='" + MiscUtils.checkApostrophe((String)this.user.getEmail()) + "', label = (" + lookupLabel + ") WHERE images_label.fileName = '<:tgtImage:>'";
        updateLabel = updateLabel.replaceAll("<:tgtImage:>", derivedImage);
        updateLabel = updateLabel.replaceAll("<:srcImage:>", sourceImage);
        queries.add(updateLabel);
    }

    private HashMap<String, String> insertVolume(ArrayList<String> queries) throws SQLException {
        String INSERT_VOLUME_TEMPLATE = "Insert into volume (volume_id, modality, state, file_format, numerical_format, endianness, algorithm_id, xfov, xdimension, xstep, xstart, xorientation, xresolution, yfov, ydimension, ystep, ystart, yorientation, yresolution, zfov, zdimension, zstep, zstart, zorientation, zresolution, scan_id)  values ('<:volume_id:>', '<:modality:>', '<:state:>', '<:file_format:>', '<:numerical_format:>', '<:endianness:>', '<:algorithm_id:>', '<:xfov:>', '<:xdimension:>', '<:xstep:>', '<:xstart:>', '<:xorientation:>', '<:xresolution:>', '<:yfov:>', '<:ydimension:>', '<:ystep:>', '<:ystart:>', '<:yorientation:>', '<:yresolution:>', '<:zfov:>', '<:zdimension:>', '<:zstep:>', '<:zstart:>', '<:zorientation:>', '<:zresolution:>', '<:scan_id:>')";
        String insertVolume = "";
        if (this.parameters.size() < 1) {
            this.success = false;
            return null;
        }
        HashMap rowParams = this.parameters.get(0);
        HashMap<String, String> derivationVolumes = new HashMap<String, String>();
        int count = 0;
        for (String outputFile : this.outFileList.keySet()) {
            ++count;
            insertVolume = INSERT_VOLUME_TEMPLATE;
            String fileName = this.outFileList.get(outputFile);
            String imageFile = this.dataDir + "/" + fileName;
            imageFile = this.extractFileNameToSave(imageFile);
            this.derivedVolumeId = this.generateDerivedId(fileName);
            derivationVolumes.put(this.derivedVolumeId, imageFile);
            insertVolume = insertVolume.replaceAll("<:volume_id:>", this.derivedVolumeId);
            insertVolume = insertVolume.replaceAll("<:modality:>", (String)rowParams.get("modality"));
            insertVolume = insertVolume.replaceAll("<:state:>", "Tensor Map");
            insertVolume = insertVolume.replaceAll("<:file_format:>", (String)rowParams.get("file_format"));
            insertVolume = insertVolume.replaceAll("<:numerical_format:>", (String)rowParams.get("numerical_format"));
            insertVolume = insertVolume.replaceAll("<:endianness:>", (String)rowParams.get("endianness"));
            String algorithmId = "Tensor Calculation ";
            if (count == 1) {
                this.checkAlgorithm(queries, algorithmId);
            }
            insertVolume = insertVolume.replaceAll("<:algorithm_id:>", algorithmId);
            insertVolume = insertVolume.replaceAll("<:xfov:>", (String)rowParams.get("xfov"));
            insertVolume = insertVolume.replaceAll("<:yfov:>", (String)rowParams.get("yfov"));
            insertVolume = insertVolume.replaceAll("<:zfov:>", (String)rowParams.get("zfov"));
            insertVolume = insertVolume.replaceAll("<:xdimension:>", (String)rowParams.get("xdimension"));
            insertVolume = insertVolume.replaceAll("<:ydimension:>", (String)rowParams.get("ydimension"));
            insertVolume = insertVolume.replaceAll("<:zdimension:>", (String)rowParams.get("zdimension"));
            String xstep = (String)rowParams.get("xstep");
            insertVolume = xstep != null ? insertVolume.replaceAll("<:xstep:>", xstep) : insertVolume.replaceAll("'<:xstep:>'", "null");
            String ystep = (String)rowParams.get("ystep");
            insertVolume = ystep != null ? insertVolume.replaceAll("<:ystep:>", ystep) : insertVolume.replaceAll("'<:ystep:>'", "null");
            String zstep = (String)rowParams.get("zstep");
            insertVolume = zstep != null ? insertVolume.replaceAll("<:zstep:>", zstep) : insertVolume.replaceAll("'<:zstep:>'", "null");
            String xstart = (String)rowParams.get("xstart");
            insertVolume = xstart != null ? insertVolume.replaceAll("<:xstart:>", xstart) : insertVolume.replaceAll("'<:xstart:>'", "null");
            String ystart = (String)rowParams.get("ystart");
            insertVolume = ystart != null ? insertVolume.replaceAll("<:ystart:>", ystart) : insertVolume.replaceAll("'<:ystart:>'", "null");
            String zstart = (String)rowParams.get("zstart");
            insertVolume = zstart != null ? insertVolume.replaceAll("<:zstart:>", zstart) : insertVolume.replaceAll("'<:zstart:>'", "null");
            insertVolume = insertVolume.replaceAll("<:xorientation:>", (String)rowParams.get("xorientation"));
            insertVolume = insertVolume.replaceAll("<:yorientation:>", (String)rowParams.get("yorientation"));
            insertVolume = insertVolume.replaceAll("<:zorientation:>", (String)rowParams.get("zorientation"));
            insertVolume = insertVolume.replaceAll("<:xresolution:>", (String)rowParams.get("xresolution"));
            insertVolume = insertVolume.replaceAll("<:yresolution:>", (String)rowParams.get("yresolution"));
            insertVolume = insertVolume.replaceAll("<:zresolution:>", (String)rowParams.get("zresolution"));
            insertVolume = insertVolume.replaceAll("<:scan_id:>", (String)rowParams.get("scan_id"));
            queries.add(insertVolume);
            this.updateVolumeLabel(queries);
        }
        return derivationVolumes;
    }

    private void checkAlgorithm(ArrayList<String> queries, String algorithmId) throws SQLException {
        String query = "SELECT * from ALGORITHM where algorithm_id = '<:algorithmId :>'";
        ResultSet rs = this.db.executeQuery(query = query.replaceAll("<:algorithmId :>", algorithmId));
        if (!rs.next()) {
            String insertAlgorithm = "INSERT INTO ALGORITHM VALUES('<:algorithmId :>', '<:algorithmId :>','version 1.0', null)";
            insertAlgorithm = insertAlgorithm.replaceAll("<:algorithmId :>", algorithmId);
            queries.add(insertAlgorithm);
        }
    }

    public static String extractUserEmailSansDomain(User user) {
        String email = user.getEmail();
        return email.indexOf("@") > 0 ? email.substring(0, email.indexOf("@")) : email;
    }

    private void updateVolumeLabel(ArrayList<String> queries) {
        String lookupLabel = "SELECT label FROM volume_label WHERE volume_id='<:srcId:>'";
        String updateLabel = "UPDATE volume_label SET owner='" + MiscUtils.checkApostrophe((String)this.user.getEmail()) + "', label = (" + lookupLabel + ") WHERE volume_label.volume_id = '<:tgtId:>'";
        updateLabel = updateLabel.replaceAll("<:tgtId:>", this.derivedVolumeId);
        updateLabel = updateLabel.replaceAll("<:srcId:>", this.sourceVolumeId);
        queries.add(updateLabel);
    }

    public void error(String msg) {
        this.success = false;
        log.log(Level.SEVERE, msg);
    }

    private void close() {
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getLineSeparator() {
        return Config.NEWLINE;
    }

    static {
        log.setLevel(Level.FINE);
    }

    public static interface Callback {
        public void run(TensorCalculation var1);
    }
}

