/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.custom;

import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.FileSaver;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.mitre.lattice.neuro.custom.TensorCalculation;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.Mailer;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.User;

public class TensorCalculationStep
extends AbstractStep {
    public static final String KEY = TensorCalculationStep.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    private static final String DATASOURCE = "main";
    protected TensorCalculation delegate;

    public void execute(MsgObject msg) throws WorkflowStepException {
        try {
            MraldConnection conn = new MraldConnection(DATASOURCE);
            User user = (User)msg.getReq().getSession().getAttribute(Config.getProperty((String)"cookietag"));
            String volumeId = msg.getValue("VolumeId")[0];
            int numOrientations = this.getOrientationCount(conn, volumeId);
            conn = new MraldConnection(DATASOURCE);
            this.delegate = new TensorCalculation(user, volumeId, conn);
            String action = msg.getValue("action")[0];
            if (action.equals("Print")) {
                this.delegate.execute(action, msg.getRes().getWriter(), null);
            } else {
                StringWriter errors = new StringWriter();
                PrintWriter output = new PrintWriter(errors);
                SendResponse code = new SendResponse(errors);
                this.delegate.execute(action, output, code);
                TensorCalculationStep.generateResponse(msg.getRes(), 202, "tensor", volumeId, "You will receive an email once tensor calculation is complete.");
            }
        }
        catch (Exception e) {
            throw new WorkflowStepException((Throwable)e);
        }
    }

    public static void generateResponse(HttpServletResponse response, int status, String request, String volumeId, String msg) throws IOException {
        response.setStatus(status);
        PrintWriter writer = response.getWriter();
        writer.append("<head><title>Request received</title></head>");
        writer.append("<body>Your request to ").append(request).append(" volume ").append(volumeId).append(" was received.<br/>");
        writer.append(msg).append("</body>");
    }

    private int getOrientationCount(MraldConnection db, String volumeId) throws SQLException {
        String SQL = "Select count(*) from volume natural join dti_scan_event natural join gradient_bvalue natural join gradient_orientation where volume_id='<:volume_id:>';";
        ResultSet rs = db.executeQuery(SQL = SQL.replaceAll("<:volume_id:>", volumeId));
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    private void createSampleSlice(File orientation) {
        FileInfo fi = new FileInfo();
        fi.fileName = orientation.getName();
        fi.directory = orientation.getParent();
        fi.fileFormat = 1;
        fi.fileType = 2;
        ArrayList<HashMap> params = this.delegate.getParamters();
        HashMap firstSet = params.get(0);
        fi.width = Integer.parseInt((String)firstSet.get("xdimension"));
        fi.height = Integer.parseInt((String)firstSet.get("ydimension"));
        fi.nImages = Integer.parseInt((String)firstSet.get("zdimension"));
        fi.offset = 0;
        fi.gapBetweenImages = 0;
        fi.intelByteOrder = false;
        fi.whiteIsZero = false;
        ImagePlus result = new FileOpener(fi).open(false);
        result.setSlice(fi.nImages / 2);
        String destination = MiscUtils.replaceSuffix((String)orientation.toString(), (String)".jpg");
        new FileSaver(result).saveAsJpeg(destination);
    }

    public class SendResponse
    implements TensorCalculation.Callback {
        public final StringWriter errors;

        public SendResponse(StringWriter errors) {
            this.errors = errors;
        }

        public void run(TensorCalculation tensor) {
            String to = TensorCalculationStep.this.delegate.getUser().getEmail();
            String from = Config.getProperty((String)"MAILTO");
            String host = Config.getProperty((String)"SMTPHOST");
            try {
                if (TensorCalculationStep.this.delegate.getSuccessStatus()) {
                    this.reportSuccess(to, from, host);
                } else {
                    this.reportFailure(to, from, host);
                }
            }
            catch (Exception e) {
                TensorCalculationStep.this.delegate.error("Unable to generate verification page==>" + e.getMessage());
                this.reportFailure(to, from, host);
            }
        }

        public void reportSuccess(String to, String from, String host) {
            String newId = TensorCalculationStep.this.delegate.getDerivedId();
            String verifyURL = Config.getProperty((String)"BaseUrl") + "/TensorCalculation.jsp?" + "volume=" + newId;
            String message = "Volume " + TensorCalculationStep.this.delegate.getSourceId() + " has been registered as " + newId + "." + "  Please visit " + verifyURL + " at your convenience to verify the tensor calculation.";
            String subject = "Tensor Calculation complete; please verify.";
            try {
                Mailer.send((String)to, (String)from, (String)host, (String)message, (String)subject);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Email concerning " + verifyURL + " failed.", e);
            }
        }

        public void reportFailure(String to, String from, String host) {
            String err = this.errors.toString();
            String message = "Unable to calculate tensor for " + TensorCalculationStep.this.delegate.getSourceId() + " due to errors: " + err;
            String subject = "Tensor Calculation error.";
            try {
                Mailer.send((String)to, (String)from, (String)host, (String)message, (String)subject);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Email concerning " + err + " failed.", e);
            }
        }
    }
}

