/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.debabbeler;

import edu.ucla.loni.dataflow.file.FileDecoder;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldOutFile;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BabelFish {
    Document document;
    Element root;

    public BabelFish() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.document = builder.newDocument();
    }

    public static void outputXml(Document document, Result destination) {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, destination);
        }
        catch (TransformerConfigurationException tce) {
            throw new RuntimeException(tce);
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
    }

    public static Element transformDom(Node node, Element newDocNode, Document doc) throws Exception {
        try {
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)"Babel Fish : In TransformDom");
            NamedNodeMap attr = node.getAttributes();
            for (int i = 0; i < attr.getLength(); ++i) {
                Node attrNode = attr.item(i);
                String attrVal = attrNode.getNodeValue();
                if (attrVal == null) continue;
                Attr newAttrNode = doc.createAttribute(attrNode.getNodeName());
                newAttrNode.setNodeValue(BabelFish.checkCharacters(attrNode.getNodeValue()));
                newDocNode.setAttributeNode(newAttrNode);
            }
            NodeList children = node.getChildNodes();
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("Babel Fish : In TransformDom. No of children " + children.getLength()));
            for (int i = 0; i < children.getLength(); ++i) {
                Node childNode = children.item(i);
                String nodeName = BabelFish.checkCharacters(childNode.getNodeName());
                if (nodeName.startsWith("0") || nodeName.startsWith("1") || nodeName.startsWith("2") || nodeName.startsWith("3") || nodeName.startsWith("4") || nodeName.startsWith("5") || nodeName.startsWith("6") || nodeName.startsWith("7") || nodeName.startsWith("8") || nodeName.startsWith("9")) {
                    nodeName = "A" + nodeName;
                }
                Element newChildNode = doc.createElement(nodeName);
                String nodeVal = childNode.getNodeValue();
                if ((nodeVal = BabelFish.checkCharacters(nodeVal)) != null) {
                    newChildNode.setNodeValue(BabelFish.checkCharacters(childNode.getNodeValue()));
                } else {
                    newChildNode.setNodeValue("");
                }
                if (newChildNode.getNodeName().equals("DATA")) continue;
                newDocNode.appendChild(newChildNode);
                BabelFish.transformDom(childNode, newChildNode, doc);
            }
            return newDocNode;
        }
        catch (Exception e) {
            MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("BabelFish: Exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            BabelFish babel = new BabelFish();
            babel.execute(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] execute(String[] args) {
        try {
            File[] afile = new File[1];
            String[] outputFiles = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                String xmlFile;
                String fileName = args[i];
                String tempFileName = fileName.substring(0, fileName.lastIndexOf("/")) + "/temp.raw";
                afile[0] = new File(tempFileName);
                FileDecoder decoder = FileDecoder.getFileDecoder((File[])afile);
                Node node = decoder.getCharacteristicMetadata();
                this.root = this.document.createElement(node.getNodeName());
                this.document.appendChild(BabelFish.transformDom(node, this.root, this.document));
                outputFiles[i] = xmlFile = fileName.substring(0, fileName.indexOf(".")) + ".xml";
                File file = new File(xmlFile);
                StreamResult res = new StreamResult(file);
                BabelFish.outputXml(this.document, res);
            }
            return outputFiles;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String checkCharacters(String s) {
        if (s == null) {
            return null;
        }
        String s1 = "$<>?@#&*|`/\\'[]";
        for (int i = 0; i < s1.length(); ++i) {
            if (s.indexOf(s1.charAt(i)) <= -1) continue;
            return "<![CDATA[" + s + "]]>";
        }
        if (s.indexOf("\u0000") > -1) {
            return "<![CDATA[]]>";
        }
        if (s.indexOf("\\n") > -1) {
            return "<![CDATA[" + s + "]]>";
        }
        return s;
    }
}

