/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.debabbeler;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mitre.lattice.neuro.debabbeler.BabelFish;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.util.Config;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportMRI
extends AbstractStep {
    Connection conn;

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public String execute(int userId, String[] args) throws Exception {
        try {
            ArrayList sqlStatements = new ArrayList();
            BabelFish babel = new BabelFish();
            String[] outputFiles = babel.execute(args);
            for (int i = 0; i < outputFiles.length; ++i) {
                sqlStatements.addAll(this.createSql(userId, outputFiles[i], args[i]));
            }
            this.executeStmnts(sqlStatements);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return null;
    }

    public void execute(MsgObject msg) {
        try {
            ArrayList sqlStatements = new ArrayList();
            BabelFish babel = new BabelFish();
            String[] file = new String[]{"mni_icbm_00152_t1_final.mnc"};
            String[] outputFiles = babel.execute(file);
            int userId = 0;
            for (int i = 0; i < outputFiles.length; ++i) {
                sqlStatements.addAll(this.createSql(userId, outputFiles[i], file[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList createSql(int userid, String xmlFileName, String fileName) throws Exception {
        try {
            String truncFileName = fileName.substring(Config.getProperty((String)"BasePath").length());
            ArrayList<String> sqlStatements = new ArrayList<String>();
            Statement stmnt = this.conn.createStatement();
            ResultSet rs = stmnt.executeQuery("SELECT max(scan_id) from Scan_event ");
            String scan_id = "";
            scan_id = !rs.next() ? "1" : new Integer(rs.getInt(1) + 1).toString();
            int lastIndex = xmlFileName.lastIndexOf("/");
            String subject = xmlFileName.substring(lastIndex + 1);
            int startNo = xmlFileName.indexOf("0");
            subject = subject.substring(0, subject.indexOf("_") + 1).toUpperCase();
            subject = subject + xmlFileName.substring(startNo, xmlFileName.lastIndexOf("."));
            String volume_id = "";
            rs = stmnt.executeQuery("SELECT count(0) from Subject where subject_id = '" + subject + "'");
            if (!rs.next()) {
                sqlStatements.add("Insert into Subject (subject_id, pat_id) values ('" + subject + "', '' )");
            } else if (rs.getInt(1) == 0) {
                sqlStatements.add("Insert into Subject (subject_id, pat_id) values ('" + subject + "',  '' )");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            String insertImage = "Insert into Images values (</imageId/>, </ownerId/>, '</fileName/>')";
            int imageId = this.getImageId(stmnt);
            insertImage = insertImage.replaceAll("</imageId/>", new Integer(imageId).toString());
            insertImage = insertImage.replaceAll("</fileName/>", truncFileName);
            insertImage = insertImage.replaceAll("</ownerId/>", new Integer(userid).toString());
            sqlStatements.add(insertImage);
            String insertStatement = "INSERT INTO Volume (volume_id, scan_id, file, imageId, xspace, xstep, xstart, xorientation,  yspace, ystep, ystart, yorientation,  zspace, zstep, zstart, zorientation, derivation_history_id  ) VALUES ('<:volume_id:>', '<:scan_id:>','<:file:>', <:image_id:>, <:xspace:>, <:xstep:>, <:xstart:>, '<:xorientation:>',  <:yspace:>, <:ystep:>, <:ystart:>, '<:yorientation:>',  <:zspace:>, <:zstep:>, <:zstart:>, '<:zorientation:>', <:derivation_id:>  )";
            volume_id = subject + "_1";
            insertStatement = insertStatement.replaceAll("<:volume_id>", volume_id);
            String insertStatementScan = "INSERT INTO Scan_event (scan_id, pat_id)  VALUES ('<:scan_id:>', '<:subject_id:>' )";
            String insertStatementHistory = "INSERT INTO Derivation_history (derivation_history_id, history)  VALUES (<:dervn_id:>, '<:history:>' )";
            insertStatementScan = insertStatementScan.replaceAll("<:scan_id:>", scan_id);
            insertStatementScan = insertStatementScan.replaceAll("<:subject_id:>", subject);
            insertStatement = insertStatement.replaceAll("<:scan_id:>", scan_id);
            insertStatement = insertStatement.replaceAll("<:file:>", truncFileName);
            insertStatement = insertStatement.replaceAll("<:volume_id:>", volume_id);
            insertStatement = insertStatement.replaceAll("<:image_id:>", String.valueOf(imageId));
            File datafile = new File(xmlFileName);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(datafile);
            NodeList nodes = doc.getElementsByTagName("DIMENSIONS");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node thisNode = nodes.item(i);
                if (thisNode.getNodeType() != 1) continue;
                String xspaceDim = ((Element)thisNode).getAttribute("xspace");
                insertStatement = insertStatement.replaceAll("<:xspace:>", xspaceDim);
                String yspaceDim = ((Element)thisNode).getAttribute("yspace");
                insertStatement = insertStatement.replaceAll("<:yspace:>", yspaceDim);
                String zspaceDim = ((Element)thisNode).getAttribute("zspace");
                insertStatement = insertStatement.replaceAll("<:zspace:>", zspaceDim);
            }
            String historyValue = "";
            NodeList historynodes = doc.getElementsByTagName("history");
            for (int i = 0; i < historynodes.getLength(); ++i) {
                NodeList historyValues;
                Node thisNode = historynodes.item(i);
                if (thisNode.getNodeType() != 1 || (historyValues = ((Element)thisNode).getElementsByTagName("VALUE")).getLength() <= 0) continue;
                historyValue = ((Element)historyValues.item(0)).getAttribute("value");
            }
            if (historyValue.equals("")) {
                insertStatement = insertStatement.replaceAll("<:derivation_id:>", "0");
            } else {
                rs = stmnt.executeQuery("SELECT max(derivation_history_id) from Derivation_history ");
                String derivation_id = "";
                derivation_id = !rs.next() ? "1" : new Integer(rs.getInt(1) + 1).toString();
                insertStatementHistory = insertStatementHistory.replaceAll("<:history:>", historyValue);
                insertStatementHistory = insertStatementHistory.replaceAll("<:dervn_id:>", derivation_id);
                sqlStatements.add(insertStatementHistory);
                insertStatement = insertStatement.replaceAll("<:derivation_id:>", derivation_id);
            }
            String[] xSpace = this.getSpaceStuff(doc, "xspace");
            insertStatement = insertStatement.replaceAll("<:xorientation:>", xSpace[0]);
            insertStatement = insertStatement.replaceAll("<:xstep:>", xSpace[1]);
            insertStatement = insertStatement.replaceAll("<:xstart:>", xSpace[2]);
            String[] ySpace = this.getSpaceStuff(doc, "yspace");
            insertStatement = insertStatement.replaceAll("<:yorientation:>", ySpace[0]);
            insertStatement = insertStatement.replaceAll("<:ystep:>", ySpace[1]);
            insertStatement = insertStatement.replaceAll("<:ystart:>", ySpace[2]);
            String[] zSpace = this.getSpaceStuff(doc, "zspace");
            insertStatement = insertStatement.replaceAll("<:zorientation:>", zSpace[0]);
            insertStatement = insertStatement.replaceAll("<:zstep:>", zSpace[1]);
            insertStatement = insertStatement.replaceAll("<:zstart:>", zSpace[2]);
            sqlStatements.add(insertStatement);
            sqlStatements.add(insertStatementScan);
            return sqlStatements;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void executeStmnts(ArrayList sqlStatements) throws SQLException {
        this.conn.setAutoCommit(false);
        Statement stmn = this.conn.createStatement();
        for (int i = 0; i < sqlStatements.size(); ++i) {
            stmn.executeUpdate(sqlStatements.get(i).toString());
        }
        this.conn.commit();
        stmn.close();
        this.conn.close();
    }

    private int getImageId(Statement s) throws SQLException {
        String selectImage = "select max(imageId) from Images";
        ResultSet rs = s.executeQuery(selectImage);
        if (rs.next()) {
            return rs.getInt(1) + 1;
        }
        return -1;
    }

    private String[] getSpaceStuff(Document doc, String tagName) {
        NodeList SpaceNodes = doc.getElementsByTagName(tagName);
        String[] values = new String[3];
        for (int i = 0; i < SpaceNodes.getLength(); ++i) {
            String startValue;
            NodeList startValues;
            NodeList startNodes;
            NodeList stepValues;
            NodeList stepNodes;
            NodeList commentValues;
            Node thisNode = SpaceNodes.item(i);
            if (thisNode.getNodeType() != 1) continue;
            NodeList commentNodes = ((Element)thisNode).getElementsByTagName("comments");
            if (commentNodes.getLength() > 0 && (commentValues = ((Element)commentNodes.item(0)).getElementsByTagName("VALUE")).getLength() > 0) {
                String commentValue;
                values[0] = commentValue = ((Element)commentValues.item(0)).getAttribute("value");
            }
            if ((stepNodes = ((Element)thisNode).getElementsByTagName("step")).getLength() > 0 && (stepValues = ((Element)stepNodes.item(0)).getElementsByTagName("VALUE")).getLength() > 0) {
                String stepValue;
                values[1] = stepValue = ((Element)stepValues.item(0)).getAttribute("value");
            }
            if ((startNodes = ((Element)thisNode).getElementsByTagName("start")).getLength() <= 0 || (startValues = ((Element)startNodes.item(0)).getElementsByTagName("VALUE")).getLength() <= 0) continue;
            values[2] = startValue = ((Element)startValues.item(0)).getAttribute("value");
        }
        return values;
    }
}

