/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.neuro.taglib;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mitre.lattice.neuro.taglib.NeuroSpecificTag;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;

public class VolumeBoxTag
extends NeuroSpecificTag {
    protected String[] getQuery() {
        String subjID = this.pageContext.getRequest().getParameter("subject_id");
        String scanID = this.pageContext.getRequest().getParameter("scan_id");
        String query = null;
        if (subjID != null) {
            subjID = MiscUtils.checkApostrophe((String)subjID);
            query = "SELECT DISTINCT volume.volume_id, subject.subject_id FROM subject, scan_event, volume WHERE subject.subject_id = '" + subjID + "'" + " AND scan_event.subject_id = subject.subject_id " + " AND volume.scan_id = scan_event.scan_id ";
        } else if (scanID != null) {
            scanID = MiscUtils.checkApostrophe((String)scanID);
            query = "SELECT DISTINCT volume.volume_id, scan_event.scan_id FROM scan_event, volume WHERE scan_event.scan_id  = '" + scanID + "'" + " AND volume.scan_id = scan_event.scan_id ";
        }
        return new String[]{query};
    }

    protected String init() {
        StringBuffer ret = new StringBuffer();
        ret.append("<TABLE WIDTH='90%' ALIGN='Left' BORDER='0' CELLSPACING='0' CELLPADDING='0'>");
        ret.append("<TR>");
        ret.append("<TD CLASS='bord'>");
        ret.append("<TABLE WIDTH='100%' BORDER='0' CELLSPACING='0' CELLPADDING='0'>");
        ret.append("<TR>");
        ret.append("<TD CLASS='bord'>");
        ret.append("<TABLE WIDTH='100%' BORDER='0' CELLSPACING='1' CELLPADDING='0'>");
        ret.append("<TR>");
        ret.append("<TH>V o l u m e &nbsp; r e s u l t s</TH>");
        ret.append("</TR>");
        ret.append("<TR>");
        ret.append("<TD>");
        ret.append("<TABLE WIDTH='100%' BORDER='0' CELLSPACING='1' CELLPADDING='2'>");
        ret.append("<TR>");
        ret.append("<TD WIDTH='25%' ALIGN='center'>");
        ret.append("<TABLE WIDTH='100%' BORDER='0' CELLSPACING='1' CELLPADDING='2'>");
        return ret.toString();
    }

    protected String endOutput() {
        StringBuffer ret = new StringBuffer();
        ret.append("</TABLE>");
        ret.append("</TD>");
        ret.append("</TR>");
        ret.append("</TABLE>");
        ret.append("</TD>");
        ret.append("</TR>");
        ret.append("</TABLE>");
        ret.append("</TD>");
        ret.append("</TR>");
        ret.append("</TABLE>");
        ret.append("</TD>");
        ret.append("</TR>");
        ret.append("</TABLE>");
        return ret.toString();
    }

    protected String processResultSet(ResultSet rs) throws MraldException {
        try {
            String subjID = this.pageContext.getRequest().getParameter("subject_id");
            String objectType = "Subject";
            if (subjID == null) {
                objectType = "Scan";
            }
            StringBuffer ret = new StringBuffer();
            StringBuffer retStart = new StringBuffer();
            int noOfVolume = 0;
            while (rs.next()) {
                String urlString = rs.getString(1);
                if (urlString != null) {
                    urlString = URLEncoder.encode(rs.getString(1), "UTF-8");
                }
                ret.append("<TR>");
                ret.append("<TD WIDTH='50%' ALIGN='Right'><a href=volume_info.jsp?volume_id=" + urlString);
                if (objectType.equals("Scan")) {
                    if (rs.getString(2) != null) {
                        urlString = URLEncoder.encode(rs.getString(2), "UTF-8");
                    }
                    ret.append("&scan_id=" + urlString + ">" + rs.getString(1) + "</a></TD>");
                } else {
                    if (rs.getString(2) != null) {
                        urlString = URLEncoder.encode(rs.getString(2), "UTF-8");
                    }
                    ret.append("&subject_id=" + urlString + ">" + rs.getString(1) + "</a></TD>");
                }
                ret.append("</TR>");
                ++noOfVolume;
            }
            retStart.append("<TR>");
            retStart.append("<TD WIDTH='50%' ALIGN='Center' COLSPAN='2'><b>There are " + noOfVolume + " volume(s) associated with this " + objectType + "</b></TD>");
            retStart.append("</TR>");
            return retStart.toString() + ret.toString();
        }
        catch (SQLException e) {
            throw new MraldException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new MraldException(e.getMessage());
        }
    }
}

