/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldCrypter;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;
import org.mitre.mrald.util.UserRegistration;

public class NeuroRegistration
extends UserRegistration {
    private static final String DATASOURCE = "main";

    public NeuroRegistration() {
        this.username = null;
        this.password = null;
        this.pageurl = null;
        this.loginAction = null;
        this.mraldUser = null;
    }

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.username = msgObject.getValue("userName")[0];
            this.password = msgObject.getValue("password")[0];
            this.pageurl = msgObject.getValue("pageurl")[0];
            this.loginAction = msgObject.getValue("loginAction")[0];
            this.mraldUser = new User(this.username);
            if (this.loginAction.equals("addUser")) {
                String[] regInfo;
                String verifyPassword = msgObject.getReq().getParameter("verifyPassword");
                if (!this.password.equals(verifyPassword)) {
                    WorkflowStepException npe = new WorkflowStepException("Your passwords did not match. Please go back and enter matching passwords.");
                    throw npe;
                }
                String pi_value = msgObject.getReq().getParameter("amPI");
                if (pi_value == null || pi_value.equals(null) || pi_value.equals("null") || pi_value.equals("")) {
                    pi_value = "N";
                }
                if (!this.registerUserInfo(this.password, verifyPassword, regInfo = new String[]{MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("firstName")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("lastName")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("company")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("department")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("address")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("city")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("state")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("zip")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("country")), pi_value, MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("comments"))})) {
                    WorkflowStepException npe = new WorkflowStepException("Error in Registering User. Please contact System Administrator.");
                    throw npe;
                }
            } else if (this.loginAction.equals("validateUser")) {
                String key = msgObject.getReq().getParameter("key");
                if (key == null || key.equals(null) || key.equals("null") || key.equals("")) {
                    throw new WorkflowStepException("No Validation Key Provided.  unable to Authenicate Your Identity.");
                }
                this.confirmUserInfo(key);
            } else if (this.loginAction.equals("addPiInfo")) {
                if (this.username == null || this.username.equals(null) || this.username.equals("null") || this.username.equals("")) {
                    throw new NullPointerException("No PI Username Provided.  Please re-register from a valid entry point.");
                }
                String[] piInfo = new String[]{MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("GrantNo")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("Grant")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("ResearchTitle")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("grant_desc")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("FundingAgency")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("StartDate")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("EndDate")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("Budget")), MiscUtils.checkApostrophe((String)msgObject.getReq().getParameter("related_people"))};
                this.addPiInfo(this.username, piInfo);
            } else {
                throw new WorkflowStepException("Invalid Entry Point.  Please go to " + Config.getProperty((String)"BaseUrl") + "/MraldLogin.jsp and log in through a valid entry point.");
            }
            if (this.loginAction.equals("validateUser")) {
                msgObject.getRes().sendRedirect("ValidationSuccess.jsp");
            } else if (this.loginAction.equals("addUser") && msgObject.getReq().getParameter("amPI") != null && msgObject.getReq().getParameter("amPI").equals("Y")) {
                msgObject.getRes().sendRedirect("PI_Registration.jsp?username=" + this.username + "&pageurl=" + this.pageurl);
            } else if (this.pageurl == null || this.pageurl.equals(null) || this.pageurl.equals("") || this.pageurl.equals("null")) {
                msgObject.getRes().sendRedirect(Config.getProperty((String)"URL"));
            } else {
                msgObject.getRes().sendRedirect(this.pageurl);
            }
        }
        catch (IOException e) {
            throw new WorkflowStepException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new WorkflowStepException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WorkflowStepException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WorkflowStepException((Throwable)e);
        }
        catch (NullPointerException npe) {
            throw new WorkflowStepException((Throwable)npe);
        }
        catch (Exception e) {
            throw new WorkflowStepException((Throwable)e);
        }
    }

    protected void confirmUserInfo(String key) throws SQLException, ClassNotFoundException, NoSuchAlgorithmException, IOException, NullPointerException, Exception {
        MraldConnection conn = new MraldConnection(DATASOURCE);
        String query = "SELECT * FROM People WHERE People.email = '" + this.username.toLowerCase() + "'";
        ResultSet r = conn.executeQuery(query);
        if (r.next()) {
            String newHash = this.password + ":" + r.getString("validationcode");
            if (!MraldCrypter.matchPassword((String)key, (String)newHash)) {
                r.close();
                conn.close();
                throw new NullPointerException("Validation Key Is Invalid. Please Try Again.");
            }
        } else {
            r.close();
            conn.close();
            throw new NullPointerException("No Username Available for Validation. Please Try Again Later.");
        }
        String update = "UPDATE People SET validated = 'Y' WHERE email = '" + this.username.toLowerCase() + "'";
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("LoginTag: confirmUserInfo() - Query:" + update));
        conn.executeUpdate(update);
        this.generateWelcome(this.username.toLowerCase());
        r.close();
        conn.close();
    }

    protected boolean registerUserInfo(String newpassword, String checkpassword, String[] regInfo) throws SQLException, ClassNotFoundException, NoSuchAlgorithmException, UnsupportedEncodingException, Exception {
        if (!newpassword.equals(checkpassword)) {
            return false;
        }
        String peopleId = this.addUserInfo();
        String validationKey = this.generateKey();
        String hashKey = this.generateHash(validationKey);
        this.addRegInfo(peopleId, regInfo, validationKey);
        return true;
    }

    protected void addRegInfo(String peopleId, String[] regInfo, String validationKey) throws SQLException, ClassNotFoundException {
        MraldConnection conn = new MraldConnection(DATASOURCE);
        String insert = "UPDATE People SET firstName = '</firstName/>',  lastName = '</lastName/>', company = '</company/>', department = '</department/>', address = '</address/>', city = '</city/>', state = '</state/>', zip = '</zip/>', country = '</country/>', pi = '</pi/>', comments = '</comments/>', validated = 'N', validationcode = '</validationcode/>' WHERE email = '" + peopleId + "'";
        insert = MiscUtils.replace((String)insert, (String)"</firstName/>", (String)regInfo[0]);
        insert = MiscUtils.replace((String)insert, (String)"</lastName/>", (String)regInfo[1]);
        insert = MiscUtils.replace((String)insert, (String)"</company/>", (String)regInfo[2]);
        insert = MiscUtils.replace((String)insert, (String)"</department/>", (String)regInfo[3]);
        insert = MiscUtils.replace((String)insert, (String)"</address/>", (String)regInfo[4]);
        insert = MiscUtils.replace((String)insert, (String)"</city/>", (String)regInfo[5]);
        insert = MiscUtils.replace((String)insert, (String)"</state/>", (String)regInfo[6]);
        insert = MiscUtils.replace((String)insert, (String)"</zip/>", (String)regInfo[7]);
        insert = MiscUtils.replace((String)insert, (String)"</country/>", (String)regInfo[8]);
        insert = MiscUtils.replace((String)insert, (String)"</pi/>", (String)regInfo[9]);
        insert = MiscUtils.replace((String)insert, (String)"</comments/>", (String)regInfo[10]);
        insert = MiscUtils.replace((String)insert, (String)"</validationcode/>", (String)validationKey);
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("LoginTag: addRegInfo() - Query:" + insert));
        conn.executeUpdate(insert);
        conn.close();
    }

    protected void addPiInfo(String username, String[] piInfo) throws SQLException, ClassNotFoundException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MraldConnection conn = new MraldConnection(DATASOURCE);
        String insert = "INSERT INTO project (grant_no , grant_name, research_title, research_desc, funding_agency, start_date, end_date, current_budget, related_people, pi_email ) VALUES ('</grant_no/>', '</grant_name/>',  '</research_title/>', '</research_desc/>', '</funding_agency/>', '</start_date/>', '</end_date/>', '</current_budget/>', '</related_people/>', '</pi_email/>' ) ";
        insert = MiscUtils.replace((String)insert, (String)"</grant_no/>", (String)piInfo[0]);
        insert = MiscUtils.replace((String)insert, (String)"</grant_name/>", (String)piInfo[1]);
        insert = MiscUtils.replace((String)insert, (String)"</research_title/>", (String)piInfo[2]);
        insert = MiscUtils.replace((String)insert, (String)"</research_desc/>", (String)piInfo[3]);
        insert = MiscUtils.replace((String)insert, (String)"</funding_agency/>", (String)piInfo[4]);
        insert = MiscUtils.replace((String)insert, (String)"</start_date/>", (String)piInfo[5]);
        insert = MiscUtils.replace((String)insert, (String)"</end_date/>", (String)piInfo[6]);
        insert = MiscUtils.replace((String)insert, (String)"</current_budget/>", (String)piInfo[7]);
        insert = MiscUtils.replace((String)insert, (String)"</related_people/>", (String)piInfo[8]);
        insert = MiscUtils.replace((String)insert, (String)"</pi_email/>", (String)username);
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("LoginTag: addPiInfo() - Query:" + insert));
        conn.executeUpdate(insert);
        conn.close();
    }

    protected String findCOI() throws SQLException, ClassNotFoundException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MraldConnection conn = new MraldConnection(DATASOURCE);
        String query = "SELECT DISTINCT latticegroupid FROM people, project WHERE project.pi_email = people.email AND project.related_people LIKE '%" + this.username.toLowerCase() + "%'";
        MraldOutFile.logToFile((String)Config.getProperty((String)"LOGFILE"), (String)("NeuroRegistration: findCOI() - Query:" + query));
        ResultSet rs = conn.executeQuery(query);
        String return_str = rs.next() ? rs.getString("latticegroupid") : "Public";
        rs.close();
        conn.close();
        return return_str;
    }
}

