/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.List;

public class EndianCorrectedChannel {
    public static final String SYSTEM_ENDIANNESS = System.getProperty("sun.cpu.endian");
    public static final List<String> VALID_ENDIANS = Arrays.asList("big", "little");
    private final boolean swap;
    private final FileChannel base;

    public EndianCorrectedChannel(FileChannel base, String imageEndianness) {
        if (!VALID_ENDIANS.contains(imageEndianness)) {
            throw new IllegalArgumentException("Value of second parameter must be either 'big' or 'little', but '" + imageEndianness + "' was passed.");
        }
        this.swap = !SYSTEM_ENDIANNESS.equals(imageEndianness);
        this.base = base;
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (buffer.capacity() % 2 != 0) {
            throw new IllegalArgumentException("This class requires reading an even number of bytes.");
        }
        int result = this.base.read(buffer);
        if (this.swap) {
            byte[] b = buffer.array();
            for (int i = 0; i < result; i += 2) {
                byte temp = b[i];
                b[i] = b[i + 1];
                b[i + 1] = temp;
            }
        }
        return result;
    }

    public void write(ByteBuffer buffer) throws IOException {
        if (buffer.capacity() % 2 != 0) {
            throw new IllegalArgumentException("This class requires writing an even number of bytes.");
        }
        if (this.swap) {
            byte[] b = buffer.array();
            for (int i = 0; i < b.length; i += 2) {
                byte temp = b[i];
                b[i] = b[i + 1];
                b[i + 1] = temp;
            }
        }
        this.base.write(buffer);
    }

    public void close() throws IOException {
        this.base.close();
    }
}

