/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.RectangleInsets;
import org.mitre.neuro.util.GraphPoint;

public class GraphMetrics {
    private static String title;
    private static ArrayList<String> yLabels;

    public GraphMetrics(String graphTitle) {
        title = graphTitle;
    }

    public static Object createDataset(String chartType, Object data, Object labels, int displayType) {
        Object dataset = null;
        ArrayList dataArray = (ArrayList)data;
        if (chartType.equals("Pie")) {
            DefaultPieDataset pieSet = new DefaultPieDataset();
            for (int i = 0; i < dataArray.size(); ++i) {
                double[] values = (double[])dataArray.get(i);
                pieSet.setValue((Comparable)((Object)new String("Image : " + i)), values[displayType]);
            }
            return pieSet;
        }
        if (chartType.equals("Bar")) {
            String[] labelSet = (String[])labels;
            DefaultCategoryDataset barDataset = new DefaultCategoryDataset();
            String series1 = "Images";
            for (int i = 0; i < dataArray.size(); ++i) {
                double[] values = (double[])dataArray.get(i);
                for (int j = 0; j < values.length; ++j) {
                    barDataset.addValue(values[j], (Comparable)((Object)labelSet[j]), (Comparable)((Object)series1));
                }
            }
            return barDataset;
        }
        if (chartType.equals("XY")) {
            int i;
            DefaultTableXYDataset xyDataset = new DefaultTableXYDataset();
            String[] seriesNames = new String[]{"Delta Omega", "Delta Theta", "Delta Phi", "Delta X", "Delta Y", "Delta Z"};
            if (labels != null) {
                seriesNames = (String[])labels;
            }
            double[] values = (double[])dataArray.get(0);
            int len = values.length;
            XYSeries[] xySeries = new XYSeries[len];
            for (i = 0; i < len; ++i) {
                xySeries[i] = new XYSeries((Comparable)((Object)seriesNames[i]), false, false);
            }
            for (i = 0; i < dataArray.size(); ++i) {
                values = (double[])dataArray.get(i);
                for (int j = 0; j < values.length; ++j) {
                    System.out.println("Series name :" + xySeries[j].getKey());
                    xySeries[j].add((double)i, values[j]);
                }
            }
            for (i = 0; i < len; ++i) {
                xyDataset.addSeries(xySeries[i]);
            }
            return xyDataset;
        }
        if (chartType.equals("Metrics")) {
            int i;
            String[] seriesNames = (String[])labels;
            String[] fileNames = (String[])dataArray.get(0);
            int noOfSets = seriesNames.length;
            DefaultCategoryDataset[] datasets = new DefaultCategoryDataset[noOfSets];
            for (i = 0; i < noOfSets; ++i) {
                datasets[i] = new DefaultCategoryDataset();
            }
            System.out.println("GraphMetrics : no of datasets : " + noOfSets);
            for (i = 1; i < dataArray.size(); ++i) {
                double[] values = (double[])dataArray.get(i);
                String fileName = fileNames[i - 1];
                int count = 0;
                for (int j = 1; j < values.length; ++j) {
                    String metricId = seriesNames[j];
                    datasets[count].addValue(values[j], (Comparable)((Object)metricId), (Comparable)((Object)fileName));
                    ++count;
                }
            }
            return datasets;
        }
        if (chartType.equals("Point")) {
            int i;
            DefaultTableXYDataset xyDataset = new DefaultTableXYDataset();
            String[] labelSet = (String[])labels;
            int len = labelSet.length;
            XYSeries[] xySeries = new XYSeries[len];
            for (i = 0; i < len; ++i) {
                xySeries[i] = new XYSeries((Comparable)((Object)labelSet[i]), false, false);
            }
            for (i = 0; i < dataArray.size(); ++i) {
                Point xyPoint = (Point)dataArray.get(i);
                if (xySeries[0].indexOf((Number)new Double(xyPoint.x)) > -1) continue;
                xySeries[0].add((double)xyPoint.x, (double)xyPoint.y);
            }
            for (i = 0; i < len; ++i) {
                xyDataset.addSeries(xySeries[i]);
            }
            return xyDataset;
        }
        if (chartType.equals("MultiPoint")) {
            int i;
            String[] ys;
            String[] seriesNames = (String[])labels;
            yLabels.clear();
            for (String y : ys = (String[])dataArray.get(0)) {
                yLabels.add(y);
            }
            GraphPoint[] testpoints = (GraphPoint[])dataArray.get(1);
            int noOfMetrics = testpoints.length;
            DefaultCategoryDataset[] datasets = new DefaultCategoryDataset[noOfMetrics];
            for (i = 0; i < noOfMetrics; ++i) {
                datasets[i] = new DefaultCategoryDataset();
            }
            for (i = 1; i < dataArray.size(); ++i) {
                GraphPoint[] points = (GraphPoint[])dataArray.get(i);
                String fileName = seriesNames[i - 1];
                for (int j = 0; j < points.length; ++j) {
                    GraphPoint newPoint = points[j];
                    for (int k = 0; k < newPoint.getNoOfPoints(); ++k) {
                        String metricId = newPoint.getLabel(k);
                        datasets[j].addValue(newPoint.getPoint(k), (Comparable)((Object)metricId), (Comparable)((Object)fileName));
                    }
                }
            }
            return datasets;
        }
        return dataset;
    }

    public static JFreeChart createChart(String graphTitle, Object dataset, String chartType, String[] labels) {
        JFreeChart chart = null;
        title = graphTitle;
        if (chartType.equals("Pie")) {
            PieDataset piedataset = (PieDataset)dataset;
            chart = ChartFactory.createPieChart((String)title, (PieDataset)piedataset, (boolean)true, (boolean)true, (boolean)false);
            PiePlot plot = (PiePlot)chart.getPlot();
            plot.setLabelFont(new Font("SansSerif", 0, 12));
            plot.setNoDataMessage("No data available");
            plot.setCircular(false);
            plot.setLabelGap(0.02);
        } else if (chartType.equals("Bar")) {
            DefaultCategoryDataset barDataset = (DefaultCategoryDataset)dataset;
            chart = ChartFactory.createBarChart((String)title, (String)"Category", (String)"Value", (CategoryDataset)barDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        } else if (chartType.equals("XY")) {
            XYDataset xydataset = (XYDataset)dataset;
            chart = ChartFactory.createScatterPlot((String)title, (String)"Image", (String)"Delta", (XYDataset)xydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            XYPlot plot = (XYPlot)chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
            plot.setDomainGridlinePaint((Paint)Color.white);
            plot.setRangeGridlinePaint((Paint)Color.white);
            plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            plot.setDomainCrosshairVisible(false);
            plot.setRangeCrosshairVisible(true);
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
            XYItemRenderer r = plot.getRenderer();
            if (r instanceof XYLineAndShapeRenderer) {
                renderer = (XYLineAndShapeRenderer)r;
                renderer.setDefaultShapesVisible(true);
                renderer.setDefaultShapesFilled(true);
            }
        } else if (chartType.equals("Metrics")) {
            chart = GraphMetrics.plotMetrics(graphTitle, dataset, chartType);
        } else if (chartType.equals("Point")) {
            chart = GraphMetrics.plotPoint(graphTitle, dataset, chartType);
        } else if (chartType.equals("MultiPoint")) {
            chart = GraphMetrics.multiPlotPoints(graphTitle, dataset, chartType);
        }
        return chart;
    }

    private static JFreeChart plotPoint(String graphTitle, Object dataset, String chartType) {
        JFreeChart chart = null;
        XYDataset xydataset = (XYDataset)dataset;
        chart = ChartFactory.createXYLineChart((String)title, (String)"Image", (String)"Delta", (XYDataset)xydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(false);
        plot.setRangeCrosshairVisible(true);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            renderer = (XYLineAndShapeRenderer)r;
            renderer.setDefaultShapesVisible(true);
            renderer.setDefaultShapesFilled(true);
        }
        return chart;
    }

    private static JFreeChart multiPlotPoints(String graphTitle, Object dataset, String chartType) {
        JFreeChart chart = null;
        DefaultCategoryDataset[] datasets = (DefaultCategoryDataset[])dataset;
        CategoryAxis domainAxis = new CategoryAxis("Volume");
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(domainAxis);
        Color[] pointColors = GraphMetrics.setColors();
        for (int i = 0; i < datasets.length; ++i) {
            LineAndShapeRenderer renderer = new LineAndShapeRenderer();
            if (datasets[i].getRowCount() == 0) continue;
            String label = yLabels.get(i).toString();
            NumberAxis rangeAxis = new NumberAxis(label);
            renderer.setShapesVisible(true);
            renderer.setDrawOutlines(true);
            renderer.setUseFillPaint(true);
            renderer.setFillPaint((Paint)Color.white);
            renderer.setLinesVisible(false);
            renderer = GraphMetrics.setColors(pointColors, renderer);
            double val = Math.random();
            int index = (int)Math.round(val * 10.0);
            renderer.setSeriesOutlinePaint(i, (Paint)pointColors[index]);
            renderer.setUseOutlinePaint(true);
            CategoryPlot subplot = new CategoryPlot((CategoryDataset)datasets[i], null, (ValueAxis)rangeAxis, (CategoryItemRenderer)renderer);
            plot.add(subplot);
        }
        chart = new JFreeChart(title, new Font("SansSerif", 1, 12), (Plot)plot, true);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.white);
        CategoryAxis actAxis = plot.getDomainAxis();
        actAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        return chart;
    }

    private static LineAndShapeRenderer setColors(Color[] cols, LineAndShapeRenderer rend) {
        double val = Math.random();
        int index = (int)Math.round(val * 10.0);
        for (int i = 0; i < cols.length; ++i) {
            rend.setSeriesOutlinePaint(i, (Paint)cols[index]);
        }
        return rend;
    }

    private static Color[] setColors() {
        Color[] pointColors = new Color[]{Color.GREEN, Color.BLUE, Color.RED, Color.ORANGE, Color.CYAN, Color.GRAY, Color.PINK, Color.BLACK, Color.lightGray, Color.CYAN, Color.MAGENTA};
        return pointColors;
    }

    private static JFreeChart plotMetrics(String graphTitle, Object dataset, String chartType) {
        JFreeChart chart = null;
        DefaultCategoryDataset[] metricDatasets = (DefaultCategoryDataset[])dataset;
        CategoryAxis domainAxis = new CategoryAxis("Category");
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(domainAxis);
        for (int i = 0; i < metricDatasets.length; ++i) {
            if (metricDatasets[i].getColumnCount() == 0) continue;
            NumberAxis rangeAxis = new NumberAxis("Value");
            LineAndShapeRenderer renderer = new LineAndShapeRenderer();
            renderer.setShapesVisible(true);
            renderer.setDrawOutlines(true);
            renderer.setUseFillPaint(true);
            renderer.setFillPaint((Paint)Color.white);
            renderer.setLinesVisible(false);
            CategoryPlot subplot = new CategoryPlot((CategoryDataset)metricDatasets[i], null, (ValueAxis)rangeAxis, (CategoryItemRenderer)renderer);
            plot.add(subplot);
        }
        chart = new JFreeChart(title, new Font("SansSerif", 1, 12), (Plot)plot, true);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.white);
        CategoryAxis actAxis = plot.getDomainAxis();
        actAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        return chart;
    }

    public static JPanel createPanel(String chartType, String title, Object data, Object labels, int displayType) {
        JFreeChart chart = GraphMetrics.createChart(title, GraphMetrics.createDataset(chartType, data, labels, displayType), chartType, (String[])labels);
        return new ChartPanel(chart);
    }

    static {
        yLabels = new ArrayList();
    }
}

