/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse;

import edu.berkeley.guir.prefuse.focus.DefaultFocusSet;
import edu.berkeley.guir.prefuse.focus.FocusSet;
import edu.berkeley.guir.prefuse.graph.Entity;
import java.util.HashMap;
import java.util.Iterator;

public class FocusManager {
    public static final String DEFAULT_KEY = "default";
    public static final String SELECTION_KEY = "selection";
    public static final String SEARCH_KEY = "search";
    public static final String HOVER_KEY = "hover";
    private HashMap m_focusSets = new HashMap();

    public FocusManager() {
        this.setDefaultFocusSet(new DefaultFocusSet());
    }

    public FocusSet getFocusSet(Object object) {
        return (FocusSet)this.m_focusSets.get(object);
    }

    public void putFocusSet(Object object, FocusSet focusSet) {
        this.m_focusSets.put(object, focusSet);
    }

    public FocusSet getDefaultFocusSet() {
        return (FocusSet)this.m_focusSets.get(DEFAULT_KEY);
    }

    public void setDefaultFocusSet(FocusSet focusSet) {
        this.m_focusSets.put(DEFAULT_KEY, focusSet);
    }

    public Iterator getFocusSetIterator() {
        return this.m_focusSets.values().iterator();
    }

    public boolean isFocus(Object object, Entity entity) {
        FocusSet focusSet = this.getFocusSet(object);
        return focusSet == null ? false : focusSet.contains(entity);
    }

    public boolean isFocus(Entity entity) {
        Iterator iterator = this.m_focusSets.keySet().iterator();
        while (iterator.hasNext()) {
            FocusSet focusSet = (FocusSet)this.m_focusSets.get(iterator.next());
            if (!focusSet.contains(entity)) continue;
            return true;
        }
        return false;
    }
}

