/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.action.AbstractAction;
import edu.berkeley.guir.prefuse.action.Action;
import java.util.ArrayList;

public class ActionSwitch
extends AbstractAction {
    private ArrayList actions = new ArrayList();
    private int switchVal = 0;

    public ActionSwitch() {
    }

    public ActionSwitch(Action[] actionArray, int n) {
        this();
        for (int i = 0; i < actionArray.length; ++i) {
            this.actions.add(actionArray[i]);
        }
        this.setSwitchValue(n);
    }

    public void run(ItemRegistry itemRegistry, double d) {
        if (this.actions.size() > 0) {
            this.get(this.switchVal).run(itemRegistry, d);
        }
    }

    public Action get(int n) {
        return (Action)this.actions.get(n);
    }

    public void add(Action action) {
        this.actions.add(action);
    }

    public void add(int n, Action action) {
        this.actions.add(n, action);
    }

    public void set(int n, Action action) {
        this.actions.set(n, action);
    }

    public Action remove(int n) {
        return (Action)this.actions.remove(n);
    }

    public int size() {
        return this.actions.size();
    }

    public int getSwitchValue() {
        return this.switchVal;
    }

    public void setSwitchValue(int n) {
        if (n < 0 || n >= this.actions.size()) {
            throw new IllegalArgumentException("Switch value out of legal range");
        }
        this.switchVal = n;
    }
}

