/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.assignment;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.AbstractAction;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Layout
extends AbstractAction {
    protected Rectangle2D m_bounds = null;
    protected Point2D m_anchor = null;
    private Insets m_insets = new Insets(0, 0, 0, 0);
    private double[] m_bpts = new double[4];
    private Rectangle2D m_tmp = new Rectangle2D.Double();

    public Rectangle2D getLayoutBounds() {
        return this.m_bounds;
    }

    public Rectangle2D getLayoutBounds(ItemRegistry itemRegistry) {
        if (this.m_bounds != null) {
            return this.m_bounds;
        }
        if (itemRegistry != null && itemRegistry.getDisplayCount() > 0) {
            Display display = itemRegistry.getDisplay(0);
            Insets insets = display.getInsets(this.m_insets);
            this.m_bpts[0] = insets.left;
            this.m_bpts[1] = insets.top;
            this.m_bpts[2] = display.getWidth() - insets.right;
            this.m_bpts[3] = display.getHeight() - insets.bottom;
            display.getInverseTransform().transform(this.m_bpts, 0, this.m_bpts, 0, 2);
            this.m_tmp.setRect(this.m_bpts[0], this.m_bpts[1], this.m_bpts[2] - this.m_bpts[0], this.m_bpts[3] - this.m_bpts[1]);
            return this.m_tmp;
        }
        return null;
    }

    public void setLayoutBounds(Rectangle2D rectangle2D) {
        this.m_bounds = rectangle2D;
    }

    public Point2D getLayoutAnchor() {
        return this.m_anchor;
    }

    public Point2D getLayoutAnchor(ItemRegistry itemRegistry) {
        if (this.m_anchor != null) {
            return this.m_anchor;
        }
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        if (itemRegistry != null) {
            Display display = itemRegistry.getDisplay(0);
            ((Point2D)double_).setLocation((double)display.getWidth() / 2.0, (double)display.getHeight() / 2.0);
            display.getInverseTransform().transform(double_, double_);
        }
        return double_;
    }

    public void setLayoutAnchor(Point2D point2D) {
        this.m_anchor = point2D;
    }

    protected void setLocation(VisualItem visualItem, VisualItem visualItem2, double d, double d2) {
        if (Double.isNaN(visualItem.getX())) {
            if (visualItem2 != null) {
                visualItem.setLocation(visualItem2.getStartLocation());
            } else {
                visualItem.setLocation(0.0, 0.0);
            }
        }
        visualItem.updateLocation(d, d2);
        visualItem.setLocation(d, d2);
    }

    public abstract void run(ItemRegistry var1, double var2);
}

