/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.filter;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.filter.Filter;
import edu.berkeley.guir.prefuse.collections.SingleElementIterator;
import edu.berkeley.guir.prefuse.graph.DefaultTree;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.util.Iterator;

public class FisheyeTreeFilter
extends Filter {
    public static final String[] ITEM_CLASSES = new String[]{"node", "edge"};
    public static final int DEFAULT_MIN_DOI = -2;
    public static final String ATTR_CENTER = "center";
    private int m_minDOI;
    private boolean m_edgesVisible = true;
    private Node m_froot;
    private ItemRegistry m_registry;
    private double m_localDOIDivisor;
    private TreeNode m_root;

    public FisheyeTreeFilter() {
        this(-2);
    }

    public FisheyeTreeFilter(int n) {
        this(n, true);
    }

    public FisheyeTreeFilter(int n, boolean bl) {
        this(n, bl, true);
    }

    public FisheyeTreeFilter(int n, boolean bl, boolean bl2) {
        super(ITEM_CLASSES, bl2);
        this.m_edgesVisible = bl;
        this.m_minDOI = n;
    }

    public void setTreeRoot(Node node) {
        this.m_froot = node;
    }

    protected Iterator getFoci(ItemRegistry itemRegistry) {
        Iterator iterator = itemRegistry.getDefaultFocusSet().iterator();
        if (!iterator.hasNext()) {
            iterator = new SingleElementIterator(this.m_root);
        }
        return iterator;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        Node node;
        TreeNode treeNode;
        Object object;
        this.m_registry = itemRegistry;
        Graph graph = itemRegistry.getGraph();
        if (!(graph instanceof Tree)) {
            throw new IllegalStateException("The FisheyeTreeFilter requires that the backing graph returned by registry.getGraph() is a Tree instance.");
        }
        Tree tree = (Tree)graph;
        this.m_localDOIDivisor = tree.getNodeCount();
        this.m_root = tree.getRoot();
        Graph graph2 = itemRegistry.getFilteredGraph();
        DefaultTree defaultTree = null;
        if (graph2 instanceof DefaultTree) {
            defaultTree = (DefaultTree)graph2;
            defaultTree.setRoot(null);
        } else {
            defaultTree = new DefaultTree();
            graph2 = defaultTree;
        }
        Iterator iterator = this.getFoci(itemRegistry);
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof TreeNode)) continue;
            treeNode = (TreeNode)object;
            node = itemRegistry.getNodeItem(treeNode);
            boolean bl = false;
            bl = node == null || ((VisualItem)((Object)node)).getDirty() > 0 || ((VisualItem)((Object)node)).getDOI() < 0.0;
            node = itemRegistry.getNodeItem(treeNode, true, true);
            if (!bl) continue;
            this.setDOI((NodeItem)node, 0, 0);
            if ((int)((VisualItem)((Object)node)).getDOI() > this.m_minDOI) {
                this.visitDescendants(treeNode, (NodeItem)node, null);
            }
            this.visitAncestors(treeNode, (NodeItem)node);
        }
        defaultTree.setRoot(itemRegistry.getNodeItem(this.m_root));
        object = itemRegistry.getNodeItems();
        while (object.hasNext()) {
            treeNode = (NodeItem)object.next();
            node = (Node)((VisualItem)((Object)treeNode)).getEntity();
            Iterator iterator2 = node.getEdges();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                Node node2 = edge.getAdjacentNode(node);
                if (!itemRegistry.isVisible(node2)) continue;
                EdgeItem edgeItem = itemRegistry.getEdgeItem(edge, true);
                if (edge.isTreeEdge()) {
                    TreeNode treeNode2 = (TreeNode)edgeItem.getAdjacentNode(treeNode);
                    TreeNode treeNode3 = treeNode2.getParent() == treeNode ? treeNode : treeNode2;
                    treeNode3.addChild(edgeItem);
                } else {
                    edgeItem.getFirstNode().addEdge(edgeItem);
                    edgeItem.getSecondNode().addEdge(edgeItem);
                }
                if (this.m_edgesVisible) continue;
                edgeItem.setVisible(false);
            }
        }
        this.m_registry = null;
        this.m_root = null;
        itemRegistry.setFilteredGraph(defaultTree);
        super.run(itemRegistry, d);
    }

    protected void visitDescendants(TreeNode treeNode, NodeItem nodeItem, TreeNode treeNode2) {
        int n = treeNode2 == null ? this.getCenter(nodeItem) : treeNode.getChildIndex(treeNode2);
        Iterator iterator = treeNode.getChildren();
        int n2 = 0;
        while (iterator.hasNext()) {
            TreeNode treeNode3 = (TreeNode)iterator.next();
            if (treeNode3 == treeNode2) continue;
            NodeItem nodeItem2 = this.m_registry.getNodeItem(treeNode3, true, true);
            this.setDOI(nodeItem2, (int)nodeItem.getDOI() - 1, Math.abs(n - n2));
            if ((int)nodeItem2.getDOI() > this.m_minDOI) {
                this.visitDescendants(treeNode3, nodeItem2, null);
            }
            ++n2;
        }
    }

    protected void visitAncestors(TreeNode treeNode, NodeItem nodeItem) {
        if (treeNode.getParent() == null || treeNode == this.m_root) {
            return;
        }
        TreeNode treeNode2 = treeNode.getParent();
        NodeItem nodeItem2 = this.m_registry.getNodeItem(treeNode2);
        boolean bl = false;
        bl = nodeItem2 == null || nodeItem2.getDirty() > 0 || nodeItem2.getDOI() < 0.0;
        nodeItem2 = this.m_registry.getNodeItem(treeNode2, true, true);
        if (bl) {
            this.setDOI(nodeItem2, 0, 0);
            if ((int)nodeItem2.getDOI() > this.m_minDOI) {
                this.visitDescendants(treeNode2, nodeItem2, treeNode);
            }
            this.visitAncestors(treeNode2, nodeItem2);
        }
    }

    protected void setDOI(NodeItem nodeItem, int n, int n2) {
        double d = (double)(-n2) / Math.min(1000.0, this.m_localDOIDivisor);
        nodeItem.setDOI((double)n + d);
    }

    private int getCenter(NodeItem nodeItem) {
        TreeNode treeNode;
        int n;
        TreeNode treeNode2 = (TreeNode)nodeItem.getVizAttribute(ATTR_CENTER);
        if (treeNode2 != null && (n = (treeNode = (TreeNode)nodeItem.getEntity()).getChildIndex(treeNode2)) > -1) {
            return n;
        }
        return 0;
    }
}

