/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.filter;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.filter.Filter;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.GraphLib;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.util.Iterator;

public class TreeFilter
extends Filter {
    public static final String[] ITEM_CLASSES = new String[]{"node", "edge"};
    private boolean m_edgesVisible;
    private boolean m_useFocusAsRoot;
    private Node m_root;

    public TreeFilter() {
        this(false, true, true);
    }

    public TreeFilter(boolean bl) {
        this(bl, true, true);
    }

    public TreeFilter(boolean bl, boolean bl2) {
        this(bl, bl2, true);
    }

    public TreeFilter(boolean bl, boolean bl2, boolean bl3) {
        super(ITEM_CLASSES, bl3);
        this.m_edgesVisible = bl2;
        this.m_useFocusAsRoot = bl;
    }

    public void setTreeRoot(Node node) {
        this.m_root = node;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        Object object;
        Object object2;
        Graph graph = itemRegistry.getGraph();
        boolean bl = graph instanceof Tree;
        Object object3 = null;
        Iterator iterator = graph.getNodes();
        while (iterator.hasNext()) {
            object2 = itemRegistry.getNodeItem((Node)iterator.next(), true, true);
            if (object3 != null) continue;
            object3 = object2;
        }
        object2 = itemRegistry.getDefaultFocusSet().iterator();
        NodeItem nodeItem = null;
        if (object2.hasNext()) {
            nodeItem = itemRegistry.getNodeItem((Node)object2.next(), true, true);
        }
        if (this.m_root != null) {
            object = this.m_root instanceof NodeItem ? this.m_root : itemRegistry.getNodeItem(this.m_root);
            object3 = (NodeItem)object;
        } else if (nodeItem != null && this.m_useFocusAsRoot) {
            object3 = nodeItem;
        } else if (bl) {
            object3 = itemRegistry.getNodeItem(((Tree)graph).getRoot());
        }
        iterator = itemRegistry.getNodeItems();
        while (iterator.hasNext()) {
            object = (NodeItem)iterator.next();
            if (((VisualItem)object).getDirty() > 0) continue;
            Node node = (Node)((VisualItem)object).getEntity();
            Iterator iterator2 = node.getEdges();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                Node node2 = edge.getAdjacentNode(node);
                EdgeItem edgeItem = itemRegistry.getEdgeItem(edge, true);
                edgeItem.getFirstNode().addEdge(edgeItem);
                if (!edgeItem.isDirected()) {
                    edgeItem.getSecondNode().addEdge(edgeItem);
                }
                if (this.m_edgesVisible) continue;
                edgeItem.setVisible(false);
            }
        }
        object = GraphLib.breadthFirstTree((TreeNode)object3);
        itemRegistry.setFilteredGraph((Graph)object);
        super.run(itemRegistry, d);
    }

    public boolean isEdgesVisible() {
        return this.m_edgesVisible;
    }

    public void setEdgesVisible(boolean bl) {
        this.m_edgesVisible = bl;
    }

    public boolean isUseFocusAsRoot() {
        return this.m_useFocusAsRoot;
    }

    public void setUseFocusAsRoot(boolean bl) {
        this.m_useFocusAsRoot = bl;
    }
}

