/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.filter;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.filter.Filter;
import edu.berkeley.guir.prefuse.graph.DefaultTree;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.Tree;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WindowedTreeFilter
extends Filter {
    public static final String[] ITEM_CLASSES = new String[]{"node", "edge"};
    public static final int DEFAULT_MIN_DOI = -2;
    private boolean m_edgesVisible;
    private boolean m_useFocusAsRoot;
    private int m_minDOI;
    private Node m_root;
    private List m_queue = new LinkedList();

    public WindowedTreeFilter() {
        this(-2);
    }

    public WindowedTreeFilter(int n) {
        this(n, false);
    }

    public WindowedTreeFilter(int n, boolean bl) {
        this(n, bl, true);
    }

    public WindowedTreeFilter(int n, boolean bl, boolean bl2) {
        this(n, bl, bl2, true);
    }

    public WindowedTreeFilter(int n, boolean bl, boolean bl2, boolean bl3) {
        super(ITEM_CLASSES, bl3);
        this.m_minDOI = n;
        this.m_useFocusAsRoot = bl;
        this.m_edgesVisible = bl2;
    }

    public void setTreeRoot(Node node) {
        this.m_root = node;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        Object object;
        Graph graph = itemRegistry.getGraph();
        boolean bl = graph instanceof Tree;
        Graph graph2 = itemRegistry.getFilteredGraph();
        DefaultTree defaultTree = null;
        if (bl && graph2 instanceof DefaultTree) {
            defaultTree = (DefaultTree)graph2;
            defaultTree.setRoot(null);
        } else {
            defaultTree = new DefaultTree();
            graph2 = defaultTree;
        }
        NodeItem nodeItem = null;
        Iterator iterator = itemRegistry.getDefaultFocusSet().iterator();
        NodeItem nodeItem2 = null;
        if (iterator.hasNext()) {
            nodeItem2 = itemRegistry.getNodeItem((Node)iterator.next(), true, true);
        }
        if (this.m_root != null) {
            object = this.m_root instanceof NodeItem ? this.m_root : itemRegistry.getNodeItem(this.m_root, true, true);
            nodeItem = (NodeItem)object;
        } else if (nodeItem2 != null && this.m_useFocusAsRoot) {
            nodeItem = nodeItem2;
        } else if (bl) {
            nodeItem = itemRegistry.getNodeItem(((Tree)graph).getRoot(), true, true);
        } else {
            object = graph.getNodes();
            if (object.hasNext()) {
                nodeItem = itemRegistry.getNodeItem((Node)object.next(), true, true);
            }
        }
        if (nodeItem == null) {
            throw new IllegalStateException("No root for the filtered tree has been specified.");
        }
        defaultTree.setRoot(nodeItem);
        nodeItem.setDOI(0.0);
        this.m_queue.add(nodeItem);
        while (!this.m_queue.isEmpty()) {
            object = (NodeItem)this.m_queue.remove(0);
            Node node = (Node)((VisualItem)object).getEntity();
            double d2 = ((VisualItem)object).getDOI() - 1.0;
            if (!(d2 >= (double)this.m_minDOI)) continue;
            Iterator iterator2 = node.getEdges();
            boolean bl2 = false;
            while (iterator2.hasNext()) {
                boolean bl3;
                Edge edge = (Edge)iterator2.next();
                Node node2 = edge.getAdjacentNode(node);
                NodeItem nodeItem3 = itemRegistry.getNodeItem(node2);
                boolean bl4 = bl3 = nodeItem3 == null || nodeItem3.getDirty() > 0;
                if (bl3) {
                    nodeItem3 = itemRegistry.getNodeItem(node2, true, true);
                }
                EdgeItem edgeItem = itemRegistry.getEdgeItem(edge, true);
                if (bl3) {
                    ((NodeItem)object).addChild(edgeItem);
                    nodeItem3.setDOI(d2);
                    this.m_queue.add(nodeItem3);
                    continue;
                }
                edgeItem.getFirstNode().addEdge(edgeItem);
                edgeItem.getSecondNode().addEdge(edgeItem);
            }
        }
        itemRegistry.setFilteredGraph(defaultTree);
        super.run(itemRegistry, d);
    }

    public boolean isEdgesVisible() {
        return this.m_edgesVisible;
    }

    public void setEdgesVisible(boolean bl) {
        this.m_edgesVisible = bl;
    }

    public int getMinDOI() {
        return this.m_minDOI;
    }

    public void setMinDOI(int n) {
        this.m_minDOI = n;
    }

    public boolean isUseFocusAsRoot() {
        return this.m_useFocusAsRoot;
    }

    public void setUseFocusAsRoot(boolean bl) {
        this.m_useFocusAsRoot = bl;
    }
}

