/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph;

import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.event.GraphEventListener;
import edu.berkeley.guir.prefuse.graph.event.GraphEventMulticaster;

public abstract class AbstractGraph
implements Graph {
    protected GraphEventListener m_graphListener = null;

    public void addGraphEventListener(GraphEventListener graphEventListener) {
        this.m_graphListener = GraphEventMulticaster.add(this.m_graphListener, graphEventListener);
    }

    public void removeGraphEventListener(GraphEventListener graphEventListener) {
        this.m_graphListener = GraphEventMulticaster.remove(this.m_graphListener, graphEventListener);
    }

    protected void fireNodeAdded(Node node) {
        if (this.m_graphListener != null) {
            this.m_graphListener.nodeAdded(this, node);
        }
    }

    protected void fireNodeRemoved(Node node) {
        if (this.m_graphListener != null) {
            this.m_graphListener.nodeRemoved(this, node);
        }
    }

    protected void fireNodeReplaced(Node node, Node node2) {
        if (this.m_graphListener != null) {
            this.m_graphListener.nodeReplaced(this, node, node2);
        }
    }

    protected void fireEdgeAdded(Edge edge) {
        if (this.m_graphListener != null) {
            this.m_graphListener.edgeAdded(this, edge);
        }
    }

    protected void fireEdgeRemoved(Edge edge) {
        if (this.m_graphListener != null) {
            this.m_graphListener.edgeRemoved(this, edge);
        }
    }

    protected void fireEdgeReplaced(Edge edge, Edge edge2) {
        if (this.m_graphListener != null) {
            this.m_graphListener.edgeReplaced(this, edge, edge2);
        }
    }
}

