/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph;

import edu.berkeley.guir.prefuse.graph.DefaultEntity;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.TreeNode;

public class DefaultEdge
extends DefaultEntity
implements Edge {
    protected Node m_node1;
    protected Node m_node2;
    protected boolean m_directed;

    public DefaultEdge(Node node, Node node2) {
        this(node, node2, false);
    }

    public DefaultEdge(Node node, Node node2, boolean bl) {
        this.m_node1 = node;
        this.m_node2 = node2;
        this.m_directed = bl;
    }

    public boolean isDirected() {
        return this.m_directed;
    }

    public boolean isTreeEdge() {
        if (this.m_node1 instanceof TreeNode && this.m_node2 instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)this.m_node1;
            TreeNode treeNode2 = (TreeNode)this.m_node2;
            return treeNode.getParent() == treeNode2 || treeNode2.getParent() == treeNode;
        }
        return false;
    }

    public boolean isIncident(Node node) {
        return this.m_node1 == node || this.m_node2 == node;
    }

    public Node getFirstNode() {
        return this.m_node1;
    }

    public Node getSecondNode() {
        return this.m_node2;
    }

    public void setFirstNode(Node node) {
        this.m_node1 = node;
    }

    public void setSecondNode(Node node) {
        this.m_node2 = node;
    }

    public Node getAdjacentNode(Node node) {
        if (node == this.m_node1) {
            return this.m_node2;
        }
        if (node == this.m_node2) {
            return this.m_node1;
        }
        return null;
    }

    public String toString() {
        return "Edge(" + this.m_node1 + "," + this.m_node2 + ")";
    }
}

