/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph.external;

import edu.berkeley.guir.prefuse.graph.DefaultTreeNode;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import edu.berkeley.guir.prefuse.graph.external.ExternalEntity;
import edu.berkeley.guir.prefuse.graph.external.GraphLoader;
import java.util.Iterator;

public class ExternalTreeNode
extends DefaultTreeNode
implements ExternalEntity {
    protected static final int LOAD_CHILDREN = 1;
    protected static final int LOAD_PARENT = 2;
    protected static final int LOAD_ALL = 3;
    protected GraphLoader m_loader;
    protected boolean m_ploaded = false;
    protected boolean m_ploadStarted = false;
    protected boolean m_loaded = false;
    protected boolean m_loadStarted = false;

    protected void checkLoadedStatus(int n) {
        this.touch();
        if ((n & 1) > 0 && !this.m_loadStarted) {
            this.m_loadStarted = true;
            this.m_loader.loadChildren(this);
        }
        if ((n & 2) > 0 && !this.m_ploadStarted) {
            this.m_ploadStarted = true;
            this.m_loader.loadParent(this);
        }
    }

    public void setLoader(GraphLoader graphLoader) {
        this.m_loader = graphLoader;
    }

    void setChildrenLoaded(boolean bl) {
        this.m_loaded = bl;
        this.m_loadStarted = bl;
    }

    void setParentLoaded(boolean bl) {
        this.m_ploaded = bl;
        this.m_ploadStarted = bl;
    }

    public boolean isParentLoaded() {
        return this.m_ploaded;
    }

    public boolean isChildrenLoaded() {
        return this.m_loaded;
    }

    public void touch() {
        this.m_loader.touch(this);
    }

    public void unload() {
        Node node;
        Edge edge;
        Iterator iterator;
        if (this.m_children != null) {
            iterator = this.m_children.iterator();
            while (iterator.hasNext()) {
                edge = (Edge)iterator.next();
                node = (TreeNode)edge.getAdjacentNode(this);
                node.removeAsChild(this);
                if (!(node instanceof ExternalTreeNode)) continue;
                ((ExternalTreeNode)node).setParentLoaded(false);
            }
            this.m_children.clear();
        }
        this.m_parent.removeChild(this);
        if (this.m_parent instanceof ExternalTreeNode) {
            ((ExternalTreeNode)this.m_parent).setChildrenLoaded(false);
        }
        this.m_parent = null;
        this.m_parentEdge = null;
        iterator = this.m_edges.iterator();
        while (iterator.hasNext()) {
            edge = (Edge)iterator.next();
            node = edge.getAdjacentNode(this);
            node.removeEdge(edge);
        }
        this.m_edges.clear();
    }

    public boolean addChild(Edge edge) {
        this.touch();
        return super.addChild(edge);
    }

    public boolean addChild(int n, Edge edge) {
        this.touch();
        return super.addChild(n, edge);
    }

    public TreeNode getChild(int n) {
        this.checkLoadedStatus(1);
        return super.getChild(n);
    }

    public int getChildCount() {
        this.touch();
        return super.getChildCount();
    }

    public Edge getChildEdge(int n) {
        this.checkLoadedStatus(1);
        return super.getChildEdge(n);
    }

    public Iterator getChildEdges() {
        this.checkLoadedStatus(1);
        return super.getChildEdges();
    }

    public int getChildIndex(Edge edge) {
        this.touch();
        return super.getChildIndex(edge);
    }

    public int getChildIndex(TreeNode treeNode) {
        this.touch();
        return super.getChildIndex(treeNode);
    }

    public Iterator getChildren() {
        this.checkLoadedStatus(1);
        return super.getChildren();
    }

    public TreeNode getNextSibling() {
        this.checkLoadedStatus(2);
        return super.getNextSibling();
    }

    public int getDescendantCount() {
        this.touch();
        return super.getDescendantCount();
    }

    public TreeNode getParent() {
        this.checkLoadedStatus(2);
        return super.getParent();
    }

    public Edge getParentEdge() {
        this.checkLoadedStatus(2);
        return super.getParentEdge();
    }

    public TreeNode getPreviousSibling() {
        this.checkLoadedStatus(2);
        return super.getPreviousSibling();
    }

    public boolean isChild(TreeNode treeNode) {
        this.touch();
        return super.isChild(treeNode);
    }

    public boolean isChildEdge(Edge edge) {
        this.touch();
        return super.isChildEdge(edge);
    }

    public boolean isDescendant(TreeNode treeNode) {
        this.touch();
        return super.isDescendant(treeNode);
    }

    public boolean isSibling(TreeNode treeNode) {
        this.checkLoadedStatus(2);
        return super.isSibling(treeNode);
    }

    public void removeAllAsChildren() {
        this.touch();
        super.removeAllAsChildren();
    }

    public void removeAllChildren() {
        this.touch();
        super.removeAllChildren();
    }

    public TreeNode removeAsChild(int n) {
        this.touch();
        return super.removeAsChild(n);
    }

    public boolean removeAsChild(TreeNode treeNode) {
        this.touch();
        return super.removeAsChild(treeNode);
    }

    public TreeNode removeChild(int n) {
        this.touch();
        return super.removeChild(n);
    }

    public boolean removeChild(TreeNode treeNode) {
        this.touch();
        return super.removeChild(treeNode);
    }

    public boolean removeChildEdge(Edge edge) {
        this.touch();
        return super.removeChildEdge(edge);
    }

    public Edge removeChildEdge(int n) {
        this.touch();
        return super.removeChildEdge(n);
    }

    public boolean setAsChild(int n, TreeNode treeNode) {
        this.touch();
        return super.setAsChild(n, treeNode);
    }

    public boolean setAsChild(TreeNode treeNode) {
        this.touch();
        return super.setAsChild(treeNode);
    }

    public void setDescendantCount(int n) {
        this.touch();
        super.setDescendantCount(n);
    }

    public void setParentEdge(Edge edge) {
        this.touch();
        super.setParentEdge(edge);
    }

    public boolean addEdge(Edge edge) {
        this.touch();
        return super.addEdge(edge);
    }

    public boolean addEdge(int n, Edge edge) {
        this.touch();
        return super.addEdge(n, edge);
    }

    public Edge getEdge(int n) {
        this.checkLoadedStatus(3);
        return super.getEdge(n);
    }

    public Edge getEdge(Node node) {
        this.checkLoadedStatus(3);
        return super.getEdge(node);
    }

    public int getEdgeCount() {
        this.touch();
        return super.getEdgeCount();
    }

    public Iterator getEdges() {
        this.checkLoadedStatus(3);
        return super.getEdges();
    }

    public int getIndex(Edge edge) {
        this.touch();
        return super.getIndex(edge);
    }

    public int getIndex(Node node) {
        this.touch();
        return super.getIndex(node);
    }

    public Node getNeighbor(int n) {
        this.checkLoadedStatus(3);
        return super.getNeighbor(n);
    }

    public Iterator getNeighbors() {
        this.checkLoadedStatus(3);
        return super.getNeighbors();
    }

    public boolean isIncidentEdge(Edge edge) {
        this.touch();
        return super.isIncidentEdge(edge);
    }

    public boolean isNeighbor(Node node) {
        this.touch();
        return super.isNeighbor(node);
    }

    public boolean removeEdge(Edge edge) {
        this.touch();
        return super.removeEdge(edge);
    }

    public Edge removeEdge(int n) {
        this.touch();
        return super.removeEdge(n);
    }

    public Node removeNeighbor(int n) {
        this.touch();
        return super.removeNeighbor(n);
    }

    public boolean removeNeighbor(Node node) {
        this.touch();
        return super.removeNeighbor(node);
    }
}

