/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph.io;

import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.DefaultTree;
import edu.berkeley.guir.prefuse.graph.DefaultTreeNode;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import edu.berkeley.guir.prefuse.graph.io.AbstractTreeReader;
import edu.berkeley.guir.prefuse.graph.io.TreeReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTreeReader
extends AbstractTreeReader
implements TreeReader {
    protected Class NODE_TYPE = class$edu$berkeley$guir$prefuse$graph$DefaultTreeNode == null ? (class$edu$berkeley$guir$prefuse$graph$DefaultTreeNode = XMLTreeReader.class$("edu.berkeley.guir.prefuse.graph.DefaultTreeNode")) : class$edu$berkeley$guir$prefuse$graph$DefaultTreeNode;
    static /* synthetic */ Class class$edu$berkeley$guir$prefuse$graph$DefaultTreeNode;

    public Tree loadTree(InputStream inputStream) throws IOException {
        try {
            XMLTreeHandler xMLTreeHandler = new XMLTreeHandler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)xMLTreeHandler);
            return xMLTreeHandler.getTree();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class XMLTreeHandler
    extends DefaultHandler {
        public static final String NODE = "node";
        public static final String EDGE = "edge";
        public static final String ATT = "att";
        public static final String ID = "id";
        public static final String LABEL = "label";
        public static final String SOURCE = "source";
        public static final String TARGET = "target";
        public static final String TYPE = "type";
        public static final String NAME = "name";
        public static final String VALUE = "value";
        public static final String LIST = "list";
        private Tree m_tree = null;
        private HashMap m_nodeMap = new HashMap();
        private Node m_activeNode = null;
        private Edge m_activeEdge = null;
        private boolean m_directed = false;
        private Locator m_locator;
        private boolean inNode;
        private boolean inEdge;

        public void setDocumentLocator(Locator locator) {
            this.m_locator = locator;
        }

        public void startDocument() {
            this.m_tree = null;
            this.m_nodeMap.clear();
        }

        public void endDocument() {
            DefaultTreeNode defaultTreeNode = (DefaultTreeNode)this.m_nodeMap.get("Top");
            this.m_tree = new DefaultTree(defaultTreeNode);
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals(NODE)) {
                this.m_activeNode = null;
                this.inNode = false;
            } else if (string3.equals(EDGE)) {
                this.m_activeEdge = null;
                this.inEdge = false;
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals(NODE)) {
                Node node;
                this.m_activeNode = node = this.parseNode(attributes);
                this.inNode = true;
            } else if (string3.equals(EDGE)) {
                Edge edge;
                this.m_activeEdge = edge = this.parseEdge(attributes);
                this.inEdge = true;
            } else if (string3.equals(ATT)) {
                this.parseAttribute(attributes);
            }
        }

        protected Node parseNode(Attributes attributes) {
            String string = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals(ID)) continue;
                string = attributes.getValue(i);
            }
            if (string == null) {
                System.err.println("Node missing id");
                return null;
            }
            Node node = null;
            try {
                node = (Node)XMLTreeReader.this.NODE_TYPE.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            node.setAttribute(ID, string.toString());
            this.m_nodeMap.put(string, node);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string2 = attributes.getQName(i);
                if (string2.equals(ID)) continue;
                node.setAttribute(string2, attributes.getValue(i));
            }
            return node;
        }

        protected Edge parseEdge(Attributes attributes) {
            String string = null;
            String string2 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string3 = attributes.getQName(i);
                if (string3.equals(SOURCE)) {
                    string = attributes.getValue(i);
                    continue;
                }
                if (string3.equals(TARGET)) {
                    string2 = attributes.getValue(i);
                    continue;
                }
                String string4 = attributes.getValue(i);
            }
            TreeNode treeNode = (TreeNode)this.m_nodeMap.get(string);
            TreeNode treeNode2 = (TreeNode)this.m_nodeMap.get(string2);
            if (string == null || string2 == null || treeNode == null || treeNode2 == null) {
                System.err.println("Edge missing source or target! lineno: " + this.m_locator.getLineNumber() + " source = " + string + " target = " + string2);
                return null;
            }
            DefaultEdge defaultEdge = new DefaultEdge(treeNode, treeNode2, this.m_directed);
            treeNode.addChild(defaultEdge);
            return defaultEdge;
        }

        protected void parseAttribute(Attributes attributes) {
            String string = null;
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getQName(i);
                if (string4.equals(TYPE)) {
                    string = attributes.getValue(i);
                    continue;
                }
                if (string4.equals(NAME)) {
                    string2 = attributes.getValue(i);
                    continue;
                }
                if (!string4.equals(VALUE)) continue;
                string3 = attributes.getValue(i);
            }
            if (string != null && string.equals(LIST) || string2 == null || string3 == null) {
                System.err.println("Attribute under-specified");
                return;
            }
            if (this.inNode) {
                this.m_activeNode.setAttribute(string2, string3);
            } else if (this.inEdge) {
                this.m_activeEdge.setAttribute(string2, string3);
            }
        }

        public Tree getTree() {
            return this.m_tree;
        }
    }
}

