/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.render;

import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.ShapeRenderer;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class DefaultNodeRenderer
extends ShapeRenderer {
    private int m_radius = 5;
    private Ellipse2D m_circle = new Ellipse2D.Double(0.0, 0.0, 2 * this.m_radius, 2 * this.m_radius);

    public DefaultNodeRenderer() {
    }

    public DefaultNodeRenderer(int n) {
        this.setRadius(n);
    }

    public void setRadius(int n) {
        this.m_radius = n;
        this.m_circle.setFrameFromCenter(0.0, 0.0, n, n);
    }

    public int getRadius() {
        return this.m_radius;
    }

    protected Shape getRawShape(VisualItem visualItem) {
        double d = (double)this.m_radius * visualItem.getSize();
        double d2 = visualItem.getX();
        double d3 = visualItem.getY();
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        this.m_circle.setFrameFromCenter(d2, d3, d2 + d, d3 + d);
        return this.m_circle;
    }
}

