/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.render;

import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.DefaultEdgeRenderer;
import edu.berkeley.guir.prefuse.render.DefaultNodeRenderer;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.RendererFactory;
import java.util.HashMap;
import java.util.Map;

public class DefaultRendererFactory
implements RendererFactory {
    private Map itemClassMap = new HashMap();

    public DefaultRendererFactory() {
        this(new DefaultNodeRenderer(), new DefaultEdgeRenderer(), null);
    }

    public DefaultRendererFactory(Renderer renderer) {
        this(renderer, null, null);
    }

    public DefaultRendererFactory(Renderer renderer, Renderer renderer2) {
        this(renderer, renderer2, null);
    }

    public DefaultRendererFactory(Renderer renderer, Renderer renderer2, Renderer renderer3) {
        if (renderer != null) {
            this.itemClassMap.put("node", renderer);
        }
        if (renderer2 != null) {
            this.itemClassMap.put("edge", renderer2);
        }
        if (renderer3 != null) {
            this.itemClassMap.put("aggregate", renderer3);
        }
    }

    public Renderer getRenderer(VisualItem visualItem) {
        return (Renderer)this.itemClassMap.get(visualItem.getItemClass());
    }

    public Renderer getRenderer(String string) {
        return (Renderer)this.itemClassMap.get(string);
    }

    public void addRenderer(String string, Renderer renderer) {
        this.itemClassMap.put(string, renderer);
    }

    public Renderer removeRenderer(String string) {
        return (Renderer)this.itemClassMap.remove(string);
    }

    public Renderer getAggregateRenderer() {
        return (Renderer)this.itemClassMap.get("aggregate");
    }

    public Renderer getEdgeRenderer() {
        return (Renderer)this.itemClassMap.get("edge");
    }

    public Renderer getNodeRenderer() {
        return (Renderer)this.itemClassMap.get("node");
    }

    public void setAggregateRenderer(Renderer renderer) {
        this.itemClassMap.put("aggregate", renderer);
    }

    public void setEdgeRenderer(Renderer renderer) {
        this.itemClassMap.put("edge", renderer);
    }

    public void setNodeRenderer(Renderer renderer) {
        this.itemClassMap.put("node", renderer);
    }
}

